/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.DateFormat;
import com.klg.jclass.field.validate.DateMask;
import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.JCTimeValidator;
import com.klg.jclass.field.validate.PopupFieldEditor;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.CalendarContainer;
import com.klg.jclass.util.calendar.DayTable;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.calendar.JCDateChooser;
import com.klg.jclass.util.swing.JCColumnLayout;
import com.klg.jclass.util.swing.JCPopupEvent;
import com.klg.jclass.util.swing.JCPopupListener;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class JCDateTimeValidator
extends JCStringValidator {
    static final int NOVALUE = -1;
    static final int NOTFOUND = -1;
    static final int PARSE_ERROR = -1;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    static final int DATE_LITERAL = 1;
    static final int MERIDIEM = 2;
    static final int ABBREV_TIMEZONE = 3;
    static final int TIMEZONE = 4;
    static final int MERIDIEM_HOUR = 5;
    static final int ZERO_MERIDIEM_HOUR = 6;
    static final int MILITARY_HOUR = 7;
    static final int ZERO_MILITARY_HOUR = 8;
    static final int MINUTE = 9;
    static final int ZERO_MINUTE = 10;
    static final int SECOND = 11;
    static final int ZERO_SECOND = 12;
    static final int NUM_DAY = 13;
    static final int ZERO_NUM_DAY = 14;
    static final int ABBREV_ALPHA_DAY = 15;
    static final int ALPHA_DAY = 16;
    static final int DAY_OF_YEAR = 17;
    static final int ZERO_DAY_OF_YEAR = 18;
    static final int NUM_MONTH = 19;
    static final int ZERO_NUM_MONTH = 20;
    static final int ABBREV_ALPHA_MONTH = 21;
    static final int ALPHA_MONTH = 22;
    static final int SHORT_YEAR = 23;
    static final int LONG_YEAR = 24;
    static final int MILLISECOND = 25;
    static final int AMSET = -2;
    static final int PMSET = -3;
    static final int ZONE_ID = 0;
    static final int ZONE_STANDARD_LONG = 1;
    static final int ZONE_STANDARD_SHORT = 2;
    static final int ZONE_DAYLIGHT_LONG = 3;
    static final int ZONE_DAYLIGHT_SHORT = 4;
    static final int ZONE_CITY_NAME = 5;
    static final byte[][] daytable = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    protected Class[] supportedClasses;
    protected boolean mask_input = false;
    protected String date_format;
    protected DateFormat compiled_format;
    protected TimeZone tz = null;
    protected WorkingCalendar cal = null;
    protected DateFormatSymbols symbols;
    protected Vector edit_formats = new Vector(0);
    protected Vector compiled_edit_formats = new Vector(0);
    protected int increment_field = 10;
    protected int millenium_threshold = 70;
    protected int default_detail = 2;
    protected int spin_policy = 1;
    protected String original_format = null;
    protected String default_format = null;
    protected Object defaultValue = null;
    private static int YEARMOD = 1997;
    private static int DAYMOD = 2;

    public JCDateTimeValidator() {
        if (this.tz == null) {
            this.tz = TimeZone.getDefault();
        }
        if (this.cal == null) {
            this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, this.locale));
        }
        if (this.defaultValue == null) {
            this.defaultValue = Calendar.getInstance(this.tz, this.locale);
        }
        this.symbols = new DateFormatSymbols(this.locale);
        this.increment = new Integer(1);
        this.default_format = this.getDefaultFormat();
        this.setFormat(this.default_format);
        this.setEditFormats(this.getDefaultEditFormats());
        this.setSpinPolicy(1);
        this.supportedClasses = this.getSupportedClasses();
    }

    public JCDateTimeValidator(Locale locale, String string, String string2, String[] stringArray, boolean bl, int n2, boolean bl2, Object object) {
        this();
        this.setLocale(locale);
        this.default_format = this.getDefaultFormat();
        if (string != null && string.length() != 0) {
            try {
                this.setFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setFormat(this.default_format);
            }
        }
        this.setPlaceHolderChars(string2);
        this.setEditFormats(stringArray);
        this.setMaskInput(bl);
        this.setDefaultDetail(n2);
        this.setAllowNull(bl2);
        this.setDefaultValue(object);
    }

    public JCDateTimeValidator(Locale locale, String string, String string2, String[] stringArray, boolean bl, int n2, boolean bl2, Object object, int n3) {
        this(locale, string, string2, stringArray, bl, n2, bl2, object);
        this.setMilleniumThreshold(n3);
    }

    protected Class[] getSupportedClasses() {
        Class[] classArray = new Class[]{Calendar.class, java.util.Date.class, GregorianCalendar.class, Date.class, Time.class, Timestamp.class};
        return classArray;
    }

    public String getDefaultFormat(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.klg.jclass.field.resources.LocaleInfo", locale);
        String[] stringArray = resourceBundle.getStringArray("DateTimePatterns");
        MessageFormat messageFormat = new MessageFormat(stringArray[8]);
        String[] stringArray2 = new String[2];
        switch (this.default_detail) {
            case 0: {
                stringArray2[0] = stringArray[0];
                stringArray2[1] = stringArray[4];
                break;
            }
            case 1: {
                stringArray2[0] = stringArray[1];
                stringArray2[1] = stringArray[5];
                break;
            }
            case 2: {
                stringArray2[0] = stringArray[2];
                stringArray2[1] = stringArray[6];
                break;
            }
            case 3: {
                stringArray2[0] = stringArray[3];
                stringArray2[1] = stringArray[7];
            }
        }
        return messageFormat.format(stringArray2);
    }

    public String getDefaultFormat() {
        return this.getDefaultFormat(this.locale);
    }

    public int getDefaultDetail() {
        return this.default_detail;
    }

    public void setDefaultDetail(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid value for defaultDetail");
        }
        this.default_detail = n2;
        String string = this.getFormat();
        if (string != null && string.equals(this.default_format)) {
            this.default_format = this.getDefaultFormat();
            this.setFormat(this.default_format);
        }
    }

    private static String[] getStringArrayCopy(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            stringArray[i2] = (String)vector.elementAt(i2);
        }
        return stringArray;
    }

    public String[] getDefaultEditFormats(Locale locale) {
        Vector<String> vector = new Vector<String>(0);
        ResourceBundle resourceBundle = this.locale == locale ? this.li : ResourceBundle.getBundle("com.klg.jclass.field.resources.LocaleInfo", locale);
        String[] stringArray = resourceBundle.getStringArray("DateTimePatterns");
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        String string8 = stringArray[7];
        MessageFormat messageFormat = new MessageFormat(stringArray[8]);
        String[] stringArray2 = new String[]{string5, string6, string7, string8};
        String[] stringArray3 = new String[]{string, string2, string3, string4};
        String[] stringArray4 = new String[2];
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                stringArray4[0] = stringArray2[i2];
                stringArray4[1] = stringArray3[i3];
                vector.addElement(messageFormat.format(stringArray4));
            }
        }
        return JCDateTimeValidator.getStringArrayCopy(vector);
    }

    public String[] getDefaultEditFormats() {
        return this.getDefaultEditFormats(this.locale);
    }

    public String[] getEditFormats() {
        return JCDateTimeValidator.getStringArrayCopy(this.edit_formats);
    }

    public void setEditFormats(String[] stringArray) {
        int n2;
        if (stringArray == null) {
            return;
        }
        this.edit_formats = new Vector(stringArray.length);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.edit_formats.insertElementAt(stringArray[n2], n2);
        }
        this.compiled_edit_formats.setSize(0);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.compiled_edit_formats.addElement(this.compileFormat(stringArray[n2]));
        }
    }

    private int getSymbol(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.compiled_format.elements.length; ++i2) {
            if (n2 >= (n3 += this.compiled_format.getLength(i2))) continue;
            return this.compiled_format.getSymbol(i2);
        }
        return -1;
    }

    private int getIncrementField(int n2) {
        int n3 = -1;
        switch (n2) {
            case 13: 
            case 14: {
                n3 = 5;
                break;
            }
            case 15: 
            case 16: {
                n3 = 7;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n3 = 2;
                break;
            }
            case 23: 
            case 24: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 9;
                break;
            }
            case 7: 
            case 8: {
                n3 = 11;
                break;
            }
            case 5: 
            case 6: {
                n3 = 10;
                break;
            }
            case 9: 
            case 10: {
                n3 = 12;
                break;
            }
            case 11: 
            case 12: {
                n3 = 13;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 18: {
                n3 = 6;
            }
        }
        return n3;
    }

    public void inferSubField(int n2, int n3) {
        int n4;
        if (!this.mask_input || this.date_format == null) {
            return;
        }
        int n5 = -1;
        for (n4 = Math.min(n2, this.date_format.length() - 1); n5 == -1 && n4 >= 0; --n4) {
            n5 = this.getIncrementField(this.getSymbol(n4));
        }
        for (n4 = Math.max(n2, 0); n5 == -1 && n4 < this.date_format.length(); ++n4) {
            n5 = this.getIncrementField(this.getSymbol(n4));
        }
        if (n5 != -1) {
            this.setIncrementField(n5);
        }
    }

    public int getIncrement() {
        if (this.increment == null) {
            return 0;
        }
        return (Integer)this.increment;
    }

    public void setIncrement(int n2) {
        this.increment = new Integer(n2);
    }

    public int getIncrementField() {
        return this.increment_field;
    }

    public void setIncrementField(int n2) {
        if (n2 < 0 && n2 >= 17) {
            throw new IllegalArgumentException("invalid value for incrementField");
        }
        this.increment_field = n2;
    }

    public int getMilleniumThreshold() {
        return this.millenium_threshold;
    }

    public void setMilleniumThreshold(int n2) {
        if (n2 < 0 && n2 >= 100) {
            throw new IllegalArgumentException("invalid value for milleniumThreshold");
        }
        this.millenium_threshold = n2;
    }

    private void spinSubField(Calendar calendar, int n2) {
        int n3 = this.increment_field;
        switch (n3) {
            case 0: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 16: {
                throw new IllegalArgumentException();
            }
            case 9: {
                if (calendar.get(n3) == 0) {
                    calendar.set(n3, 1);
                    calendar.set(11, calendar.get(11) + 12);
                    break;
                }
                calendar.set(n3, 0);
                calendar.set(11, calendar.get(11) - 12);
                break;
            }
            case 6: {
                int n4 = JCDateTimeValidator.daysInYear(calendar.get(1));
                int n5 = (calendar.get(n3) + n2) % n4;
                if (n5 == 0) {
                    n5 = n4;
                }
                calendar.set(n3, n5);
                break;
            }
            case 7: {
                int n6 = (calendar.get(n3) + n2) % 7;
                if (n6 == 0) {
                    n6 = 7;
                }
                calendar.set(n3, n6);
                break;
            }
            case 10: {
                calendar.roll(11, n2);
                break;
            }
            default: {
                calendar.roll(n3, n2);
            }
        }
    }

    protected Object addIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n2 = (Integer)this.increment;
        if (n2 == 0) {
            return null;
        }
        Calendar calendar = (Calendar)this.convertToSupported(object);
        calendar = (Calendar)calendar.clone();
        if (this.spin_policy == 1) {
            this.spinSubField(calendar, n2);
        } else {
            calendar.add(this.increment_field, n2);
        }
        return this.convertFromSupported(calendar, object.getClass());
    }

    protected Object subtractIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n2 = (Integer)this.increment;
        if (n2 == 0) {
            return null;
        }
        Calendar calendar = (Calendar)this.convertToSupported(object);
        calendar = (Calendar)calendar.clone();
        if (this.spin_policy == 1) {
            this.spinSubField(calendar, -n2);
        } else {
            calendar.add(this.increment_field, -n2);
        }
        return this.convertFromSupported(calendar, object.getClass());
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        super.setLocale(locale);
        if (this.tz == null) {
            this.tz = TimeZone.getDefault();
        }
        this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, this.getLocale()));
        this.symbols = new DateFormatSymbols(this.getLocale());
        String string = this.getFormat();
        if (string == null) {
            return;
        }
        if (string.equals(this.default_format)) {
            this.default_format = this.getDefaultFormat();
            this.setFormat(this.default_format);
        } else {
            this.setFormat(string);
        }
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.tz = timeZone;
        this.cal = new WorkingCalendar(Calendar.getInstance(this.tz, this.locale));
    }

    public boolean inRange(Object object) {
        return true;
    }

    public void addEditFormat(String string) {
        this.edit_formats.addElement(string);
        this.compiled_edit_formats.addElement(this.compileFormat(string));
    }

    private String convertDateFormatToStringMask() {
        StringBuffer stringBuffer = new StringBuffer(this.date_format.length());
        if (this.compiled_format.size_ambiguous) {
            StringBuffer stringBuffer2 = new StringBuffer(this.date_format.length() + 10);
            for (int i2 = 0; i2 < this.compiled_format.elements.length; ++i2) {
                if (this.compiled_format.elements[i2].absolute_replacement == null) {
                    stringBuffer2.append(this.compiled_format.getChars(i2));
                    continue;
                }
                this.compiled_format.elements[i2] = this.compiled_format.elements[i2].absolute_replacement;
                stringBuffer2.append(this.compiled_format.getChars(i2));
            }
            this.date_format = stringBuffer2.toString();
        }
        for (int i3 = 0; i3 < this.compiled_format.elements.length; ++i3) {
            if (this.compiled_format.getSymbol(i3) != 1) {
                int n2;
                String[] stringArray = this.compiled_format.getStrings(i3);
                int n3 = this.compiled_format.getSymbol(i3);
                if (stringArray == null || n3 == 5 || n3 == 6) {
                    for (n2 = 0; n2 < this.compiled_format.getChars(i3).length(); ++n2) {
                        stringBuffer.append("@");
                    }
                    this.compiled_format.setLength(i3, this.compiled_format.getChars(i3).length());
                    continue;
                }
                n2 = 0;
                if (n3 == 4 || n3 == 3) {
                    String string = this.getTimeZoneString(i3);
                    if (string != null) {
                        n2 = string.length();
                    }
                } else {
                    n2 = stringArray[0].length();
                }
                if (n2 == 0) {
                    for (int i4 = 1; i4 < stringArray.length; ++i4) {
                        n2 = Math.max(n2, stringArray[i4].length());
                    }
                }
                for (int i5 = 0; i5 < n2; ++i5) {
                    stringBuffer.append("A");
                }
                this.compiled_format.setLength(i3, n2);
                continue;
            }
            stringBuffer.append(this.compiled_format.getChars(i3));
            this.compiled_format.setLength(i3, this.compiled_format.getChars(i3).length());
        }
        return stringBuffer.toString();
    }

    public boolean getMaskInput() {
        return this.mask_input;
    }

    public void setMaskInput(boolean bl) {
        this.mask_input = bl;
        if (bl) {
            this.setMask(this.convertDateFormatToStringMask());
        } else {
            this.setMask("");
        }
    }

    public String getFormat() {
        return this.original_format;
    }

    public void setFormat(String string) {
        this.compiled_format = this.compileFormat(string);
        this.date_format = string;
        this.original_format = string;
        if (string != null) {
            if (this.mask_input) {
                this.setMask(this.convertDateFormatToStringMask());
            } else {
                this.setMask("");
            }
        } else {
            this.setMask("");
        }
    }

    public Object parse(Class clazz, String string) {
        WorkingCalendar workingCalendar;
        Serializable serializable;
        boolean bl = false;
        Object object = null;
        if (this.mask_input) {
            serializable = null;
            try {
                serializable = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            object = super.parse((Class)serializable, string);
            if (object == null) {
                if (this.getAllowNull()) {
                    return object;
                }
                throw new FieldParseException("Null text is invalid");
            }
        }
        if (string.equalsIgnoreCase("now") || string.equalsIgnoreCase("today")) {
            serializable = Calendar.getInstance();
            ((Calendar)serializable).setTime(new java.util.Date());
            workingCalendar = new WorkingCalendar((Calendar)serializable);
            bl = true;
        } else if (this.mask_input) {
            workingCalendar = new WorkingCalendar();
            bl = this.parseString(string, this.compiled_format.elements, workingCalendar);
        } else {
            workingCalendar = new WorkingCalendar();
            for (int i2 = 0; i2 < this.compiled_edit_formats.size() && !(bl = this.parseString(string, ((DateFormat)this.compiled_edit_formats.elementAt((int)i2)).elements, workingCalendar)); ++i2) {
            }
        }
        if (bl) {
            object = this.convertFromSupported(workingCalendar.toCalendar(), clazz);
            return object;
        }
        throw new FieldParseException("cannot construct date/time from text");
    }

    private boolean setDayOfWeek(WorkingCalendar workingCalendar, int n2, int n3, int n4) {
        int n5 = JCDateTimeValidator.dayOfWeek(n2, n3, n4);
        if (workingCalendar.isSet(7)) {
            if (n5 != workingCalendar.get(7)) {
                return false;
            }
        } else {
            workingCalendar.set(7, n5);
        }
        return true;
    }

    public Object copyValue(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Calendar calendar = (Calendar)this.convertToSupported(object);
        if (calendar == object) {
            return calendar.clone();
        }
        return this.convertFromSupported(calendar, clazz);
    }

    public boolean validate(Object object) {
        if (object == null) {
            return this.internal_validate(null);
        }
        Calendar calendar = (Calendar)this.convertToSupported(object);
        return this.internal_validate(new WorkingCalendar(calendar));
    }

    protected boolean internal_validate(WorkingCalendar workingCalendar) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (workingCalendar == null) {
            return this.allow_null;
        }
        Calendar calendar = Calendar.getInstance(this.tz, this.locale);
        calendar.setTime(new java.util.Date());
        WorkingCalendar workingCalendar2 = new WorkingCalendar(calendar);
        if (workingCalendar.isSet(1)) {
            n5 = workingCalendar.get(1);
        } else {
            n5 = workingCalendar2.get(1);
            workingCalendar.set(1, n5);
        }
        if (workingCalendar.isSet(3) && workingCalendar.isSet(7)) {
            n4 = workingCalendar.get(2);
            n3 = workingCalendar.get(1);
            n2 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 += JCDateTimeValidator.daysInMonth(i2, n3);
            }
            n2 += workingCalendar.get(5);
            if (workingCalendar.isSet(6)) {
                if (n2 != workingCalendar.get(6)) {
                    return false;
                }
            } else {
                workingCalendar.set(6, n2);
            }
        }
        if (workingCalendar.isSet(6)) {
            n4 = JCDateTimeValidator.monthOfYear(n5, workingCalendar.get(6));
            if (workingCalendar.isSet(2)) {
                if (n4 != workingCalendar.get(2)) {
                    return false;
                }
            } else {
                workingCalendar.set(2, n4);
            }
            n3 = JCDateTimeValidator.dayOfMonthOfYear(n5, workingCalendar.get(6));
            if (workingCalendar.isSet(5)) {
                if (n3 != workingCalendar.get(5)) {
                    return false;
                }
            } else {
                workingCalendar.set(5, n3);
            }
            if (!this.setDayOfWeek(workingCalendar, workingCalendar.get(1), workingCalendar.get(2), workingCalendar.get(5))) {
                return false;
            }
            if (!workingCalendar.isSet(3)) {
                workingCalendar.set(3, JCDateTimeValidator.weekOfYear(n5, workingCalendar.get(6)));
            }
            if (!workingCalendar.isSet(4)) {
                workingCalendar.set(4, JCDateTimeValidator.weekOfMonth(n5, workingCalendar.get(2), workingCalendar.get(5)));
            }
        } else if (workingCalendar.isSet(2)) {
            n4 = workingCalendar.get(2);
            if (workingCalendar.isSet(5)) {
                n3 = workingCalendar.get(5);
                workingCalendar.set(6, JCDateTimeValidator.dayOfYear(n5, n4, n3));
                if (!this.setDayOfWeek(workingCalendar, n5, n4, n3)) {
                    return false;
                }
                workingCalendar.set(3, JCDateTimeValidator.weekOfYear(n5, workingCalendar.get(6)));
                workingCalendar.set(4, JCDateTimeValidator.weekOfMonth(n5, n4, n3));
            } else if (workingCalendar.isSet(4) && workingCalendar.isSet(7)) {
                throw new IllegalStateException("Validation from only WeekOfMonth and DayOfWeek not currently supported");
            }
        }
        if (workingCalendar.isSet(10) && workingCalendar.isSet(11) && workingCalendar.isSet(9)) {
            if (workingCalendar.get(10) + 12 * workingCalendar.get(9) != workingCalendar.get(11)) {
                return false;
            }
        } else if (workingCalendar.isSet(10) && !workingCalendar.isSet(11)) {
            if (!workingCalendar.isSet(9)) {
                if (workingCalendar.get(10) == 12) {
                    workingCalendar.set(9, 1);
                } else {
                    workingCalendar.set(9, 0);
                }
            }
            this.setHourOfDayFromHour(workingCalendar);
        } else if (workingCalendar.isSet(11)) {
            this.setHourFromHourOfDay(workingCalendar);
        }
        if (workingCalendar.isSet(11) || workingCalendar.isSet(12) || workingCalendar.isSet(13) || workingCalendar.isSet(14)) {
            if (!workingCalendar.isSet(11)) {
                workingCalendar.set(11, 0);
                this.setHourFromHourOfDay(workingCalendar);
            }
            if (!workingCalendar.isSet(12)) {
                workingCalendar.set(12, 0);
            }
            if (!workingCalendar.isSet(13)) {
                workingCalendar.set(13, 0);
            }
            if (!workingCalendar.isSet(14)) {
                workingCalendar.set(14, 0);
            }
        } else {
            workingCalendar.set(11, workingCalendar2.get(11));
            this.setHourFromHourOfDay(workingCalendar);
            workingCalendar.set(12, workingCalendar2.get(12));
            workingCalendar.set(13, workingCalendar2.get(13));
            workingCalendar.set(14, workingCalendar2.get(14));
        }
        for (n4 = 0; n4 < 17; ++n4) {
            if (workingCalendar.isSet(n4)) continue;
            workingCalendar.set(n4, workingCalendar2.get(n4));
        }
        n4 = workingCalendar.get(2);
        if (!JCDateTimeValidator.domain_check(n4 + 1, 19)) {
            return false;
        }
        n3 = workingCalendar.get(6);
        if (n3 < 1 || n3 > JCDateTimeValidator.daysInYear(n5)) {
            return false;
        }
        n2 = workingCalendar.get(5);
        if (n2 < 1 || n2 > JCDateTimeValidator.daysInMonth(n4, n5)) {
            return false;
        }
        if (!JCDateTimeValidator.domain_check(workingCalendar.get(11), 7)) {
            return false;
        }
        if (!JCDateTimeValidator.domain_check(workingCalendar.get(12), 9)) {
            return false;
        }
        if (!JCDateTimeValidator.domain_check(workingCalendar.get(13), 11)) {
            return false;
        }
        return JCDateTimeValidator.domain_check(workingCalendar.get(14), 25);
    }

    private void setHourFromHourOfDay(WorkingCalendar workingCalendar) {
        int n2 = workingCalendar.get(11);
        workingCalendar.set(9, n2 / 12);
        if ((n2 %= 12) == 0) {
            n2 = 12;
        }
        workingCalendar.set(10, n2);
    }

    private void setHourOfDayFromHour(WorkingCalendar workingCalendar) {
        int n2 = workingCalendar.get(10) + 12 * workingCalendar.get(9);
        if (n2 == 12) {
            n2 = 0;
        } else if (n2 == 24) {
            n2 = 12;
        }
        workingCalendar.set(11, n2);
    }

    private String formatDigits(int n2, int n3) {
        String string = Integer.toString(n2);
        if (string.length() >= n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (int i2 = 0; i2 < n3 - string.length(); ++i2) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String format(Object object) {
        int n2;
        if (object == null) {
            return super.format(object);
        }
        if (!this.isClassSupported(object.getClass())) {
            return "";
        }
        object = this.convertToSupported(object);
        Calendar calendar = (Calendar)object;
        StringBuffer stringBuffer = new StringBuffer(30);
        block15: for (n2 = 0; n2 < this.compiled_format.elements.length; ++n2) {
            switch (this.compiled_format.getSymbol(n2)) {
                case 5: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    stringBuffer.append(Integer.toString(n3));
                    continue block15;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(Integer.toString(n3));
                    continue block15;
                }
                case 19: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(Integer.toString(n3));
                    continue block15;
                }
                case 17: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(Integer.toString(n3));
                    continue block15;
                }
                case 24: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(Integer.toString(n3));
                    continue block15;
                }
                case 6: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    stringBuffer.append(this.formatDigits(n3, 2));
                    continue block15;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    int n4 = this.compiled_format.getField(n2);
                    int n3 = calendar.get(n4);
                    stringBuffer.append(this.formatDigits(n3, 2));
                    continue block15;
                }
                case 20: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(this.formatDigits(n3, 2));
                    continue block15;
                }
                case 23: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(this.formatDigits(n3 %= 100, 2));
                    continue block15;
                }
                case 18: {
                    int n3 = calendar.get(this.compiled_format.getField(n2)) + 1;
                    stringBuffer.append(this.formatDigits(n3, 3));
                    continue block15;
                }
                case 2: 
                case 15: 
                case 16: 
                case 21: 
                case 22: {
                    int n3 = calendar.get(this.compiled_format.getField(n2));
                    stringBuffer.append(this.compiled_format.getString(n2, n3));
                    continue block15;
                }
                case 3: 
                case 4: {
                    String string = this.getTimeZoneString(n2);
                    stringBuffer.append(string);
                    continue block15;
                }
                case 1: {
                    stringBuffer.append(this.compiled_format.getChars(n2));
                }
            }
        }
        if (this.case_policy != 0) {
            for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
                stringBuffer.setCharAt(n2, this.convertCase(stringBuffer.charAt(n2)));
            }
        }
        return stringBuffer.toString();
    }

    private int getZoneIndex() {
        String[][] stringArray = this.symbols.getZoneStrings();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2][0].equals(this.tz.getID())) continue;
            return i2;
        }
        return -1;
    }

    private String getTimeZoneString(int n2) {
        String string = null;
        int n3 = this.getZoneIndex();
        string = n3 == -1 ? this.tz.getID() : this.compiled_format.getString(n2, n3);
        return string;
    }

    private String[] getZoneStrings(int n2) {
        String[][] stringArray = this.symbols.getZoneStrings();
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2][n2];
        }
        return stringArray2;
    }

    private String[] getShortZoneStrings() {
        Calendar calendar = this.cal.toCalendar();
        if (this.tz.inDaylightTime(calendar.getTime())) {
            return this.getZoneStrings(4);
        }
        return this.getZoneStrings(2);
    }

    private String[] getLongZoneStrings() {
        Calendar calendar = this.cal.toCalendar();
        if (this.tz.inDaylightTime(calendar.getTime())) {
            return this.getZoneStrings(3);
        }
        return this.getZoneStrings(1);
    }

    private DateFormat compileFormat(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string.length()) {
            objectArray = new DateMask();
            block0 : switch (string.charAt(n3)) {
                case 'd': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 2 && string.charAt(n3 + n4) == 'd'; ++n4) {
                    }
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    objectArray.field = 5;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 13;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 14;
                            objectArray.absolute_replacement.field = 5;
                            objectArray.absolute_replacement.chars = "dd";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 14;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing day of month in \"" + string + "\"");
                }
                case 'E': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 4 && string.charAt(n3 + n4) == 'E'; ++n4) {
                    }
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    objectArray.field = 7;
                    switch (n4) {
                        case 1: 
                        case 2: {
                            objectArray.symbol = 15;
                            objectArray.strings = this.symbols.getShortWeekdays();
                            break block0;
                        }
                        case 3: 
                        case 4: {
                            objectArray.symbol = 16;
                            objectArray.strings = this.symbols.getWeekdays();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 15;
                            objectArray.absolute_replacement.field = 7;
                            objectArray.absolute_replacement.strings = this.symbols.getShortWeekdays();
                            objectArray.absolute_replacement.chars = "EE";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing week in \"" + string + "\"");
                }
                case 'M': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 4 && string.charAt(n3 + n4) == 'M'; ++n4) {
                    }
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    objectArray.field = 2;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 19;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 20;
                            objectArray.absolute_replacement.field = 2;
                            objectArray.absolute_replacement.chars = "MM";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 20;
                            break block0;
                        }
                        case 3: {
                            objectArray.symbol = 21;
                            objectArray.strings = this.symbols.getShortMonths();
                            break block0;
                        }
                        case 4: {
                            objectArray.symbol = 22;
                            objectArray.strings = this.symbols.getMonths();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 21;
                            objectArray.absolute_replacement.field = 2;
                            objectArray.absolute_replacement.strings = this.symbols.getShortMonths();
                            objectArray.absolute_replacement.chars = "MMM";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing month in \"" + string + "\"");
                }
                case 'Y': 
                case 'y': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 4 && n3 + n4 < string.length() && (string.charAt(n3 + n4) == 'Y' || string.charAt(n3 + n4) == 'y'); ++n4) {
                    }
                    objectArray.field = 1;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 23;
                            objectArray.absolute_replacement.field = 1;
                            objectArray.absolute_replacement.chars = "YY";
                        }
                        case 2: {
                            objectArray.symbol = 23;
                            break block0;
                        }
                        case 3: {
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 24;
                            objectArray.absolute_replacement.field = 1;
                            objectArray.absolute_replacement.chars = "YYYY";
                        }
                        case 4: {
                            objectArray.symbol = 24;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing year in \"" + string + "\"");
                }
                case 'h': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 2 && string.charAt(n3 + n4) == 'h'; ++n4) {
                    }
                    objectArray.field = 10;
                    objectArray.strings = this.symbols.getAmPmStrings();
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 5;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 6;
                            objectArray.absolute_replacement.field = 10;
                            objectArray.absolute_replacement.chars = "hh";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 6;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing hour in \"" + string + "\"");
                }
                case 'H': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 2 && string.charAt(n3 + n4) == 'H'; ++n4) {
                    }
                    objectArray.field = 11;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 7;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 8;
                            objectArray.absolute_replacement.field = 11;
                            objectArray.absolute_replacement.chars = "HH";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 8;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing hour in \"" + string + "\"");
                }
                case 'm': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 2 && string.charAt(n3 + n4) == 'm'; ++n4) {
                    }
                    objectArray.field = 12;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 9;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 10;
                            objectArray.absolute_replacement.field = 12;
                            objectArray.absolute_replacement.chars = "mm";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 10;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing minute in \"" + string + "\"");
                }
                case 's': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 2 && n3 + n4 < string.length() && string.charAt(n3 + n4) == 's'; ++n4) {
                    }
                    objectArray.field = 13;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 11;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 12;
                            objectArray.absolute_replacement.field = 13;
                            objectArray.absolute_replacement.chars = "ss";
                            break block0;
                        }
                        case 2: {
                            objectArray.symbol = 12;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing second in \"" + string + "\"");
                }
                case 'a': 
                case 'p': {
                    objectArray.symbol = 2;
                    objectArray.field = 9;
                    objectArray.strings = this.symbols.getAmPmStrings();
                    objectArray.chars = "" + string.charAt(n3);
                    ++n3;
                    break;
                }
                case 'z': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 4 && n3 + n4 < string.length() && string.charAt(n3 + n4) == 'z'; ++n4) {
                    }
                    objectArray.symbol = 4;
                    objectArray.field = -1;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: 
                        case 2: {
                            objectArray.symbol = 3;
                            objectArray.strings = this.getShortZoneStrings();
                            break block0;
                        }
                        case 4: {
                            objectArray.symbol = 4;
                            objectArray.strings = this.getLongZoneStrings();
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 3;
                            objectArray.absolute_replacement.field = -1;
                            objectArray.absolute_replacement.strings = this.getShortZoneStrings();
                            objectArray.absolute_replacement.chars = "zz";
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing timezone in \"" + string + "\"");
                }
                case 'D': {
                    int n4;
                    for (n4 = 1; n3 + n4 != n2 && n4 < 3 && string.charAt(n3 + n4) == 'D'; ++n4) {
                    }
                    objectArray.field = 6;
                    objectArray.chars = string.substring(n3, n3 + n4);
                    n3 += n4;
                    switch (n4) {
                        case 1: {
                            objectArray.symbol = 17;
                            bl = true;
                            objectArray.absolute_replacement = new DateMask();
                            objectArray.absolute_replacement.symbol = 18;
                            objectArray.absolute_replacement.field = 6;
                            objectArray.absolute_replacement.chars = "DDD";
                            break block0;
                        }
                        case 3: {
                            objectArray.symbol = 18;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("error parsing day of year in \"" + string + "\"");
                }
                case '\\': {
                    int n4 = 1;
                    if (string.charAt(++n3) == '\u0000') break;
                    objectArray.symbol = 1;
                    objectArray.chars = "" + string.charAt(n3);
                    ++n3;
                    break;
                }
                default: {
                    objectArray.symbol = 1;
                    objectArray.chars = "" + string.charAt(n3);
                    ++n3;
                }
            }
            vector.addElement(objectArray);
        }
        objectArray = new DateMask[vector.size()];
        vector.copyInto(objectArray);
        DateFormat dateFormat = new DateFormat();
        dateFormat.elements = objectArray;
        dateFormat.size_ambiguous = bl;
        return dateFormat;
    }

    private static boolean domain_check(int n2, int n3) {
        switch (n3) {
            case 5: 
            case 6: {
                return n2 >= 0 && n2 <= 12;
            }
            case 7: 
            case 8: {
                return n2 >= 0 && n2 <= 23;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return n2 >= 0 && n2 <= 59;
            }
            case 13: 
            case 14: {
                return n2 >= 1 && n2 <= 31;
            }
            case 19: 
            case 20: {
                return n2 >= 1 && n2 <= 12;
            }
            case 23: 
            case 24: {
                return n2 >= 0 && n2 <= 9999;
            }
            case 17: 
            case 18: {
                return n2 >= 0 && n2 <= 365;
            }
            case 25: {
                return n2 >= 0 && n2 <= 999;
            }
        }
        return false;
    }

    private int patternSearch(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        boolean bl = false;
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[i2]);
            int n3 = string.length();
            if (n3 < stringBuffer.length()) {
                stringBuffer.setLength(n3);
            }
            if (!stringBuffer.toString().equalsIgnoreCase(string)) continue;
            if (bl) {
                return -1;
            }
            bl = true;
            n2 = i2;
            break;
        }
        return bl ? n2 : -1;
    }

    private int parseEnum(WorkingCalendar workingCalendar, String string, int n2, int n3, int n4, String[] stringArray) {
        int n5;
        if (n2 >= string.length()) {
            return -1;
        }
        int n6 = 0;
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            n6 = Math.max(n6, stringArray[n5].length());
        }
        int n7 = -1;
        int n8 = 0;
        int n9 = n2 + 1;
        while (n9 - n2 <= n6) {
            int n10 = Math.min(n9, string.length());
            n5 = this.patternSearch(string.substring(n2, n10), stringArray);
            if (n5 != -1) {
                n7 = n5;
                n8 = n10;
            }
            ++n9;
        }
        if (n7 == -1) {
            return -1;
        }
        if (workingCalendar.isSet(n4) && workingCalendar.get(n4) != n5) {
            return -1;
        }
        workingCalendar.set(n4, n7);
        return n8;
    }

    private int parseDigitField(WorkingCalendar workingCalendar, String string, int n2, int n3, int n4, int n5) {
        int n6;
        if (n2 >= string.length() || !Character.isDigit(string.charAt(n2))) {
            return -1;
        }
        for (n6 = n2; n6 < string.length() && Character.isDigit(string.charAt(n6)) && n6 - n2 < n5; ++n6) {
        }
        int n7 = Integer.parseInt(string.substring(n2, n6));
        if (!JCDateTimeValidator.domain_check(n7, n3)) {
            return -1;
        }
        if (workingCalendar.isSet(n4) && workingCalendar.get(n4) != n7) {
            return -1;
        }
        workingCalendar.set(n4, n7);
        return n6;
    }

    private int parseTimeZone(WorkingCalendar workingCalendar, String string, int n2) {
        int n3;
        String[][] stringArray = this.symbols.getZoneStrings();
        String string2 = "";
        String string3 = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = stringArray[i2][2];
            n3 = Math.min(string.length(), n2 + string2.length());
            if (string.substring(n2, n3).equalsIgnoreCase(string2)) {
                string3 = stringArray[i2][0];
                break;
            }
            string2 = stringArray[i2][3];
            n3 = Math.min(string.length(), n2 + string2.length());
            if (string.substring(n2, n3).equalsIgnoreCase(string2)) {
                string3 = stringArray[i2][0];
                break;
            }
            string2 = stringArray[i2][4];
            n3 = Math.min(string.length(), n2 + string2.length());
            if (!string.substring(n2, n3).equalsIgnoreCase(string2)) continue;
            string3 = stringArray[i2][0];
            break;
        }
        if (string3 == null) {
            String[] stringArray2 = TimeZone.getAvailableIDs();
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                string2 = stringArray2[n3];
                int n4 = Math.min(string.length(), n2 + string2.length());
                if (!string.substring(n2, n4).equalsIgnoreCase(string2)) continue;
                string3 = stringArray2[n3];
                break;
            }
        }
        if (string3 == null) {
            return -1;
        }
        workingCalendar.setTimeZone(TimeZone.getTimeZone(string3));
        return n2 + string2.length();
    }

    private int parseLiteral(String string, int n2, char c2) {
        if (n2 < string.length() && c2 == string.charAt(n2)) {
            ++n2;
        } else if (c2 != ' ') {
            return -1;
        }
        return n2;
    }

    private boolean parseString(String string, DateMask[] dateMaskArray, WorkingCalendar workingCalendar) {
        if (string == null || string.length() == 0 || dateMaskArray == null || dateMaskArray.length == 0 && workingCalendar != null) {
            return false;
        }
        workingCalendar.clear();
        int n2 = 0;
        for (int i2 = 0; i2 < dateMaskArray.length && n2 < string.length(); ++i2) {
            while (n2 < string.length() && Character.isSpaceChar(string.charAt(n2))) {
                ++n2;
            }
            switch (dateMaskArray[i2].symbol) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = this.parseDigitField(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, 2);
                    break;
                }
                case 19: 
                case 20: {
                    n2 = this.parseDigitField(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, 2);
                    if (n2 == 0) {
                        n2 = -1;
                    }
                    if (n2 == -1) break;
                    int n3 = workingCalendar.get(dateMaskArray[i2].field);
                    if (n3 == 0) {
                        n2 = -1;
                        break;
                    }
                    workingCalendar.set(dateMaskArray[i2].field, --n3);
                    break;
                }
                case 23: {
                    n2 = this.parseDigitField(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, 2);
                    if (n2 == -1) break;
                    int n3 = workingCalendar.get(dateMaskArray[i2].field);
                    n3 = n3 < this.millenium_threshold ? (n3 += 2000) : (n3 += 1900);
                    workingCalendar.set(dateMaskArray[i2].field, n3);
                    break;
                }
                case 24: {
                    n2 = this.parseDigitField(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, 4);
                    break;
                }
                case 17: 
                case 18: {
                    n2 = this.parseDigitField(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, 3);
                    break;
                }
                case 2: 
                case 15: 
                case 16: 
                case 21: 
                case 22: {
                    n2 = this.parseEnum(workingCalendar, string, n2, dateMaskArray[i2].symbol, dateMaskArray[i2].field, dateMaskArray[i2].strings);
                    break;
                }
                case 3: 
                case 4: {
                    n2 = this.parseTimeZone(workingCalendar, string, n2);
                    break;
                }
                case 1: {
                    n2 = this.parseLiteral(string, n2, dateMaskArray[i2].chars.charAt(0));
                }
            }
            if (n2 == -1) {
                // empty if block
            }
            if (n2 != -1) continue;
            return false;
        }
        while (n2 < string.length() && Character.isSpaceChar(string.charAt(n2))) {
            ++n2;
        }
        return n2 >= string.length();
    }

    public static boolean isLeap(int n2) {
        if (n2 >= 0) {
            return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0;
        }
        return false;
    }

    public static int dayOfYear(int n2, int n3, int n4) {
        int n5 = JCDateTimeValidator.isLeap(n2) ? 1 : 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += daytable[n5][i2];
        }
        return n4;
    }

    public static int daysInMonth(int n2, int n3) {
        int n4 = JCDateTimeValidator.isLeap(n3) ? 1 : 0;
        return daytable[n4][n2];
    }

    public static int monthOfYear(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n4 = JCDateTimeValidator.isLeap(n2) ? 1 : 0;
        while (n3 > daytable[n4][n5]) {
            n3 -= daytable[n4][n5];
            ++n5;
        }
        return n5;
    }

    public static int dayOfMonthOfYear(int n2, int n3) {
        int n4 = JCDateTimeValidator.isLeap(n2) ? 1 : 0;
        int n5 = 0;
        while (n3 > daytable[n4][n5]) {
            n3 -= daytable[n4][n5];
            ++n5;
        }
        return n3;
    }

    public static int daysInYear(int n2) {
        if (JCDateTimeValidator.isLeap(n2)) {
            return 366;
        }
        return 365;
    }

    public static int dayOfWeek(int n2, int n3, int n4) {
        long l2 = 0L;
        if (n2 > YEARMOD) {
            l2 = JCDateTimeValidator.dayOfYear(n2, n3, n4);
            for (int i2 = YEARMOD; i2 < n2; ++i2) {
                l2 += (long)JCDateTimeValidator.daysInYear(i2);
            }
        } else if (n2 == YEARMOD) {
            l2 = JCDateTimeValidator.dayOfYear(n2, n3, n4);
        } else {
            if (n2 < 0) {
                return -1;
            }
            l2 = JCDateTimeValidator.daysInYear(n2) - JCDateTimeValidator.dayOfYear(n2, n3, n4);
            for (int i3 = n2 + 1; i3 < YEARMOD; ++i3) {
                l2 += (long)JCDateTimeValidator.daysInYear(i3);
            }
            int n5 = DAYMOD - (int)(l2 % 7L);
            if (n5 < 0) {
                n5 += 7;
            }
            return n5 + 1;
        }
        return (int)((l2 + (long)DAYMOD) % 7L) + 1;
    }

    public static int weekOfYear(int n2, int n3) {
        int n4 = JCDateTimeValidator.dayOfWeek(n2, 0, 0);
        return (n3 + (6 - n4)) / 7 + 1;
    }

    public static int weekOfMonth(int n2, int n3, int n4) {
        int n5 = JCDateTimeValidator.dayOfWeek(n2, n3, 0);
        return (n4 + (6 - n5)) / 7 + 1;
    }

    public Object convertToSupported(Object object) {
        return JCCalendar.convertObjectToCalendar(object, this.getLocale());
    }

    public Object convertFromSupported(Object object, Class clazz) {
        if (!(object instanceof Calendar)) {
            return null;
        }
        return JCCalendar.convertCalendarToObject((Calendar)object, clazz);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public PopupFieldEditor createPopupComponent() {
        return new DateTimePopup();
    }

    public class DateChooser
    extends JCDateChooser {
        public DateChooser(JCValueModel jCValueModel, Locale locale, int n2) {
            super(jCValueModel, locale, n2 == 3 ? 2 : n2);
        }

        public DateChooser(JCValueModel jCValueModel, Locale locale, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            super(jCValueModel, locale, n2 == 3 ? 2 : n2, stringArray, stringArray2, stringArray3);
        }

        public void setChooserType(int n2) {
            if (n2 == 3) {
                n2 = 2;
            }
            super.setChooserType(n2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.getDayComponent()) {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public class TimeSpin
    extends JCSpinField
    implements CalendarComponent {
        public void setCalendarModel(JCValueModel jCValueModel) {
            this.setValueModel(jCValueModel);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void setSpecialDates(JCCalendar jCCalendar) {
        }

        public void setLocale(Locale locale) {
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }
    }

    public class DateTimeChooser
    extends CalendarContainer {
        protected JCDateChooser dateChooser;
        protected CalendarContainer timeContainer;
        protected boolean showTimeSpinner = true;

        public DateTimeChooser() {
            this(2, null, null, null);
        }

        public DateTimeChooser(int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            CalendarValueModel calendarValueModel = new CalendarValueModel(Calendar.getInstance());
            this.setLayout(new JCColumnLayout(0));
            Locale locale = JCDateTimeValidator.this.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.setLocale(locale);
            this.dateChooser = new DateChooser(calendarValueModel, this.locale, n2, stringArray, stringArray2, stringArray3);
            this.add(this.dateChooser);
            this.timeContainer = new CalendarContainer();
            TimeSpin timeSpin = new TimeSpin();
            timeSpin.setEditable(false);
            JTextField jTextField = (JTextField)timeSpin.getEditor().getEditorComponent();
            jTextField.setHorizontalAlignment(0);
            JCTimeValidator jCTimeValidator = new JCTimeValidator();
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < JCDateTimeValidator.this.compiled_format.elements.length; ++i2) {
                switch (JCDateTimeValidator.this.compiled_format.getSymbol(i2)) {
                    case 5: 
                    case 6: {
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    case 7: 
                    case 8: {
                        bl = true;
                        bl2 = true;
                    }
                }
                if (bl2) break;
            }
            if (bl) {
                jCTimeValidator.setFormat("HH");
            } else {
                jCTimeValidator.setFormat("hh");
            }
            jCTimeValidator.setMaskInput(true);
            timeSpin.setValidator(jCTimeValidator);
            if (this.userFont != null) {
                timeSpin.setFont(this.userFont);
            }
            this.timeContainer.add(timeSpin);
            TimeSpin timeSpin2 = new TimeSpin();
            timeSpin2.setEditable(false);
            jTextField = (JTextField)timeSpin2.getEditor().getEditorComponent();
            jTextField.setHorizontalAlignment(0);
            JCTimeValidator jCTimeValidator2 = new JCTimeValidator();
            jCTimeValidator2.setFormat("mm");
            jCTimeValidator2.setMaskInput(true);
            timeSpin2.setValidator(jCTimeValidator2);
            if (this.userFont != null) {
                timeSpin2.setFont(this.userFont);
            }
            this.timeContainer.add(timeSpin2);
            TimeSpin timeSpin3 = new TimeSpin();
            timeSpin3.setEditable(false);
            jTextField = (JTextField)timeSpin3.getEditor().getEditorComponent();
            jTextField.setHorizontalAlignment(0);
            JCTimeValidator jCTimeValidator3 = new JCTimeValidator();
            jCTimeValidator3.setFormat("ss");
            jCTimeValidator3.setMaskInput(true);
            timeSpin3.setValidator(jCTimeValidator3);
            if (this.userFont != null) {
                timeSpin3.setFont(this.userFont);
            }
            this.timeContainer.add(timeSpin3);
            TimeSpin timeSpin4 = new TimeSpin();
            timeSpin4.setEditable(false);
            jTextField = (JTextField)timeSpin4.getEditor().getEditorComponent();
            jTextField.setHorizontalAlignment(0);
            JCTimeValidator jCTimeValidator4 = new JCTimeValidator();
            jCTimeValidator4.setFormat("a");
            jCTimeValidator4.setMaskInput(true);
            timeSpin4.setValidator(jCTimeValidator4);
            if (this.userFont != null) {
                timeSpin4.setFont(this.userFont);
            }
            this.timeContainer.add(timeSpin4);
            this.add(this.timeContainer);
            this.setCalendarModel(calendarValueModel);
        }

        public void setShowTimeSpinner(boolean bl) {
            if (this.showTimeSpinner == bl) {
                return;
            }
            if (!bl) {
                this.remove(this.timeContainer);
            } else {
                this.add(this.timeContainer);
            }
            this.showTimeSpinner = bl;
            this.doLayout();
        }

        public Object getValue() {
            return this.model.getValue();
        }

        public JCDateChooser getDateChooser() {
            return this.dateChooser;
        }

        public CalendarContainer getTimeSpinnerContainer() {
            return this.timeContainer;
        }
    }

    public class DateTimePopup
    implements PopupFieldEditor,
    ActionListener {
        DateTimeChooser chooser;
        JCListenerList popupListeners = null;

        public DateTimePopup() {
            this(2, null, null, null);
        }

        public DateTimePopup(int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            this.chooser = new DateTimeChooser(n2, stringArray, stringArray2, stringArray3);
            this.chooser.addActionListener(this);
        }

        public JComponent getEditorComponent() {
            return this.getDateTimeChooser();
        }

        public void addPopupListener(JCPopupListener jCPopupListener) {
            this.popupListeners = JCListenerList.add(this.popupListeners, jCPopupListener);
        }

        public void removePopupListener(JCPopupListener jCPopupListener) {
            this.popupListeners = JCListenerList.remove(this.popupListeners, jCPopupListener);
        }

        public void setValue(Object object) {
            Calendar calendar = (Calendar)JCDateTimeValidator.this.convertToSupported(object);
            this.chooser.setCalendarModel(new CalendarValueModel(calendar));
        }

        public boolean processKeyEvent(KeyEvent keyEvent) {
            boolean bl = true;
            if (keyEvent.getKeyCode() == 10) {
                ((DayTable)this.chooser.getDateChooser().getDayComponent()).fireActionEvent();
                return bl;
            }
            Calendar calendar = JCCalendar.copyCalendar(this.chooser.getDateChooser().getValue());
            if (keyEvent.getKeyCode() == 38) {
                calendar.add(5, -1);
            } else if (keyEvent.getKeyCode() == 40) {
                calendar.add(5, 1);
            } else if (keyEvent.getKeyCode() == 33) {
                calendar.add(2, -1);
            } else if (keyEvent.getKeyCode() == 34) {
                calendar.add(2, 1);
            } else {
                bl = false;
            }
            this.chooser.getDateChooser().setValue(calendar);
            return bl;
        }

        public void setLocale(Locale locale) {
            if (this.chooser != null) {
                this.chooser.setLocale(locale);
            }
        }

        public void setFont(Font font) {
            if (this.chooser != null) {
                this.chooser.setFont(font);
                this.chooser.invalidate();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.chooser.getDateChooser().getValue().clone();
            object = JCDateTimeValidator.this.convertToSupported(object);
            JCPopupEvent jCPopupEvent = new JCPopupEvent(this, object);
            Enumeration<Object> enumeration = JCListenerList.elements(this.popupListeners);
            while (enumeration.hasMoreElements()) {
                JCPopupListener jCPopupListener = (JCPopupListener)enumeration.nextElement();
                jCPopupListener.commit(jCPopupEvent);
            }
        }

        public DateTimeChooser getDateTimeChooser() {
            return this.chooser;
        }
    }

    protected class WorkingCalendar
    implements Cloneable,
    Serializable {
        private int[] fields = new int[17];

        public WorkingCalendar() {
            Calendar calendar = Calendar.getInstance(JCDateTimeValidator.this.tz, JCDateTimeValidator.this.locale);
            this.create(calendar);
        }

        public WorkingCalendar(Calendar calendar) {
            this.create(calendar);
        }

        private void create(Calendar calendar) {
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                this.fields[i2] = calendar.isSet(i2) ? calendar.get(i2) : -1;
            }
        }

        public void clear() {
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                this.fields[i2] = -1;
            }
        }

        public int get(int n2) {
            return this.fields[n2];
        }

        public void set(int n2, int n3) {
            this.fields[n2] = n3;
        }

        public boolean isSet(int n2) {
            return this.fields[n2] != -1;
        }

        public TimeZone getTimeZone() {
            return JCDateTimeValidator.this.tz;
        }

        public void setTimeZone(TimeZone timeZone) {
            JCDateTimeValidator.this.tz = timeZone;
        }

        public Calendar toCalendar() {
            Calendar calendar = Calendar.getInstance(JCDateTimeValidator.this.tz, JCDateTimeValidator.this.locale);
            if (this.get(11) == -1 && this.get(10) != -1) {
                JCDateTimeValidator.this.setHourOfDayFromHour(this);
            }
            calendar.set(this.get(1) == -1 ? 1970 : this.get(1), this.get(2) == -1 ? 0 : this.get(2), this.get(5) == -1 ? 1 : this.get(5), this.get(11) == -1 ? 0 : this.get(11), this.get(12) == -1 ? 0 : this.get(12), this.get(13) == -1 ? 0 : this.get(13));
            return calendar;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

