/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.DataPropertiesRegistry;
import com.klg.jclass.field.JCComboField;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCLabelField;
import com.klg.jclass.field.JCPopupField;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCIPAddressValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCListModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class Field
implements Serializable,
JCValueListener,
ComboBoxModel {
    public static final int VALID = 1;
    public static final int UNDEREDIT = 2;
    public static final int INVALID = 3;
    public static final int SHOW_INVALID = 1;
    public static final int RESTORE_DEFAULT = 2;
    public static final int RESTORE_PREVIOUS = 3;
    public static final int CLEAR_FIELD = 4;
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    protected boolean internalBackgroundChange = false;
    protected boolean internalForegroundChange = false;
    protected Color invalidBackground;
    protected Color invalidForeground;
    protected Color validBackground;
    protected Color validForeground;
    protected boolean select_on_enter;
    protected Object edit_initial_value;
    protected Class edit_class;
    transient Object defaultValue;
    transient Object previousValue = null;
    protected JCValidator validator;
    protected Locale current;
    transient Object event_source;
    protected Component vc;
    protected int state;
    protected int invalidPolicy = 1;
    protected boolean beepOnInvalid = true;
    protected boolean internal_text_change = false;
    protected boolean has_focus = false;
    protected boolean auto_complete_mode = false;
    protected boolean doing_completion = false;
    protected boolean doing_commit = false;
    protected boolean in_set_selected_item = false;
    protected boolean set_selected_item_called = false;
    protected boolean in_contents_change = false;
    protected boolean upDownPressed = false;
    transient JCListenerList propertyListeners = null;
    transient JCListenerList valueListeners = null;
    transient Listeners listener = new Listeners();
    transient EventListenerList listenerList = new EventListenerList();
    protected boolean okayToBeep = false;
    protected boolean allow_text_change = false;
    protected boolean is_cell_editor = false;
    protected boolean select_all = false;
    protected JCValueModel valueModel = null;
    transient TextFieldDocument document = null;
    protected boolean restoringPrevious = false;

    public Field(Component component, JCValidator jCValidator) {
        this.vc = component;
        this.validator = jCValidator;
        if (jCValidator != null) {
            this.defaultValue = jCValidator.getDefaultValue();
        }
        this.event_source = component;
        this.initialize();
    }

    protected JTextField getTextField() {
        AbstractSpinBox abstractSpinBox;
        JTextField jTextField = null;
        if (this.vc instanceof JTextField) {
            jTextField = (JTextField)this.vc;
            if (!jTextField.isEditable()) {
                jTextField = null;
            }
        } else if (this.vc instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)this.vc;
            if (jComboBox.isEditable()) {
                jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
            }
        } else if (this.vc instanceof AbstractSpinBox && (abstractSpinBox = (AbstractSpinBox)this.vc).isEditable()) {
            jTextField = (JTextField)abstractSpinBox.getEditor().getEditorComponent();
        }
        return jTextField;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void initialize() {
        JTextField jTextField = this.getTextField();
        boolean bl = false;
        if (jTextField == null) {
            bl = this.vc instanceof JCLabelField;
        }
        if (jTextField != null) {
            this.document = new TextFieldDocument(new TextFieldContent());
            jTextField.setDocument(this.document);
        }
        if (jTextField == null && !bl) {
            throw new ClassCastException("Visual Component not supported by Field");
        }
        this.invalidBackground = null;
        this.invalidForeground = null;
        this.select_on_enter = false;
        if (jTextField != null) {
            jTextField.addFocusListener(this.listener);
            jTextField.addKeyListener(this.listener);
            this.validBackground = (Color)UIManager.get("TextField.background");
            this.validForeground = (Color)UIManager.get("TextField.foreground");
        } else {
            if (!bl) {
                this.vc.addFocusListener(this.listener);
                this.vc.addKeyListener(this.listener);
            }
            this.validBackground = this.vc.getBackground();
            this.validForeground = this.vc.getForeground();
        }
        if (this.vc instanceof JComboBox && !(this.vc instanceof JCPopupField)) {
            ((JComboBox)this.vc).setModel(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners = JCListenerList.add(this.propertyListeners, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners = JCListenerList.remove(this.propertyListeners, propertyChangeListener);
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    public void setDataProperties(DataProperties dataProperties) {
        this.validator = dataProperties.getValidator();
        if (this.validator != null && this.vc instanceof JCPopupField) {
            ((JCPopupField)this.vc).setPopupEditor(this.validator.createPopupComponent());
        }
        if (this.validator != null) {
            this.defaultValue = this.validator.getDefaultValue();
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this);
        }
        if (dataProperties.getValueModel() != null) {
            this.valueModel = dataProperties.getValueModel();
            this.valueModel.addValueListener(this);
        }
        if (this.vc instanceof JCPopupField) {
            this.valueModel.addValueListener((JCPopupField)this.vc);
        }
        this.setValueAndReformat(this.valueModel.getValue());
        this.setInvalidInfo(dataProperties.getInvalidInfo());
    }

    public void setCellEditor(boolean bl) {
        this.is_cell_editor = bl;
    }

    public DataProperties getDataProperties() {
        if (this.validator != null) {
            this.defaultValue = this.validator.getDefaultValue();
        }
        DataProperties dataProperties = new DataProperties(this.validator, this.valueModel, this.getInvalidInfo());
        return dataProperties;
    }

    public void addNotify() {
        if (this.valueModel != null) {
            this.valueModel.getValue();
        }
        this.okayToBeep = true;
    }

    protected Color getInvalidBackground() {
        JTextField jTextField = this.getTextField();
        if (this.invalidBackground == null) {
            if (jTextField != null) {
                return jTextField.getBackground();
            }
            return this.vc.getBackground();
        }
        return this.invalidBackground;
    }

    protected void setInvalidBackground(Color color) {
        this.invalidBackground = color;
        if (this.state == 3) {
            this.setColors(this.invalidBackground, this.invalidForeground);
        }
    }

    protected Color getInvalidForeground() {
        JTextField jTextField = this.getTextField();
        if (this.invalidForeground == null) {
            if (jTextField != null) {
                return jTextField.getForeground();
            }
            return this.vc.getForeground();
        }
        return this.invalidForeground;
    }

    protected void setInvalidForeground(Color color) {
        this.invalidForeground = color;
        if (this.state == 3) {
            this.setColors(this.invalidBackground, this.invalidForeground);
        }
    }

    protected Color getValidBackground() {
        return this.validBackground;
    }

    protected Color getValidForeground() {
        return this.validForeground;
    }

    protected boolean getBeepOnInvalid() {
        return this.beepOnInvalid;
    }

    protected void setBeepOnInvalid(boolean bl) {
        this.beepOnInvalid = bl;
    }

    protected int getInvalidPolicy() {
        return this.invalidPolicy;
    }

    protected void setInvalidPolicy(int n2) {
        if (this.invalidPolicy == n2) {
            return;
        }
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("invalid value for invalidPolicy");
        }
        this.invalidPolicy = n2;
        if (this.state != 3) {
            return;
        }
        if (this.state == 3) {
            this.processFailure();
        }
    }

    public JCInvalidInfo getInvalidInfo() {
        Color color = this.invalidBackground;
        Color color2 = this.invalidForeground;
        if (this.invalidForeground == null) {
            color2 = this.validForeground;
        }
        if (this.invalidBackground == null) {
            color = this.validBackground;
        }
        return new JCInvalidInfo(this.beepOnInvalid, this.invalidPolicy, color2, color);
    }

    public void setInvalidInfo(JCInvalidInfo jCInvalidInfo) {
        this.setBeepOnInvalid(jCInvalidInfo.getBeepOnInvalid());
        this.setInvalidForeground(jCInvalidInfo.getInvalidForeground());
        this.setInvalidBackground(jCInvalidInfo.getInvalidBackground());
        this.setInvalidPolicy(jCInvalidInfo.getInvalidPolicy());
    }

    public int getState() {
        return this.state;
    }

    public boolean getSelectOnEnter() {
        return this.select_on_enter;
    }

    public void setSelectOnEnter(boolean bl) {
        this.select_on_enter = bl;
    }

    public Object getValue() {
        if (this.validator == null || this.valueModel == null) {
            return null;
        }
        return this.validator.copyValue(this.valueModel.getValue());
    }

    protected void setValueAndReformat(Object object) {
        this.setValue(object, false);
        this.valueChanged(null);
    }

    public void setClass(Class clazz) {
        if (this.valueModel != null && this.valueModel.getValueClass() == clazz) {
            return;
        }
        if (DataPropertiesRegistry.isRegistered(clazz)) {
            if (this.valueModel == null) {
                this.setValueModel(DataPropertiesRegistry.createValueModel(clazz));
            }
            if (this.validator == null) {
                this.setValidator(DataPropertiesRegistry.createValidator(clazz));
            }
        }
    }

    public void setValue(Object object) {
        this.setValue(object, true);
    }

    protected void setValue(Object object, boolean bl) {
        if (this.valueModel == null || this.validator == null) {
            if (object != null) {
                this.setClass(object.getClass());
            } else {
                return;
            }
        }
        if (this.valueModel == null) {
            return;
        }
        Object object2 = this.valueModel.getValue();
        if (bl && (object == object2 || this.validator != null && this.validator.compareValues(object, object2))) {
            this.internal_text_change = true;
            JTextField jTextField = this.getTextField();
            if (this.has_focus && this.validator.hasEditFormat() && jTextField != null && jTextField.isEditable()) {
                this.setText(this.validator.formatForEdit(object2));
            } else {
                this.setText(this.validator.format(object2));
            }
            this.internal_text_change = false;
            boolean bl2 = this.validator.validate(object2);
            if (bl2) {
                this.setStateValid();
            } else {
                this.setStateInvalid();
            }
            return;
        }
        this.valueModel.setValue(object, bl);
    }

    public boolean getAllowTextChange() {
        return this.allow_text_change;
    }

    protected void setText(String string) {
        JTextField jTextField = this.getTextField();
        if (jTextField == null) {
            if (this.vc instanceof JCLabelField) {
                this.allow_text_change = true;
                ((JCLabelField)this.vc).setText(string);
                this.allow_text_change = false;
            } else if (this.vc instanceof JCSpinField) {
                this.allow_text_change = true;
                ((JCSpinField)this.vc).getRenderer().getComponent((AbstractSpinBox)this.vc, this.getValue());
                this.allow_text_change = false;
            } else if (this.vc instanceof JCPopupField) {
                ListCellRenderer<String> listCellRenderer = ((JCPopupField)this.vc).getRenderer();
                listCellRenderer.getListCellRendererComponent(new JList(), string, -1, true, false);
            }
            return;
        }
        this.allow_text_change = true;
        if (this.document.getOverstrike()) {
            this.document.setOverstrike(false);
            jTextField.setText(string);
            this.document.setOverstrike(true);
        } else {
            jTextField.setText(string);
        }
        this.allow_text_change = false;
    }

    public JCValueModel getValueModel() {
        return this.valueModel;
    }

    public void setValueModel(JCValueModel jCValueModel) {
        if (jCValueModel == null) {
            return;
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this);
        }
        Class<?> clazz = jCValueModel.getValueClass();
        if (this.validator != null) {
            if (!this.validator.isClassSupported(clazz)) {
                throw new IllegalArgumentException("Current validator cannot support the data model");
            }
        } else if (DataPropertiesRegistry.isRegistered(clazz)) {
            this.valueModel = jCValueModel;
            this.setValidator(DataPropertiesRegistry.createValidator(clazz));
        }
        this.valueModel = jCValueModel;
        this.valueModel.addValueListener(this);
        if (this.vc instanceof JCPopupField) {
            this.valueModel.addValueListener((JCPopupField)this.vc);
        }
        this.setValueAndReformat(this.valueModel.getValue());
    }

    public JCValidator getValidator() {
        return this.validator;
    }

    public void setValidator(JCValidator jCValidator) {
        if (jCValidator != null && jCValidator != this.validator && this.vc instanceof JCPopupField) {
            ((JCPopupField)this.vc).setPopupEditor(jCValidator.createPopupComponent());
        }
        if (this.valueModel == null) {
            this.validator = jCValidator;
            if (jCValidator != null) {
                this.defaultValue = jCValidator.getDefaultValue();
            }
            return;
        }
        Class<?> clazz = this.valueModel.getValueClass();
        if (!jCValidator.isClassSupported(clazz)) {
            throw new IllegalArgumentException("Validator being set does not support the current data model");
        }
        this.validator = jCValidator;
        if (jCValidator != null) {
            this.defaultValue = jCValidator.getDefaultValue();
        }
        this.setValueAndReformat(this.valueModel.getValue());
        if (this.vc instanceof JCSpinField) {
            ((JCSpinField)this.vc).checkArrowButtons();
        }
    }

    protected void setColors(Color color, Color color2) {
        Component component = null;
        JTextField jTextField = this.getTextField();
        component = jTextField != null ? jTextField : this.vc;
        if (color == null) {
            color = this.validBackground;
        }
        if (color2 == null) {
            color2 = this.validForeground;
        }
        this.internalBackgroundChange = true;
        component.setBackground(color);
        this.internalBackgroundChange = false;
        this.internalForegroundChange = true;
        component.setForeground(color2);
        this.internalForegroundChange = false;
    }

    protected void processFailure() {
        switch (this.invalidPolicy) {
            case 1: {
                this.setStateInvalid();
                break;
            }
            case 2: {
                this.setValue(this.defaultValue);
                break;
            }
            case 3: {
                this.setValue(this.previousValue);
                break;
            }
            case 4: {
                this.setValue(null);
            }
        }
    }

    protected void setStateInvalid() {
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (this.state != 3) {
            if (this.okayToBeep && this.beepOnInvalid) {
                this.vc.getToolkit().beep();
            }
            this.setColors(this.invalidBackground, this.invalidForeground);
            int n2 = this.state;
            this.state = 3;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n2), new Integer(3));
            Enumeration<Object> enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected void setStateValid() {
        if (this.state != 1) {
            this.setColors(null, null);
            int n2 = this.state;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n2), new Integer(1));
            Enumeration<Object> enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            this.state = 1;
        }
    }

    protected void setStateUnderEdit() {
        if (this.state == 3) {
            this.setColors(null, null);
        }
        if (this.state != 2) {
            int n2 = this.state;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.vc, "state", new Integer(n2), new Integer(2));
            Enumeration<Object> enumeration = JCListenerList.elements(this.propertyListeners);
            while (enumeration.hasMoreElements()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        this.state = 2;
    }

    public Component getComponent() {
        return this.vc;
    }

    public Object getEventSource() {
        return this.event_source;
    }

    public void setEventSource(Object object) {
        this.event_source = object;
    }

    public void commitEdit() {
        this.commitEdit(null);
    }

    public void commitEdit(AWTEvent aWTEvent) {
        JComboBox jComboBox;
        this.doCommitEdit(aWTEvent);
        JComboBox jComboBox2 = jComboBox = this.vc instanceof JComboBox ? (JComboBox)this.vc : null;
        if (jComboBox != null) {
            if (jComboBox.isPopupVisible()) {
                jComboBox.hidePopup();
                jComboBox.showPopup();
            }
            jComboBox.setPopupVisible(false);
        }
    }

    protected void doCommitEdit(AWTEvent aWTEvent) {
        JTextField jTextField = this.getTextField();
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        this.turnOffAutoCompleteMode();
        if (this.state != 2) {
            if (jTextField != null && this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
            return;
        }
        this.doing_commit = true;
        String string = null;
        if (jTextField != null) {
            string = jTextField.getText();
        }
        Object object = null;
        boolean bl = false;
        if (jTextField == null || string == null || string.length() == 0) {
            object = null;
        } else {
            try {
                object = this.validator.parse(this.valueModel.getValueClass(), jTextField.getText());
            }
            catch (FieldParseException fieldParseException) {
                bl = true;
            }
        }
        if (bl) {
            this.previousValue = this.valueModel.getValue();
            this.processFailure();
            this.doing_commit = false;
            return;
        }
        this.setValue(object);
        if (this.invalidPolicy != 1) {
            this.valueChanged(null);
        }
        this.doing_commit = false;
    }

    public Component getVisualComponent() {
        return this.vc;
    }

    public void textValueChangeBegin(TextEvent textEvent) {
        if (this.validator == null || this.valueModel == null) {
            return;
        }
        if (this.internal_text_change) {
            return;
        }
        if (this.validator != null) {
            this.validator.changeText(textEvent);
        }
        if (!textEvent.getAllowChange() && this.beepOnInvalid && this.okayToBeep) {
            this.vc.getToolkit().beep();
        }
    }

    public void textValueChangeEnd(TextEvent textEvent) {
        if (this.internal_text_change) {
            return;
        }
    }

    public void textCursorMoveBegin(TextCursorEvent textCursorEvent) {
        if (this.validator != null) {
            this.validator.setCursor(textCursorEvent);
        }
    }

    public int getSize() {
        if (this.validator == null || this.validator.getPickList() == null) {
            return 0;
        }
        return this.validator.getPickList().getSize();
    }

    public Object getElementAt(int n2) {
        if (this.validator == null || this.validator.getPickList() == null) {
            return null;
        }
        return this.validator.format(this.validator.getPickList().getElementAt(n2));
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(ListDataListener.class, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(ListDataListener.class, listDataListener);
    }

    protected void fireContentsChanged(Object object, int n2, int n3) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        this.in_contents_change = true;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(object, 0, n2, n3);
            }
            ((ListDataListener)objectArray[i2 + 1]).contentsChanged(listDataEvent);
        }
        this.in_contents_change = false;
    }

    protected void restorePickList() {
        JCComboField jCComboField;
        JCComboField jCComboField2 = jCComboField = this.vc instanceof JCComboField ? (JCComboField)this.vc : null;
        if (jCComboField != null && jCComboField.isAutoComplete() && jCComboField.isAutoRefinement() && this.validator != null) {
            jCComboField.restoreOriginalPickList();
        }
    }

    public void setSelectedItem(Object object) {
        JComboBox jComboBox;
        this.set_selected_item_called = true;
        if (object == null || this.validator == null) {
            return;
        }
        this.in_set_selected_item = true;
        boolean bl = this.validator instanceof JCStringValidator && !(this.validator instanceof JCIPAddressValidator);
        boolean bl2 = bl && ((JCStringValidator)this.validator).getMask() != null && ((JCStringValidator)this.validator).getMask().length() > 0;
        boolean bl3 = true;
        if (this.doing_completion && bl && bl2) {
            bl3 = false;
        }
        ListModel listModel = this.validator.getPickList();
        boolean bl4 = false;
        if (listModel != null) {
            for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
                Object e2 = listModel.getElementAt(i2);
                boolean bl5 = bl4 = bl3 ? object.equals(this.validator.format(e2)) : object.equals(e2);
                if (!bl4) continue;
                object = listModel.getElementAt(i2).toString();
                break;
            }
        }
        if (!(!bl3 || bl4 && bl && bl2)) {
            Object object2 = null;
            try {
                if (this.valueModel != null) {
                    object2 = this.validator.parse(this.valueModel.getValueClass(), (String)object);
                }
            }
            catch (FieldParseException fieldParseException) {
                // empty catch block
            }
            object = object2;
        }
        this.setValue(object);
        if (!this.doing_completion && !this.upDownPressed) {
            this.restorePickList();
        }
        this.upDownPressed = false;
        if (this.vc instanceof JComboBox && (jComboBox = (JComboBox)this.vc).isPopupVisible()) {
            jComboBox.setPopupVisible(true);
        }
        this.in_set_selected_item = false;
    }

    public Object getSelectedItem() {
        if (this.validator == null) {
            return "";
        }
        Object object = this.getValue();
        object = this.state == 2 && !this.auto_complete_mode ? this.validator.formatForEdit(object) : this.validator.format(object);
        return object;
    }

    protected void calcAutoCompleteMode(JCComboField jCComboField) {
        this.auto_complete_mode = false;
        if (!this.doing_commit && jCComboField != null && this.validator.getPickList() != null && this.validator instanceof JCStringValidator) {
            this.auto_complete_mode = jCComboField.isAutoComplete();
        }
    }

    protected void turnOffAutoCompleteMode() {
        JTextField jTextField = this.getTextField();
        if (this.auto_complete_mode && jTextField != null) {
            jTextField.setSelectionStart(jTextField.getCaretPosition());
            jTextField.setSelectionEnd(jTextField.getCaretPosition());
        }
        this.restorePickList();
        this.auto_complete_mode = false;
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
        Object object;
        if (jCValueEvent != null) {
            // empty if block
        }
        if (jCValueEvent != null) {
            object = new JCValueEvent(this.vc, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
            this.fireValueChangingEvent((JCValueEvent)object);
            if (!((JCValueEvent)object).getAllowChange()) {
                jCValueEvent.setAllowChange(false);
                this.valueChanged(null);
                return;
            }
            if (((JCValueEvent)object).getNewValue() != jCValueEvent.getNewValue() && !this.doing_completion) {
                jCValueEvent.setNewValue(((JCValueEvent)object).getNewValue());
            }
        }
        object = jCValueEvent.getOldValue();
        Object object2 = jCValueEvent.getNewValue();
        boolean bl = this.validator != null ? this.validator.validate(object2) : false;
        if (bl) {
            if (this.valueModel != null && this.validator != null && object2 != object) {
                jCValueEvent.setNewValue(this.validator.copyValue(object2));
            }
            this.setStateValid();
        } else {
            switch (this.invalidPolicy) {
                case 1: {
                    this.setStateInvalid();
                    break;
                }
                case 2: {
                    object2 = this.defaultValue;
                    break;
                }
                case 3: {
                    object2 = jCValueEvent.getOldValue();
                    if (this.valueModel != null && this.validator != null && this.validator.validate(object2) && jCValueEvent.getNewValue() != object) {
                        object2 = this.validator.copyValue(object2);
                        break;
                    }
                    this.setStateInvalid();
                    break;
                }
                case 4: {
                    boolean bl2 = this.validator.validate(null);
                    object2 = null;
                    if (bl2) {
                        this.setStateValid();
                        break;
                    }
                    this.setStateInvalid();
                }
            }
            jCValueEvent.setNewValue(object2);
        }
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        Object object;
        if (jCValueEvent != null) {
            // empty if block
        }
        if (jCValueEvent != null) {
            object = new JCValueEvent(this.vc, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
            this.fireValueChangedEvent((JCValueEvent)object);
        }
        object = null;
        if (jCValueEvent == null) {
            object = this.valueModel.getValue();
        } else {
            object = jCValueEvent.getNewValue();
            this.previousValue = jCValueEvent.getOldValue();
        }
        this.internal_text_change = true;
        JTextField jTextField = this.getTextField();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (jTextField != null) {
            n3 = jTextField.getSelectionStart();
            n4 = jTextField.getSelectionEnd();
            n5 = jTextField.getText().length();
        }
        if (this.validator != null) {
            if (this.has_focus && this.validator.hasEditFormat() && jTextField != null && jTextField.isEditable()) {
                this.setText(this.validator.formatForEdit(object));
            } else {
                this.setText(this.validator.format(object));
            }
        }
        if (jTextField != null && n5 == jTextField.getText().length() && !this.auto_complete_mode) {
            if (n3 == n4 && n3 == n2) {
                jTextField.setCaretPosition(n2);
            } else {
                jTextField.select(n3, n4);
            }
        }
        this.internal_text_change = false;
        if (this.vc instanceof JCSpinField) {
            ((JCSpinField)this.vc).checkArrowButtons();
        }
    }

    protected void fireValueChangingEvent(JCValueEvent jCValueEvent) {
        if (jCValueEvent == null || this.in_contents_change) {
            return;
        }
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanging(jCValueEvent);
        }
    }

    protected void fireValueChangedEvent(JCValueEvent jCValueEvent) {
        if (jCValueEvent == null || this.in_contents_change) {
            return;
        }
        Enumeration<Object> enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanged(jCValueEvent);
        }
    }

    final class ContentPosition
    implements Position {
        PositionEntry rec;

        ContentPosition(int n2, TextFieldContent textFieldContent) {
            this.rec = new PositionEntry(n2);
            textFieldContent.marks.addElement(this.rec);
        }

        public int getOffset() {
            return this.rec.offset;
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class PositionEntry {
        int offset;
        boolean unused;

        PositionEntry(int n2) {
            this.offset = n2;
        }
    }

    public class TextFieldContent
    implements AbstractDocument.Content,
    Serializable {
        protected boolean overstrike = false;
        private int data_length;
        private final char[] empty = new char[0];
        private char[] data;
        public transient Vector marks;

        public TextFieldContent() {
            this(10);
        }

        public TextFieldContent(int n2) {
            if (n2 < 1) {
                n2 = 1;
            }
            this.data = new char[n2];
            this.data[0] = 10;
            this.data_length = 1;
        }

        public int length() {
            return this.data_length;
        }

        protected void replaceRange(int n2, char[] cArray, int n3, int n4) {
            System.arraycopy(cArray, n3, this.data, n2, n4);
        }

        public UndoableEdit insertString(int n2, String string) throws BadLocationException {
            if (n2 >= this.data_length) {
                throw new BadLocationException("Invalid location", this.data_length);
            }
            char[] cArray = string.toCharArray();
            if (!this.overstrike || n2 == this.data_length - 1) {
                this.insertText(n2, 0, cArray, 0, cArray.length);
                if (this.marks != null) {
                    this.updateMarksForInsert(n2, string.length());
                }
            } else {
                this.replaceRange(n2, cArray, 0, cArray.length);
            }
            return null;
        }

        public void insertText(int n2, int n3, char[] cArray, int n4, int n5) {
            int n6 = n5 - n3;
            int n7 = n2 + n3;
            int n8 = this.data_length - n7;
            int n9 = n7 + n6;
            if (this.data_length + n6 >= this.data.length) {
                int n10 = Math.max(2 * this.data.length, this.data_length + n6);
                char[] cArray2 = new char[n10];
                System.arraycopy(this.data, 0, cArray2, 0, n2);
                System.arraycopy(cArray, n4, cArray2, n2, n5);
                System.arraycopy(this.data, n7, cArray2, n9, n8);
                this.data = cArray2;
            } else {
                System.arraycopy(this.data, n7, this.data, n9, n8);
                System.arraycopy(cArray, n4, this.data, n2, n5);
            }
            this.data_length += n6;
        }

        public UndoableEdit remove(int n2, int n3) throws BadLocationException {
            if (n2 + n3 >= this.data_length) {
                throw new BadLocationException("Invalid range", this.data_length);
            }
            if (!this.overstrike) {
                this.insertText(n2, n3, this.empty, 0, 0);
                if (this.marks != null) {
                    this.updateMarksForRemove(n2, n3);
                }
            } else {
                char[] cArray = new char[n3];
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = 32;
                }
                this.replaceRange(n2, cArray, 0, n3);
            }
            return null;
        }

        public String getString(int n2, int n3) throws BadLocationException {
            if (n2 + n3 > this.data_length) {
                throw new BadLocationException("Invalid range", this.data_length);
            }
            return new String(this.data, n2, n3);
        }

        public void getChars(int n2, int n3, Segment segment) throws BadLocationException {
            if (n2 + n3 > this.data_length) {
                throw new BadLocationException("Invalid location", this.data_length);
            }
            segment.array = this.data;
            segment.offset = n2;
            segment.count = n3;
        }

        public Position createPosition(int n2) throws BadLocationException {
            if (this.marks == null) {
                this.marks = new Vector();
            }
            return new ContentPosition(n2, this);
        }

        public void setOverstrike(boolean bl) {
            this.overstrike = bl;
        }

        public boolean getOverstrike() {
            return this.overstrike;
        }

        synchronized void updateMarksForInsert(int n2, int n3) {
            if (n2 == 0) {
                n2 = 1;
            }
            int n4 = this.marks.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                PositionEntry positionEntry = (PositionEntry)this.marks.elementAt(i2);
                if (positionEntry.unused) {
                    this.marks.removeElementAt(i2);
                    --i2;
                    --n4;
                    continue;
                }
                if (positionEntry.offset < n2) continue;
                positionEntry.offset += n3;
            }
        }

        synchronized void updateMarksForRemove(int n2, int n3) {
            int n4 = this.marks.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                PositionEntry positionEntry = (PositionEntry)this.marks.elementAt(i2);
                if (positionEntry.unused) {
                    this.marks.removeElementAt(i2);
                    --i2;
                    --n4;
                    continue;
                }
                if (positionEntry.offset >= n2 + n3) {
                    positionEntry.offset -= n3;
                    continue;
                }
                if (positionEntry.offset < n2) continue;
                positionEntry.offset = n2;
            }
        }
    }

    class TextFieldDocument
    extends PlainDocument
    implements CaretListener {
        protected SelectedItem selected;
        protected boolean doingRemove;
        protected int currentCursorPosition;
        protected int lastCursorPosition;

        public TextFieldDocument(AbstractDocument.Content content) {
            super(content);
            this.selected = null;
            this.doingRemove = false;
            this.currentCursorPosition = 0;
            this.lastCursorPosition = 0;
            JTextField jTextField = Field.this.getTextField();
            jTextField.addCaretListener(this);
            this.currentCursorPosition = jTextField.getCaretPosition();
        }

        public void setOverstrike(boolean bl) {
            ((TextFieldContent)this.getContent()).setOverstrike(bl);
        }

        public boolean getOverstrike() {
            return ((TextFieldContent)this.getContent()).getOverstrike();
        }

        protected String getMatchedPrefix(JCComboField jCComboField, String string) {
            int n2 = 0;
            int n3 = -1;
            String[] stringArray = jCComboField.getPrefixList();
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    if (string2 == null || string2.length() == 0) continue;
                    int n4 = string2.length();
                    if (!string.startsWith(string2) || n4 <= n2) continue;
                    n2 = n4;
                    n3 = i2;
                }
            }
            if (n2 > 0) {
                return stringArray[n3];
            }
            return null;
        }

        protected SelectedItem getPickListCompletion(JCComboField jCComboField, String string, String string2, int n2, int n3) {
            String string3;
            if (Field.this.validator == null || Field.this.validator.getPickList() == null || string == null || n2 < 0) {
                return null;
            }
            ListModel listModel = jCComboField.isAutoRefinement() ? jCComboField.getOriginalPickList() : Field.this.validator.getPickList();
            String string4 = string3 = this.getOverstrike() ? string2 : string;
            if (listModel != null && string3 != null) {
                for (int i2 = n2; i2 < listModel.getSize(); ++i2) {
                    Object e2 = listModel.getElementAt(i2);
                    String string5 = e2.toString();
                    if (string5 == null || string5.length() <= 0) continue;
                    if (string3.length() == 0) {
                        return new SelectedItem(e2, i2);
                    }
                    String string6 = this.getMatchedPrefix(jCComboField, string5);
                    if (string6 != null && string6.length() != 0) {
                        StringBuffer stringBuffer = new StringBuffer(string6);
                        stringBuffer.append(string3);
                        if (!string5.startsWith(stringBuffer.toString())) continue;
                        return new SelectedItem(e2, i2, string6.length());
                    }
                    if (!string5.startsWith(string3)) continue;
                    return new SelectedItem(e2, i2);
                }
            }
            return null;
        }

        protected void doCompletion(JCComboField jCComboField, String string, int n2) {
            SelectedItem selectedItem;
            Object object;
            String string2 = null;
            if (this.getOverstrike()) {
                object = null;
                try {
                    object = Field.this.validator.parse(Field.this.valueModel.getValueClass(), string);
                }
                catch (FieldParseException fieldParseException) {
                    // empty catch block
                }
                string2 = object == null ? null : object.toString();
            }
            this.selected = null;
            object = null;
            if (jCComboField.isAutoRefinement()) {
                object = new JCListModel();
                selectedItem = this.getPickListCompletion(jCComboField, string, string2, 0, n2);
                while (selectedItem != null) {
                    if (this.selected == null) {
                        this.selected = selectedItem;
                    }
                    ((DefaultListModel)object).addElement(selectedItem.item);
                    selectedItem = this.getPickListCompletion(jCComboField, string, string2, selectedItem.index + 1, n2);
                }
                String string3 = null;
                if (this.getOverstrike() && string2 != null) {
                    string3 = string2.length() == 0 ? null : string2;
                } else if (string != null) {
                    String string4 = string3 = string.length() == 0 ? null : string;
                }
                if (this.selected == null || string3 != null && !string3.equals(this.selected.item)) {
                    ((DefaultListModel)object).addElement(string3);
                }
                int n3 = ((DefaultListModel)object).getSize();
                if (this.selected == null && n3 > 0) {
                    this.selected = new SelectedItem(((DefaultListModel)object).getElementAt(n3 - 1), 0);
                }
            } else {
                this.selected = this.getPickListCompletion(jCComboField, string, string2, 0, n2);
            }
            SelectedItem selectedItem2 = selectedItem = this.selected == null ? null : Field.this.validator.format(this.selected.item);
            if (this.selected != null && selectedItem != null) {
                this.selected.start_pos = this.getOverstrike() ? n2 : string.length();
                this.selected.end_pos = ((String)((Object)selectedItem)).length();
                if (this.selected.prefix_length > 0) {
                    this.selected.end_pos -= this.selected.prefix_length;
                }
                this.selected.end_pos = Math.max(this.selected.start_pos, this.selected.end_pos);
                this.selected.parsed = string2;
                Field.this.doing_completion = true;
                if (object != null) {
                    jCComboField.setTemporaryPickList((ListModel)object);
                }
                if (jCComboField.isAutoSuggest()) {
                    if (jCComboField.isAutoRefinement()) {
                        jCComboField.setPopupVisible(false);
                    }
                    jCComboField.setPopupVisible(true);
                }
                jCComboField.setSelectedItem(this.selected.item);
                if (!Field.this.set_selected_item_called) {
                    Field.this.setSelectedItem(this.selected.item);
                }
                Field.this.set_selected_item_called = false;
                if (jCComboField.isPopupVisible() || jCComboField.isAutoSuggest()) {
                    jCComboField.setPopupVisible(true);
                }
                Field.this.doing_completion = false;
            }
        }

        protected void doAutoCompleteSelection(JTextField jTextField, JCComboField jCComboField) {
            int n2;
            String string;
            int n3;
            if (!Field.this.auto_complete_mode || jTextField == null || jCComboField == null || !jCComboField.isAutoAppend() || this.selected == null || this.selected.start_pos >= this.selected.end_pos) {
                return;
            }
            JCStringValidator jCStringValidator = (JCStringValidator)Field.this.validator;
            String string2 = jTextField.getText();
            if (this.getOverstrike() && (n3 = jCStringValidator.getLastValidInputCharPosition(string = jCStringValidator.format(this.selected.parsed))) >= (n2 = jCStringValidator.getLastValidInputCharPosition(string2))) {
                jTextField.getCaret().setDot(jCStringValidator.getNextCursorPosition(n2, true));
                return;
            }
            if (string2 != null && this.selected.end_pos <= string2.length()) {
                jTextField.select(this.selected.start_pos, this.selected.end_pos);
            }
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (Field.this.validator == null || Field.this.valueModel == null || Field.this.in_contents_change) {
                return;
            }
            JTextField jTextField = Field.this.getTextField();
            if (jTextField == null) {
                return;
            }
            if (Field.this.validator instanceof JCStringValidator && ((JCStringValidator)Field.this.validator).getMask() != null && ((JCStringValidator)Field.this.validator).getMask().length() > 0) {
                this.setOverstrike(true);
            }
            boolean bl = false;
            Caret caret = jTextField.getCaret();
            int n3 = Math.min(caret.getDot(), caret.getMark());
            int n4 = Math.max(caret.getDot(), caret.getMark());
            int n5 = Field.this.validator.getFirstValidCursorPosition();
            if (n3 < n5) {
                n3 = n5;
            }
            TextEvent textEvent = new TextEvent(jTextField.getText(), n3, n4, string, false);
            Field.this.textValueChangeBegin(textEvent);
            bl = textEvent.getAllowChange();
            String string2 = jTextField.getSelectedText();
            if (bl && string2 != null && string2.length() != 0) {
                try {
                    this.remove(textEvent.getStartPosition(), string2.length());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            caret.setDot(textEvent.getStartPosition());
            if (bl && !Field.this.doing_completion) {
                super.insertString(caret.getDot(), textEvent.getText(), attributeSet);
            }
            JCComboField jCComboField = Field.this.vc instanceof JComboBox ? (JCComboField)Field.this.vc : null;
            Field.this.calcAutoCompleteMode(jCComboField);
            if (Field.this.auto_complete_mode && bl) {
                if (!Field.this.doing_completion) {
                    if (Field.this.in_set_selected_item) {
                        return;
                    }
                    String string3 = jTextField.getText();
                    if (string3 != null && string3.length() != 0) {
                        this.doCompletion(jCComboField, string3, textEvent.getEndPosition());
                    }
                    return;
                }
                boolean bl2 = jCComboField.isAutoAppend() && !this.doingRemove;
                String string4 = textEvent.getText();
                if (this.getOverstrike() && this.selected != null) {
                    String string5 = string4 = bl2 ? this.selected.item.toString() : this.selected.parsed;
                }
                if (string4 != null) {
                    if (this.selected != null && this.selected.prefix_length > 0 && string4.length() >= this.selected.prefix_length) {
                        string4 = string4.substring(this.selected.prefix_length);
                    }
                    if (this.getOverstrike() && this.selected != null) {
                        string4 = Field.this.validator.format(string4);
                    }
                    if (!bl2 && this.selected != null) {
                        if (this.getOverstrike()) {
                            super.insertString(caret.getDot(), string4, attributeSet);
                            caret.setDot(this.selected.start_pos);
                        } else if (string4.length() >= this.selected.start_pos) {
                            String string6 = string4.substring(0, this.selected.start_pos);
                            super.insertString(caret.getDot(), string6, attributeSet);
                        }
                    } else {
                        super.insertString(caret.getDot(), string4, attributeSet);
                    }
                }
                if (bl2) {
                    this.doAutoCompleteSelection(jTextField, jCComboField);
                }
                Field.this.setStateUnderEdit();
            }
        }

        public void remove(int n2, int n3) throws BadLocationException {
            int n4;
            if (Field.this.validator == null || Field.this.valueModel == null || Field.this.in_contents_change) {
                return;
            }
            JTextField jTextField = Field.this.getTextField();
            if (jTextField == null) {
                return;
            }
            TextEvent textEvent = new TextEvent(jTextField.getText(), n2, n2 + n3, "", true);
            Field.this.textValueChangeBegin(textEvent);
            String string = textEvent.getText();
            int n5 = n4 = string == null ? 0 : string.length();
            if (this.getOverstrike()) {
                jTextField.setCaretPosition(textEvent.getStartPosition());
                int n6 = jTextField.getCaretPosition();
                int n7 = 0;
                if (n2 < n6 && string != null && n4 >= 1) {
                    n7 = n6 - n2;
                    string = string.substring(n7);
                }
                super.insertString(n6, string, null);
                jTextField.getCaret().setDot(textEvent.getStartPosition() + n7);
            } else {
                super.remove(n2, n3);
            }
            JCComboField jCComboField = Field.this.vc instanceof JComboBox ? (JCComboField)Field.this.vc : null;
            Field.this.calcAutoCompleteMode(jCComboField);
            if (!Field.this.auto_complete_mode || !textEvent.getAllowChange() || Field.this.in_set_selected_item) {
                return;
            }
            JCStringValidator jCStringValidator = (JCStringValidator)Field.this.validator;
            int n8 = n2 + n3;
            String string2 = jTextField == null ? null : jTextField.getText();
            int n9 = string2 == null ? 0 : string2.length();
            int n10 = jTextField.getCaret().getDot();
            int n11 = jCStringValidator.getLastValidInputCharPosition(string2);
            if (!(n9 <= 0 && !jCComboField.isAutoRefinement() || Field.this.doing_completion || n10 >= n11 && !jCComboField.isAutoRefinement() || this.selected == null || this.selected.start_pos == n2 && this.selected.end_pos == n8)) {
                this.doingRemove = true;
                this.doCompletion(jCComboField, string2, n10);
                this.doingRemove = false;
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.lastCursorPosition = this.currentCursorPosition;
            this.currentCursorPosition = caretEvent.getDot();
            JTextField jTextField = Field.this.getTextField();
            TextCursorEvent textCursorEvent = new TextCursorEvent(this.lastCursorPosition, this.currentCursorPosition);
            Field.this.textCursorMoveBegin(textCursorEvent);
            if (this.getOverstrike() && textCursorEvent.getNewPosition() != this.currentCursorPosition && jTextField != null && jTextField.getCaret() != null) {
                jTextField.getCaret().setDot(textCursorEvent.getNewPosition());
            }
        }

        public class SelectedItem {
            public int prefix_length = -1;
            public Object item = null;
            public String parsed = null;
            public int index = -1;
            public int start_pos = 0;
            public int end_pos = 0;

            SelectedItem(Object object, int n2, int n3) {
                this.item = object;
                this.index = n2;
                this.prefix_length = n3;
            }

            SelectedItem(Object object, int n2) {
                this.item = object;
                this.index = n2;
            }
        }
    }

    class Listeners
    implements FocusListener,
    KeyListener,
    Serializable {
        Listeners() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Field.this.has_focus = true;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            JTextField jTextField = Field.this.getTextField();
            if (jTextField == null) {
                return;
            }
            if (!jTextField.isEditable()) {
                return;
            }
            if (Field.this.validator.hasEditFormat() && Field.this.state != 3) {
                Field.this.internal_text_change = true;
                Field.this.setText(Field.this.validator.formatForEdit(Field.this.valueModel.getValue()));
                Field.this.internal_text_change = false;
            }
            if (Field.this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Field.this.has_focus = false;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            if (Field.this.state == 2) {
                Field.this.commitEdit(focusEvent);
            } else if (Field.this.state != 3 && Field.this.validator != null && Field.this.validator.hasEditFormat()) {
                Field.this.setValue(Field.this.valueModel.getValue());
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = null;
            boolean bl = false;
            if (Field.this.validator == null || Field.this.valueModel == null) {
                return;
            }
            Object object2 = Field.this.valueModel.getValue();
            JTextField jTextField = Field.this.getTextField();
            if (jTextField != null) {
                // empty if block
            }
            if (Field.this.vc instanceof JCPopupField && ((JCPopupField)Field.this.vc).isPopupVisible()) {
                if (((JCPopupField)Field.this.vc).getPopupEditor() == null) {
                    return;
                }
                boolean bl2 = ((JCPopupField)Field.this.vc).getPopupEditor().processKeyEvent(keyEvent);
                if (bl2) {
                    return;
                }
            }
            JComboBox jComboBox = Field.this.vc instanceof JComboBox ? (JComboBox)Field.this.vc : null;
            int n2 = keyEvent.getKeyCode();
            switch (n2) {
                case 27: {
                    if (jComboBox != null && jComboBox.isPopupVisible()) {
                        jComboBox.setPopupVisible(false);
                        keyEvent.consume();
                        return;
                    }
                    bl = true;
                    if (Field.this.state != 2 && Field.this.state != 3) break;
                    int n3 = Field.this.state;
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(Field.this.vc, "state", new Integer(n3), new Integer(1));
                    Enumeration<Object> enumeration = JCListenerList.elements(Field.this.propertyListeners);
                    while (enumeration.hasMoreElements()) {
                        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                    Field.this.state = 1;
                    object = object2;
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    Field.this.commitEdit(keyEvent);
                    keyEvent.consume();
                    return;
                }
                case 38: 
                case 40: {
                    Field.this.upDownPressed = true;
                    return;
                }
                default: {
                    if (Field.this.state == 2) break;
                    Field.this.setStateUnderEdit();
                }
            }
            if (object != null) {
                Field.this.setValue(object);
            }
            if (jTextField != null && bl && Field.this.select_on_enter) {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

