/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d.actions;

import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.actions.BaseAction;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import javax.vecmath.Matrix4d;

public class ZoomAction
extends BaseAction {
    protected Point first = null;
    protected Point last = null;

    public void start(InputEvent inputEvent, int n2, int n3) {
        if (this.getChart3dArea() == null || !this.enabled) {
            return;
        }
        this.first = new Point(n2, n3);
        this.last = null;
        this.status = 1;
    }

    public void animate(InputEvent inputEvent, int n2, int n3) {
        if (this.getChart3dArea() == null || !this.enabled || this.status == 0) {
            return;
        }
        if (this.first == null) {
            return;
        }
        this.status = 2;
        if (this.last == null) {
            this.last = new Point(n2, n3);
            this.getChart3dArea().drawZoomRectangle(this.last, this.first);
            return;
        }
        this.getChart3dArea().drawZoomRectangle(this.last, this.first);
        this.last.x = n2;
        this.last.y = n3;
        this.getChart3dArea().drawZoomRectangle(this.last, this.first);
    }

    public void reanimate(int n2, int n3) {
        if (this.getChart3dArea() == null || !this.enabled || this.first == null || this.status != 2) {
            return;
        }
        this.last = new Point(n2, n3);
        this.getChart3dArea().drawZoomRectangle(this.last, this.first);
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.getChart3dArea() == null || !this.enabled || this.status == 0) {
            return;
        }
        JCChart3d jCChart3d = this.getChart3dArea().getChart3d();
        if (jCChart3d != null) {
            jCChart3d.sendEvent();
        }
        this.status = 0;
        JCViewport jCViewport = this.getChart3dArea().getViewport();
        if (this.first != null && this.last != null && this.first.x != this.last.x && this.first.y != this.last.y) {
            this.getChart3dArea().drawZoomRectangle(this.last, this.first);
            Rectangle rectangle = new Rectangle();
            rectangle.x = Math.min(this.first.x, this.last.x);
            rectangle.y = Math.min(this.first.y, this.last.y);
            rectangle.width = Math.max(this.first.x, this.last.x);
            rectangle.height = Math.max(this.first.y, this.last.y);
            rectangle.width -= rectangle.x;
            rectangle.height -= rectangle.y;
            Transform transform = this.getChart3dArea().getTransform();
            JCBox jCBox = transform.getCurrentViewport();
            Matrix4d matrix4d = transform.getInverseScreen();
            JCBox jCBox2 = new JCBox();
            jCBox2.x = rectangle.getX() * matrix4d.m00 + matrix4d.m03;
            jCBox2.y = (rectangle.getY() + rectangle.getHeight()) * matrix4d.m11 + matrix4d.m13;
            jCBox2.width = rectangle.getWidth() * matrix4d.m00;
            jCBox2.height = rectangle.getHeight() * -matrix4d.m11;
            double d2 = jCBox.width / jCBox2.width;
            double d3 = jCBox.height / jCBox2.height;
            double d4 = Math.min(d2, d3);
            double d5 = (jCBox2.x - jCBox.x) / jCBox.width;
            double d6 = (jCBox2.y - jCBox.y) / jCBox.height;
            jCViewport.setViewport(d4, d5, d6);
        }
        this.first = null;
        this.last = null;
    }

    public void cancel() {
        if (this.getChart3dArea() == null || !this.enabled || this.status == 0) {
            return;
        }
        if (this.first != null && this.last != null && this.first.x != this.last.x && this.first.y != this.last.y) {
            this.getChart3dArea().drawZoomRectangle(this.last, this.first);
        }
        this.status = 0;
        this.first = null;
        this.last = null;
    }
}

