/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j2d.actions;

import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.j2d.actions.BaseAction;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.vecmath.Matrix4d;

public class TranslateAction
extends BaseAction {
    protected Point first = null;
    protected Point last = null;
    protected double horizontalShift = 0.0;
    protected double verticalShift = 0.0;
    protected double origHorizontalShift = 0.0;
    protected double origVerticalShift = 0.0;

    public void start(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled) {
            return;
        }
        this.first = new Point(n2, n3);
        this.last = new Point(n2, n3);
        this.status = 1;
        JCViewport jCViewport = this.chart3dArea.getViewport();
        this.origHorizontalShift = jCViewport.getHorizontalShift();
        this.origVerticalShift = jCViewport.getVerticalShift();
    }

    public void animate(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        if (this.last == null) {
            return;
        }
        if (inputEvent instanceof KeyEvent) {
            switch (((KeyEvent)inputEvent).getKeyCode()) {
                case 38: {
                    n2 = this.last.x;
                    n3 = this.last.y - 1;
                    break;
                }
                case 40: {
                    n2 = this.last.x;
                    n3 = this.last.y + 1;
                    break;
                }
                case 37: {
                    n2 = this.last.x - 1;
                    n3 = this.last.y;
                    break;
                }
                case 39: {
                    n2 = this.last.x + 1;
                    n3 = this.last.y;
                }
            }
        }
        if (n3 == this.last.y && n2 == this.last.x) {
            return;
        }
        this.status = 2;
        int n4 = this.last.x - n2;
        int n5 = this.last.y - n3;
        this.last.x = n2;
        this.last.y = n3;
        JCViewport jCViewport = this.chart3dArea.getViewport();
        Transform transform = this.chart3dArea.getTransform();
        JCBox jCBox = transform.getCurrentViewport();
        Matrix4d matrix4d = transform.getInverseScreen();
        this.horizontalShift = jCViewport.getHorizontalShift() + (double)n4 * matrix4d.m00 / jCBox.width;
        this.verticalShift = jCViewport.getVerticalShift() + (double)n5 * matrix4d.m11 / jCBox.height;
        JCView3d jCView3d = this.chart3dArea.getView3d();
        this.drawPreview(jCViewport.getScale(), this.horizontalShift, this.verticalShift, jCView3d.getXRotation(), jCView3d.getYRotation(), jCView3d.getZRotation(), 0, n2, n3, false);
    }

    public void reanimate(int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status != 2) {
            return;
        }
        JCViewport jCViewport = this.chart3dArea.getViewport();
        JCView3d jCView3d = this.chart3dArea.getView3d();
        this.drawPreview(jCViewport.getScale(), this.horizontalShift, this.verticalShift, jCView3d.getXRotation(), jCView3d.getYRotation(), jCView3d.getZRotation(), 0, n2, n3, false);
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        JCChart3d jCChart3d = this.chart3dArea.getChart3d();
        if (jCChart3d != null) {
            jCChart3d.sendEvent();
        }
        this.status = 0;
        this.first = null;
        this.last = null;
        JCViewport jCViewport = this.chart3dArea.getViewport();
        jCViewport.setViewport(jCViewport.getScale(), this.horizontalShift, this.verticalShift);
    }

    public void cancel() {
        if (this.chart3dArea == null || !this.enabled || this.status == 0) {
            return;
        }
        this.status = 0;
        this.first = null;
        this.last = null;
        JCViewport jCViewport = this.chart3dArea.getViewport();
        jCViewport.setViewport(jCViewport.getScale(), this.origHorizontalShift, this.origVerticalShift);
    }
}

