/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.data;

import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.HoleValueChart3dDataModel;
import com.klg.jclass.chart3d.LabelledChart3dGridDataModel;
import com.klg.jclass.chart3d.LabelledChart3dPointDataModel;
import com.klg.jclass.chart3d.data.Base3dDataSource;
import com.klg.jclass.chart3d.data.Base3dGridDataSource;
import com.klg.jclass.chart3d.data.Base3dPointDataSource;
import com.klg.jclass.util.LocaleHandler;
import com.klg.jclass.util.io.XMLTextUtil;
import com.klg.jclass.util.property.xml.LocalizedPropertyHandler;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML3dDataHandler
extends LocalizedPropertyHandler {
    protected StringBuffer sb = null;
    protected Base3dDataSource baseDS = null;
    protected boolean inGrid = true;
    protected Point3d curPoint = null;
    protected List<Double> xData = null;
    protected List<Double> yData = null;
    protected List<Double> zData = null;
    protected List<List<Double>> zValues = null;
    protected List<String> xLabels = null;
    protected List<String> yLabels = null;
    protected List<List<Point3d>> seriesList = null;
    protected List<String> seriesLabels = null;
    protected List<Point3d> point3dList = null;
    public static final String XML_DS_DATA = "data";
    public static final String XML_DS_GRID_DATA = "grid-data";
    public static final String XML_DS_POINT_DATA = "point-data";
    public static final String XML_DS_XLABEL = "xlabel";
    public static final String XML_DS_YLABEL = "ylabel";
    public static final String XML_DS_XGRID = "xgrid";
    public static final String XML_DS_YGRID = "ygrid";
    public static final String XML_DS_ZGRID = "zgrid";
    public static final String XML_DS_XVAL = "xval";
    public static final String XML_DS_YVAL = "yval";
    public static final String XML_DS_ZVAL = "zval";
    public static final String XML_DS_SERIES = "series";
    public static final String XML_DS_POINT3D = "point3d";
    public static final String XML_DS_ATT_HOLE = "hole";
    public static final String XML_DS_ATT_NAME = "name";
    public static final String XML_DS_ATT_LABEL = "label";

    public XML3dDataHandler() {
    }

    public XML3dDataHandler(Base3dDataSource base3dDataSource) {
        this();
        this.baseDS = base3dDataSource;
    }

    public XML3dDataHandler(LocaleHandler localeHandler) {
        this.localeHandler = localeHandler;
    }

    public XML3dDataHandler(Base3dDataSource base3dDataSource, LocaleHandler localeHandler) {
        this(base3dDataSource);
        this.localeHandler = localeHandler;
    }

    public static void setCharacterBounds(int n2, int n3) {
        XMLTextUtil.setCharacterBounds(n2, n3);
    }

    public static int getLowCharacterBound() {
        return XMLTextUtil.getLowCharacterBound();
    }

    public static int getHighCharacterBound() {
        return XMLTextUtil.getHighCharacterBound();
    }

    public Base3dDataSource getDataSource() {
        return this.baseDS;
    }

    public void setDataSource(Base3dDataSource base3dDataSource) {
        this.baseDS = base3dDataSource;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.handleStartElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handleEndElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.handleCharacters(cArray, n2, n3);
    }

    public void handleStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(XML_DS_GRID_DATA) || string3.equals(XML_DS_DATA)) {
            this.inGrid = true;
            if (this.baseDS == null) {
                this.baseDS = new Base3dGridDataSource();
            }
            if (!(this.baseDS instanceof Base3dGridDataSource)) {
                throw new SAXException("Trying to load grid data into a non-grid data source.");
            }
            if (attributes != null) {
                int n2 = attributes.getIndex(XML_DS_ATT_NAME);
                if (n2 > -1) {
                    this.baseDS.dataSourceName = attributes.getValue(n2);
                }
                if ((n2 = attributes.getIndex(XML_DS_ATT_HOLE)) > -1) {
                    this.baseDS.holeValue = this.getNextDouble(attributes.getValue(n2));
                }
            }
            this.zValues = new ArrayList<List<Double>>();
            this.xLabels = new ArrayList<String>();
            this.yLabels = new ArrayList<String>();
        } else if (string3.equals(XML_DS_XGRID)) {
            this.xData = new ArrayList<Double>();
        } else if (string3.equals(XML_DS_YGRID)) {
            this.yData = new ArrayList<Double>();
        } else if (string3.equals(XML_DS_ZGRID)) {
            this.zData = new ArrayList<Double>();
        } else if (string3.equals(XML_DS_POINT_DATA)) {
            this.inGrid = false;
            if (this.baseDS == null) {
                this.baseDS = new Base3dPointDataSource();
            }
            if (!(this.baseDS instanceof Base3dPointDataSource)) {
                throw new SAXException("Trying to load point data into a non-point data source.");
            }
            this.seriesList = new ArrayList<List<Point3d>>();
            this.seriesLabels = new ArrayList<String>();
        } else if (string3.equals(XML_DS_SERIES)) {
            this.point3dList = new ArrayList<Point3d>();
            String string4 = "";
            int n3 = attributes.getIndex(XML_DS_ATT_LABEL);
            if (n3 > -1) {
                String string5 = attributes.getValue(n3);
                string4 = string5 == null ? "" : string5;
            }
            this.seriesLabels.add(string4);
        } else if (string3.equals(XML_DS_POINT3D)) {
            this.curPoint = new Point3d();
        }
    }

    public void handleEndElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = string4 = this.sb == null ? null : this.sb.toString();
        if (string3.equals(XML_DS_XVAL)) {
            Double d2 = this.getNextDouble(string4);
            if (this.inGrid) {
                this.xData.add(d2);
            } else {
                this.curPoint.x = d2;
            }
        } else if (string3.equals(XML_DS_YVAL)) {
            Double d3 = this.getNextDouble(string4);
            if (this.inGrid) {
                this.yData.add(d3);
            } else {
                this.curPoint.y = d3;
            }
        } else if (string3.equals(XML_DS_ZVAL)) {
            Double d4 = this.getNextDouble(string4);
            if (this.inGrid) {
                this.zData.add(d4);
            } else {
                this.curPoint.z = d4;
            }
        } else if (string3.equals(XML_DS_ZGRID)) {
            this.zValues.add(this.zData);
            this.zData = null;
        } else if (string3.equals(XML_DS_XLABEL)) {
            this.xLabels.add(string4);
        } else if (string3.equals(XML_DS_YLABEL)) {
            this.yLabels.add(string4);
        } else if (string3.equals(XML_DS_GRID_DATA) || string3.equals(XML_DS_DATA)) {
            this.processGridArrays();
        } else if (string3.equals(XML_DS_POINT_DATA)) {
            this.processPointArrays();
        } else if (string3.equals(XML_DS_SERIES)) {
            this.seriesList.add(this.point3dList);
            this.point3dList = null;
        } else if (string3.equals(XML_DS_POINT3D)) {
            this.point3dList.add(this.curPoint);
            this.curPoint = null;
        }
        this.sb = null;
    }

    public void handleCharacters(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        if (this.localeHandler != null) {
            string = this.localizeString(string);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected double[] processListToDoubles(List<Double> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        double[] dArray = new double[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Double d2 = list.get(i2);
            dArray[i2] = d2;
        }
        return dArray;
    }

    protected double[] fillOutDoubleArray(double[] dArray, int n2) {
        int n3;
        if (dArray != null && dArray.length >= n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        int n4 = n3 = dArray == null ? 0 : dArray.length;
        if (n3 > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n3);
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            dArray2[i2] = this.baseDS.getHoleValue();
        }
        return dArray2;
    }

    protected String[] processLabels(List<String> list, int n2) {
        if (n2 <= 0 || list == null || list.size() == 0) {
            return null;
        }
        boolean bl = false;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 < list.size()) {
                String string = list.get(i2);
                if (string != null) {
                    bl = true;
                }
                if (string == null || string.length() == 0) {
                    string = "";
                }
                stringArray[i2] = string;
                continue;
            }
            stringArray[i2] = null;
        }
        return bl ? stringArray : null;
    }

    protected void processGridArrays() throws SAXException {
        int n2;
        int n3;
        int n4;
        Base3dGridDataSource base3dGridDataSource = (Base3dGridDataSource)this.baseDS;
        int n5 = n4 = this.xData == null ? 0 : this.xData.size();
        if (n4 == 0) {
            throw new SAXException("X grid elements are empty");
        }
        int n6 = n3 = this.yData == null ? 0 : this.yData.size();
        if (n3 == 0) {
            throw new SAXException("Y grid elements are empty");
        }
        base3dGridDataSource.xGrid = this.processListToDoubles(this.xData);
        base3dGridDataSource.yGrid = this.processListToDoubles(this.yData);
        int n7 = n2 = this.zValues == null ? 0 : this.zValues.size();
        if (n2 == 0) {
            throw new SAXException("Z values are empty");
        }
        double[][] dArrayArray = new double[n4][];
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 < n2) {
                List<Double> list = this.zValues.get(i2);
                dArrayArray[i2] = this.fillOutDoubleArray(this.processListToDoubles(list), n3);
                continue;
            }
            dArrayArray[i2] = this.fillOutDoubleArray(null, n3);
        }
        base3dGridDataSource.zValues = dArrayArray;
        base3dGridDataSource.xLabels = this.processLabels(this.xLabels, n4);
        base3dGridDataSource.yLabels = this.processLabels(this.yLabels, n3);
    }

    protected void processPointArrays() throws SAXException {
        Base3dPointDataSource base3dPointDataSource = (Base3dPointDataSource)this.baseDS;
        int n2 = this.seriesList.size();
        Point3d[][] point3dArrayArray = new Point3d[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            List<Point3d> list = this.seriesList.get(i2);
            point3dArrayArray[i2] = list.toArray(new Point3d[0]);
        }
        base3dPointDataSource.points = point3dArrayArray;
        base3dPointDataSource.seriesLabels = this.seriesLabels.toArray(new String[0]);
    }

    protected Double getNextDouble(String string) throws SAXException {
        Double d2;
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            d2 = new Double(this.baseDS.getHoleValue());
        } else if (string.equalsIgnoreCase("MAX")) {
            d2 = new Double(Double.MAX_VALUE);
        } else if (string.equalsIgnoreCase("MIN")) {
            d2 = new Double(Double.MIN_VALUE);
        } else if (string.equalsIgnoreCase("INFINITY")) {
            d2 = new Double(Double.POSITIVE_INFINITY);
        } else {
            try {
                d2 = Double.valueOf(string);
            }
            catch (Exception exception) {
                System.err.println("Expecting either a hole or numeric value and not " + string);
                throw new SAXException("Error in data file format - ");
            }
            if (d2 == null) {
                d2 = new Double(0.0);
            }
        }
        return d2;
    }

    public static String doubleToString(double d2, double d3, boolean bl) {
        String string = bl && d2 == d3 ? XML_DS_ATT_HOLE : (d2 == Double.MAX_VALUE ? "max" : (d2 == Double.MIN_VALUE ? "min" : String.valueOf(d2)));
        return string;
    }

    private static void writeDouble(double d2, double d3, boolean bl, Writer writer, StringBuffer stringBuffer, String string, int n2) throws IOException {
        XML3dDataHandler.writeString(writer, stringBuffer, "<" + string + ">", n2);
        XML3dDataHandler.writeString(writer, stringBuffer, XML3dDataHandler.doubleToString(d2, d3, bl), 0);
        XML3dDataHandler.writeString(writer, stringBuffer, "</" + string + ">\n", 0);
    }

    private static void writeDoubleArray(double[] dArray, double d2, boolean bl, Writer writer, StringBuffer stringBuffer, String string, String string2, int n2, int n3) throws IOException {
        XML3dDataHandler.writeString(writer, stringBuffer, "<" + string + ">\n", n2);
        for (double d3 : dArray) {
            XML3dDataHandler.writeDouble(d3, d2, bl, writer, stringBuffer, string2, n2 + n3);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, "</" + string + ">\n", n2);
    }

    private static void writeString(Writer writer, StringBuffer stringBuffer, String string, int n2) throws IOException {
        if (writer == null && stringBuffer == null || string == null) {
            return;
        }
        StringBuffer stringBuffer2 = null;
        if (n2 > 0) {
            stringBuffer2 = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer2.append(" ");
            }
        }
        if (writer != null) {
            if (stringBuffer2 != null) {
                writer.write(stringBuffer2.toString());
            }
            writer.write(string);
        }
        if (stringBuffer != null) {
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append(string);
        }
    }

    private static void writeStringArray(String[] stringArray, Writer writer, StringBuffer stringBuffer, String string, int n2) throws IOException {
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = false;
            for (String string2 : stringArray) {
                if (string2 == null || string2.length() <= 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (String string2 : stringArray) {
                    XML3dDataHandler.writeString(writer, stringBuffer, "<" + string + ">", n2);
                    XML3dDataHandler.writeString(writer, stringBuffer, XMLTextUtil.expandReservedCharacters(string2), 0);
                    XML3dDataHandler.writeString(writer, stringBuffer, "</" + string + ">\n", 0);
                }
            }
        }
    }

    private static void writeGridDataToXML(Chart3dGridDataModel chart3dGridDataModel, Writer writer, StringBuffer stringBuffer, int n2, int n3, boolean bl) throws IOException {
        Object object;
        if (chart3dGridDataModel == null) {
            System.err.println("The data is null.");
            return;
        }
        if (writer == null && stringBuffer == null) {
            System.err.println("Nothing to write to.  Both the writer and the StringBuffer are null.");
            return;
        }
        double[] dArray = chart3dGridDataModel.getXGrid();
        if (dArray == null || dArray.length == 0) {
            System.err.println("The x grid is null.");
            return;
        }
        double[] dArray2 = chart3dGridDataModel.getYGrid();
        if (dArray2 == null || dArray2.length == 0) {
            System.err.println("The y grid is null.");
            return;
        }
        double[][] dArray3 = chart3dGridDataModel.getZValues();
        if (dArray3 == null) {
            System.err.println("The z values are null.");
            return;
        }
        boolean bl2 = false;
        Object object2 = dArray3;
        int n4 = ((double[][])object2).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            object = object2[i2];
            if (object == null) continue;
            bl2 = true;
        }
        if (!bl2) {
            System.err.println("Cannot find any non-null z arrays.");
            return;
        }
        object2 = null;
        String[] stringArray = null;
        String string = null;
        if (chart3dGridDataModel instanceof LabelledChart3dGridDataModel) {
            object = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
            object2 = object.getXLabels();
            stringArray = object.getYLabels();
            string = object.getDataSourceName();
        }
        boolean bl3 = false;
        double d2 = Double.MAX_VALUE;
        if (chart3dGridDataModel instanceof HoleValueChart3dDataModel) {
            d2 = ((HoleValueChart3dDataModel)((Object)chart3dGridDataModel)).getHoleValue();
            bl3 = true;
        }
        n2 = Math.max(n2, 0);
        n3 = Math.max(n3, 0);
        if (bl) {
            XML3dDataHandler.writeString(writer, stringBuffer, "<?xml version=\"1.0\"?>\n", n2);
            XML3dDataHandler.writeString(writer, stringBuffer, "<!DOCTYPE grid-data SYSTEM \"JCChart3dData.dtd\">\n", n2);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, "<grid-data", n2);
        if (string != null && string.length() > 0) {
            XML3dDataHandler.writeString(writer, stringBuffer, " name=\"" + XMLTextUtil.expandReservedCharacters(string) + "\"", 0);
        }
        if (bl3 && d2 != Double.MAX_VALUE) {
            XML3dDataHandler.writeString(writer, stringBuffer, " hole=\"" + XML3dDataHandler.doubleToString(d2, d2, false) + "\"", 0);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, ">\n", 0);
        XML3dDataHandler.writeDoubleArray(dArray, d2, bl3, writer, stringBuffer, XML_DS_XGRID, XML_DS_XVAL, n2 += n3, n3);
        XML3dDataHandler.writeDoubleArray(dArray2, d2, bl3, writer, stringBuffer, XML_DS_YGRID, XML_DS_YVAL, n2, n3);
        for (double[] dArray4 : dArray3) {
            if (dArray4 == null) continue;
            XML3dDataHandler.writeDoubleArray(dArray4, d2, bl3, writer, stringBuffer, XML_DS_ZGRID, XML_DS_ZVAL, n2, n3);
        }
        XML3dDataHandler.writeStringArray((String[])object2, writer, stringBuffer, XML_DS_XLABEL, n2);
        XML3dDataHandler.writeStringArray(stringArray, writer, stringBuffer, XML_DS_XLABEL, n2);
        XML3dDataHandler.writeString(writer, stringBuffer, "</grid-data>\n", n2 -= n3);
        if (writer != null) {
            writer.flush();
        }
    }

    private static void writePointDataToXML(Chart3dPointDataModel chart3dPointDataModel, Writer writer, StringBuffer stringBuffer, int n2, int n3, boolean bl) throws IOException {
        if (chart3dPointDataModel == null) {
            System.err.println("The data is null.");
            return;
        }
        if (writer == null && stringBuffer == null) {
            System.err.println("Nothing to write to.  Both the writer and the StringBuffer are null.");
            return;
        }
        Point3d[][] point3dArray = chart3dPointDataModel.getPoints();
        if (point3dArray == null || point3dArray.length == 0) {
            System.err.println("No points to write.");
            return;
        }
        String string = null;
        String[] stringArray = null;
        if (chart3dPointDataModel instanceof LabelledChart3dPointDataModel) {
            LabelledChart3dPointDataModel labelledChart3dPointDataModel = (LabelledChart3dPointDataModel)((Object)chart3dPointDataModel);
            stringArray = labelledChart3dPointDataModel.getSeriesLabels();
            string = labelledChart3dPointDataModel.getDataSourceName();
        }
        boolean bl2 = false;
        double d2 = Double.MAX_VALUE;
        if (chart3dPointDataModel instanceof HoleValueChart3dDataModel) {
            d2 = ((HoleValueChart3dDataModel)((Object)chart3dPointDataModel)).getHoleValue();
            bl2 = true;
        }
        n2 = Math.max(n2, 0);
        n3 = Math.max(n3, 0);
        if (bl) {
            XML3dDataHandler.writeString(writer, stringBuffer, "<?xml version=\"1.0\"?>\n", n2);
            XML3dDataHandler.writeString(writer, stringBuffer, "<!DOCTYPE point-data SYSTEM \"JCChart3dData.dtd\">\n", n2);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, "<point-data", n2);
        if (string != null && string.length() > 0) {
            XML3dDataHandler.writeString(writer, stringBuffer, " name=\"" + XMLTextUtil.expandReservedCharacters(string) + "\"", 0);
        }
        if (bl2 && d2 != Double.MAX_VALUE) {
            XML3dDataHandler.writeString(writer, stringBuffer, " hole=\"" + XML3dDataHandler.doubleToString(d2, d2, false) + "\"", 0);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, ">\n", 0);
        n2 += n3;
        for (int i2 = 0; i2 < point3dArray.length; ++i2) {
            XML3dDataHandler.writeString(writer, stringBuffer, "<series", n2);
            String string2 = null;
            if (stringArray != null) {
                String string3 = string2 = i2 < stringArray.length ? stringArray[i2] : null;
            }
            if (string2 != null && string2.length() > 0) {
                XML3dDataHandler.writeString(writer, stringBuffer, " label=\"" + XMLTextUtil.expandReservedCharacters(string2) + "\"", 0);
            }
            XML3dDataHandler.writeString(writer, stringBuffer, ">\n", 0);
            Point3d[] point3dArray2 = point3dArray[i2];
            if (point3dArray2 != null && point3dArray2.length > 0) {
                n2 += n3;
                for (Point3d point3d : point3dArray2) {
                    XML3dDataHandler.writeString(writer, stringBuffer, "<point3d>\n", n2);
                    XML3dDataHandler.writeDouble(point3d.x, d2, bl2, writer, stringBuffer, XML_DS_XVAL, n2 + n3);
                    XML3dDataHandler.writeDouble(point3d.y, d2, bl2, writer, stringBuffer, XML_DS_YVAL, n2 + n3);
                    XML3dDataHandler.writeDouble(point3d.z, d2, bl2, writer, stringBuffer, XML_DS_ZVAL, n2 + n3);
                    XML3dDataHandler.writeString(writer, stringBuffer, "</point3d>\n", n2);
                }
                n2 -= n3;
            }
            XML3dDataHandler.writeString(writer, stringBuffer, "</series>\n", n2);
        }
        XML3dDataHandler.writeString(writer, stringBuffer, "</point-data>\n", n2 -= n3);
        if (writer != null) {
            writer.flush();
        }
    }

    public static void writeDataToXML(Chart3dDataModel chart3dDataModel, Object object, int n2, int n3, boolean bl) throws IOException {
        if (chart3dDataModel == null) {
            return;
        }
        Writer writer = null;
        StringBuffer stringBuffer = null;
        if (object instanceof String) {
            String string = (String)object;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            writer = new OutputStreamWriter(dataOutputStream);
        } else if (object instanceof OutputStream) {
            OutputStream outputStream = (OutputStream)object;
            DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
            writer = new OutputStreamWriter(dataOutputStream);
        } else if (object instanceof Writer) {
            writer = (Writer)object;
        } else if (object instanceof StringBuffer) {
            stringBuffer = (StringBuffer)object;
        } else {
            throw new IllegalArgumentException("Bad outputTarget.  Must be one of String, OutputStream, or Writer.");
        }
        if (chart3dDataModel instanceof Chart3dGridDataModel) {
            XML3dDataHandler.writeGridDataToXML((Chart3dGridDataModel)chart3dDataModel, writer, stringBuffer, n2, n3, bl);
        } else if (chart3dDataModel instanceof Chart3dPointDataModel) {
            XML3dDataHandler.writePointDataToXML((Chart3dPointDataModel)chart3dDataModel, writer, stringBuffer, n2, n3, bl);
        }
    }
}

