/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.data;

import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.data.JCEditable3dGridDataSource;
import com.klg.jclass.chart3d.event.Chart3dGridDataEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JCSwing3dDataSource
extends JCEditable3dGridDataSource
implements TableModelListener {
    protected TableModel tableModel;

    public JCSwing3dDataSource(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.setData();
    }

    protected void setData() {
        int n2;
        int n3 = this.tableModel.getRowCount();
        int n4 = this.tableModel.getColumnCount();
        double[][] dArray = new double[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n4; ++i2) {
                Object object = this.tableModel.getValueAt(n2, i2);
                if (object == null) {
                    dArray[n2][i2] = this.getHoleValue();
                    continue;
                }
                if (object instanceof Number) {
                    dArray[n2][i2] = ((Number)object).doubleValue();
                    continue;
                }
                if (object instanceof String) {
                    try {
                        dArray[n2][i2] = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        dArray[n2][i2] = 0.0;
                    }
                    continue;
                }
                dArray[n2][i2] = 0.0;
            }
        }
        this.setZValues(dArray);
        this.setXGrid(null);
        this.setYGrid(null);
        n2 = 2;
        JCData3dGridIndex jCData3dGridIndex = new JCData3dGridIndex(-100, -100);
        this.fireChart3dDataEvent(new Chart3dGridDataEvent((Object)this, n2, jCData3dGridIndex));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        int n4 = tableModelEvent.getColumn();
        if (n2 == -1 || n3 != n2 || tableModelEvent.getType() != 0 || n4 == -1) {
            this.setTableModel((TableModel)tableModelEvent.getSource());
        } else {
            double d2;
            Object object;
            try {
                object = this.tableModel.getValueAt(n2, n4);
                d2 = ((Number)object).doubleValue();
            }
            catch (Exception exception) {
                d2 = 0.0;
            }
            object = new JCData3dGridIndex(n2, n4);
            this.setZValue((JCData3dIndex)object, d2);
            int n5 = 9;
            this.fireChart3dDataEvent(new Chart3dGridDataEvent((Object)this, n5, (JCData3dGridIndex)object));
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.setData();
    }
}

