/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.AlignmentComboBox;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.TitlesEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TitlesGeneralEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener {
    private static final String nameKey = "General";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox isVisibleCheckBox;
    private JTextField textField;
    private AlignmentComboBox horizontalAlignmentComboBox;
    private AlignmentComboBox verticalAlignmentComboBox;

    public TitlesGeneralEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = TitlesGeneralEditor.getLocalizedString("Visible");
            this.isVisibleCheckBox = TitlesGeneralEditor.createCheckBox(string, this);
            string = TitlesGeneralEditor.getLocalizedString("Text");
            JLabel jLabel = new JLabel(string);
            this.textField = TitlesGeneralEditor.createTextField(10, this, this);
            string = TitlesGeneralEditor.getLocalizedString("Horizontal");
            JLabel jLabel2 = new JLabel(string);
            this.horizontalAlignmentComboBox = new AlignmentComboBox(0, this);
            string = TitlesGeneralEditor.getLocalizedString("Vertical");
            JLabel jLabel3 = new JLabel(string);
            this.verticalAlignmentComboBox = new AlignmentComboBox(1, this);
            JPanel jPanel = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel.add(this.isVisibleCheckBox);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            JPanel jPanel2 = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel2.add(new JPanel());
            jPanel2.add(this.textField);
            jPanel2.add(this.horizontalAlignmentComboBox);
            jPanel2.add(this.verticalAlignmentComboBox);
            JPanel jPanel3 = TitlesGeneralEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = TitlesGeneralEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.isVisibleCheckBox.removeActionListener(this);
            this.isVisibleCheckBox = null;
            this.textField.removeActionListener(this);
            this.textField.removeFocusListener(this);
            this.textField = null;
            this.horizontalAlignmentComboBox.removeActionListener(this);
            this.horizontalAlignmentComboBox = null;
            this.verticalAlignmentComboBox.removeActionListener(this);
            this.verticalAlignmentComboBox = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            TitlesEditor titlesEditor = (TitlesEditor)this.getParent();
            JComponent jComponent = titlesEditor.getSelectedTitleComponent();
            this.content.setEnabled(true);
            this.isVisibleCheckBox.setSelected(jComponent.isVisible());
            if (jComponent instanceof JLabel) {
                JLabel jLabel = (JLabel)jComponent;
                this.textField.setText(jLabel.getText());
                this.horizontalAlignmentComboBox.setSelectedAlignment(jLabel.getHorizontalTextPosition());
                this.verticalAlignmentComboBox.setSelectedAlignment(jLabel.getVerticalTextPosition());
            }
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.handleChange(focusEvent.getSource());
        }
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            TitlesEditor titlesEditor = (TitlesEditor)this.getParent();
            JComponent jComponent = titlesEditor.getSelectedTitleComponent();
            if (object == this.isVisibleCheckBox) {
                jComponent.setVisible(this.isVisibleCheckBox.isSelected());
                return;
            }
            if (!(jComponent instanceof JLabel)) {
                return;
            }
            JLabel jLabel = (JLabel)jComponent;
            if (object == this.textField) {
                jLabel.setText(this.textField.getText());
            } else if (object == this.horizontalAlignmentComboBox) {
                jLabel.setHorizontalAlignment(this.horizontalAlignmentComboBox.getSelectedAlignment());
            } else if (object == this.verticalAlignmentComboBox) {
                jLabel.setVerticalAlignment(this.verticalAlignmentComboBox.getSelectedAlignment());
            }
        }
    }
}

