/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCProjection;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public abstract class ProjectionEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private boolean refreshing = false;
    private boolean isFloor;
    private Container content;
    private JCheckBox isZonedCheckBox;
    private JCheckBox isContouredCheckBox;

    public ProjectionEditor(String string, boolean bl) {
        super(string);
        this.isFloor = bl;
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = ProjectionEditor.getLocalizedString("Zoned");
            this.isZonedCheckBox = ProjectionEditor.createCheckBox(string, this);
            string = ProjectionEditor.getLocalizedString("Contoured");
            this.isContouredCheckBox = ProjectionEditor.createCheckBox(string, this);
            JPanel jPanel = ProjectionEditor.createPreferredSizePanel();
            jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            jPanel.add(this.isZonedCheckBox);
            jPanel.add(this.isContouredCheckBox);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.isZonedCheckBox.removeActionListener(this);
            this.isZonedCheckBox = null;
            this.isContouredCheckBox.removeActionListener(this);
            this.isContouredCheckBox = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            JCProjection jCProjection = this.isFloor ? jCPlotCube.getFloor() : jCPlotCube.getCeiling();
            this.isZonedCheckBox.setSelected(jCProjection.isZoned());
            this.isContouredCheckBox.setSelected(jCProjection.isContoured());
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            JCProjection jCProjection;
            Object object = actionEvent.getSource();
            JCPlotCube jCPlotCube = this.getChart().getChart3dArea().getPlotCube();
            JCProjection jCProjection2 = jCProjection = this.isFloor ? jCPlotCube.getFloor() : jCPlotCube.getCeiling();
            if (object == this.isZonedCheckBox) {
                jCProjection.setZoned(this.isZonedCheckBox.isSelected());
                this.getChart().update();
            } else if (object == this.isContouredCheckBox) {
                jCProjection.setContoured(this.isContouredCheckBox.isSelected());
                this.getChart().update();
            }
        }
    }
}

