/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCChart3dLegend;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LegendGeneralEditor
extends Chart3dPropertyEditor
implements ActionListener {
    private static String nameKey = "General";
    private boolean refreshing = false;
    private Container content;
    private JCheckBox isVisibleCheckBox;
    private JComboBox anchorComboBox;
    private JComboBox orientationComboBox;
    private JComboBox layoutStyleComboBox;
    private JComboBox distRangeComboBox;
    private Object[] anchorModel;
    private Object[] orientationModel;
    private Object[] layoutStyleModel;
    private Object[] distRangeModel;

    public LegendGeneralEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = LegendGeneralEditor.getLocalizedString("Visible");
            this.isVisibleCheckBox = LegendGeneralEditor.createCheckBox(string, this);
            string = LegendGeneralEditor.getLocalizedString("Anchor");
            JLabel jLabel = new JLabel(string);
            this.anchorModel = new ComboBoxEntry[]{new ComboBoxEntry(16, LegendGeneralEditor.getLocalizedString("North")), new ComboBoxEntry(32, LegendGeneralEditor.getLocalizedString("South")), new ComboBoxEntry(1, LegendGeneralEditor.getLocalizedString("East")), new ComboBoxEntry(2, LegendGeneralEditor.getLocalizedString("West")), new ComboBoxEntry(17, LegendGeneralEditor.getLocalizedString("North East")), new ComboBoxEntry(18, LegendGeneralEditor.getLocalizedString("North West")), new ComboBoxEntry(33, LegendGeneralEditor.getLocalizedString("South East")), new ComboBoxEntry(34, LegendGeneralEditor.getLocalizedString("South West"))};
            Arrays.sort(this.anchorModel);
            this.anchorComboBox = LegendGeneralEditor.createComboBox(this.anchorModel, this);
            string = LegendGeneralEditor.getLocalizedString("Orientation");
            JLabel jLabel2 = new JLabel(string);
            this.orientationModel = new ComboBoxEntry[]{new ComboBoxEntry(0, LegendGeneralEditor.getLocalizedString("Horizontal")), new ComboBoxEntry(1, LegendGeneralEditor.getLocalizedString("Vertical"))};
            Arrays.sort(this.orientationModel);
            this.orientationComboBox = LegendGeneralEditor.createComboBox(this.orientationModel, this);
            string = LegendGeneralEditor.getLocalizedString("Layout Style");
            JLabel jLabel3 = new JLabel(string);
            this.layoutStyleModel = new ComboBoxEntry[]{new ComboBoxEntry(0, LegendGeneralEditor.getLocalizedString("Continuous")), new ComboBoxEntry(1, LegendGeneralEditor.getLocalizedString("Stepped"))};
            Arrays.sort(this.layoutStyleModel);
            this.layoutStyleComboBox = LegendGeneralEditor.createComboBox(this.layoutStyleModel, this);
            string = LegendGeneralEditor.getLocalizedString("Dist Range");
            JLabel jLabel4 = new JLabel(string);
            this.distRangeModel = new ComboBoxEntry[]{new ComboBoxEntry(1, LegendGeneralEditor.getLocalizedString("Data")), new ComboBoxEntry(0, LegendGeneralEditor.getLocalizedString("All"))};
            Arrays.sort(this.distRangeModel);
            this.distRangeComboBox = LegendGeneralEditor.createComboBox(this.distRangeModel, this);
            JPanel jPanel = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel.add(this.isVisibleCheckBox);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(jLabel3);
            jPanel.add(jLabel4);
            JPanel jPanel2 = new JPanel(new GridLayout(5, 0, 5, 5));
            jPanel2.add(new JPanel());
            jPanel2.add(this.anchorComboBox);
            jPanel2.add(this.orientationComboBox);
            jPanel2.add(this.layoutStyleComboBox);
            jPanel2.add(this.distRangeComboBox);
            JPanel jPanel3 = LegendGeneralEditor.createBorderPanel();
            jPanel3.setBorder(null);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(jPanel2);
            JPanel jPanel4 = LegendGeneralEditor.createPreferredSizePanel();
            jPanel4.add(jPanel3);
            this.content = Box.createVerticalBox();
            this.content.add(jPanel4);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.isVisibleCheckBox.removeActionListener(this);
            this.isVisibleCheckBox = null;
            this.anchorComboBox.removeActionListener(this);
            this.anchorComboBox = null;
            this.orientationComboBox.removeActionListener(this);
            this.orientationComboBox = null;
            this.layoutStyleComboBox.removeActionListener(this);
            this.layoutStyleComboBox = null;
            this.distRangeComboBox.removeActionListener(this);
            this.distRangeComboBox = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            JCLegend jCLegend = this.getChart().getLegend();
            this.isVisibleCheckBox.setSelected(jCLegend.isVisible());
            MutableComboBoxEntry mutableComboBoxEntry = new MutableComboBoxEntry();
            mutableComboBoxEntry.setConstant(jCLegend.getAnchor());
            this.anchorComboBox.setSelectedIndex(Arrays.binarySearch(this.anchorModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(jCLegend.getOrientation());
            this.orientationComboBox.setSelectedIndex(Arrays.binarySearch(this.orientationModel, mutableComboBoxEntry));
            if (!(jCLegend instanceof JCChart3dLegend)) {
                this.layoutStyleComboBox.setEnabled(false);
                this.distRangeComboBox.setEnabled(false);
                return;
            }
            this.layoutStyleComboBox.setEnabled(true);
            this.distRangeComboBox.setEnabled(true);
            mutableComboBoxEntry.setConstant(((JCChart3dLegend)jCLegend).getLayoutStyle());
            this.layoutStyleComboBox.setSelectedIndex(Arrays.binarySearch(this.layoutStyleModel, mutableComboBoxEntry));
            mutableComboBoxEntry.setConstant(((JCChart3dLegend)jCLegend).getDistributionRange());
            this.distRangeComboBox.setSelectedIndex(Arrays.binarySearch(this.distRangeModel, mutableComboBoxEntry));
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            JCLegend jCLegend = this.getChart().getLegend();
            if (object == this.isVisibleCheckBox) {
                jCLegend.setVisible(this.isVisibleCheckBox.isSelected());
                return;
            }
            JComboBox jComboBox = (JComboBox)object;
            int n2 = ((ComboBoxEntry)jComboBox.getSelectedItem()).getConstant();
            if (object == this.anchorComboBox) {
                jCLegend.setAnchor(n2);
            } else if (object == this.orientationComboBox) {
                jCLegend.setOrientation(n2);
            }
            if (!(jCLegend instanceof JCChart3dLegend)) {
                return;
            }
            if (object == this.layoutStyleComboBox) {
                ((JCChart3dLegend)jCLegend).setLayoutStyle(n2);
            } else if (object == this.distRangeComboBox) {
                ((JCChart3dLegend)jCLegend).setDistributionRange(n2);
            }
        }
    }

    public static class MutableComboBoxEntry
    extends ComboBoxEntry {
        private int constant;

        public MutableComboBoxEntry() {
            super(0, "");
        }

        public void setConstant(int n2) {
            this.constant = n2;
        }

        public int getConstant() {
            return this.constant;
        }
    }

    public static class ComboBoxEntry
    implements Comparable {
        private int constant;
        private String name;

        public ComboBoxEntry(int n2, String string) {
            this.name = string;
            this.constant = n2;
        }

        public int compareTo(Object object) {
            int n2 = ((ComboBoxEntry)object).getConstant();
            if (this.getConstant() < n2) {
                return -1;
            }
            if (this.getConstant() > n2) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof ComboBoxEntry) {
                return ((ComboBoxEntry)object).getConstant() == this.getConstant();
            }
            return false;
        }

        public int getConstant() {
            return this.constant;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

