/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.chart3d.customizer.DataViewEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DataViewContourLevelsEditor
extends Chart3dPropertyEditor
implements ActionListener,
ListDataListener,
FocusListener {
    private static final String nameKey = "Contour Levels";
    private boolean refreshing = false;
    private Container content;
    private JRadioButton useDefaultLevelsButton;
    private JRadioButton setLevelsButton;
    private JTextField numLevelsField;
    private JList levelsList;
    private JButton addButton;
    private JButton removeButton;
    private LevelsModel levelsModel;

    public DataViewContourLevelsEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            String string = DataViewContourLevelsEditor.getLocalizedString("Use Default Levels");
            this.useDefaultLevelsButton = DataViewContourLevelsEditor.createRadioButton(string, this);
            this.useDefaultLevelsButton.setAlignmentX(0.0f);
            string = DataViewContourLevelsEditor.getLocalizedString("Set Levels");
            this.setLevelsButton = DataViewContourLevelsEditor.createRadioButton(string, this);
            this.setLevelsButton.setAlignmentX(0.0f);
            string = DataViewContourLevelsEditor.getLocalizedString("Levels");
            JLabel jLabel = new JLabel(string);
            this.numLevelsField = DataViewContourLevelsEditor.createTextField(10, this, this);
            string = DataViewContourLevelsEditor.getLocalizedString("Add");
            this.addButton = DataViewContourLevelsEditor.createButton(string, this);
            string = DataViewContourLevelsEditor.getLocalizedString("Remove");
            this.removeButton = DataViewContourLevelsEditor.createButton(string, this);
            this.levelsModel = new LevelsModel();
            this.levelsModel.addListDataListener(this);
            this.levelsList = new JList(this.levelsModel);
            this.levelsList.setPrototypeCellValue("XXXXXXXXXXXX");
            JScrollPane jScrollPane = new JScrollPane(this.levelsList, 20, 30);
            jScrollPane.setAlignmentX(0.0f);
            JPanel jPanel = DataViewContourLevelsEditor.createBorderPanel(0, 15, 0, 0);
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.numLevelsField);
            jPanel.setAlignmentX(0.0f);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel2.add(this.addButton);
            jPanel2.add(this.removeButton);
            jPanel2.setAlignmentX(0.0f);
            this.content = DataViewContourLevelsEditor.createBorderPanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(this.useDefaultLevelsButton);
            this.content.add(jPanel);
            this.content.add(this.setLevelsButton);
            this.content.add(jScrollPane);
            this.content.add(Box.createVerticalStrut(5));
            this.content.add(jPanel2);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.useDefaultLevelsButton.removeActionListener(this);
            this.useDefaultLevelsButton = null;
            this.setLevelsButton.removeActionListener(this);
            this.setLevelsButton = null;
            this.numLevelsField.removeActionListener(this);
            this.numLevelsField.removeFocusListener(this);
            this.numLevelsField = null;
            this.levelsModel.removeListDataListener(this);
            this.levelsModel = null;
            this.levelsList = null;
            this.addButton.removeActionListener(this);
            this.addButton = null;
            this.removeButton.removeActionListener(this);
            this.removeButton = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            JCContourLevels jCContourLevels = chart3dDataView.getContour().getContourLevels();
            boolean bl = jCContourLevels.isDefault();
            this.useDefaultLevelsButton.setSelected(bl);
            this.numLevelsField.setEnabled(bl);
            this.numLevelsField.setText(String.valueOf(jCContourLevels.getNumLevelsInternal()));
            this.setLevelsButton.setSelected(!bl);
            this.addButton.setEnabled(!bl);
            this.removeButton.setEnabled(!bl);
            this.levelsModel.setLevels(jCContourLevels.getLevels());
            this.refreshing = false;
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.handleChange();
    }

    public void handleChange() {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            JCContourLevels jCContourLevels = chart3dDataView.getContour().getContourLevels();
            jCContourLevels.setLevels(this.levelsModel.getLevels());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
            Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
            JCContourLevels jCContourLevels = chart3dDataView.getContour().getContourLevels();
            Object object = actionEvent.getSource();
            if (object == this.addButton) {
                Double d2 = this.showLevelsDialog(this.addButton, "Add");
                if (d2 != null) {
                    this.levelsModel.add(d2);
                }
            } else if (object == this.removeButton) {
                if (this.levelsList.getSelectedIndex() != -1) {
                    this.levelsModel.remove(this.levelsList.getSelectedIndex());
                }
            } else if (object == this.useDefaultLevelsButton) {
                jCContourLevels.setDefault(true);
            } else if (object == this.setLevelsButton) {
                jCContourLevels.setDefault(false);
            } else if (object == this.numLevelsField) {
                this.handleNumLevelsChange();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleNumLevelsChange();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    private void handleNumLevelsChange() {
        if (this.refreshing) {
            return;
        }
        DataViewEditor dataViewEditor = (DataViewEditor)this.getParent();
        Chart3dDataView chart3dDataView = dataViewEditor.getSelectedDataView();
        JCContourLevels jCContourLevels = chart3dDataView.getContour().getContourLevels();
        Integer n2 = DataViewContourLevelsEditor.parseIntegerInput(this.numLevelsField);
        if (n2 == null || n2 <= 2) {
            this.refreshEditor();
            return;
        }
        jCContourLevels.setNumLevels(n2);
    }

    private Double showLevelsDialog(Component component, String string) {
        String string2 = DataViewContourLevelsEditor.getLocalizedString("Levels");
        JLabel jLabel = new JLabel(string2);
        JTextField jTextField = new JTextField(10);
        JPanel jPanel = DataViewContourLevelsEditor.createPreferredSizePanel();
        jPanel.add((Component)jLabel, "West");
        jPanel.add(jTextField);
        int n2 = JOptionPane.showOptionDialog(component, jPanel, DataViewContourLevelsEditor.getLocalizedString(string), 2, -1, null, null, null);
        if (n2 == 0) {
            return DataViewContourLevelsEditor.parseDoubleInput(jTextField);
        }
        return null;
    }

    private static class LevelsModel
    extends AbstractListModel {
        private List levels = new ArrayList();

        public void setLevels(double[] dArray) {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
                this.levels.clear();
            }
            if (dArray == null) {
                return;
            }
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.levels.add(new Double(dArray[i2]));
            }
            if (this.getSize() > 0) {
                this.sortLevels();
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        public Object getElementAt(int n2) {
            return this.levels.get(n2);
        }

        public double getLevelAt(int n2) {
            return (Double)this.levels.get(n2);
        }

        public int getSize() {
            return this.levels.size();
        }

        public void remove(int n2) {
            this.levels.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public void add(double d2) {
            this.levels.add(new Double(d2));
            this.sortLevels();
            this.fireIntervalAdded(this, this.getSize(), this.getSize());
        }

        private void sortLevels() {
            Collections.sort(this.levels);
        }

        public double[] getLevels() {
            double[] dArray = new double[this.getSize()];
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                dArray[i2] = this.getLevelAt(i2);
            }
            return dArray;
        }
    }
}

