/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.customizer.AxesEditor;
import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import com.klg.jclass.util.swing.JCFontChooserPane;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AxisTitleEditor
extends Chart3dPropertyEditor
implements ActionListener,
FocusListener,
JCFontListener {
    private static String nameKey = "Titles";
    private boolean refreshing = false;
    private Container content;
    private JCFontChooserPane fontChooser;
    private JTextField titleField;
    private JTextField cubeSizeField;

    public AxisTitleEditor() {
        super(nameKey);
    }

    public Component getEditor() {
        if (this.content == null) {
            this.fontChooser = this.getFontChooser();
            this.fontChooser.addJCFontListener(this);
            this.fontChooser.setAlignmentX(0.0f);
            String string = AxisTitleEditor.getLocalizedString("Title");
            JLabel jLabel = new JLabel(string);
            this.titleField = AxisTitleEditor.createTextField(10, this, this);
            JPanel jPanel = AxisTitleEditor.createBorderPanel();
            jPanel.setBorder(null);
            jPanel.add((Component)jLabel, "West");
            jPanel.add(this.titleField);
            jPanel.setAlignmentX(0.0f);
            string = AxisTitleEditor.getLocalizedString("Font Cube Size");
            JLabel jLabel2 = new JLabel(string);
            this.cubeSizeField = AxisTitleEditor.createTextField(10, this, this);
            JPanel jPanel2 = AxisTitleEditor.createBorderPanel();
            jPanel2.setBorder(null);
            jPanel2.add((Component)jLabel2, "West");
            jPanel2.add(this.cubeSizeField);
            jPanel2.setAlignmentX(0.0f);
            this.content = AxisTitleEditor.createPreferredSizePanel();
            this.content.setLayout(new BoxLayout(this.content, 1));
            this.content.add(jPanel);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(jPanel2);
            this.content.add(Box.createVerticalStrut(10));
            this.content.add(this.fontChooser);
        }
        return this.content;
    }

    public void finalizeEditor() {
        if (this.content != null) {
            this.fontChooser.removeJCFontListener(this);
            this.fontChooser = null;
            this.titleField.removeActionListener(this);
            this.titleField.removeFocusListener(this);
            this.titleField = null;
            this.cubeSizeField.removeActionListener(this);
            this.cubeSizeField.removeFocusListener(this);
            this.cubeSizeField = null;
            this.content = null;
        }
    }

    public void refreshEditor() {
        if (this.content != null) {
            this.refreshing = true;
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            this.fontChooser.setSelectedFont(jCAxis.getTitleFont());
            this.titleField.setText(jCAxis.getTitle());
            this.cubeSizeField.setText(String.valueOf(jCAxis.getTitleFontCubeSize()));
            this.refreshing = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleChange(actionEvent.getSource());
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleChange(focusEvent.getSource());
    }

    private void handleChange(Object object) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            if (object == this.titleField) {
                jCAxis.setTitle(this.titleField.getText());
            } else if (object == this.cubeSizeField) {
                Integer n2 = AxisTitleEditor.parseIntegerInput(this.cubeSizeField);
                if (n2 == null || n2 < 0 || n2 > 1000) {
                    this.refreshEditor();
                    return;
                }
                jCAxis.setTitleFontCubeSize(n2);
            }
        }
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.content != null) {
            AxesEditor axesEditor = (AxesEditor)this.getParent();
            JCAxis jCAxis = axesEditor.getSelectedAxis();
            jCAxis.setTitleFont(jCFontEvent.getFont());
        }
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }
}

