/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.customizer;

import com.klg.jclass.chart3d.customizer.Chart3dPropertyEditor;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingConstants;

public class AlignmentComboBox
extends JComboBox
implements SwingConstants {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int[] constants = new int[]{1, 0, 3, 2, 0, 4};
    private int alignment;

    public AlignmentComboBox(int n2, ActionListener actionListener) {
        this.alignment = n2;
        this.setModel(this.createAlignmentModel());
        this.addActionListener(actionListener);
    }

    private ComboBoxModel createAlignmentModel() {
        String[] stringArray = new String[3];
        if (this.alignment == 1) {
            stringArray[0] = Chart3dPropertyEditor.getLocalizedString("Top");
            stringArray[1] = Chart3dPropertyEditor.getLocalizedString("Center");
            stringArray[2] = Chart3dPropertyEditor.getLocalizedString("Bottom");
        } else {
            stringArray[0] = Chart3dPropertyEditor.getLocalizedString("Left");
            stringArray[1] = Chart3dPropertyEditor.getLocalizedString("Center");
            stringArray[2] = Chart3dPropertyEditor.getLocalizedString("Right");
        }
        return new DefaultComboBoxModel<String>(stringArray);
    }

    public int getSelectedAlignment() {
        int n2 = this.getSelectedIndex();
        if (this.alignment == 1) {
            return constants[n2];
        }
        return constants[3 + n2];
    }

    public void setSelectedAlignment(int n2) {
        int n3 = this.getSelectedIndex();
        if (n2 == 1) {
            if (n2 == 1) {
                this.setSelectedIndex(0);
            } else if (n2 == 0) {
                this.setSelectedIndex(1);
            } else if (n2 == 3) {
                this.setSelectedIndex(2);
            }
        } else if (n2 == 2) {
            this.setSelectedIndex(0);
        } else if (n2 == 0) {
            this.setSelectedIndex(1);
        } else if (n2 == 4) {
            this.setSelectedIndex(2);
        }
    }
}

