/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.FacetAbstract;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.ScreenPoint;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class ScatterFacet
extends FacetAbstract {
    protected transient Graphics gc = null;

    ScatterFacet() {
    }

    ScatterFacet(DrawGrid drawGrid, Graphics graphics) {
        super(drawGrid);
        this.gc = graphics;
    }

    public void processFacet(int n2, int n3, int n4) {
        JCLineStyle jCLineStyle;
        JCSymbolStyle jCSymbolStyle;
        ParentTrackChange parentTrackChange;
        Serializable serializable;
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        ScreenPoint[][] screenPointArray = chart3dGridData.getScreenPoints();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (n2 < gridLimits.getXOffset() || n2 > gridLimits.getXLast() || n3 < gridLimits.getYOffset() || n3 > gridLimits.getYLast()) {
            return;
        }
        if (screenPointArray == null) {
            return;
        }
        ScreenPoint screenPoint = screenPointArray[n2][n3];
        if (screenPoint.isDrawn() || screenPoint.isHoleValue() || screenPoint.isHidden()) {
            return;
        }
        if (!jCChart3dArea.getViewport().isNormalized() && jCChart3dArea.getScatter().hasDropLines()) {
            serializable = new ScreenPoint();
            parentTrackChange = jCChart3dArea.getAxis(3);
            JCChart3dUtil.getScreenPoint(jCChart3dArea.getChart3d(), chart3dGridData.getX(n2), chart3dGridData.getY(n3), ((JCAxis)parentTrackChange).getOrigin(), ((JCAxis)parentTrackChange).getMin(), (ScreenPoint)serializable);
            int n5 = Math.min(screenPoint.getXPixel(), ((ScreenPoint)serializable).getXPixel());
            int n6 = Math.min(screenPoint.getYPixel(), ((ScreenPoint)serializable).getYPixel());
            int n7 = Math.max(screenPoint.getXPixel(), ((ScreenPoint)serializable).getXPixel());
            int n8 = Math.max(screenPoint.getYPixel(), ((ScreenPoint)serializable).getYPixel());
            Rectangle rectangle = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            if (rectangle.width > 0 && rectangle.height > 0 && !rectangle.intersects(jCChart3dArea.getDrawingArea())) {
                return;
            }
        }
        serializable = chart3dDataView.getZoneData();
        parentTrackChange = chart3dDataView.getContour();
        JCContourLevels jCContourLevels = ((JCContour)parentTrackChange).getContourLevels();
        if (((JCContour)parentTrackChange).isContoured() || ((JCContour)parentTrackChange).isZoned()) {
            int n9;
            JCContourStyle jCContourStyle;
            double d2 = chart3dGridData.getZValue(n2, n3);
            if (((Chart3dData)serializable).isDataOK()) {
                d2 = ((Chart3dGridData)serializable).getZValue(n2, n3);
            }
            if ((jCContourStyle = ((JCContour)parentTrackChange).getContourStyleFromLevel(n9 = jCContourLevels.getLevelFromValue(d2))) == null) {
                return;
            }
            jCSymbolStyle = jCContourStyle.getSymbolStyle();
            jCLineStyle = jCContourStyle.getLineStyle();
        } else {
            JCChart3dStyle jCChart3dStyle = chart3dGridData.getChartStyle();
            if (jCChart3dStyle == null) {
                return;
            }
            jCSymbolStyle = jCChart3dStyle.getSymbolStyle();
            jCLineStyle = jCChart3dStyle.getLineStyle();
        }
        this.drawGrid.renderPoint(this.gc, jCSymbolStyle, jCLineStyle, screenPoint, chart3dGridData.getX(n2), chart3dGridData.getY(n3));
    }
}

