/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCAxis;
import java.awt.Color;
import java.io.Serializable;

public class JCValueLabel
implements Cloneable,
Serializable {
    protected double value;
    protected String label;
    protected boolean tickDrawn = true;
    protected boolean labelDrawn = true;
    protected boolean minorTick = false;
    protected Color background = null;
    protected Color foreground = null;
    protected int index = -1;
    protected JCAxis axis = null;
    protected boolean allowUpdates = true;

    public JCValueLabel() {
        this.value = 0.0;
        this.label = null;
    }

    public JCValueLabel(double d2, String string) {
        this.value = d2;
        this.label = string;
    }

    public JCValueLabel(double d2, String string, boolean bl) {
        this.value = d2;
        this.label = string;
        this.minorTick = bl;
        this.labelDrawn = !bl;
    }

    public JCValueLabel(double d2, String string, boolean bl, boolean bl2, boolean bl3) {
        this.value = d2;
        this.label = string;
        this.labelDrawn = bl;
        this.tickDrawn = bl2;
        this.minorTick = bl3;
    }

    public JCAxis getAxis() {
        return this.axis;
    }

    protected void setAxis(JCAxis jCAxis) {
        this.axis = jCAxis;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d2) {
        if (this.value == d2) {
            return;
        }
        this.value = d2;
        this.setChanged(true, 2);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (this.label != null ? this.label.equals(string) : string == null) {
            return;
        }
        this.label = string;
        this.setChanged(true, 2);
    }

    public boolean isLabelDrawn() {
        return this.labelDrawn;
    }

    public void setLabelDrawn(boolean bl) {
        if (this.labelDrawn == bl) {
            return;
        }
        this.labelDrawn = bl;
        this.setChanged(true, 2);
    }

    public boolean isTickDrawn() {
        return this.tickDrawn;
    }

    public void setTickDrawn(boolean bl) {
        if (this.tickDrawn == bl) {
            return;
        }
        this.tickDrawn = bl;
        this.setChanged(true, 1);
    }

    public boolean isMinorTick() {
        return this.minorTick;
    }

    public void setMinorTick(boolean bl) {
        if (this.minorTick == bl) {
            return;
        }
        this.minorTick = bl;
        this.setChanged(true, 1);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.background == color) {
            return;
        }
        this.background = color;
        this.setChanged(true, 1);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.foreground == color) {
            return;
        }
        this.foreground = color;
        this.setChanged(true, 1);
    }

    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int n2) {
        this.index = n2;
    }

    public boolean isTickOnly() {
        return this.minorTick && !this.labelDrawn;
    }

    public void setTickOnly(boolean bl) {
        if (this.minorTick == bl) {
            return;
        }
        this.minorTick = bl;
        this.labelDrawn = !bl;
        this.setChanged(true, 2);
    }

    protected void setChanged(boolean bl, int n2) {
        if (this.axis != null && this.allowUpdates) {
            this.axis.callParentSetChanged(bl, n2);
        }
    }

    public String toString() {
        return "value:" + this.value + " label:" + this.label;
    }

    public Object clone() {
        JCValueLabel jCValueLabel;
        try {
            jCValueLabel = (JCValueLabel)super.clone();
            jCValueLabel.value = this.value;
            jCValueLabel.label = this.label;
            jCValueLabel.tickDrawn = this.tickDrawn;
            jCValueLabel.labelDrawn = this.labelDrawn;
            jCValueLabel.minorTick = this.minorTick;
            jCValueLabel.background = this.background;
            jCValueLabel.foreground = this.foreground;
            jCValueLabel.index = this.index;
            jCValueLabel.axis = this.axis;
            jCValueLabel.allowUpdates = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("JCValueLabel does not support cloneable.");
        }
        return jCValueLabel;
    }
}

