/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.Transform;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class JCGridLines
implements Serializable {
    public static final int NO_PLANE = 0;
    public static final int XY_PLANE = 1;
    public static final int XZ_PLANE = 2;
    public static final int YZ_PLANE = 4;
    public static final int ALL_PLANES = 7;
    protected int planeMask = 0;
    protected JCLineStyle lineStyle = null;
    protected JCAxis axis = null;
    protected Point4d data1 = null;
    protected Point4d data2 = null;

    public JCGridLines() {
        this.lineStyle = new JCLineStyle(1, Color.black, 1);
    }

    public JCGridLines(JCAxis jCAxis, int n2) {
        this();
        this.lineStyle.parent = jCAxis;
        this.axis = jCAxis;
        this.planeMask = n2;
    }

    public JCGridLines(JCAxis jCAxis, int n2, JCLineStyle jCLineStyle) {
        this.axis = jCAxis;
        this.planeMask = n2;
        if (jCLineStyle == null) {
            jCLineStyle = new JCLineStyle(1, Color.black, 1);
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = jCAxis;
    }

    public int getPlaneMask() {
        return this.planeMask;
    }

    public void setPlaneMask(int n2) {
        if (this.planeMask == n2) {
            return;
        }
        this.planeMask = n2;
        this.setChanged(true, 1);
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        if (this.lineStyle == jCLineStyle) {
            return;
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = this.axis;
        this.setChanged(true, 1);
    }

    public JCAxis getAxis() {
        return this.axis;
    }

    public void setAxis(JCAxis jCAxis) {
        if (this.axis == jCAxis) {
            return;
        }
        this.axis = jCAxis;
        if (this.lineStyle != null) {
            this.lineStyle.parent = jCAxis;
        }
        this.setChanged(true, 2);
    }

    protected void setChanged(boolean bl, int n2) {
        if (this.axis != null) {
            this.axis.callParentSetChanged(bl, n2);
        }
    }

    protected void drawSingleGridLine(Graphics graphics, Matrix4d matrix4d, double d2, int n2, Point3d point3d) {
        int n3 = this.axis.getAxisId();
        if (this.data1 == null) {
            this.data1 = new Point4d();
            this.data2 = new Point4d();
        }
        boolean bl = false;
        if (n3 == 1 && (n2 & 0xC) > 0 && (this.planeMask & 1) > 0) {
            this.data1.set(d2, -1.0, point3d.z, 1.0);
            this.data2.set(d2, 1.0, point3d.z, 1.0);
            bl = true;
        } else if (n3 == 1 && (n2 & 0x30) > 0 && (this.planeMask & 2) > 0) {
            this.data1.set(d2, point3d.y, -1.0, 1.0);
            this.data2.set(d2, point3d.y, 1.0, 1.0);
            bl = true;
        } else if (n3 == 2 && (n2 & 3) > 0 && (this.planeMask & 1) > 0) {
            this.data1.set(-1.0, d2, point3d.z, 1.0);
            this.data2.set(1.0, d2, point3d.z, 1.0);
            bl = true;
        } else if (n3 == 2 && (n2 & 0x30) > 0 && (this.planeMask & 4) > 0) {
            this.data1.set(point3d.x, d2, -1.0, 1.0);
            this.data2.set(point3d.x, d2, 1.0, 1.0);
            bl = true;
        } else if (n3 == 3 && (n2 & 3) > 0 && (this.planeMask & 2) > 0) {
            this.data1.set(-1.0, point3d.y, d2, 1.0);
            this.data2.set(1.0, point3d.y, d2, 1.0);
            bl = true;
        } else if (n3 == 3 && (n2 & 0xC) > 0 && (this.planeMask & 4) > 0) {
            this.data1.set(point3d.x, -1.0, d2, 1.0);
            this.data2.set(point3d.x, 1.0, d2, 1.0);
            bl = true;
        }
        if (bl) {
            Transform.transformPoint(matrix4d, this.data1);
            int n4 = (int)Math.round(this.data1.x);
            int n5 = (int)Math.round(this.data1.y);
            Transform.transformPoint(matrix4d, this.data2);
            int n6 = (int)Math.round(this.data2.x);
            int n7 = (int)Math.round(this.data2.y);
            graphics.drawLine(n4, n5, n6, n7);
        }
    }

    protected void drawGridFace(Graphics graphics, Matrix4d matrix4d, int n2, Point3d point3d) {
        if (this.lineStyle == null || this.lineStyle.getWidth() <= 0 || this.lineStyle.getPattern() == 0) {
            return;
        }
        double d2 = this.axis.getDataportMin();
        double d3 = this.axis.getDataportMax();
        if (1.0 + (d3 - d2) == 1.0) {
            return;
        }
        this.lineStyle.updateGraphics(graphics);
        List<JCValueLabel> list = this.axis.getAnnoHandler().getValueLabels();
        if (list == null || list.size() == 0) {
            return;
        }
        for (JCValueLabel jCValueLabel : list) {
            double d4 = jCValueLabel.getValue();
            if (jCValueLabel.isMinorTick() || d4 <= d2 || d4 >= d3 || d4 < this.axis.getAnnoMin() || d4 > this.axis.getAnnoMax() || this.axis.getAnnotationMethod() == 2 && this.axis.isCombineLabels() && !jCValueLabel.isTickDrawn()) continue;
            double d5 = 2.0 * (d4 - d2) / (d3 - d2) - 1.0;
            this.drawSingleGridLine(graphics, matrix4d, d5, n2, point3d);
        }
        this.lineStyle.resetGraphics(graphics);
    }
}

