/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ParentFormatter;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import com.klg.jclass.util.JCNumberUtil;

public class JCContourLevels
extends ParentFormatter {
    public static final int DEFAULT_NUM_LEVELS = 10;
    protected boolean isDefault = true;
    protected double[] levels = null;
    protected int numLevels = 10;
    protected int numLevelsInternal = 0;
    protected double min = Double.MAX_VALUE;
    protected double max = Double.MAX_VALUE;

    public JCContourLevels() {
    }

    public JCContourLevels(int n2) {
        if (n2 < 0) {
            String string = LocaleBundle.string("Invalid value. NumLevels must be non-negative.");
            throw new IllegalArgumentException(string);
        }
        this.numLevels = n2;
        this.setNumLevelsInternal();
    }

    public JCContourLevels(double[] dArray) {
        this.levels = dArray;
        this.isDefault = false;
        this.setNumLevelsInternal();
    }

    public double[] getLevels() {
        if (this.levels == null && this.min == Double.MAX_VALUE) {
            Chart3dDataView chart3dDataView = (Chart3dDataView)this.parents.get(0);
            chart3dDataView.calcDefaults();
        }
        return this.levels;
    }

    public void setLevels(double[] dArray) {
        if (this.levels == dArray) {
            return;
        }
        if (dArray != null) {
            double d2 = -1.7976931348623157E308;
            double[] dArray2 = dArray;
            int n2 = dArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3 = dArray2[i2];
                if (d3 <= d2) {
                    String string = LocaleBundle.string("Invalid value. Levels array must be strictly increasing!");
                    throw new IllegalArgumentException(string);
                }
                d2 = d3;
            }
        }
        this.levels = dArray;
        this.isDefault = false;
        this.setNumLevelsInternal();
        int n3 = 0;
        if (dArray != null) {
            for (double d4 : dArray) {
                n3 = Math.max(JCChart3dUtil.nDigits(d4), n3);
            }
        }
        if (n3 == 0x3FFFFFFF) {
            n3 = 0;
        }
        this.setNFrac(Math.max(0, n3 + 1));
        this.callParentSetChanged(true, 290);
    }

    public int getNumLevelsInternal() {
        return this.numLevelsInternal;
    }

    private void setNumLevelsInternal() {
        this.numLevelsInternal = this.isDefault ? this.numLevels : (this.levels == null ? 0 : this.levels.length);
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public void setNumLevels(int n2) {
        if (this.numLevels == n2) {
            return;
        }
        if (n2 < 0) {
            String string = LocaleBundle.string("Invalid value. NumLevels must be non-negative.");
            throw new IllegalArgumentException(string);
        }
        this.numLevels = n2;
        this.setNumLevelsInternal();
        if (this.isDefault) {
            this.callParentSetChanged(true, 290);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        if (this.isDefault == bl) {
            return;
        }
        this.isDefault = bl;
        this.setNumLevelsInternal();
        this.callParentSetChanged(true, 290);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void addLevel(double d2) {
        int n2;
        this.isDefault = false;
        int n3 = this.numLevelsInternal;
        double[] dArray = new double[n3 + 1];
        for (n2 = 0; n2 < n3 && this.levels[n2] < d2; ++n2) {
            dArray[n2] = this.levels[n2];
        }
        int n4 = n2;
        if (this.levels != null && this.levels[n2] != d2) {
            dArray[n4++] = d2;
        }
        if (this.levels != null) {
            while (n2 < n3) {
                dArray[n4++] = this.levels[n2];
                ++n2;
            }
        }
        this.levels = dArray;
        this.setNumLevelsInternal();
        this.callParentSetChanged(true, 290);
    }

    public void removeLevel(int n2) {
        int n3 = this.numLevelsInternal;
        if (n3 == 0 || n2 < 0 || n2 > n3 - 1) {
            return;
        }
        this.isDefault = false;
        if (n3 <= 1) {
            this.levels = null;
            this.setNumLevelsInternal();
            return;
        }
        double[] dArray = new double[n3 - 1];
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            dArray[i2] = i2 < n2 ? this.levels[i2] : this.levels[i2 + 1];
        }
        this.levels = dArray;
        this.setNumLevelsInternal();
        this.callParentSetChanged(true, 290);
    }

    public void removeLevel(double d2) {
        if (this.numLevelsInternal == 0) {
            return;
        }
        double d3 = Double.MAX_VALUE;
        int n2 = -1;
        for (int i2 = 0; i2 < this.numLevelsInternal; ++i2) {
            double d4 = Math.abs(this.levels[i2] - d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            n2 = i2;
        }
        if (n2 >= 0) {
            this.removeLevel(n2);
        }
    }

    public int getLevelFromValue(double d2) {
        int n2;
        for (n2 = 0; n2 < this.numLevelsInternal && !(d2 <= this.levels[n2]); ++n2) {
        }
        return n2;
    }

    protected void calcLimits(Chart3dDataView chart3dDataView, Chart3dGridData chart3dGridData, Chart3dGridData chart3dGridData2) {
        if (chart3dDataView == null || chart3dGridData == null || chart3dGridData2 == null) {
            return;
        }
        if (chart3dGridData2.isDataOK()) {
            chart3dGridData2.computeZLimits(chart3dGridData, this.min, this.max);
            this.min = chart3dGridData2.getDataMin();
            this.max = chart3dGridData2.getDataMax();
        } else {
            this.min = chart3dGridData.getDataMin();
            this.max = chart3dGridData.getDataMax();
            if (chart3dDataView.getChartType() == 1) {
                JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
                double d2 = jCChart3dArea.getAxis(3).getOrigin();
                this.min = Math.min(this.min, d2);
                this.max = Math.max(this.max, d2);
            }
        }
    }

    protected void calcLevels() {
        this.setNumLevelsInternal();
        if (!this.isDefault) {
            return;
        }
        this.levels = null;
        if (this.numLevelsInternal == 0) {
            return;
        }
        if (this.min == this.max) {
            this.numLevelsInternal = 0;
            return;
        }
        this.levels = new double[this.numLevelsInternal];
        double d2 = (this.max - this.min) / (double)(this.numLevelsInternal + 1);
        int n2 = 1.0 + d2 == 1.0 ? (this.min == 0.0 ? JCChart3dUtil.nDigits(this.max) : JCChart3dUtil.nDigits(this.min)) : JCChart3dUtil.nDigits(d2);
        this.setNFrac(Math.max(0, n2 + 1));
        for (int i2 = 0; i2 < this.numLevelsInternal; ++i2) {
            this.levels[i2] = this.min + (double)(i2 + 1) * d2;
            String string = JCNumberUtil.format(this.levels[i2], this.getNFrac());
            this.levels[i2] = Double.valueOf(string);
        }
    }
}

