/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Rectangle;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;

public class JCChart3dUtil
extends JCNumberUtil {
    public static final double roundOffEpsilon = 1.0E-13;

    public static boolean backfacing(int[] nArray, int[] nArray2) {
        long l2 = 0L;
        int n2 = Math.min(nArray.length, nArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 < n2 - 1 ? i2 + 1 : 0;
            l2 += (long)nArray[i2] * (long)nArray2[n3] - (long)nArray2[i2] * (long)nArray[n3];
        }
        return l2 < 0L;
    }

    public static boolean gridBackfacing(ScreenPoint screenPoint, ScreenPoint screenPoint2, ScreenPoint screenPoint3) {
        long l2;
        long l3;
        long l4 = screenPoint2.getXPixel() - screenPoint.getXPixel();
        long l5 = screenPoint2.getYPixel() - screenPoint.getYPixel();
        return l5 * (l3 = (long)(screenPoint3.getXPixel() - screenPoint.getXPixel())) - l4 * (l2 = (long)(screenPoint3.getYPixel() - screenPoint.getYPixel())) > 0L;
    }

    public static void getScreenPoint(JCChart3d jCChart3d, double d2, double d3, double d4, double d5, ScreenPoint screenPoint) {
        if (screenPoint.isHoleValue()) {
            d4 = d5;
        }
        Point4d point4d = new Point4d(d2, d3, d4, 1.0);
        Transform transform = jCChart3d.getChart3dArea().getTransform();
        Transform.transformPoint(transform.getView(), point4d);
        screenPoint.setXPixel((int)Math.round(point4d.x));
        screenPoint.setYPixel((int)Math.round(point4d.y));
    }

    public static double distanceToEye(JCChart3d jCChart3d, double d2, double d3, double d4) {
        Transform transform = jCChart3d.getChart3dArea().getTransform();
        Point4d point4d = new Point4d(transform.getEyePosition());
        Transform.transformPoint(transform.getInverseAbsolute(), point4d);
        double d5 = point4d.x - d2;
        double d6 = point4d.y - d3;
        double d7 = point4d.z - d4;
        return Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
    }

    public static void printMatrix(Matrix4d matrix4d) {
        System.out.println("[" + matrix4d.m00 + ", " + matrix4d.m01 + ", " + matrix4d.m02 + ", " + matrix4d.m02 + "]");
        System.out.println("[" + matrix4d.m10 + ", " + matrix4d.m11 + ", " + matrix4d.m12 + ", " + matrix4d.m12 + "]");
        System.out.println("[" + matrix4d.m20 + ", " + matrix4d.m21 + ", " + matrix4d.m22 + ", " + matrix4d.m22 + "]");
        System.out.println("[" + matrix4d.m30 + ", " + matrix4d.m31 + ", " + matrix4d.m32 + ", " + matrix4d.m32 + "]");
    }

    protected static void printAxisExtents(JCAxis jCAxis) {
        String string;
        if (jCAxis == null) {
            return;
        }
        switch (jCAxis.getAxisId()) {
            case 1: {
                string = LocaleBundle.string("X axis") + ":";
                break;
            }
            case 2: {
                string = LocaleBundle.string("Y axis") + ":";
                break;
            }
            case 3: {
                string = LocaleBundle.string("Z axis") + ":";
                break;
            }
            default: {
                return;
            }
        }
        System.out.println(string);
        String string2 = LocaleBundle.string("minimum");
        String string3 = LocaleBundle.string("maximum");
        System.out.println(string2 + ": " + jCAxis.getMin() + " " + string3 + ": " + jCAxis.getMax());
        System.out.println("Anno " + string2 + ":" + jCAxis.getAnnoMin() + " Anno " + string3 + ": " + jCAxis.getAnnoMax());
        System.out.println("Dataport " + string2 + ": " + jCAxis.getDataportMin() + " Dataport " + string3 + ": " + jCAxis.getDataportMax());
    }

    public static void booleanfill(boolean[] blArray, boolean bl) {
        int n2 = blArray.length;
        if (n2 > 0) {
            blArray[0] = bl;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(blArray, 0, blArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static int min4(int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n2, n3);
        int n7 = Math.min(n4, n5);
        return Math.min(n6, n7);
    }

    public static int max4(int n2, int n3, int n4, int n5) {
        int n6 = Math.max(n2, n3);
        int n7 = Math.max(n4, n5);
        return Math.max(n6, n7);
    }

    public static double floor(double d2) {
        return Math.floor(d2 + 1.0E-13);
    }

    public static double ceil(double d2) {
        return Math.ceil(d2 - 1.0E-13);
    }

    public static int nDigits(double d2) {
        if (d2 == 0.0) {
            return 0x3FFFFFFF;
        }
        return -((int)JCChart3dUtil.floor(JCNumberUtil.log10(JCNumberUtil.abs(d2))));
    }

    public static double niceNum(double d2, boolean bl) {
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        int n2 = (int)JCChart3dUtil.floor(JCNumberUtil.log10(d2));
        double d3 = JCNumberUtil.pow10(n2);
        double d4 = d2 / d3;
        double d5 = bl ? (d4 < 1.5 ? 1.0 : (d4 < 3.0 ? 2.0 : (d4 < 7.0 ? 5.0 : 10.0))) : (d4 <= 1.0 ? 1.0 : (d4 <= 2.0 ? 2.0 : (d4 <= 5.0 ? 5.0 : 10.0)));
        return d5 * d3;
    }

    public static Point4d[] constructBarPlane(Chart3dGridData chart3dGridData, int n2, int n3) {
        double d2;
        double d3;
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        int n4 = chart3dDataView.getChartType();
        Point4d[] point4dArray = new Point4d[4];
        JCBar jCBar = chart3dDataView.getChart3d().getChart3dArea().getBar();
        double[] dArray = chart3dGridData.getXGrid();
        double[] dArray2 = chart3dGridData.getYGrid();
        for (int i2 = 0; i2 < 4; ++i2) {
            point4dArray[i2] = new Point4d();
        }
        if (n4 == 2 || n4 == 1 && jCBar.getXFormat() == 1) {
            d3 = dArray[n2];
            d2 = chart3dGridData.getMinXStep() * jCBar.getXSpacing() / 200.0;
            point4dArray[1].x = d3 - d2;
            point4dArray[3].x = d3 + d2;
        } else {
            point4dArray[1].x = dArray[n2];
            point4dArray[3].x = dArray[n2 + 1];
        }
        if (n4 == 2 || n4 == 1 && jCBar.getYFormat() == 1) {
            d3 = dArray2[n3];
            d2 = chart3dGridData.getMinYStep() * jCBar.getYSpacing() / 200.0;
            point4dArray[1].y = d3 - d2;
            point4dArray[2].y = d3 + d2;
        } else {
            point4dArray[1].y = dArray2[n3];
            point4dArray[2].y = dArray2[n3 + 1];
        }
        point4dArray[0].x = point4dArray[3].x;
        point4dArray[0].y = point4dArray[1].y;
        point4dArray[2].x = point4dArray[1].x;
        point4dArray[3].y = point4dArray[2].y;
        point4dArray[3].w = 1.0;
        point4dArray[2].w = 1.0;
        point4dArray[1].w = 1.0;
        point4dArray[0].w = 1.0;
        return point4dArray;
    }

    public static boolean holeInFacet(Chart3dGridData chart3dGridData, int n2, int n3) {
        if (chart3dGridData == null) {
            return true;
        }
        ScreenPoint[][] screenPointArray = chart3dGridData.getScreenPoints();
        if (screenPointArray == null) {
            return true;
        }
        int n4 = chart3dGridData.getNumX();
        int n5 = chart3dGridData.getNumY();
        if (n2 < 0 || n3 < 0 || n2 >= n4 || n3 >= n5) {
            return true;
        }
        boolean bl = screenPointArray[n2][n3].isHoleValue();
        if (n2 + 1 < n4 && !bl) {
            bl = screenPointArray[n2 + 1][n3].isHoleValue();
        }
        if (n3 + 1 < n5 && !bl) {
            bl = screenPointArray[n2][n3 + 1].isHoleValue();
            if (n2 + 1 < n4 && !bl) {
                bl = screenPointArray[n2 + 1][n3 + 1].isHoleValue();
            }
        }
        return bl;
    }

    public static double biLinearInterp(Chart3dGridData chart3dGridData, int n2, int n3, double d2, double d3) {
        double d4 = chart3dGridData.getX(n2);
        double d5 = chart3dGridData.getY(n3);
        double d6 = chart3dGridData.getX(n2 + 1) - d4;
        double d7 = chart3dGridData.getY(n3 + 1) - d5;
        double d8 = chart3dGridData.getZValue(n2, n3);
        double d9 = chart3dGridData.getZValue(n2, n3 + 1);
        double d10 = chart3dGridData.getZValue(n2 + 1, n3);
        double d11 = chart3dGridData.getZValue(n2 + 1, n3 + 1);
        double d12 = d10 - d8;
        double d13 = d12 * (d2 - d4) / d6 + d8;
        d12 = d11 - d9;
        double d14 = d12 * (d2 - d4) / d6 + d9;
        return (d3 - d5) * (d14 - d13) / d7 + d13;
    }

    public static Rectangle computeBoundingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return rectangle2;
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        Rectangle rectangle3 = new Rectangle();
        rectangle3.x = Math.min(rectangle.x, rectangle2.x);
        rectangle3.y = Math.min(rectangle.y, rectangle2.y);
        rectangle3.width = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - rectangle3.x;
        rectangle3.height = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - rectangle3.y;
        return rectangle3;
    }
}

