/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3dLegendLabelGenerator;
import com.klg.jclass.chart3d.JCChart3dLegendTemplate;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChart3dLegend
extends JCLegend
implements JCChart3dLegendTemplate,
Serializable {
    protected int layoutStyle = 0;
    protected int distRange = 1;
    protected JCChart3dLegendLabelGenerator labelGenerator = null;
    protected List<List<String>> userLabels = null;
    protected int marginGap = 2;
    protected int groupGap = 5;
    protected int horizItemGap = 5;
    protected int vertItemGap = 2;
    protected int insideItemGap = 2;
    protected boolean continuousLayout = false;
    protected int legendRows = 0;
    protected int legendColumns = 0;

    public JCChart3dLegend() {
        this.adjustable = false;
    }

    @Override
    public void setAnchor(int n2) {
        if (n2 == this.anchor) {
            return;
        }
        this.checkAnchor(n2);
        this.setChanged(true, 2);
    }

    public void setLayoutStyle(int n2) {
        if (this.layoutStyle == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: {
                this.layoutStyle = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of CONTINUOUS or STEPPED."));
            }
        }
        this.setChanged(true, 2);
    }

    @Override
    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    public void setDistributionRange(int n2) {
        if (this.distRange == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: {
                this.distRange = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of RANGE_DATA or RANGE_ALL."));
            }
        }
        this.setChanged(true, 2);
    }

    @Override
    public int getDistributionRange() {
        return this.distRange;
    }

    public void setLabelGenerator(JCChart3dLegendLabelGenerator jCChart3dLegendLabelGenerator) {
        this.labelGenerator = jCChart3dLegendLabelGenerator;
        this.setChanged(true, 2);
    }

    @Override
    public JCChart3dLegendLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabels(List<List<String>> list) {
        this.userLabels = list;
        this.setChanged(true, 2);
    }

    @Override
    public List<List<String>> getLabels() {
        return this.userLabels;
    }

    public void setLabels(int n2, List<String> list) {
        int n3;
        if (this.userLabels == null) {
            this.userLabels = new Vector<List<String>>();
        }
        if (n2 < (n3 = this.userLabels.size())) {
            this.userLabels.set(n2, list);
        } else {
            for (int i2 = n3; i2 < n2; ++i2) {
                this.userLabels.add(i2, null);
            }
            this.userLabels.add(n2, list);
        }
        this.setChanged(true, 2);
    }

    public List<String> getLabels(int n2) {
        if (this.userLabels == null) {
            return null;
        }
        int n3 = this.userLabels.size();
        if (n2 >= 0 && n2 < n3) {
            return this.userLabels.get(n2);
        }
        return null;
    }

    public void setMarginGap(int n2) {
        this.marginGap = n2;
        this.setChanged(true, 2);
    }

    public int getMarginGap() {
        return this.marginGap;
    }

    public void setGroupGap(int n2) {
        this.groupGap = n2;
        this.setChanged(true, 2);
    }

    public int getGroupGap() {
        return this.groupGap;
    }

    @Override
    public int getItemGap() {
        if (this.orientation == 0) {
            return this.getHorizontalItemGap();
        }
        return this.getVerticalItemGap();
    }

    public void setHorizontalItemGap(int n2) {
        this.horizItemGap = n2;
        this.setChanged(true, 2);
    }

    public int getHorizontalItemGap() {
        return this.horizItemGap;
    }

    public void setVerticalItemGap(int n2) {
        this.vertItemGap = n2;
        this.setChanged(true, 2);
    }

    public int getVerticalItemGap() {
        return this.vertItemGap;
    }

    public void setInsideItemGap(int n2) {
        this.insideItemGap = n2;
        this.setChanged(true, 2);
    }

    public int getInsideItemGap() {
        return this.insideItemGap;
    }

    @Override
    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    @Override
    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    @Override
    public Dimension layoutLegend(List<List<JCLegendItem>> list, boolean bl, Font font) {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = new Dimension(0, 0);
        boolean[] blArray = this.findBiggestLegendItem(list, bl, dimension, dimension2);
        Dimension dimension3 = this.calcLegendSize(list, bl, dimension, blArray, dimension2);
        if (this.isContinuousLayout()) {
            this.layoutContinuousLegendItems(list, bl, dimension, dimension3, blArray, dimension2);
        } else {
            this.layoutSteppedLegendItems(list, bl, dimension, dimension3, blArray, dimension2);
        }
        return dimension3;
    }

    @Override
    public int getNumRows() {
        return this.legendRows;
    }

    @Override
    public int getNumColumns() {
        return this.legendColumns;
    }

    protected boolean[] findBiggestLegendItem(List<List<JCLegendItem>> list, boolean bl, Dimension dimension, Dimension dimension2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = list.size();
        boolean[] blArray = new boolean[n6];
        Arrays.fill(blArray, false);
        for (int i2 = 0; i2 < n6; ++i2) {
            List<JCLegendItem> list2 = list.get(i2);
            for (JCLegendItem jCLegendItem : list2) {
                int n7;
                int n8;
                if (this.isTitleItem(jCLegendItem)) {
                    blArray[i2] = true;
                    n4 = Math.max(n4, jCLegendItem.textDim.width);
                    n5 = Math.max(n5, jCLegendItem.textDim.height);
                    continue;
                }
                if (this.isContinuousLayout() && bl) {
                    n8 = jCLegendItem.symbolDim.width + this.getInsideItemGap() + jCLegendItem.textDim.width;
                    n7 = jCLegendItem.textDim.height;
                } else if (this.isContinuousLayout() && !bl) {
                    n8 = jCLegendItem.textDim.width;
                    n7 = jCLegendItem.symbolDim.height + this.getInsideItemGap() + jCLegendItem.textDim.height;
                } else {
                    n8 = jCLegendItem.symbolDim.width + this.getInsideItemGap() + jCLegendItem.textDim.width;
                    n7 = Math.max(jCLegendItem.symbolDim.height, jCLegendItem.textDim.height);
                }
                n2 = Math.max(n2, n8);
                n3 = Math.max(n3, n7);
            }
        }
        dimension.width = n2;
        dimension.height = n3;
        dimension2.width = n4;
        dimension2.height = n5;
        return blArray;
    }

    protected Dimension calcLegendSize(List<List<JCLegendItem>> list, boolean bl, Dimension dimension, boolean[] blArray, Dimension dimension2) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = list.size();
        for (n4 = 0; n4 < n7; ++n4) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            List<JCLegendItem> list2 = list.get(n4);
            n3 = list2.size();
            if (blArray[n4]) {
                --n3;
            }
            if (!bl) {
                n2 = 1;
                n13 = 2;
            } else {
                n2 = 3;
                n13 = 1;
            }
            --n3;
            if (this.isContinuousLayout()) {
                --n3;
            }
            if ((this.getAnchor() & 0xF) != 0) {
                n12 = this.isContinuousLayout() && bl ? this.getParent().getHeight() - this.getInsets().top - this.getInsets().bottom - dimension.height - 2 * this.getMarginGap() : this.getParent().getHeight() - this.getInsets().top - this.getInsets().bottom - 2 * this.getMarginGap();
                if (blArray[n4]) {
                    n12 -= dimension2.height;
                    n12 -= this.getGroupGap();
                }
                if ((n11 = Math.max(1 + n3 / (n10 = Math.max(n9 = n12 / (n8 = dimension.height + this.getItemGap()), n2)), n13)) != 0) {
                    n10 = 1 + n3 / n11;
                }
                if (n10 != 0) {
                    n11 = 1 + n3 / n10;
                }
            } else {
                n12 = this.isContinuousLayout() && !bl ? this.getParent().getWidth() - this.getInsets().left - this.getInsets().right - dimension.width - 2 * this.getMarginGap() : this.getParent().getWidth() - this.getInsets().left - this.getInsets().right - 2 * this.getMarginGap();
                n9 = n12 / (n8 = dimension.width + this.getItemGap());
                n11 = Math.max(n9, n13);
                n10 = Math.max(1 + n3 / n11, n2);
                if (n10 != 0) {
                    n11 = 1 + n3 / n10;
                }
                if (n11 != 0) {
                    n10 = 1 + n3 / n11;
                }
            }
            if (!bl) {
                n6 += n10;
                n5 = n11;
                continue;
            }
            n6 = n10;
            n5 += n11;
        }
        n4 = this.isContinuousLayout() && !bl ? n5 * dimension.width + dimension.width + n5 * this.getItemGap() + this.getMarginGap() * 2 : (bl ? n5 * dimension.width + (n5 - 1) * this.getGroupGap() + this.getMarginGap() * 2 : n5 * dimension.width + (n5 - 1) * this.getItemGap() + this.getMarginGap() * 2);
        int n14 = this.isContinuousLayout() && bl ? n6 * dimension.height + dimension.height + n6 * this.getItemGap() + this.getMarginGap() * 2 : (!bl ? n6 * dimension.height + (n6 - 1) * this.getGroupGap() + this.getMarginGap() * 2 : n6 * dimension.height + (n6 - 1) * this.getItemGap() + this.getMarginGap() * 2);
        n3 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 > 0) {
            if (bl) {
                n4 = Math.max(n4, dimension2.width * n7 + this.getMarginGap() * 2);
                n14 += dimension2.height + this.getGroupGap();
            } else {
                n14 += n3 * (dimension2.height + this.getGroupGap());
                n4 = Math.max(n4, dimension2.width + this.getMarginGap() * 2);
            }
        }
        Dimension dimension3 = new Dimension(n4, n14);
        this.legendColumns = n5;
        this.legendRows = n6;
        return dimension3;
    }

    protected void layoutSteppedLegendItems(List<List<JCLegendItem>> list, boolean bl, Dimension dimension, Dimension dimension2, boolean[] blArray, Dimension dimension3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getMarginGap();
        int n5 = this.getMarginGap();
        int n6 = this.getMarginGap();
        int n7 = this.getMarginGap();
        int n8 = list.size();
        int n9 = bl ? (dimension2.width - 2 * this.getMarginGap() - (n8 - 1) * this.getGroupGap()) / n8 : dimension2.width - 2 * this.getMarginGap();
        for (int i2 = 0; i2 < n8; ++i2) {
            Dimension dimension4;
            List<JCLegendItem> list2 = list.get(i2);
            if (!bl) {
                if (blArray[i2]) {
                    n5 += dimension3.height + this.getGroupGap();
                }
                for (JCLegendItem jCLegendItem : list2) {
                    if (this.isTitleItem(jCLegendItem)) {
                        this.positionTitleItem(jCLegendItem, n9, n6, n7);
                        continue;
                    }
                    dimension4 = new Dimension(dimension.width, dimension.height);
                    if (n3 >= this.legendColumns) {
                        n3 = 0;
                        ++n2;
                        n5 += dimension.height + this.getGroupGap();
                        n4 = this.getMarginGap();
                    }
                    if (n3 != 0) {
                        n4 += this.getItemGap();
                    }
                    jCLegendItem.pos = new Point(n4, n5);
                    jCLegendItem.dim = dimension4;
                    jCLegendItem.symbolPos = new Point(0, 0);
                    jCLegendItem.textPos = new Point(jCLegendItem.symbolDim.width + this.getInsideItemGap(), 0);
                    jCLegendItem.pickRectangle = new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y, jCLegendItem.dim.width, jCLegendItem.dim.height);
                    n4 += dimension.width;
                    ++n3;
                }
                n3 = 0;
                ++n2;
                n4 = this.getMarginGap();
                n7 = n5 += dimension.height + this.getGroupGap();
                continue;
            }
            n5 = this.getMarginGap();
            if (blArray[i2]) {
                n5 += dimension3.height + this.getGroupGap();
            }
            for (JCLegendItem jCLegendItem : list2) {
                if (this.isTitleItem(jCLegendItem)) {
                    this.positionTitleItem(jCLegendItem, n9, n6, n7);
                    continue;
                }
                dimension4 = new Dimension(dimension.width, dimension.height);
                if (n2 >= this.legendRows) {
                    n2 = 0;
                    ++n3;
                    n4 += dimension.width + this.getGroupGap();
                    n5 = this.getMarginGap();
                    if (blArray[i2]) {
                        n5 += dimension3.height + this.getGroupGap();
                    }
                }
                if (n2 != 0) {
                    n5 += this.getItemGap();
                }
                jCLegendItem.pos = new Point(n4, n5);
                jCLegendItem.dim = dimension4;
                jCLegendItem.symbolPos = new Point(0, 0);
                jCLegendItem.textPos = new Point(jCLegendItem.symbolDim.width + this.getInsideItemGap(), 0);
                jCLegendItem.pickRectangle = new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y, jCLegendItem.dim.width, jCLegendItem.dim.height);
                n5 += dimension.height;
                ++n2;
            }
            n2 = 0;
            ++n3;
            n5 = this.getMarginGap();
            if ((n4 += dimension.width + this.getGroupGap()) < (n6 += dimension3.width + this.getGroupGap())) {
                n4 = n6;
                continue;
            }
            if (n6 >= n4) continue;
            n6 = n4;
        }
    }

    public void layoutContinuousLegendItems(List<List<JCLegendItem>> list, boolean bl, Dimension dimension, Dimension dimension2, boolean[] blArray, Dimension dimension3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getMarginGap();
        int n5 = this.getMarginGap();
        int n6 = this.getMarginGap();
        int n7 = this.getMarginGap();
        int n8 = list.size();
        int n9 = bl ? (dimension2.width - 2 * this.getMarginGap() - (n8 - 1) * this.getGroupGap()) / n8 : dimension2.width - 2 * this.getMarginGap();
        for (int i2 = 0; i2 < n8; ++i2) {
            Dimension dimension4;
            JCLegendItem jCLegendItem;
            int n10;
            List<JCLegendItem> list2 = list.get(i2);
            if (!bl) {
                if (blArray[i2]) {
                    n5 += dimension3.height + this.getGroupGap();
                }
                for (n10 = 0; n10 < list2.size(); ++n10) {
                    jCLegendItem = list2.get(n10);
                    if (this.isTitleItem(jCLegendItem)) {
                        this.positionTitleItem(jCLegendItem, n9, n6, n7);
                        continue;
                    }
                    dimension4 = new Dimension((int)((double)dimension.width * 1.5) + this.getItemGap(), dimension.height);
                    if (n3 >= this.legendColumns) {
                        dimension4 = new Dimension(dimension.width, dimension.height);
                        if (n2 != this.legendRows - 1) {
                            jCLegendItem = new JCLegendItem(jCLegendItem);
                            jCLegendItem.drawType = 0;
                            jCLegendItem.pickRectangle = null;
                            list2.add(n10, jCLegendItem);
                        }
                    }
                    if (n3 != 0) {
                        n4 += this.getItemGap();
                    }
                    jCLegendItem.pos = new Point(n4, n5);
                    jCLegendItem.dim = dimension4;
                    jCLegendItem.textPos = new Point((dimension.width - jCLegendItem.textDim.width) / 2, jCLegendItem.symbolDim.height + this.getInsideItemGap());
                    jCLegendItem.symbolPos = new Point(dimension.width / 2, 0);
                    jCLegendItem.pickRectangle = jCLegendItem.drawType != 0 ? new Rectangle(jCLegendItem.pos.x + jCLegendItem.symbolPos.x, jCLegendItem.pos.y, jCLegendItem.symbolDim.width, jCLegendItem.dim.height) : null;
                    if (n3 >= this.legendColumns) {
                        n3 = 0;
                        ++n2;
                        n5 += dimension.height + this.getGroupGap();
                        n4 = this.getMarginGap();
                        continue;
                    }
                    n4 += dimension.width;
                    ++n3;
                }
                n3 = 0;
                ++n2;
                n4 = this.getMarginGap();
                n7 = n5 += dimension.height + this.getGroupGap();
                continue;
            }
            if (blArray[i2]) {
                n5 += dimension3.height + this.getGroupGap();
            }
            for (n10 = 0; n10 < list2.size(); ++n10) {
                jCLegendItem = list2.get(n10);
                if (this.isTitleItem(jCLegendItem)) {
                    this.positionTitleItem(jCLegendItem, n9, n6, n7);
                    continue;
                }
                dimension4 = new Dimension(dimension.width, (int)((double)dimension.height * 1.5) + this.getItemGap());
                if (n2 >= this.legendRows) {
                    dimension4 = new Dimension(dimension.width, dimension.height);
                    if (n3 != this.legendColumns - 1) {
                        jCLegendItem = new JCLegendItem(jCLegendItem);
                        jCLegendItem.drawType = 0;
                        list2.add(n10, jCLegendItem);
                    }
                }
                if (n2 != 0) {
                    n5 += this.getItemGap();
                }
                jCLegendItem.pos = new Point(n4, n5);
                jCLegendItem.dim = dimension4;
                jCLegendItem.textPos = new Point(jCLegendItem.symbolDim.width + this.getInsideItemGap(), 0);
                jCLegendItem.symbolPos = new Point(0, jCLegendItem.textDim.height / 2);
                jCLegendItem.pickRectangle = jCLegendItem.drawType != 0 ? new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y + jCLegendItem.symbolPos.y, jCLegendItem.dim.width, jCLegendItem.symbolDim.height) : null;
                if (n2 >= this.legendRows) {
                    n2 = 0;
                    ++n3;
                    n4 += dimension.width + this.getGroupGap();
                    n5 = this.getMarginGap();
                    if (!blArray[i2]) continue;
                    n5 += dimension3.height + this.getGroupGap();
                    continue;
                }
                n5 += dimension.height;
                ++n2;
            }
            n2 = 0;
            ++n3;
            n5 = this.getMarginGap();
            if ((n4 += dimension.width + this.getGroupGap()) < (n6 += dimension3.width + this.getGroupGap())) {
                n4 = n6;
                continue;
            }
            if (n6 >= n4) continue;
            n6 = n4;
        }
    }

    protected void positionTitleItem(JCLegendItem jCLegendItem, int n2, int n3, int n4) {
        jCLegendItem.pos = new Point(n3 + (n2 - jCLegendItem.textDim.width) / 2, n4);
        jCLegendItem.dim = new Dimension(jCLegendItem.textDim.width, jCLegendItem.textDim.height);
        jCLegendItem.textPos = new Point(0, 0);
    }

    @Override
    public JCLegendItem pick(Point point) {
        JCLegendItem jCLegendItem = super.pick(point);
        if (jCLegendItem != null && jCLegendItem.pickRectangle == null) {
            jCLegendItem = null;
        }
        return jCLegendItem;
    }
}

