/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.Transform;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;

public class GridRegion
implements Serializable {
    public static final int REGION_1 = 1;
    public static final int REGION_2 = 2;
    public static final int REGION_3 = 3;
    public static final int REGION_4 = 4;
    public static final int REGION_5 = 5;
    public static final int REGION_6 = 6;
    public static final int REGION_7 = 7;
    public static final int REGION_8 = 8;
    public static final int REGION_9 = 9;
    protected int xEye;
    protected int yEye;
    protected int xBegin;
    protected int yBegin;
    protected int xLeft;
    protected int yLeft;
    protected int xRight;
    protected int yRight;
    protected int xEnd;
    protected int yEnd;
    protected DrawGrid drawGrid = null;

    GridRegion() {
    }

    GridRegion(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected DrawGrid getDrawGrid() {
        return this.drawGrid;
    }

    protected void setDrawGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    protected int getXEye() {
        return this.xEye;
    }

    protected void setXEye(int n2) {
        this.xEye = n2;
    }

    protected int getYEye() {
        return this.yEye;
    }

    protected void setYEye(int n2) {
        this.yEye = n2;
    }

    protected int getXBegin() {
        return this.xBegin;
    }

    protected void setXBegin(int n2) {
        this.xBegin = n2;
    }

    protected int getYBegin() {
        return this.yBegin;
    }

    protected void setYBegin(int n2) {
        this.yBegin = n2;
    }

    protected int getXLeft() {
        return this.xLeft;
    }

    protected void setXLeft(int n2) {
        this.xLeft = n2;
    }

    protected int getYLeft() {
        return this.yLeft;
    }

    protected void setYLeft(int n2) {
        this.yLeft = n2;
    }

    protected int getXRight() {
        return this.xRight;
    }

    protected void setXRight(int n2) {
        this.xRight = n2;
    }

    protected int getYRight() {
        return this.yRight;
    }

    protected void setYRight(int n2) {
        this.yRight = n2;
    }

    protected int getXEnd() {
        return this.xEnd;
    }

    protected void setXEnd(int n2) {
        this.xEnd = n2;
    }

    protected int getYEnd() {
        return this.yEnd;
    }

    protected void setYEnd(int n2) {
        this.yEnd = n2;
    }

    protected void calcRegions() {
        Chart3dDataView chart3dDataView = this.drawGrid.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        this.xBegin = gridLimits.getXOffset();
        this.yBegin = gridLimits.getYOffset();
        this.xEnd = gridLimits.getXLast() - 1;
        this.yEnd = gridLimits.getYLast() - 1;
        JCBar jCBar = jCChart3dArea.getBar();
        if (chart3dDataView.getChartType() == 1) {
            if (jCBar.getXFormat() == 1) {
                ++this.xEnd;
            }
            if (jCBar.getYFormat() == 1) {
                ++this.yEnd;
            }
        } else if (chart3dDataView.getChartType() == 2) {
            ++this.xEnd;
            ++this.yEnd;
        }
        Transform transform = jCChart3dArea.getTransform();
        Point4d point4d = transform.getEyePosition();
        this.xEye = chart3dGridData.getGridIndex(point4d.x, true, true);
        this.yEye = chart3dGridData.getGridIndex(point4d.y, false, true);
        this.xLeft = this.xEye - 1;
        this.yLeft = this.yEye - 1;
        this.xRight = this.xEye + 1;
        this.yRight = this.yEye + 1;
        Point4d[] point4dArray = JCChart3dUtil.constructBarPlane(chart3dGridData, this.xEye, this.yEye);
        Matrix4d matrix4d = transform.getAbsolute();
        double d2 = (point4d.x - matrix4d.m03) / matrix4d.m00;
        double d3 = (point4d.y - matrix4d.m13) / matrix4d.m11;
        if (d2 < point4dArray[1].x) {
            --this.xRight;
        }
        if (d2 > point4dArray[3].x) {
            ++this.xLeft;
        }
        if (d3 < point4dArray[1].y) {
            --this.yRight;
        }
        if (d3 > point4dArray[2].y) {
            ++this.yLeft;
        }
    }

    public int getRegion(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.xLeft < this.xBegin) {
            bl = true;
        } else if (this.xRight > this.xEnd) {
            bl3 = true;
        } else {
            bl3 = n2 <= this.xLeft;
            bl2 = n2 == this.xEye;
            bl = n2 >= this.xRight;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.yLeft < this.yBegin) {
            bl4 = true;
        } else if (this.yRight > this.yEnd) {
            bl6 = true;
        } else {
            bl6 = n3 <= this.yLeft;
            bl5 = n3 == this.yEye;
            boolean bl7 = bl4 = n3 >= this.yRight;
        }
        if (bl2 && bl5) {
            return 1;
        }
        if (bl2 && bl4) {
            return 2;
        }
        if (bl2 && bl6) {
            return 3;
        }
        if (bl && bl5) {
            return 4;
        }
        if (bl3 && bl5) {
            return 5;
        }
        if (bl && bl4) {
            return 6;
        }
        if (bl && bl6) {
            return 7;
        }
        if (bl3 && bl4) {
            return 8;
        }
        if (bl3 && bl6) {
            return 9;
        }
        return 9;
    }
}

