/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCChart3dArea;
import java.io.Serializable;

public class GridLimits
implements Serializable {
    protected int xOffset;
    protected int yOffset;
    protected int xLast;
    protected int yLast;
    protected int numX;
    protected int numY;
    protected Chart3dGridData data = null;

    public GridLimits() {
        this.assignGridValues(null);
    }

    public GridLimits(Chart3dGridData chart3dGridData, boolean bl) {
        this.data = chart3dGridData;
        if (bl) {
            this.assignGridValues(chart3dGridData);
        } else {
            this.assignGridValues(null);
        }
    }

    public int getXOffset() {
        return this.xOffset;
    }

    protected void setXOffset(int n2) {
        this.xOffset = n2;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    protected void setYOffset(int n2) {
        this.yOffset = n2;
    }

    public int getXLast() {
        return this.xLast;
    }

    protected void setXLast(int n2) {
        this.xLast = n2;
    }

    public int getYLast() {
        return this.yLast;
    }

    protected void setYLast(int n2) {
        this.yLast = n2;
    }

    public int getNumX() {
        return this.numX;
    }

    protected void setNumX(int n2) {
        this.numX = n2;
    }

    public int getNumY() {
        return this.numY;
    }

    protected void setNumY(int n2) {
        this.numY = n2;
    }

    protected Chart3dGridData getGridData() {
        return this.data;
    }

    protected void setGridData(Chart3dGridData chart3dGridData) {
        this.data = chart3dGridData;
        this.assignGridValues(chart3dGridData);
    }

    protected void assignGridValues(Chart3dGridData chart3dGridData) {
        int n2;
        if (chart3dGridData == null) {
            this.xOffset = 0;
            this.yOffset = 0;
            this.xLast = 0;
            this.yLast = 0;
            this.numX = 0;
            this.numY = 0;
            return;
        }
        JCChart3dArea jCChart3dArea = chart3dGridData.getDataView().getChart3d().getChart3dArea();
        double d2 = jCChart3dArea.getAxis(1).getMin();
        double d3 = jCChart3dArea.getAxis(1).getMax();
        double d4 = jCChart3dArea.getAxis(2).getMin();
        double d5 = jCChart3dArea.getAxis(2).getMax();
        double[] dArray = chart3dGridData.getXGrid();
        double[] dArray2 = chart3dGridData.getYGrid();
        this.numX = chart3dGridData.getNumX();
        this.numY = chart3dGridData.getNumY();
        this.xOffset = chart3dGridData.getPointIndex(d2, dArray, this.numX);
        this.yOffset = chart3dGridData.getPointIndex(d4, dArray2, this.numY);
        this.xLast = chart3dGridData.getPointIndex(d3, dArray, this.numX);
        this.yLast = chart3dGridData.getPointIndex(d5, dArray2, this.numY);
        if (1.0 + (dArray[this.xLast] - d3) != 1.0) {
            this.xLast = Math.min(this.xLast + 1, this.numX - 1);
        }
        if (1.0 + (dArray2[this.yLast] - d5) != 1.0) {
            this.yLast = Math.min(this.yLast + 1, this.numY - 1);
        }
        if (((n2 = chart3dGridData.getDataView().getChartType()) == 0 || n2 == 1 && jCChart3dArea.getBar().getXFormat() != 1) && this.xLast <= this.xOffset) {
            if (this.xLast == this.numX - 1) {
                this.xOffset = this.xLast - 1;
            } else {
                this.xLast = this.xOffset + 1;
            }
        }
        if ((n2 == 0 || n2 == 1 && jCChart3dArea.getBar().getYFormat() != 1) && this.yLast <= this.yOffset) {
            if (this.yLast == this.numY - 1) {
                this.yOffset = this.yLast - 1;
            } else {
                this.yLast = this.yOffset + 1;
            }
        }
        this.xOffset = Math.max(this.xOffset, 0);
        this.yOffset = Math.max(this.yOffset, 0);
        this.xLast = Math.min(this.xLast, this.numX - 1);
        this.yLast = Math.min(this.yLast, this.numY - 1);
        this.numX = this.xLast - this.xOffset + 1;
        this.numY = this.yLast - this.yOffset + 1;
    }
}

