/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointDataHandler;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.Extents;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SortPoint;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart3dPointData
extends Chart3dData
implements Comparator<SortPoint> {
    protected List<Chart3dPointSeries> series = null;
    protected int numSeries;
    protected List<SortPoint> sortPoints = null;
    protected boolean sorted = false;

    public Chart3dPointData() {
        this.dataHandler = new Chart3dPointDataHandler(this);
        this.setDataSource(null);
    }

    public Chart3dPointData(Chart3dDataView chart3dDataView, Chart3dPointDataModel chart3dPointDataModel) {
        super(chart3dDataView);
        this.dataHandler = new Chart3dPointDataHandler(this);
        this.setDataSource(chart3dPointDataModel);
    }

    public Point3d getPoint(int n2, int n3) {
        if (n2 < 0 || n2 > this.numSeries - 1) {
            throw new IllegalArgumentException(LocaleBundle.string("Series number out of range."));
        }
        Chart3dPointSeries chart3dPointSeries = this.series.get(n2);
        return chart3dPointSeries.getPoint(n3);
    }

    public Chart3dPointSeries getSeries(int n2) {
        if (n2 < 0 || n2 > this.numSeries - 1) {
            throw new IllegalArgumentException(LocaleBundle.string("Series number out of range."));
        }
        return this.series.get(n2);
    }

    public List<Chart3dPointSeries> getSeries() {
        return this.series;
    }

    public int getNumSeries() {
        return this.numSeries;
    }

    protected void addSeries(Point3d[] point3dArray) {
        if (point3dArray == null) {
            return;
        }
        if (this.series == null) {
            this.series = new ArrayList<Chart3dPointSeries>();
        }
        this.series.add(new Chart3dPointSeries(this, point3dArray));
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void addSeries(Point3d[] point3dArray, int n2) {
        if (this.series == null) {
            this.series = new ArrayList<Chart3dPointSeries>();
        }
        if (n2 < 0 || n2 > this.series.size() || point3dArray == null) {
            return;
        }
        this.series.add(n2, new Chart3dPointSeries(this, point3dArray));
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void removeSeries(int n2) {
        if (this.series == null || n2 < 0 || n2 > this.series.size()) {
            return;
        }
        this.series.remove(n2);
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void makePointSeriesList(Point3d[][] point3dArray) {
        this.series = null;
        this.numSeries = 0;
        if (point3dArray != null) {
            this.numSeries = point3dArray.length;
            this.series = new ArrayList<Chart3dPointSeries>();
            for (int i2 = 0; i2 < this.numSeries; ++i2) {
                this.series.add(new Chart3dPointSeries(this, point3dArray[i2]));
            }
        }
        this.processData();
    }

    protected void refreshPointSeriesList(Point3d[][] point3dArray) {
        if (point3dArray == null || this.series == null || point3dArray.length != this.numSeries) {
            return;
        }
        for (int i2 = 0; i2 < this.numSeries; ++i2) {
            Chart3dPointSeries chart3dPointSeries = this.series.get(i2);
            Point3d[] point3dArray2 = point3dArray[i2];
            chart3dPointSeries.setPoints(point3dArray2);
        }
        this.processData();
    }

    protected void processData() {
        this.dataOK = true;
        if (this.numSeries < 1) {
            this.dataOK = false;
        }
        for (int i2 = 0; i2 < this.numSeries; ++i2) {
            Chart3dPointSeries chart3dPointSeries = this.series.get(i2);
            if (chart3dPointSeries != null && chart3dPointSeries.getNumPoints() >= 1) continue;
            this.dataOK = false;
        }
    }

    protected void setDataSource(Chart3dPointDataModel chart3dPointDataModel) {
        this.dataSource = chart3dPointDataModel;
        if (chart3dPointDataModel == null) {
            this.makePointSeriesList(null);
            return;
        }
        if (this.dataHandler == null) {
            return;
        }
        this.dataHandler.reset(chart3dPointDataModel);
    }

    public List<SortPoint> getSortPoints() {
        return this.sortPoints;
    }

    protected void computePointLimits() {
        Serializable serializable;
        Extents extents = new Extents();
        for (int i2 = 0; i2 < this.numSeries; ++i2) {
            serializable = this.series.get(i2);
            for (int i3 = 0; i3 < ((Chart3dPointSeries)serializable).getNumPoints(); ++i3) {
                Point3d point3d = ((Chart3dPointSeries)serializable).getPoint(i3);
                if (point3d.z == this.getHoleValue()) continue;
                extents.checkXYZExtents(point3d.x, point3d.y, point3d.z);
            }
        }
        if (extents.getXMin() == Double.MAX_VALUE) {
            extents.setXMin(0.0);
            extents.setXMax(1.0);
            extents.setYMin(0.0);
            extents.setYMax(1.0);
            extents.setZMin(0.0);
            extents.setZMax(1.0);
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        serializable = jCChart3dArea.getAxis(1);
        ((JCAxis)serializable).setExtents(extents.getXMin(), extents.getXMax());
        serializable = jCChart3dArea.getAxis(2);
        ((JCAxis)serializable).setExtents(extents.getYMin(), extents.getYMax());
        serializable = jCChart3dArea.getAxis(3);
        ((JCAxis)serializable).setExtents(extents.getZMin(), extents.getZMax());
        this.dataMin = extents.getZMin();
        this.dataMax = extents.getZMax();
    }

    protected void calcLimits() {
        if (!this.dataOK) {
            return;
        }
        this.computePointLimits();
        this.checkValidZExtents();
    }

    @Override
    protected void calcAnnoLimits() {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(1);
        JCAxis jCAxis2 = jCChart3dArea.getAxis(2);
        JCAxis jCAxis3 = jCChart3dArea.getAxis(3);
        jCAxis.setAnnoMin(jCAxis.getMin());
        jCAxis.setAnnoMax(jCAxis.getMax());
        jCAxis.setAnnoStep(0.0);
        jCAxis2.setAnnoMin(jCAxis2.getMin());
        jCAxis2.setAnnoMax(jCAxis2.getMax());
        jCAxis2.setAnnoStep(0.0);
        double d2 = jCAxis3.getMin();
        double d3 = jCAxis3.getMax();
        if (!jCChart3dArea.getChart3d().isProjection() && jCChart3dArea.getScatter().hasDropLines()) {
            d2 = Math.min(d2, jCAxis3.getOrigin());
            d3 = Math.max(d3, jCAxis3.getOrigin());
        }
        jCAxis3.setAnnoMin(d2);
        jCAxis3.setAnnoMax(d3);
        jCAxis3.setAnnoStep(0.0);
    }

    @Override
    public void precomputePoints() {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        boolean bl = false;
        if (this.screenPoints == null || this.screenPoints.length != this.numSeries) {
            this.screenPoints = new ScreenPoint[this.numSeries][];
            bl = true;
        }
        for (int i2 = 0; i2 < this.numSeries; ++i2) {
            Chart3dPointSeries chart3dPointSeries = this.series.get(i2);
            int n2 = chart3dPointSeries.getNumPoints();
            boolean bl2 = false;
            if (bl || this.screenPoints[i2].length != n2) {
                this.screenPoints[i2] = new ScreenPoint[n2];
                bl2 = true;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                ScreenPoint screenPoint;
                Point3d point3d = chart3dPointSeries.getPoint(i3);
                if (bl2) {
                    screenPoint = new ScreenPoint();
                } else {
                    screenPoint = this.screenPoints[i2][i3];
                    screenPoint.reset();
                }
                if (point3d.x == this.holeValue || point3d.y == this.holeValue || point3d.z == this.holeValue) {
                    screenPoint.setHoleValue(true);
                }
                JCAxis jCAxis = jCChart3dArea.getAxis(1);
                JCAxis jCAxis2 = jCChart3dArea.getAxis(2);
                JCAxis jCAxis3 = jCChart3dArea.getAxis(3);
                if (point3d.x > jCAxis.getMax() || point3d.x < jCAxis.getMin() || point3d.y > jCAxis2.getMax() || point3d.y < jCAxis2.getMin() || point3d.z > jCAxis3.getMax() || point3d.z < jCAxis3.getMin()) {
                    screenPoint.setHidden(true);
                }
                JCChart3dUtil.getScreenPoint(this.dataView.getChart3d(), point3d.x, point3d.y, point3d.z, jCAxis3.getMin(), screenPoint);
                this.screenPoints[i2][i3] = screenPoint;
            }
        }
        this.sorted = false;
    }

    public void sortPoints() {
        if (this.sorted) {
            return;
        }
        if (!this.isDataOK()) {
            return;
        }
        if (this.sortPoints == null) {
            this.sortPoints = new ArrayList<SortPoint>();
        } else {
            this.sortPoints.clear();
        }
        for (int i2 = 0; i2 < this.numSeries; ++i2) {
            Chart3dPointSeries chart3dPointSeries = this.series.get(i2);
            for (int i3 = 0; i3 < chart3dPointSeries.getNumPoints(); ++i3) {
                Point3d point3d = chart3dPointSeries.getPoint(i3);
                double d2 = JCChart3dUtil.distanceToEye(this.dataView.getChart3d(), point3d.x, point3d.y, point3d.z);
                SortPoint sortPoint = new SortPoint(i2, i3, d2);
                this.sortPoints.add(sortPoint);
            }
        }
        Collections.sort(this.sortPoints, this);
        this.sorted = true;
    }

    @Override
    public int compare(SortPoint sortPoint, SortPoint sortPoint2) {
        int n2 = 0;
        if (sortPoint.getDistanceToEye() > sortPoint2.getDistanceToEye()) {
            n2 = -1;
        } else if (sortPoint.getDistanceToEye() < sortPoint2.getDistanceToEye()) {
            n2 = 1;
        }
        return n2;
    }
}

