/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataHandler;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.EditableChart3dDataModel;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.LabelledChart3dGridDataModel;
import com.klg.jclass.chart3d.event.Chart3dDataEvent;
import com.klg.jclass.chart3d.event.Chart3dGridDataEvent;
import com.klg.jclass.chart3d.resources.LocaleBundle;

public class Chart3dGridDataHandler
extends Chart3dDataHandler {
    public Chart3dGridDataHandler(Chart3dGridData chart3dGridData) {
        super(chart3dGridData);
    }

    public boolean handleEvent(Chart3dDataModel chart3dDataModel, Chart3dDataEvent chart3dDataEvent) {
        boolean bl = false;
        if (chart3dDataModel == null || chart3dDataEvent == null) {
            return bl;
        }
        bl = super.handleEvent(chart3dDataModel, chart3dDataEvent);
        if (bl) {
            return bl;
        }
        Chart3dGridDataModel chart3dGridDataModel = (Chart3dGridDataModel)chart3dDataModel;
        if (!(chart3dDataEvent instanceof Chart3dGridDataEvent)) {
            return bl;
        }
        Chart3dGridDataEvent chart3dGridDataEvent = (Chart3dGridDataEvent)chart3dDataEvent;
        switch (chart3dGridDataEvent.getType()) {
            case 5: {
                bl = this.reloadXValue(chart3dGridDataModel, chart3dGridDataEvent.getX());
                break;
            }
            case 6: {
                bl = this.reloadXGrid(chart3dGridDataModel);
                break;
            }
            case 7: {
                bl = this.reloadYValue(chart3dGridDataModel, chart3dGridDataEvent.getY());
                break;
            }
            case 8: {
                bl = this.reloadYGrid(chart3dGridDataModel);
                break;
            }
            case 9: {
                bl = this.reloadZValue(chart3dGridDataModel, chart3dGridDataEvent.getX(), chart3dGridDataEvent.getY());
                break;
            }
            case 10: {
                bl = this.reloadZArray(chart3dGridDataModel, chart3dGridDataEvent.getX());
                break;
            }
            case 11: {
                bl = this.reloadZAll(chart3dGridDataModel);
                break;
            }
            case 12: {
                bl = this.reloadXLabel(chart3dGridDataModel, chart3dGridDataEvent.getX());
                break;
            }
            case 13: {
                bl = this.reloadAllXLabels(chart3dGridDataModel);
                break;
            }
            case 14: {
                bl = this.reloadXLabel(chart3dGridDataModel, chart3dGridDataEvent.getY());
                break;
            }
            case 15: {
                bl = this.reloadAllYLabels(chart3dGridDataModel);
                break;
            }
            default: {
                throw new RuntimeException(LocaleBundle.string("Unknown event type: ") + chart3dGridDataEvent.getType());
            }
        }
        return bl;
    }

    public boolean reset(Chart3dDataModel chart3dDataModel) {
        if (chart3dDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        Chart3dGridDataModel chart3dGridDataModel = (Chart3dGridDataModel)chart3dDataModel;
        chart3dGridData.setAllXYZValues(chart3dGridDataModel.getXGrid(), chart3dGridDataModel.getYGrid(), chart3dGridDataModel.getZValues());
        this.reloadAllXLabels(chart3dGridDataModel);
        this.reloadAllYLabels(chart3dGridDataModel);
        this.reloadHoleValue(chart3dDataModel);
        this.reloadDataSourceName(chart3dDataModel);
        return true;
    }

    public boolean reload(Chart3dDataModel chart3dDataModel) {
        if (chart3dDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        Chart3dGridDataModel chart3dGridDataModel = (Chart3dGridDataModel)chart3dDataModel;
        chart3dGridData.setAllXYZValues(chart3dGridDataModel.getXGrid(), chart3dGridDataModel.getYGrid(), chart3dGridDataModel.getZValues());
        this.reloadHoleValue(chart3dDataModel);
        return true;
    }

    public boolean reloadXValue(Chart3dGridDataModel chart3dGridDataModel, int n2) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        double[] dArray = chart3dGridData.getXGrid();
        if (n2 < 0 || dArray == null || n2 >= dArray.length) {
            return false;
        }
        chart3dGridData.setXGrid(chart3dGridDataModel.getXGrid());
        return true;
    }

    public boolean reloadXGrid(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        chart3dGridData.setXGrid(chart3dGridDataModel.getXGrid());
        return true;
    }

    public boolean reloadYValue(Chart3dGridDataModel chart3dGridDataModel, int n2) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        double[] dArray = chart3dGridData.getYGrid();
        if (n2 < 0 || dArray == null || n2 >= dArray.length) {
            return false;
        }
        chart3dGridData.setYGrid(chart3dGridDataModel.getYGrid());
        return true;
    }

    public boolean reloadYGrid(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        chart3dGridData.setYGrid(chart3dGridDataModel.getYGrid());
        return true;
    }

    public boolean reloadZValue(Chart3dGridDataModel chart3dGridDataModel, int n2, int n3) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        double[][] dArray = chart3dGridData.getZValues();
        if (dArray == null || n2 < 0 || n2 >= dArray.length) {
            return false;
        }
        if (dArray[n2] == null || n3 < 0 || n3 > dArray[n2].length) {
            return false;
        }
        chart3dGridData.setZValues(chart3dGridDataModel.getZValues());
        return true;
    }

    public boolean reloadZArray(Chart3dGridDataModel chart3dGridDataModel, int n2) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        double[][] dArray = chart3dGridData.getZValues();
        if (dArray == null || n2 < 0 || n2 >= dArray.length) {
            return false;
        }
        chart3dGridData.setZValues(chart3dGridDataModel.getZValues());
        return true;
    }

    public boolean reloadZAll(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel == null) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        chart3dGridData.setZValues(chart3dGridDataModel.getZValues());
        return true;
    }

    public boolean reloadXLabel(Chart3dGridDataModel chart3dGridDataModel, int n2) {
        if (chart3dGridDataModel == null || !(chart3dGridDataModel instanceof LabelledChart3dGridDataModel)) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        LabelledChart3dGridDataModel labelledChart3dGridDataModel = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
        String[] stringArray = chart3dGridData.getXLabels();
        if (stringArray == null || n2 < 0 || n2 >= stringArray.length) {
            return false;
        }
        chart3dGridData.xLabels = labelledChart3dGridDataModel.getXLabels();
        return true;
    }

    public boolean reloadAllXLabels(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel == null || !(chart3dGridDataModel instanceof LabelledChart3dGridDataModel)) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        LabelledChart3dGridDataModel labelledChart3dGridDataModel = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
        chart3dGridData.xLabels = labelledChart3dGridDataModel.getXLabels();
        return true;
    }

    public boolean reloadYLabel(Chart3dGridDataModel chart3dGridDataModel, int n2) {
        if (chart3dGridDataModel == null || !(chart3dGridDataModel instanceof LabelledChart3dGridDataModel)) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        LabelledChart3dGridDataModel labelledChart3dGridDataModel = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
        String[] stringArray = chart3dGridData.getYLabels();
        if (stringArray == null || n2 < 0 || n2 >= stringArray.length) {
            return false;
        }
        chart3dGridData.yLabels = labelledChart3dGridDataModel.getYLabels();
        return true;
    }

    public boolean reloadAllYLabels(Chart3dGridDataModel chart3dGridDataModel) {
        if (chart3dGridDataModel == null || !(chart3dGridDataModel instanceof LabelledChart3dGridDataModel)) {
            return false;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)this.data;
        LabelledChart3dGridDataModel labelledChart3dGridDataModel = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
        chart3dGridData.yLabels = labelledChart3dGridDataModel.getYLabels();
        return true;
    }

    public boolean editZValue(JCData3dIndex jCData3dIndex, double d2) {
        if (jCData3dIndex == null || !(jCData3dIndex instanceof JCData3dGridIndex)) {
            return false;
        }
        JCData3dGridIndex jCData3dGridIndex = (JCData3dGridIndex)jCData3dIndex;
        Chart3dDataModel chart3dDataModel = this.data.getDataSource();
        if (chart3dDataModel == null || !(chart3dDataModel instanceof EditableChart3dDataModel)) {
            return false;
        }
        EditableChart3dDataModel editableChart3dDataModel = (EditableChart3dDataModel)((Object)chart3dDataModel);
        return editableChart3dDataModel.setZValue(jCData3dGridIndex, d2);
    }
}

