/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataHandler;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.TrackChange;
import com.klg.jclass.chart3d.resources.LocaleBundle;

public abstract class Chart3dData
extends TrackChange {
    protected Chart3dDataView dataView = null;
    protected double holeValue = Double.MAX_VALUE;
    protected String name = null;
    protected boolean dataOK = false;
    protected Chart3dDataModel dataSource = null;
    protected Chart3dDataHandler dataHandler = null;
    protected double dataMin = Double.MAX_VALUE;
    protected double dataMax = Double.MAX_VALUE;
    protected ScreenPoint[][] screenPoints = null;

    Chart3dData() {
    }

    Chart3dData(Chart3dDataView chart3dDataView) {
        this.dataView = chart3dDataView;
    }

    public Chart3dDataView getDataView() {
        return this.dataView;
    }

    public void setDataView(Chart3dDataView chart3dDataView) {
        this.dataView = chart3dDataView;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isDataOK() {
        return this.dataOK;
    }

    protected void setDataOK(boolean bl) {
        this.dataOK = bl;
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    protected void setHoleValue(double d2) {
        this.holeValue = d2;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    protected void setDataMin(double d2) {
        this.dataMin = d2;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    protected void setDataMax(double d2) {
        this.dataMax = d2;
    }

    public Chart3dDataModel getDataSource() {
        return this.dataSource;
    }

    public Chart3dDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public ScreenPoint[][] getScreenPoints() {
        return this.screenPoints;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = LocaleBundle.string("Unnamed Data Object");
        }
        return string;
    }

    public int getClosestPoint(double d2, double[] dArray, int n2) {
        if (dArray == null) {
            return 0;
        }
        double d3 = Double.MAX_VALUE;
        int n3 = 0;
        for (int i2 = 0; i2 < Math.min(n2, dArray.length); ++i2) {
            double d4 = Math.abs(dArray[i2] - d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            n3 = i2;
        }
        return n3;
    }

    public int getPointIndex(double d2, double[] dArray, int n2) {
        if (n2 <= 1) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            if (dArray[n5] < d2) {
                n3 = n5 + 1;
                continue;
            }
            if (dArray[n5] > d2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        if (n3 == n2 || n3 > 0 && dArray[n3] > d2) {
            --n3;
        }
        return Math.max(Math.min(n3, n2 - 1), 0);
    }

    public double getMinStep(double[] dArray, int n2) {
        double d2 = Double.MAX_VALUE;
        if (!this.dataOK || dArray == null || n2 < 1) {
            return d2;
        }
        if (n2 == 1) {
            d2 = dArray[0];
            if (d2 + 1.0 == 1.0) {
                d2 = 1.0;
            }
        } else {
            d2 = dArray[1] - dArray[0];
            for (int i2 = 1; i2 < n2 - 1; ++i2) {
                double d3 = dArray[i2 + 1] - dArray[i2];
                if (!(d2 > d3)) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    protected void checkValidZExtents() {
        JCAxis jCAxis = this.dataView.getChart3d().getChart3dArea().getAxis(3);
        double d2 = jCAxis.getMin();
        if (!jCAxis.min.setValidValue(this.dataMin, true)) {
            // empty if block
        }
        d2 = jCAxis.getMax();
        if (!jCAxis.max.setValidValue(this.dataMax, false)) {
            // empty if block
        }
    }

    public void setChanged(boolean bl, int n2) {
        this.updateFlags(bl, n2);
        if (this.dataView != null) {
            this.dataView.setChanged(this.changed, this.changedFlag);
        }
        this.updateFlags(false, 0);
    }

    public abstract void precomputePoints();

    protected abstract void calcAnnoLimits();
}

