/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dNumberFormat;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCLabelGenerator;
import com.klg.jclass.chart3d.JCValueLabel;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart3dAnnoHandler
implements Comparator<JCValueLabel>,
Serializable {
    protected List<JCValueLabel> valueLabels = new ArrayList<JCValueLabel>();
    protected List<JCValueLabel> userValueLabels = new ArrayList<JCValueLabel>();
    protected double annoHeight = 0.0;
    protected double annoShift = 0.0;
    protected JCAxis axis = null;

    public Chart3dAnnoHandler(JCAxis jCAxis) {
        this.axis = jCAxis;
    }

    protected JCAxis getAxis() {
        return this.axis;
    }

    public List<JCValueLabel> getValueLabels() {
        return this.valueLabels;
    }

    protected List<JCValueLabel> getUserValueLabels() {
        return this.userValueLabels;
    }

    protected void setUserValueLabels(List<JCValueLabel> list) {
        this.userValueLabels = list;
        this.sortValueLabels();
    }

    public double getAnnoHeight() {
        return this.annoHeight;
    }

    public double getAnnoShift() {
        return this.annoShift;
    }

    protected void sortValueLabels() {
        if (this.userValueLabels.size() <= 1) {
            return;
        }
        Collections.sort(this.userValueLabels, this);
    }

    @Override
    public int compare(JCValueLabel jCValueLabel, JCValueLabel jCValueLabel2) {
        if (jCValueLabel == null && jCValueLabel2 == null) {
            return 0;
        }
        if (jCValueLabel == null) {
            return -1;
        }
        if (jCValueLabel2 == null) {
            return 1;
        }
        int n2 = 0;
        if (jCValueLabel.getValue() < jCValueLabel2.getValue()) {
            n2 = -1;
        } else if (jCValueLabel.getValue() > jCValueLabel2.getValue()) {
            n2 = 1;
        }
        return n2;
    }

    protected void calcAnnoHeight(Graphics graphics) {
        this.annoHeight = 0.0;
        this.annoShift = 0.0;
        Font font = this.axis.getAnnoFont();
        if (graphics == null || this.valueLabels == null || this.valueLabels.size() == 0 || font == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        for (JCValueLabel jCValueLabel : this.valueLabels) {
            if (jCValueLabel.getLabel() == null || !jCValueLabel.isLabelDrawn() || jCValueLabel.getLabel().length() <= 0) continue;
            TextLayout textLayout = new TextLayout(jCValueLabel.getLabel(), font, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            d2 = Math.min(d2, rectangle2D.getY());
            d3 = Math.max(d3, rectangle2D.getY() + rectangle2D.getHeight());
        }
        this.annoHeight = d3 - d2;
        this.annoShift = this.annoHeight / 2.0 - d3;
    }

    protected void makeAnnotations(Graphics graphics, Anno anno) {
        switch (this.axis.getAnnotationMethod()) {
            case 3: {
                this.makeValueLabels();
                break;
            }
            case 2: {
                this.makeDataLabels(anno);
                break;
            }
            case 1: {
                this.makeValues(anno);
                break;
            }
        }
        this.calcAnnoHeight(graphics);
    }

    private void makeValueLabels() {
        this.valueLabels = new ArrayList<JCValueLabel>();
        if (this.userValueLabels == null) {
            return;
        }
        for (int i2 = 0; i2 < this.userValueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel = this.userValueLabels.get(i2);
            jCValueLabel.setAxis(this.axis);
            jCValueLabel.setIndex(i2);
            this.valueLabels.add(jCValueLabel);
        }
    }

    private void makeDataLabels(Anno anno) {
        Object object;
        int n2;
        int n3;
        int n4;
        double[] dArray;
        ArrayList<? extends Object> arrayList;
        String[] stringArray;
        this.valueLabels = new ArrayList<JCValueLabel>();
        if (anno == null) {
            return;
        }
        JCChart3dArea jCChart3dArea = anno.getChart3dArea();
        Chart3dDataView chart3dDataView = jCChart3dArea.getChart3d().getDataView(0);
        Chart3dData chart3dData = chart3dDataView.getElevationData();
        if (!(chart3dData instanceof Chart3dGridData)) {
            return;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        switch (this.axis.getAxisId()) {
            case 1: {
                stringArray = chart3dGridData.getXLabels();
                arrayList = chart3dGridData.getXLabelsArrayList();
                dArray = chart3dGridData.getXGrid();
                n4 = chart3dGridData.getNumX();
                n3 = jCChart3dArea.getBar().getXFormat();
                int n5 = gridLimits.getXOffset();
                n2 = gridLimits.getXLast();
                break;
            }
            case 2: {
                stringArray = chart3dGridData.getYLabels();
                arrayList = chart3dGridData.getYLabelsArrayList();
                dArray = chart3dGridData.getYGrid();
                n4 = chart3dGridData.getNumY();
                n3 = jCChart3dArea.getBar().getYFormat();
                int n5 = gridLimits.getYOffset();
                n2 = gridLimits.getYLast();
                break;
            }
            default: {
                return;
            }
        }
        if (stringArray == null && arrayList == null) {
            return;
        }
        int n6 = arrayList == null ? stringArray.length : arrayList.size();
        for (int i2 = n5; i2 <= n2 && i2 < n6; ++i2) {
            JCValueLabel jCValueLabel;
            double d2 = dArray[i2];
            if (chart3dDataView.getChartType() == 1 && n3 == 2) {
                if (i2 >= n4 - 1) continue;
                d2 = (d2 + dArray[i2 + 1]) / 2.0;
            }
            if (arrayList == null) {
                jCValueLabel = new JCValueLabel(d2, stringArray[i2]);
            } else {
                object = arrayList.get(i2);
                if (object instanceof JCValueLabel) {
                    jCValueLabel = (JCValueLabel)object;
                    jCValueLabel = (JCValueLabel)jCValueLabel.clone();
                    jCValueLabel.value = d2;
                } else {
                    jCValueLabel = new JCValueLabel(d2, object.toString());
                }
            }
            jCValueLabel.setAxis(this.axis);
            jCValueLabel.setIndex(i2);
            this.valueLabels.add(jCValueLabel);
        }
        if (this.axis.isCombineLabels()) {
            String string = null;
            int n7 = 0;
            int n8 = -1;
            boolean bl = false;
            object = new ArrayList();
            for (int i3 = 0; i3 < this.valueLabels.size(); ++i3) {
                JCValueLabel jCValueLabel = this.valueLabels.get(i3);
                if (string != null && jCValueLabel.getLabel() == string) {
                    if (!bl) {
                        n8 = i3 - 1;
                        n7 = 1;
                        object.remove(object.size() - 1);
                        bl = true;
                    }
                    ++n7;
                    if (i3 < this.valueLabels.size() - 1) continue;
                }
                if (bl) {
                    int n9;
                    boolean bl2 = !(n7 & true);
                    JCValueLabel jCValueLabel2 = null;
                    double d3 = 0.0;
                    for (n9 = n8; n9 < n8 + n7; ++n9) {
                        jCValueLabel2 = this.valueLabels.get(n9);
                        d3 += jCValueLabel2.getValue();
                        jCValueLabel2.allowUpdates = false;
                        if (!bl2 && n9 == n8 + n7 / 2) {
                            jCValueLabel2.setLabelDrawn(true);
                            jCValueLabel2.setIndex(n8);
                        } else {
                            jCValueLabel2.setLabelDrawn(false);
                        }
                        jCValueLabel2.allowUpdates = true;
                        object.add(jCValueLabel2);
                    }
                    if (bl2 && jCValueLabel2 != null) {
                        JCValueLabel jCValueLabel3 = (JCValueLabel)jCValueLabel2.clone();
                        jCValueLabel3.value = d3 / (double)n7;
                        jCValueLabel3.labelDrawn = true;
                        jCValueLabel3.tickDrawn = false;
                        jCValueLabel3.minorTick = false;
                        jCValueLabel3.index = n8;
                        object.add(jCValueLabel3);
                    }
                    bl = false;
                    if (n9 == this.valueLabels.size()) break;
                }
                object.add(jCValueLabel);
                string = jCValueLabel.getLabel();
            }
            Collections.sort(object, this);
            this.valueLabels = object;
        }
    }

    protected JCValueLabel getLabelFromValue(double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = JCChart3dUtil.format(d2, this.axis.getNFrac());
        JCChart3dNumberFormat jCChart3dNumberFormat = this.axis.getNumberFormatter();
        String string2 = jCChart3dNumberFormat.localize(string);
        JCValueLabel jCValueLabel = new JCValueLabel(d2, string2, bl, bl2, bl3);
        jCValueLabel.setAxis(this.axis);
        jCValueLabel.allowUpdates = false;
        JCLabelGenerator jCLabelGenerator = this.axis.getLabelGenerator();
        if (bl4 && jCLabelGenerator != null) {
            jCLabelGenerator.makeLabel(jCValueLabel);
            jCValueLabel.setValue(d2);
        }
        jCValueLabel.allowUpdates = true;
        return jCValueLabel;
    }

    private void makeValues(Anno anno) {
        double d2;
        this.valueLabels = new ArrayList<JCValueLabel>();
        if (anno == null) {
            return;
        }
        double d3 = this.axis.getAnnoMin();
        double d4 = this.axis.getAnnoMax();
        double d5 = this.axis.getAnnoStep();
        double d6 = d5 / 2.0;
        double d7 = d2 = d6 * JCChart3dUtil.ceil(d3 / d6);
        double d8 = d5 * JCChart3dUtil.ceil(d3 / d5);
        boolean bl = d8 - d7 > d6 / 2.0;
        int n2 = (int)(JCChart3dUtil.floor(d4 / d6) - d7 / d6 + 0.5);
        for (int i2 = 0; i2 <= n2; ++i2) {
            double d9 = d7 == -0.0 ? 0.0 : d7;
            JCValueLabel jCValueLabel = bl ? this.getLabelFromValue(d9, false, true, true, true) : this.getLabelFromValue(d9, true, true, false, true);
            jCValueLabel.setIndex(i2);
            this.valueLabels.add(jCValueLabel);
            d7 = d2 + (double)(i2 + 1) * d6;
            bl = !bl;
        }
    }
}

