/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.property.xml;

import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCChartEnumMappings;
import com.klg.jclass.chart.JCEnvelope;
import com.klg.jclass.chart.JCGrid;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.XMLDataHandler;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.property.PropertyAccessModel;
import com.klg.jclass.util.property.xml.LocalizedPropertyHandler;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ChartHandler
extends LocalizedPropertyHandler {
    protected XMLDataHandler dataHandler = null;
    protected BaseDataSource baseDS = null;
    protected PropertyAccessModel pam = null;
    protected StringBuffer sb = null;
    protected String prefix = null;
    protected boolean inData = false;
    protected boolean inExternalCode = false;
    protected boolean inAxis = false;
    protected boolean inPie = false;
    protected boolean inBorder = false;
    protected boolean inTitledBorder = false;
    protected boolean inCompoundBorder = false;
    protected Stack<CompoundBorder> compoundBorderStack = null;
    protected Border savedBorder = null;
    protected boolean inGrid = false;
    protected Color color = null;
    protected Insets insets = null;
    protected LinkedList<String> prefixList = null;
    protected ArrayList<String> pointLabels = null;
    protected ArrayList<JCValueLabel> valueLabels = null;
    protected ArrayList<String[]> seriesPoints = null;
    protected ArrayList<JCAnno> annoList = null;
    protected ArrayList<JCGrid> gridList = null;
    protected int otherSliceInfoCount = -1;
    protected int curGrid = -1;
    protected JCValueLabel curValueLabel;
    protected String curDataViewName = null;
    protected int dataViewCount = 0;
    protected int dataViewSeriesCount = 1;
    protected int chartLabelCount = 1;
    protected int dataIndexCount = 1;
    protected int dataImageMapCount = -1;
    protected int xAxisCount = 0;
    protected int yAxisCount = 0;
    protected int thresholdCount = 0;
    protected int dataThresholdCount = 0;
    protected int envelopeCount = 0;
    protected int yEnvelopeDataListCount = 0;
    protected int pointCount = 0;
    protected boolean inStartLineStyle = false;
    protected boolean inEndLineStyle = false;
    protected boolean inHoleStyle = false;
    protected int markerCount = 0;
    protected int timelineStateCount = 0;
    protected int dataRangeCount = 0;
    protected int exclusionCount = 0;
    protected boolean inChartLabel = false;
    protected boolean inMarker = false;
    protected boolean inThreshold = false;
    protected boolean inEnvelope = false;
    protected boolean inEnvelopeData = false;
    protected boolean inTimeLineState = false;
    protected int legendColumnCount = 0;
    protected int externalCodeCount = 0;
    protected String attName = null;
    protected String attValue = null;
    protected List<Double> xEnvelopeData = null;
    protected List<List<Double>> yEnvelopeData = null;
    protected JCEnvelope envelope = null;

    public ChartHandler(PropertyAccessModel propertyAccessModel) {
        this.pam = propertyAccessModel;
        this.localeHandler = propertyAccessModel.getLoadProperties().getLocaleHandler();
    }

    public BaseDataSource getDataSource() {
        return this.baseDS;
    }

    public void setDataSource(BaseDataSource baseDataSource) {
        this.baseDS = baseDataSource;
    }

    public void addPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = this.prefix + string;
    }

    public void setPrefix(String string) {
        this.prefixList.addLast(this.prefix);
        this.prefix = string;
    }

    public void popPrefix() {
        this.prefix = this.prefixList.removeLast();
    }

    public void startDocument() throws SAXException {
        this.prefixList = new LinkedList();
        this.prefix = "";
    }

    public void endDocument() throws SAXException {
        this.prefixList = null;
        this.prefix = null;
        this.attName = null;
        this.attValue = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("chart-data") || string3.equals("JCChartData")) {
            if (this.baseDS == null) {
                this.baseDS = new BaseDataSource();
            }
            this.dataHandler = new XMLDataHandler(this.baseDS, this.localeHandler);
            this.inData = true;
        }
        if (this.inData) {
            this.dataHandler.handleStartElement(string, string2, string3, attributes);
            return;
        }
        if (string3.equals("component")) {
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "font");
            this.handleAttribute(attributes, "visible");
        } else if (string3.equals("locale")) {
            this.addPrefix("locale.");
            this.handleAttribute(attributes, "language");
            this.handleAttribute(attributes, "country");
            this.handleAttribute(attributes, "variant");
        } else if (string3.equals("insets")) {
            this.handleInsets(attributes);
        } else if (string3.equals("event-trigger")) {
            this.handleTrigger(attributes);
        } else if (string3.equals("key")) {
            this.handleKey(attributes);
        } else if (string3.equals("layout-hints")) {
            this.handleAttribute(attributes, "x");
            this.handleAttribute(attributes, "y");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
        } else if (string3.equals("value-label")) {
            this.handleValueLabel(attributes);
        } else if (string3.equals("chart-style")) {
            if (this.inThreshold || this.inEnvelope || this.inTimeLineState) {
                this.attName = this.prefix + "hasChartStyle";
                this.pam.setProperty(this.attName, "true");
            }
        } else if (string3.equals("line-style")) {
            if (this.inGrid) {
                this.addPrefix("grid" + this.curGrid + ".");
            } else if (this.inAxis) {
                this.addPrefix("grid.");
            } else if (this.inStartLineStyle) {
                this.addPrefix("startLine.");
            } else if (this.inEndLineStyle) {
                this.addPrefix("endLine.");
            } else if (this.inHoleStyle) {
                this.addPrefix("hole.line.");
            } else if (this.inChartLabel) {
                this.attName = this.prefix + "hasLineStyle";
                this.pam.setProperty(this.attName, "true");
                this.addPrefix("line.");
            } else {
                this.addPrefix("line.");
            }
            this.handleAttribute(attributes, "pattern");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "join");
            this.handleAttribute(attributes, "cap");
        } else if (string3.equals("fill-style")) {
            if (!this.inPie && !this.inHoleStyle) {
                this.attName = this.prefix + "hasFillStyle";
                this.pam.setProperty(this.attName, "true");
            }
            if (this.inPie) {
                this.addPrefix("other.fill.");
            } else if (this.inHoleStyle) {
                this.addPrefix("hole.fill.");
            } else {
                this.addPrefix("fill.");
            }
            this.handleAttribute(attributes, "pattern");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "image");
            this.handleAttribute(attributes, "imageLayoutHint");
            this.handleAttribute(attributes, "fillOrientation");
            this.handleAttribute(attributes, "background");
        } else if (string3.equals("symbol-style")) {
            if (this.inHoleStyle) {
                this.addPrefix("hole.symbol.");
            } else {
                this.addPrefix("symbol.");
            }
            this.handleAttribute(attributes, "shape");
            this.handleAttribute(attributes, "color");
            this.handleAttribute(attributes, "size");
        } else if (string3.equals("chart-data-view")) {
            String string4 = this.dataViewCount == 0 ? "" : "" + this.dataViewCount;
            String string5 = "data" + string4;
            if (this.dataViewCount > 0) {
                this.attName = "dataName" + string4;
                this.pam.setProperty(this.attName, string5);
            }
            this.addPrefix(string5 + ".");
            this.handleAttribute(attributes, "chartType");
            this.handleAttribute(attributes, "inverted");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "visibleInLegend");
            this.handleAttribute(attributes, "legendSeriesReversed");
            this.handleAttribute(attributes, "autoLabel");
            this.handleAttribute(attributes, "autoLabelType");
            this.handleAttribute(attributes, "fastUpdate");
            this.handleAttribute(attributes, "drawFrontPlane");
            this.handleAttribute(attributes, "holeValue");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "xaxis");
            this.handleAttribute(attributes, "yaxis");
            this.handleAttribute(attributes, "yaxisDataMinHint");
            this.handleAttribute(attributes, "yaxisDataMaxHint");
            ++this.dataViewCount;
            this.dataViewSeriesCount = 1;
            this.thresholdCount = 0;
            this.markerCount = 0;
            this.envelopeCount = 0;
            this.timelineStateCount = 0;
        } else if (string3.equals("chart-data-view-series")) {
            this.addPrefix("series" + this.dataViewSeriesCount + ".");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "visibleInLegend");
            this.handleAttribute(attributes, "included");
            this.handleAttribute(attributes, "firstPoint");
            this.handleAttribute(attributes, "lastPoint");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "trackLabel");
            ++this.dataViewSeriesCount;
            this.dataThresholdCount = 0;
        } else if (string3.equals("chart-data-threshold")) {
            this.inThreshold = true;
            this.addPrefix("data-threshold" + this.dataThresholdCount + ".");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "includedInDataBounds");
            this.handleAttribute(attributes, "visibleInLegend");
            ++this.dataThresholdCount;
        } else if (string3.equals("chart-label")) {
            String string6;
            this.inChartLabel = true;
            if (this.inMarker) {
                this.attName = this.prefix + "hasChartLabel";
                this.pam.setProperty(this.attName, "true");
                string6 = "chartLabel";
            } else {
                string6 = "label" + this.chartLabelCount;
                this.attName = "labelName" + this.chartLabelCount;
                this.pam.setProperty(this.attName, string6);
            }
            this.addPrefix(string6 + ".");
            if (!this.inMarker) {
                this.handleDataViewName(attributes, false);
            }
            this.handleAttribute(attributes, "anchor");
            this.handleAttribute(attributes, "attachMethod");
            this.handleAttribute(attributes, "dataIndexMode");
            this.handleAttribute(attributes, "connected");
            this.handleAttribute(attributes, "connectedAttachMode");
            this.handleAttribute(attributes, "dwellLabel");
        } else if (string3.equals("threshold")) {
            this.inThreshold = true;
            this.addPrefix("threshold" + this.thresholdCount + ".");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "startValue");
            this.handleAttribute(attributes, "endValue");
            this.handleAttribute(attributes, "associatedWithYAxis");
            this.handleAttribute(attributes, "includedInDataBounds");
            this.handleAttribute(attributes, "visibleInLegend");
            this.handleAttribute(attributes, "limitType");
            ++this.thresholdCount;
        } else if (string3.equals("start-limit") || string3.equals("end-limit")) {
            this.addPrefix(string3 + ".");
            this.pointCount = 0;
        } else if (string3.equals("start-line-style")) {
            this.inStartLineStyle = true;
            this.attName = this.prefix + "hasStartLineStyle";
            this.pam.setProperty(this.attName, "true");
        } else if (string3.equals("end-line-style")) {
            this.inEndLineStyle = true;
            this.attName = this.prefix + "hasEndLineStyle";
            this.pam.setProperty(this.attName, "true");
        } else if (string3.equals("hole-style")) {
            this.inHoleStyle = true;
            this.attName = this.prefix + "hasHoleStyle";
            this.pam.setProperty(this.attName, "true");
        } else if (string3.equals("marker")) {
            this.inMarker = true;
            this.addPrefix("marker" + this.markerCount + ".");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "value");
            this.handleAttribute(attributes, "startPoint");
            this.handleAttribute(attributes, "endPoint");
            this.handleAttribute(attributes, "associatedWithYAxis");
            this.handleAttribute(attributes, "includedInDataBounds");
            this.handleAttribute(attributes, "drawnBeforeData");
            this.handleAttribute(attributes, "visibleInLegend");
            ++this.markerCount;
        } else if (string3.equals("envelope")) {
            this.inEnvelope = true;
            this.addPrefix("envelope" + this.envelopeCount + ".");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "includedInDataBounds");
            this.handleAttribute(attributes, "visibleInLegend");
            this.handleAttribute(attributes, "drawnWithData");
            ++this.envelopeCount;
        } else if (string3.equals("envelope-data")) {
            this.inEnvelopeData = true;
            this.yEnvelopeData = new ArrayList<List<Double>>(2);
            this.addPrefix("envelope-data.");
        } else if (string3.equals("x-data-list")) {
            this.xEnvelopeData = new ArrayList<Double>();
        } else if (string3.equals("y-data-list")) {
            this.yEnvelopeData.add(new ArrayList());
        } else if (string3.equals("timeline-state")) {
            this.inTimeLineState = true;
            this.addPrefix("timeline-state" + this.timelineStateCount + ".");
            this.handleAttribute(attributes, "label");
            this.handleAttribute(attributes, "clearState");
            this.handleAttribute(attributes, "visibleInLegend");
            ++this.timelineStateCount;
            this.dataRangeCount = 0;
        } else if (string3.equals("data-range")) {
            this.addPrefix("data-range" + this.dataRangeCount + ".");
            this.handleAttribute(attributes, "min");
            this.handleAttribute(attributes, "max");
            this.handleAttribute(attributes, "minValueIncluded");
            this.handleAttribute(attributes, "maxValueIncluded");
            ++this.dataRangeCount;
        } else if (string3.equals("label")) {
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
        } else if (string3.equals("coord")) {
            this.handleAttributesPoint(attributes, string3);
        } else if (string3.equals("offset")) {
            this.handleAttributesPoint(attributes, string3);
        } else if (string3.equals("data-coord")) {
            if (this.inThreshold) {
                this.addPrefix("data-coord" + this.pointCount + ".");
                ++this.pointCount;
            }
            this.handleAttributesPoint(attributes, string3);
        } else if (string3.equals("data-index")) {
            String string7 = "attachIndex" + this.dataIndexCount;
            this.attName = this.prefix + "dataIndex";
            this.pam.setProperty(this.attName, string7);
            this.attName = "indexName" + this.dataIndexCount;
            this.pam.setProperty(this.attName, string7);
            this.setPrefix(string7 + ".");
            this.handleDataViewName(attributes, true);
            this.handleAttribute(attributes, "point");
            this.handleAttribute(attributes, "series", "seriesIndex");
            ++this.dataIndexCount;
        } else if (string3.equals("chart-data-file")) {
            this.handleDataFile(attributes);
        } else if (string3.equals("image-file")) {
            this.addPrefix("image.");
            this.handleAttribute(attributes, "fileName");
            this.handleAttribute(attributes, "fileAccess");
        } else if (string3.equals("image-position")) {
            this.addPrefix("imagePosition.");
            this.handleAttribute(attributes, "x");
            this.handleAttribute(attributes, "y");
        } else if (string3.equals("chart")) {
            this.handleAttribute(attributes, "allowUserChanges");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "height");
            this.handleAttribute(attributes, "antiAliasing");
            this.handleAttribute(attributes, "chartLayout");
            this.handleAttribute(attributes, "pickItemType");
            this.handleAttribute(attributes, "pickItemMode");
        } else if (string3.equals("header")) {
            this.addPrefix("header.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
        } else if (string3.equals("footer")) {
            this.addPrefix("footer.");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "horizontalAlignment");
            this.handleAttribute(attributes, "verticalAlignment");
            this.handleAttribute(attributes, "horizontalTextPosition");
            this.handleAttribute(attributes, "verticalTextPosition");
        } else if (string3.equals("legend")) {
            this.addPrefix("legend.");
            this.handleAttribute(attributes, "type");
            this.handleAttribute(attributes, "anchor");
            this.handleAttribute(attributes, "orientation");
            this.handleAttribute(attributes, "itemTextToolTipEnabled");
            this.handleAttribute(attributes, "useEllipsisWhenTruncating");
            this.handleAttribute(attributes, "itemRenderMode");
            this.handleAttribute(attributes, "symbolRenderMode");
        } else if (string3.equals("multi-col")) {
            this.handleAttribute(attributes, "numRows");
            this.handleAttribute(attributes, "numColumns");
        } else if (string3.equals("legend-column")) {
            this.addPrefix("legendColumn" + this.legendColumnCount + ".");
            this.handleAttribute(attributes, "column");
            this.handleAttribute(attributes, "maxItemTextWidth");
            this.handleAttribute(attributes, "itemTextAlignment");
            this.handleAttribute(attributes, "truncateMode");
            ++this.legendColumnCount;
        } else if (string3.equals("chart-area")) {
            this.addPrefix("chartArea.");
            this.handleAttribute(attributes, "axisBoundingBox");
            this.handleAttribute(attributes, "fillOverAxisBoundingBox");
            this.handleAttribute(attributes, "depth");
            this.handleAttribute(attributes, "elevation");
            this.handleAttribute(attributes, "rotation");
            this.handleAttribute(attributes, "angleUnit");
            this.handleAttribute(attributes, "fastAction");
            this.handleAttribute(attributes, "horizActionAxis");
            this.handleAttribute(attributes, "vertActionAxis");
        } else if (string3.equals("plot-area")) {
            this.addPrefix("plotArea.");
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "opaque");
            this.handleAttribute(attributes, "left");
            this.handleAttribute(attributes, "right");
            this.handleAttribute(attributes, "top");
            this.handleAttribute(attributes, "bottom");
        } else if (string3.equals("chart-interior-region")) {
            this.handleAttribute(attributes, "background");
            this.handleAttribute(attributes, "foreground");
            this.handleAttribute(attributes, "font");
            this.handleAttribute(attributes, "groupingUsed");
            this.handleAttribute(attributes, "numberLocalization");
            this.handleAttribute(attributes, "visible");
            this.handleAttribute(attributes, "left");
            this.handleAttribute(attributes, "width");
            this.handleAttribute(attributes, "top");
            this.handleAttribute(attributes, "height");
        } else if (string3.equals("axis-formula")) {
            this.addPrefix("formula.");
            this.handleAttribute(attributes, "multiplier");
            this.handleAttribute(attributes, "constant");
            this.handleAttribute(attributes, "originator");
        } else if (string3.equals("axis-title")) {
            this.addPrefix("title.");
            this.handleAttribute(attributes, "placement");
            this.handleAttribute(attributes, "text");
            this.handleAttribute(attributes, "rotation");
            this.handleAttribute(attributes, "adjust");
        } else if (string3.equals("axis")) {
            int n2;
            this.inAxis = true;
            this.curGrid = -1;
            int n3 = attributes.getIndex("type");
            String string8 = null;
            if (n3 > -1) {
                string8 = attributes.getValue(n3);
            }
            if (string8.equals("XAxis")) {
                int n4 = this.xAxisCount;
                n2 = n4;
                this.xAxisCount = n4 + 1;
            } else {
                int n5 = this.yAxisCount;
                n2 = n5;
                this.yAxisCount = n5 + 1;
            }
            n3 = n2;
            String string9 = n3 == 0 ? "" : "" + n3;
            string8 = string8.toLowerCase();
            if (n3 > 0) {
                this.attName = this.prefix + string8 + "Name" + string9;
                this.attValue = string8 + string9;
                this.pam.setPropertyObject(this.attName, this.attValue);
            }
            this.exclusionCount = 0;
            this.setPrefix(string8 + string9 + ".");
            this.handleAttribute(attributes, "name");
            this.handleAttribute(attributes, "vertical");
            this.handleAttribute(attributes, "logarithmic");
            this.handleAttribute(attributes, "reversed");
            this.handleAttribute(attributes, "editable");
            this.handleAttribute(attributes, "dropOverlappingLabels");
            this.handleAttribute(attributes, "dropTicksForHiddenLabels");
            this.handleAttribute(attributes, "annotationRotation");
            this.handleAttribute(attributes, "annotationRotationAngle");
            this.handleAttribute(attributes, "annotationMethod");
            this.handleAttribute(attributes, "annotationVisible");
            this.handleAttribute(attributes, "annotateToRange");
            this.handleAttribute(attributes, "placement");
            this.handleAttribute(attributes, "placementAxis");
            this.handleAttribute(attributes, "placementLocation");
            this.handleAttribute(attributes, "gap");
            this.handleAttribute(attributes, "timeBase");
            this.handleAttribute(attributes, "timeUnit");
            this.handleAttribute(attributes, "timeFormat");
            this.handleAttribute(attributes, "timeZone");
            this.handleAttribute(attributes, "skipWeekends");
            this.handleAttribute(attributes, "min");
            this.handleAttribute(attributes, "max");
            this.handleAttribute(attributes, "usePrecisionCalculatedBoundsForInvisibleAxis");
            this.handleAttribute(attributes, "showGridLinesOnInvisibleAxis");
            this.handleAttribute(attributes, "precision");
            this.handleAttribute(attributes, "tickSpacing");
            this.handleAttribute(attributes, "numSpacing");
            this.handleAttribute(attributes, "origin");
            this.handleAttribute(attributes, "originPlacement");
            this.handleAttribute(attributes, "gridVisible", "grid.Visible");
            this.handleAttribute(attributes, "gridDefault", "grid.Default");
            this.handleAttribute(attributes, "gridSpacing", "grid.Spacing");
            this.handleAttribute(attributes, "useDefaultLabels");
            this.handleAttribute(attributes, "useDefaultTicks");
            this.handleAttribute(attributes, "useAnnoTicks");
            this.handleAttribute(attributes, "useDefaultGrid");
        } else if (string3.equals("anno")) {
            if (this.annoList == null) {
                this.annoList = new ArrayList();
            }
            this.handleAnnotation(attributes);
        } else if (string3.equals("grid")) {
            ++this.curGrid;
            this.inGrid = true;
            if (this.gridList == null) {
                this.gridList = new ArrayList();
            }
            this.handleGrid(attributes);
        } else if (string3.equals("time-exclusion")) {
            this.addPrefix("time-exclusion" + this.exclusionCount + ".");
            this.handleAttribute(attributes, "startTime");
            this.handleAttribute(attributes, "stopTime");
            this.handleAttribute(attributes, "startTimeOmitted");
            this.handleAttribute(attributes, "stopTimeOmitted");
            this.handleAttribute(attributes, "recurrencePattern");
            this.handleAttribute(attributes, "active");
            ++this.exclusionCount;
        } else if (string3.equals("plot-format")) {
            this.addPrefix("Plot.");
            this.handleAttribute(attributes, "generalPathPlotUsed");
        } else if (string3.equals("area-format")) {
            this.addPrefix("Area.");
            this.handleAttribute(attributes, "percent100", "100percent");
            this.handleAttribute(attributes, "outlineStyle");
            this.handleAttribute(attributes, "holeInterpretation");
            this.handleAttribute(attributes, "connectedAcrossOrigin");
        } else if (string3.equals("bar-format")) {
            this.addPrefix("Bar.");
            this.handleAttribute(attributes, "percent100", "100percent");
            this.handleAttribute(attributes, "clusterWidth");
            this.handleAttribute(attributes, "clusterOverlap");
            this.handleAttribute(attributes, "outlineStyle");
        } else if (string3.equals("candle-format")) {
            this.addPrefix("Candle.");
            this.handleAttribute(attributes, "complex");
            this.handleAttribute(attributes, "candleWidthMode");
            this.handleAttribute(attributes, "percentageWidth");
        } else if (string3.equals("hi-lo-open-close-format")) {
            this.addPrefix("HLOC.");
            this.handleAttribute(attributes, "showingOpen");
            this.handleAttribute(attributes, "showingClosed", "showingClose");
            this.handleAttribute(attributes, "showingClose");
            this.handleAttribute(attributes, "openCloseFullWidth");
            this.handleAttribute(attributes, "openCloseWidthMode");
            this.handleAttribute(attributes, "percentageWidth");
        } else if (string3.equals("pie-format")) {
            this.inPie = true;
            this.addPrefix("Pie.");
            this.handleAttribute(attributes, "minSlices");
            this.handleAttribute(attributes, "explodeOffset");
            this.handleAttribute(attributes, "thresholdMethod");
            this.handleAttribute(attributes, "thresholdValue");
            this.handleAttribute(attributes, "sortOrder");
            this.handleAttribute(attributes, "startAngle");
            this.handleAttribute(attributes, "outlineStyle");
            this.handleAttribute(attributes, "otherLabel", "other.label");
        } else if (string3.equals("series-point")) {
            if (this.seriesPoints == null) {
                this.seriesPoints = new ArrayList();
            }
            this.handleSeriesPoint(attributes);
        } else if (string3.equals("polar-radar-format")) {
            this.addPrefix("PolarRadar.");
            this.handleAttribute(attributes, "yAxisAngle");
            this.handleAttribute(attributes, "originBase");
            this.handleAttribute(attributes, "radarCircularGrid");
            this.handleAttribute(attributes, "halfRange");
            this.handleAttribute(attributes, "outlineStyle");
        } else if (string3.equals("timeline-format")) {
            this.addPrefix("Timeline.");
            this.handleAttribute(attributes, "barHeightMode");
            this.handleAttribute(attributes, "displaySeriesLabel");
            this.handleAttribute(attributes, "displayDataLabel");
            this.handleAttribute(attributes, "displayStateLabel");
            this.handleAttribute(attributes, "labelInset");
            this.handleAttribute(attributes, "labelThreshold");
            this.handleAttribute(attributes, "maxSymbolLabelWidth");
            this.handleAttribute(attributes, "maxTrackHeight");
            this.handleAttribute(attributes, "mergeTracks");
            this.handleAttribute(attributes, "percentageHeight");
            this.handleAttribute(attributes, "trackPosition");
            this.handleAttribute(attributes, "truncateLabels");
            this.handleAttribute(attributes, "truncateMode");
            this.handleAttribute(attributes, "useEllipsisWhenTruncating");
            this.handleAttribute(attributes, "layoutType");
            this.handleAttribute(attributes, "ascendingTracks");
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, attributes, true);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(true);
        } else if (string3.equals("image-map-info")) {
            String string10 = "imageMapInfo";
            if (this.inPie) {
                string10 = "otherSliceImageMapInfo";
                String string11 = "Legend";
                if (this.otherSliceInfoCount >= 0) {
                    string11 = this.otherSliceInfoCount == 0 ? "" : "" + this.otherSliceInfoCount;
                    ++this.otherSliceInfoCount;
                }
                string10 = string10 + string11;
            }
            this.addPrefix(string10 + ".");
            this.handleAttribute(attributes, "url");
            this.handleAttribute(attributes, "extra");
        } else if (string3.equals("legend-image-map-info")) {
            this.addPrefix("legendImageMapInfo.");
            this.handleAttribute(attributes, "url");
            this.handleAttribute(attributes, "extra");
        } else if (string3.equals("other-slice-image-map-info-list")) {
            this.otherSliceInfoCount = 0;
        } else if (string3.equals("data-image-map")) {
            String string12 = this.dataImageMapCount == 0 ? "" : "" + this.dataImageMapCount;
            String string13 = "dataImageMap" + string12;
            this.attName = "dataImageMapName" + string12;
            this.attValue = string13;
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix(string13 + ".");
            this.handleAttribute(attributes, "mapType");
            this.handleAttribute(attributes, "mapMethod");
            this.handleAttribute(attributes, "plotRadius");
            this.handleDataViewName(attributes, false);
        } else if (string3.equals("data-image-map-list")) {
            this.dataImageMapCount = 0;
        } else if (string3.equals("legend-image-map")) {
            this.attName = "legendImageMapName";
            this.attValue = "legendImageMap";
            this.pam.setProperty(this.attName, this.attValue);
            this.addPrefix("legendImageMap.");
            this.handleDataViewName(attributes, false);
            this.handleAttribute(attributes, "none");
        } else if (string3.equals("external-java-code")) {
            this.addPrefix("externalJavaCode" + this.externalCodeCount + ".");
            this.handleAttribute(attributes, "class");
            this.inExternalCode = true;
            ++this.externalCodeCount;
        } else if (string3.equals("gradient")) {
            this.addPrefix("gradient.");
            this.handleAttribute(attributes, "color2");
            this.handleAttribute(attributes, "ribbonSize");
            this.handleAttribute(attributes, "style");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = string4 = this.sb == null ? null : this.sb.toString();
        if (this.inData) {
            this.dataHandler.handleEndElement(string, string2, string3);
            if (string3.equals("chart-data") || string3.equals("JCChartData")) {
                String string6 = this.prefix.substring(0, this.prefix.lastIndexOf("."));
                this.pam.setPropertyObject(string6, this.baseDS);
                this.baseDS = null;
                this.dataHandler = null;
                this.inData = false;
            }
            return;
        }
        if (string3.equals("point-label")) {
            if (this.pointLabels == null) {
                this.pointLabels = new ArrayList();
            }
            this.pointLabels.add(this.sb == null ? "" : this.sb.toString());
        } else if (string3.equals("value-label")) {
            if (this.valueLabels == null) {
                this.valueLabels = new ArrayList();
            }
            String string7 = this.sb == null ? "" : this.sb.toString().trim();
            this.curValueLabel.setText(string7);
            this.valueLabels.add(this.curValueLabel);
            this.curValueLabel = null;
        } else if (string3.equals("axis")) {
            this.handleValueLabels();
            this.handleGrids();
            this.handleAnnotations();
            if (this.exclusionCount > 0) {
                this.attName = this.prefix + "numExclusions";
                this.attValue = "" + this.exclusionCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.popPrefix();
            this.inAxis = false;
            this.curGrid = -1;
        } else if (string3.equals("grid")) {
            this.inGrid = false;
        } else if (string3.equals("chart-data-view")) {
            this.attName = this.prefix + "lastSeriesIndex";
            this.attValue = "" + (this.dataViewSeriesCount - 1);
            this.pam.setProperty(this.attName, this.attValue);
            if (this.thresholdCount > 0) {
                this.attName = this.prefix + "numThresholds";
                this.attValue = "" + this.thresholdCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            if (this.markerCount > 0) {
                this.attName = this.prefix + "numMarkers";
                this.attValue = "" + this.markerCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            if (this.envelopeCount > 0) {
                this.attName = this.prefix + "numEnvelopes";
                this.attValue = "" + this.envelopeCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            if (this.timelineStateCount > 0) {
                this.attName = this.prefix + "numTimeLineStates";
                this.attValue = "" + this.timelineStateCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.handlePointLabels();
            this.popPrefix();
        } else if (string3.equals("chart-data-view-series")) {
            if (this.dataThresholdCount > 0) {
                this.attName = this.prefix + "numThresholds";
                this.attValue = "" + this.dataThresholdCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.popPrefix();
        } else if (string3.equals("pie-format")) {
            this.popPrefix();
            this.inPie = false;
        } else if (string3.equals("explode-list")) {
            this.handleExplodeList();
        } else if (string3.equals("chart-label")) {
            this.popPrefix();
            ++this.chartLabelCount;
            this.inChartLabel = false;
        } else if (string3.equals("chart")) {
            this.attValue = "" + (this.chartLabelCount - 1);
            this.pam.setProperty("lastLabelIndex", this.attValue);
            this.attValue = "" + (this.externalCodeCount - 1);
            this.pam.setProperty("lastExternalJavaCodeIndex", this.attValue);
            this.resolveAxisNames();
        } else if (string3.equals("external-java-code")) {
            this.pam.setProperty(this.prefix + "userData", this.sb == null ? "" : this.sb.toString().trim());
            this.inExternalCode = false;
            this.popPrefix();
        } else if (string3.equals("empty-border") || string3.equals("bevel-border") || string3.equals("etched-border") || string3.equals("line-border") || string3.equals("matte-border") || string3.equals("titled-border")) {
            this.handleBorder(string3, null, false);
        } else if (string3.equals("compound-border")) {
            this.handleCompoundBorder(false);
        } else if (string3.equals("data-image-map") || string3.equals("legend-image-map")) {
            if (this.seriesPoints != null) {
                this.attName = this.prefix + "seriesPoint";
                this.pam.setPropertyObject(this.attName, this.seriesPoints);
                this.seriesPoints = null;
            }
            if (string3.equals("data-image-map")) {
                ++this.dataImageMapCount;
            }
            this.popPrefix();
        } else if (string3.equals("data-image-map-list")) {
            this.attName = this.prefix + "dataImageMapCount";
            this.pam.setProperty(this.attName, "" + this.dataImageMapCount);
            this.dataImageMapCount = -1;
        } else if (string3.equals("other-slice-image-map-info-list")) {
            this.attName = this.prefix + "otherSliceImageMapInfoCount";
            this.pam.setProperty(this.attName, "" + this.otherSliceInfoCount);
            this.otherSliceInfoCount = -1;
        } else if (string3.equals("start-line-style") || string3.equals("end-line-style")) {
            this.inEndLineStyle = false;
            this.inStartLineStyle = false;
        } else if (string3.equals("hole-style")) {
            this.inHoleStyle = false;
        } else if (string3.equals("threshold") || string3.equals("chart-data-threshold")) {
            this.inThreshold = false;
            this.popPrefix();
        } else if (string3.equals("start-limit") || string3.equals("end-limit")) {
            if (this.pointCount > 0) {
                this.attName = this.prefix + "numPoints";
                this.attValue = "" + this.pointCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.popPrefix();
        } else if (string3.equals("data-coord")) {
            if (this.inThreshold) {
                this.popPrefix();
            }
        } else if (string3.equals("marker")) {
            this.inMarker = false;
            this.popPrefix();
        } else if (string3.equals("x-data")) {
            if (this.inEnvelopeData) {
                Double d2 = this.getNextDouble(string4);
                this.xEnvelopeData.add(d2);
            }
        } else if (string3.equals("y-data")) {
            if (this.inEnvelopeData) {
                Double d3 = this.getNextDouble(string4);
                this.yEnvelopeData.get(this.yEnvelopeDataListCount).add(d3);
            }
        } else if (string3.equals("x-data-list")) {
            this.attName = this.prefix + "x-data-list";
            this.pam.setPropertyObject(this.attName, this.xEnvelopeData);
        } else if (string3.equals("y-data-list")) {
            this.attName = this.prefix + "y-data-list" + this.yEnvelopeDataListCount;
            this.pam.setPropertyObject(this.attName, this.yEnvelopeData.get(this.yEnvelopeDataListCount));
            ++this.yEnvelopeDataListCount;
        } else if (string3.equals("envelope-data")) {
            this.inEnvelopeData = false;
            this.popPrefix();
        } else if (string3.equals("envelope")) {
            this.inEnvelope = false;
            this.xEnvelopeData = null;
            this.yEnvelopeData.clear();
            this.yEnvelopeDataListCount = 0;
            this.yEnvelopeData = null;
            this.popPrefix();
        } else if (string3.equals("timeline-state")) {
            if (this.dataRangeCount > 0) {
                this.attName = this.prefix + "numDataRanges";
                this.attValue = "" + this.dataRangeCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.inTimeLineState = false;
            this.popPrefix();
        } else if (string3.equals("legend")) {
            if (this.legendColumnCount > 0) {
                this.attName = this.prefix + "numLegendColumns";
                this.attValue = "" + this.legendColumnCount;
                this.pam.setProperty(this.attName, this.attValue);
            }
            this.popPrefix();
        } else if (string3.equals("line-style") || string3.equals("fill-style") || string3.equals("symbol-style") || string3.equals("image-file") || string3.equals("data-index") || string3.equals("header") || string3.equals("footer") || string3.equals("chart-area") || string3.equals("axis-title") || string3.equals("axis-formula") || string3.equals("plot-format") || string3.equals("area-format") || string3.equals("bar-format") || string3.equals("candle-format") || string3.equals("hi-lo-open-close-format") || string3.equals("pie-format") || string3.equals("polar-radar-format") || string3.equals("timeline-format") || string3.equals("plot-area") || string3.equals("image-map-info") || string3.equals("legend-image-map-info") || string3.equals("threshold") || string3.equals("legend-column") || string3.equals("locale") || string3.equals("image-position") || string3.equals("gradient") || string3.equals("data-range") || string3.equals("time-exclusion")) {
            this.popPrefix();
        }
        this.sb = null;
    }

    protected Double getNextDouble(String string) throws SAXException {
        Double d2;
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            d2 = new Double(this.baseDS.getHoleValue());
        } else if (string.equalsIgnoreCase("MAX")) {
            d2 = new Double(Double.MAX_VALUE);
        } else if (string.equalsIgnoreCase("MIN")) {
            d2 = new Double(Double.MIN_VALUE);
        } else if (string.equalsIgnoreCase("INFINITY")) {
            d2 = new Double(Double.POSITIVE_INFINITY);
        } else {
            try {
                d2 = Double.valueOf(string);
            }
            catch (Exception exception) {
                throw new SAXException("Error in data file format");
            }
            if (d2 == null) {
                d2 = new Double(0.0);
            }
        }
        return d2;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.inData) {
            this.dataHandler.handleCharacters(cArray, n2, n3);
            return;
        }
        String string = new String(cArray, n2, n3);
        string = this.localizeString(string);
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected void handleAttribute(Attributes attributes, String string) {
        this.handleAttribute(attributes, string, string);
    }

    protected void handleAttribute(Attributes attributes, String string, String string2) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = attributes.getIndex(string);
        if (n2 > -1) {
            this.attName = this.prefix + string2;
            this.attValue = this.localizeString(attributes.getValue(n2));
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handleTrigger(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("trigger");
        if (n2 > -1) {
            string = this.prefix + attributes.getValue(n2) + "Trigger";
        }
        if (string == null) {
            return;
        }
        n2 = attributes.getIndex("modifier");
        if (n2 > -1) {
            this.attValue = attributes.getValue(n2);
            this.pam.setProperty(string, this.attValue);
        }
    }

    protected void handleKey(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("type");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        if (string == null) {
            return;
        }
        n2 = attributes.getIndex("keyValue");
        if (n2 > -1) {
            this.attValue = attributes.getValue(n2);
            this.pam.setProperty(string, attributes.getValue(n2));
        }
    }

    protected void handleDataFile(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("fileName");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        if (string == null) {
            return;
        }
        this.attValue = string;
        String string2 = this.prefix.substring(0, this.prefix.lastIndexOf("."));
        this.attName = string2 + "File";
        this.pam.setProperty(this.attName, this.attValue);
        n2 = attributes.getIndex("fileType");
        if (n2 > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = string2 + "FileType";
            this.pam.setProperty(this.attName, this.attValue);
        }
        if ((n2 = attributes.getIndex("fileAccess")) > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = string2 + "FileAccess";
            this.pam.setProperty(this.attName, this.attValue);
        }
        if ((n2 = attributes.getIndex("fileCharset")) > -1) {
            this.attValue = attributes.getValue(n2);
            this.attName = string2 + "FileCharset";
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handlePointLabels() {
        if (this.pointLabels != null && this.pointLabels.size() > 0 && this.pam != null) {
            this.pam.setPropertyObject(this.prefix + "pointLabels", this.pointLabels);
        }
        this.pointLabels = null;
    }

    protected void handleValueLabel(Attributes attributes) {
        double d2 = 0.0;
        int n2 = attributes.getIndex("value");
        if (n2 > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), d2);
        }
        this.curValueLabel = new JCValueLabel(d2, null);
        String string = null;
        n2 = attributes.getIndex("imageMapURL");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        String string2 = null;
        n2 = attributes.getIndex("imageMapExtra");
        if (n2 > -1) {
            string2 = attributes.getValue(n2);
        }
        if (string != null || string2 != null) {
            this.curValueLabel.setImageMapInfo(new ImageMapInfo(string, string2));
        }
    }

    public void handleValueLabels() {
        if (this.valueLabels != null && this.valueLabels.size() > 0 && this.pam != null) {
            JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.valueLabels.size()];
            for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
                jCValueLabelArray[i2] = this.valueLabels.get(i2);
            }
            this.pam.setPropertyObject(this.prefix + "valueLabels", jCValueLabelArray);
        }
        this.valueLabels = null;
    }

    protected void handleBorder(String string, Attributes attributes, boolean bl) {
        if (string == null || bl && attributes == null || this.pam == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (string.equals("titled-border")) {
            bl2 = true;
        } else if (string.equals("bevel-border")) {
            bl3 = true;
        } else if (string.equals("etched-border")) {
            bl4 = true;
        } else if (string.equals("line-border")) {
            bl5 = true;
        } else if (string.equals("matte-border")) {
            bl6 = true;
        } else if (string.equals("empty-border")) {
            bl7 = true;
        }
        Border border = null;
        if (bl) {
            if (bl2) {
                this.inTitledBorder = true;
            } else {
                this.inBorder = true;
            }
            if (bl3 || bl4) {
                Object object;
                int n2 = bl3 ? 1 : 1;
                int n3 = attributes.getIndex("type");
                if (n3 > -1) {
                    object = attributes.getValue(n3);
                    n2 = ((String)object).equalsIgnoreCase("raised") ? (bl3 ? 0 : 0) : (bl3 ? 1 : 1);
                }
                object = null;
                n3 = attributes.getIndex("highlightColor");
                if (n3 > -1) {
                    object = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                Color color = null;
                n3 = attributes.getIndex("shadowColor");
                if (n3 > -1) {
                    color = JCSwingTypeConverter.toColor(attributes.getValue(n3));
                }
                if (bl3) {
                    boolean bl8 = false;
                    n3 = attributes.getIndex("soft");
                    if (n3 > -1) {
                        bl8 = JCTypeConverter.toBoolean(attributes.getValue(n3), false);
                    }
                    border = object != null && color != null ? (bl8 ? new SoftBevelBorder(n2, (Color)object, color) : new BevelBorder(n2, (Color)object, color)) : (bl8 ? new SoftBevelBorder(n2) : new BevelBorder(n2));
                } else {
                    border = new EtchedBorder(n2, (Color)object, color);
                }
            } else if (bl5) {
                int n4 = attributes.getIndex("color");
                if (n4 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n4), Color.black);
                }
                int n5 = 1;
                n4 = attributes.getIndex("thickness");
                if (n4 > -1) {
                    n5 = JCTypeConverter.toInt(attributes.getValue(n4), 1);
                }
                boolean bl9 = false;
                n4 = attributes.getIndex("roundedCorners");
                if (n4 > -1) {
                    bl9 = JCTypeConverter.toBoolean(attributes.getValue(n4), false);
                }
                border = new LineBorder(this.color, n5, bl9);
            } else if (bl2) {
                Object object;
                String string2 = null;
                int n6 = attributes.getIndex("title");
                if (n6 > -1) {
                    string2 = this.localizeString(attributes.getValue(n6));
                }
                int n7 = 0;
                n6 = attributes.getIndex("titlePosition");
                if (n6 > -1) {
                    n7 = JCTypeConverter.toEnum(attributes.getValue(n6), JCSwingTypeConverter.positionStrings, JCSwingTypeConverter.positionValues, n7);
                }
                int n8 = 0;
                n6 = attributes.getIndex("titleJustification");
                if (n6 > -1) {
                    object = JCSwingTypeConverter.justificationStrings;
                    int[] nArray = JCSwingTypeConverter.justificationValues;
                    n8 = JCTypeConverter.toEnum(attributes.getValue(n6), object, nArray, n8);
                }
                this.color = null;
                n6 = attributes.getIndex("color");
                if (n6 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n6));
                }
                object = null;
                n6 = attributes.getIndex("font");
                if (n6 > -1) {
                    object = JCSwingTypeConverter.toFont(attributes.getValue(n6));
                }
                this.savedBorder = new TitledBorder(null, string2, n8, n7, (Font)object, this.color);
            } else if (bl6) {
                this.color = Color.black;
                int n9 = attributes.getIndex("color");
                if (n9 > -1) {
                    this.color = JCSwingTypeConverter.toColor(attributes.getValue(n9), Color.black);
                }
            }
        } else {
            if (bl6) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = BorderFactory.createMatteBorder(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right, this.color);
            } else if (bl7) {
                if (this.insets == null) {
                    this.insets = new Insets(0, 0, 0, 0);
                }
                border = new EmptyBorder(this.insets);
            } else if (bl2) {
                border = this.savedBorder;
                this.savedBorder = null;
                this.inTitledBorder = false;
            }
            if (!bl2) {
                this.inBorder = false;
                this.insets = null;
                this.color = null;
            }
        }
        if (border != null) {
            if (this.inTitledBorder) {
                if (this.savedBorder instanceof TitledBorder) {
                    TitledBorder titledBorder = (TitledBorder)this.savedBorder;
                    titledBorder.setBorder(border);
                }
            } else if (this.inCompoundBorder) {
                this.addToCompoundBorder(border);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, border);
            }
        }
    }

    protected void handleCompoundBorder(boolean bl) {
        if (bl) {
            this.inCompoundBorder = true;
            if (this.compoundBorderStack == null) {
                this.compoundBorderStack = new Stack();
            }
            this.compoundBorderStack.push(new CompoundBorder());
        } else {
            CompoundBorder compoundBorder = this.compoundBorderStack.pop();
            if (this.compoundBorderStack.size() > 0) {
                this.addToCompoundBorder(compoundBorder);
            } else {
                this.attName = this.prefix + "border";
                this.pam.setPropertyObject(this.attName, compoundBorder);
                this.inCompoundBorder = false;
                this.compoundBorderStack = null;
            }
        }
    }

    protected void addToCompoundBorder(Border border) {
        CompoundBorder compoundBorder = this.compoundBorderStack.pop();
        CompoundBorder compoundBorder2 = compoundBorder.getOutsideBorder() == null ? new CompoundBorder(border, null) : (compoundBorder.getInsideBorder() == null ? new CompoundBorder(compoundBorder.getOutsideBorder(), border) : compoundBorder);
        this.compoundBorderStack.push(compoundBorder2);
    }

    protected void handleSeriesPoint(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String string = null;
        String string2 = null;
        int n2 = attributes.getIndex("series");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        if ((n2 = attributes.getIndex("point")) > -1) {
            string2 = attributes.getValue(n2);
        }
        if (string != null && string2 != null) {
            String[] stringArray = new String[]{string, string2};
            this.seriesPoints.add(stringArray);
        }
    }

    protected void handleExplodeList() {
        if (this.pam == null) {
            return;
        }
        this.attName = this.prefix + "explodeList";
        this.pam.setPropertyObject(this.attName, this.seriesPoints);
        this.seriesPoints = null;
    }

    protected void handleAnnotation(Attributes attributes) {
        int n2;
        JCAnno jCAnno = new JCAnno();
        int n3 = attributes.getIndex("type");
        if (n3 > -1) {
            n2 = JCTypeConverter.toEnum(attributes.getValue(n3), JCChartEnumMappings.anno_type_strings, JCChartEnumMappings.anno_type_values, 30);
            jCAnno.setType(n2);
        }
        if ((n3 = attributes.getIndex("startValue")) > -1) {
            double d2 = JCTypeConverter.toDouble(attributes.getValue(n3), jCAnno.getStartValue());
            jCAnno.setStartValue(d2);
        }
        if ((n3 = attributes.getIndex("stopValue")) > -1) {
            double d3 = JCTypeConverter.toDouble(attributes.getValue(n3), jCAnno.getStopValue());
            jCAnno.setStopValue(d3);
        }
        if ((n3 = attributes.getIndex("incrementValue")) > -1) {
            double d4 = JCTypeConverter.toDouble(attributes.getValue(n3), jCAnno.getIncrementValue());
            jCAnno.setIncrementValue(d4);
        }
        if ((n3 = attributes.getIndex("precision")) > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n3), jCAnno.getPrecision());
            jCAnno.setPrecision(n2);
        }
        if ((n3 = attributes.getIndex("drawLabels")) > -1) {
            n2 = JCTypeConverter.toBoolean(attributes.getValue(n3), jCAnno.getDrawLabels()) ? 1 : 0;
            jCAnno.setDrawLabels(n2 != 0);
        }
        if ((n3 = attributes.getIndex("drawTicks")) > -1) {
            n2 = JCTypeConverter.toBoolean(attributes.getValue(n3), jCAnno.getDrawTicks());
            jCAnno.setDrawTicks(n2 != 0);
        }
        if ((n3 = attributes.getIndex("labelExtent")) > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n3), jCAnno.getLabelExtent());
            jCAnno.setLabelExtent(n2);
        }
        if ((n3 = attributes.getIndex("innerExtent")) > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n3), jCAnno.getInnerExtent());
            jCAnno.setInnerExtent(n2);
        }
        if ((n3 = attributes.getIndex("outerExtent")) > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n3), jCAnno.getOuterExtent());
            jCAnno.setOuterExtent(n2);
        }
        if ((n3 = attributes.getIndex("tickColor")) > -1) {
            Color color = JCSwingTypeConverter.toColor(attributes.getValue(n3), jCAnno.getTickColor());
            jCAnno.setTickColor(color);
        }
        if ((n3 = attributes.getIndex("labelColor")) > -1) {
            Color color = JCSwingTypeConverter.toColor(attributes.getValue(n3), jCAnno.getLabelColor());
            jCAnno.setLabelColor(color);
        }
        this.annoList.add(jCAnno);
    }

    protected void handleAnnotations() {
        if (this.pam != null) {
            this.attName = this.prefix + "annoList";
            this.pam.setPropertyObject(this.attName, this.annoList);
            this.annoList = null;
        }
    }

    protected void handleGrid(Attributes attributes) {
        double d2;
        JCGrid jCGrid = new JCGrid();
        int n2 = attributes.getIndex("startValue");
        if (n2 > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), jCGrid.getStartValue());
            jCGrid.setStartValue(d2);
        }
        if ((n2 = attributes.getIndex("stopValue")) > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), jCGrid.getStopValue());
            jCGrid.setStopValue(d2);
        }
        if ((n2 = attributes.getIndex("incrementValue")) > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), jCGrid.getIncrementValue());
            jCGrid.setIncrementValue(d2);
        }
        this.gridList.add(jCGrid);
    }

    protected void handleGrids() {
        if (this.pam != null) {
            this.attName = this.prefix + "gridList";
            this.pam.setPropertyObject(this.attName, this.gridList);
            this.gridList = null;
        }
    }

    protected void handleInsets(Attributes attributes) {
        if (attributes == null || this.pam == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = attributes.getIndex("left");
        if (n6 > -1) {
            n2 = JCTypeConverter.toInt(attributes.getValue(n6), n2);
        }
        if ((n6 = attributes.getIndex("right")) > -1) {
            n3 = JCTypeConverter.toInt(attributes.getValue(n6), n3);
        }
        if ((n6 = attributes.getIndex("top")) > -1) {
            n4 = JCTypeConverter.toInt(attributes.getValue(n6), n4);
        }
        if ((n6 = attributes.getIndex("bottom")) > -1) {
            n5 = JCTypeConverter.toInt(attributes.getValue(n6), n5);
        }
        this.insets = new Insets(n4, n2, n5, n3);
        if (!this.inBorder) {
            this.attName = this.prefix + "insets";
            this.pam.setPropertyObject(this.attName, this.insets);
            this.insets = null;
        }
    }

    protected void handleAttributesPoint(Attributes attributes, String string) {
        if (attributes == null || this.pam == null) {
            return;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        int n2 = attributes.getIndex("x");
        if (n2 > -1) {
            d2 = JCTypeConverter.toDouble(attributes.getValue(n2), d2);
        }
        if ((n2 = attributes.getIndex("y")) > -1) {
            d3 = JCTypeConverter.toDouble(attributes.getValue(n2), d3);
        }
        if (string.equals("data-coord")) {
            String string2 = this.inThreshold ? "x" : "dataAttachX";
            this.attName = this.prefix + string2;
            this.attValue = "" + d2;
            this.pam.setProperty(this.attName, this.attValue);
            string2 = this.inThreshold ? "y" : "dataAttachY";
            this.attName = this.prefix + string2;
            this.attValue = "" + d3;
            this.pam.setProperty(this.attName, this.attValue);
        } else {
            this.attName = this.prefix + string;
            this.attValue = "" + (int)d2 + "," + (int)d3;
            this.pam.setProperty(this.attName, this.attValue);
        }
    }

    protected void handleDataViewName(Attributes attributes, boolean bl) {
        if (attributes == null || this.pam == null) {
            return;
        }
        String string = null;
        int n2 = attributes.getIndex("dataView");
        if (n2 > -1) {
            string = attributes.getValue(n2);
        }
        this.curDataViewName = bl ? "data" : null;
        for (n2 = 0; string != null && n2 < this.dataViewCount; ++n2) {
            String string2 = n2 == 0 ? "" : "" + n2;
            String string3 = this.pam.getProperty("data" + string2 + ".name");
            if (!string.equals(string3)) continue;
            this.curDataViewName = "data" + string2;
            break;
        }
        if (this.curDataViewName != null) {
            this.attName = this.prefix + "dataView";
            this.pam.setProperty(this.attName, this.curDataViewName);
        }
    }

    protected String findAxisName(String string, boolean bl) {
        String string2;
        String string3 = string2 = bl ? "xaxis" : "yaxis";
        if (string == null || string.length() == 0) {
            return string2;
        }
        int n2 = bl ? this.xAxisCount : this.yAxisCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = i2 == 0 ? "" : "" + i2;
            String string5 = this.pam.getProperty(string2 + string4 + ".name");
            if (string5 == null || !string5.equals(string)) continue;
            return string2 + string4;
        }
        return string2;
    }

    protected void resolveAxisProperty(String string, boolean bl) {
        String string2 = this.pam.getProperty(string);
        if (string2 != null) {
            String string3 = this.findAxisName(string2, bl);
            this.pam.setProperty(string, string3);
        }
    }

    protected void resolveAxisNames() {
        String string;
        int n2;
        if (this.pam == null) {
            return;
        }
        this.resolveAxisProperty("chartArea.horizActionAxis", true);
        this.resolveAxisProperty("chartArea.vertActionAxis", true);
        for (n2 = 0; n2 < this.xAxisCount; ++n2) {
            string = n2 == 0 ? "" : "" + n2;
            this.resolveAxisProperty("xaxis" + string + ".formula.originator", true);
            this.resolveAxisProperty("xaxis" + string + ".placementAxis", false);
        }
        for (n2 = 0; n2 < this.yAxisCount; ++n2) {
            string = n2 == 0 ? "" : "" + n2;
            this.resolveAxisProperty("yaxis" + string + ".formula.originator", false);
            this.resolveAxisProperty("yaxis" + string + ".placementAxis", true);
        }
        for (n2 = 0; n2 < this.dataViewCount; ++n2) {
            string = n2 == 0 ? "" : "" + n2;
            this.resolveAxisProperty("data" + string + ".xaxis", true);
            this.resolveAxisProperty("data" + string + ".yaxis", false);
        }
    }

    public static void parseXMLSource(PropertyAccessModel propertyAccessModel, InputSource inputSource, boolean bl) throws IOException {
        if (propertyAccessModel == null || inputSource == null) {
            return;
        }
        ChartHandler chartHandler = new ChartHandler(propertyAccessModel);
        LoadProperties loadProperties = propertyAccessModel.getLoadProperties();
        if (inputSource.getSystemId() == null) {
            if (loadProperties != null) {
                inputSource.setSystemId(loadProperties.getLocalEntitySystemId());
            } else {
                inputSource.setSystemId("");
            }
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        try {
            ErrorHandler errorHandler;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(chartHandler);
            ErrorHandler errorHandler2 = errorHandler = loadProperties == null ? null : loadProperties.getXmlErrorHandler();
            if (errorHandler == null) {
                errorHandler = new JCXMLErrorPrinter();
            }
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setEntityResolver(new JCXMLDTDResolver("Chart.dtd", chartHandler.getClass()));
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JCParseException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JCParseException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }
}

