/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.DataLabelChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.ImageMapChartDataModel;
import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.ThresholdChartDataModel;
import com.klg.jclass.chart.TimelineChartDataModel;
import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.LocaleHandler;
import com.klg.jclass.util.io.XMLTextUtil;
import com.klg.jclass.util.property.xml.LocalizedPropertyHandler;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataHandler
extends LocalizedPropertyHandler {
    protected StringBuffer sb = null;
    protected BaseDataSource baseDS = null;
    protected List<Double> xData = null;
    protected List<Double> yData = null;
    protected List<Double> yThresholdData = null;
    protected List<double[]> xDataArrays = null;
    protected List<double[]> yDataArrays = null;
    protected List<List<String>> yDataLabelsList = null;
    protected List<List<JCDataThreshold>> yDataThresholdsList = null;
    protected List<String> seriesLabels = null;
    protected List<String> trackLabels = null;
    protected List<String> dataLabels = null;
    protected List<String> pointLabels = null;
    protected List<JCDataThreshold> yThresholds = null;
    protected List<ImageMapInfo> pointImageMapInfo = null;
    protected List<ImageMapInfo[]> pointImageMapArrays = null;
    protected List<ImageMapInfo> clusterImageMapInfo = null;
    protected List<ImageMapInfo> seriesImageMapInfo = null;
    protected List<ImageMapInfo> legendImageMapInfo = null;
    protected String seriesLabel = null;
    protected String pointLabel = null;
    protected String trackLabel = null;
    protected JCDataThreshold dataThreshold = null;
    protected boolean inSeries = false;
    protected boolean inPoint = false;
    protected boolean usingSeries = true;
    protected boolean newTags = true;
    protected String XML_DS = null;
    protected String XML_DS_ATT_NAME = null;
    protected String XML_DS_ATT_HOLE = null;
    protected String XML_DS_SERIES = null;
    protected String XML_DS_SERIESLABEL = null;
    protected String XML_DS_POINT = null;
    protected String XML_DS_POINTLABEL = null;
    protected String XML_DS_TRACK_LABEL = "track-label";
    protected String XML_DS_XDATA = null;
    protected String XML_DS_YDATA = null;
    protected String XML_DS_DATA_LABEL = "dataLabel";
    protected String XML_DS_DATA_THRESHOLD = "data-threshold";
    protected String XML_DS_YTHRESHOLDDATA = "y-threshold-data";
    protected String XML_DS_POINT_URL = "pointImageMapURL";
    protected String XML_DS_POINT_EXTRA = "pointImageMapExtra";
    protected String XML_DS_CLUSTER_URL = "clusterImageMapURL";
    protected String XML_DS_CLUSTER_EXTRA = "clusterImageMapExtra";
    protected String XML_DS_SERIES_URL = "seriesImageMapURL";
    protected String XML_DS_SERIES_EXTRA = "seriesImageMapExtra";
    protected String XML_DS_LEGEND_URL = "legendImageMapURL";
    protected String XML_DS_LEGEND_EXTRA = "legendImageMapExtra";

    public XMLDataHandler(BaseDataSource baseDataSource) {
        this.baseDS = baseDataSource;
        this.useNewTags();
    }

    public XMLDataHandler(BaseDataSource baseDataSource, LocaleHandler localeHandler) {
        this(baseDataSource);
        this.localeHandler = localeHandler;
    }

    public void useNewTags() {
        this.XML_DS = "chart-data";
        this.XML_DS_ATT_NAME = "name";
        this.XML_DS_ATT_HOLE = "hole";
        this.XML_DS_SERIES = "data-series";
        this.XML_DS_SERIESLABEL = "data-series-label";
        this.XML_DS_POINT = "data-point";
        this.XML_DS_POINTLABEL = "data-point-label";
        this.XML_DS_XDATA = "x-data";
        this.XML_DS_YDATA = "y-data";
        this.newTags = true;
    }

    public void useOldTags() {
        this.XML_DS = "JCChartData";
        this.XML_DS_ATT_NAME = "Name";
        this.XML_DS_ATT_HOLE = "Hole";
        this.XML_DS_SERIES = "Series";
        this.XML_DS_SERIESLABEL = "SeriesLabel";
        this.XML_DS_POINT = "Point";
        this.XML_DS_POINTLABEL = "PointLabel";
        this.XML_DS_XDATA = "XData";
        this.XML_DS_YDATA = "YData";
        this.newTags = false;
    }

    public static void setCharacterBounds(int n2, int n3) {
        XMLTextUtil.setCharacterBounds(n2, n3);
    }

    public static int getLowCharacterBound() {
        return XMLTextUtil.getLowCharacterBound();
    }

    public static int getHighCharacterBound() {
        return XMLTextUtil.getHighCharacterBound();
    }

    public BaseDataSource getDataSource() {
        return this.baseDS;
    }

    public void setDataSource(BaseDataSource baseDataSource) {
        this.baseDS = baseDataSource;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.handleStartElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handleEndElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.handleCharacters(cArray, n2, n3);
    }

    public void handleStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.baseDS == null) {
            return;
        }
        if (string3.equals("JCChartData") && this.newTags) {
            this.useOldTags();
        } else if (string3.equals("chart-data") && !this.newTags) {
            this.useNewTags();
        }
        if (string3.equals(this.XML_DS_SERIES)) {
            this.inSeries = true;
            this.usingSeries = true;
            if (this.xData == null) {
                this.xData = new ArrayList<Double>();
            }
            if (this.yData == null) {
                this.yData = new ArrayList<Double>();
            }
            if (this.dataLabels == null) {
                this.dataLabels = new ArrayList<String>();
            }
            if (this.yThresholds == null) {
                this.yThresholds = new ArrayList<JCDataThreshold>();
            }
            if (this.pointImageMapInfo == null) {
                this.pointImageMapInfo = new ArrayList<ImageMapInfo>();
            }
            if (this.xDataArrays.size() == 0 && this.clusterImageMapInfo.size() > 0) {
                this.clusterImageMapInfo = new ArrayList<ImageMapInfo>();
            }
            this.processURLToList(attributes, this.XML_DS_SERIES_URL, this.XML_DS_SERIES_EXTRA, this.seriesImageMapInfo);
            this.processURLToList(attributes, this.XML_DS_LEGEND_URL, this.XML_DS_LEGEND_EXTRA, this.legendImageMapInfo);
        } else if (string3.equals(this.XML_DS_POINT)) {
            this.inPoint = true;
            this.usingSeries = false;
            if (this.xData == null) {
                this.xData = new ArrayList<Double>();
            }
            if (this.yData == null) {
                this.yData = new ArrayList<Double>();
            }
            if (this.dataLabels == null) {
                this.dataLabels = new ArrayList<String>();
            }
            if (this.pointImageMapInfo == null) {
                this.pointImageMapInfo = new ArrayList<ImageMapInfo>();
            }
        } else if (string3.equals(this.XML_DS_DATA_THRESHOLD)) {
            this.dataThreshold = new JCDataThreshold();
            this.dataThreshold.setLegendImageMapInfo(this.processURL(attributes, this.XML_DS_LEGEND_URL, this.XML_DS_LEGEND_EXTRA));
        } else if (string3.equals(this.XML_DS_XDATA)) {
            if (this.inSeries && this.xDataArrays.size() == 0 || this.inPoint) {
                this.processURLToList(attributes, this.XML_DS_CLUSTER_URL, this.XML_DS_CLUSTER_EXTRA, this.clusterImageMapInfo);
            }
        } else if (string3.equals(this.XML_DS_YDATA)) {
            this.processURLToList(attributes, this.XML_DS_POINT_URL, this.XML_DS_POINT_EXTRA, this.pointImageMapInfo);
            this.processDataLabel(attributes, this.dataLabels);
        } else if (string3.equals(this.XML_DS_YTHRESHOLDDATA)) {
            if (this.yThresholdData == null) {
                this.yThresholdData = new ArrayList<Double>();
            }
        } else if (string3.equals(this.XML_DS)) {
            if (attributes != null) {
                int n2 = attributes.getIndex(this.XML_DS_ATT_NAME);
                if (n2 > -1) {
                    this.baseDS.name = attributes.getValue(n2);
                }
                if ((n2 = attributes.getIndex(this.XML_DS_ATT_HOLE)) > -1) {
                    this.baseDS.holeValue = this.getNextDouble(attributes.getValue(n2));
                }
            }
            this.xDataArrays = new ArrayList<double[]>();
            this.yDataArrays = new ArrayList<double[]>();
            this.yDataLabelsList = new ArrayList<List<String>>();
            this.seriesLabels = new ArrayList<String>();
            this.pointLabels = new ArrayList<String>();
            this.trackLabels = new ArrayList<String>();
            this.yDataThresholdsList = new ArrayList<List<JCDataThreshold>>();
            this.pointImageMapArrays = new ArrayList<ImageMapInfo[]>();
            this.clusterImageMapInfo = new ArrayList<ImageMapInfo>();
            this.seriesImageMapInfo = new ArrayList<ImageMapInfo>();
            this.legendImageMapInfo = new ArrayList<ImageMapInfo>();
        }
    }

    public void handleEndElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = string4 = this.sb == null ? null : this.sb.toString();
        if (string3.equals(this.XML_DS_XDATA)) {
            Double d2 = this.getNextDouble(string4);
            this.xData.add(d2);
        } else if (string3.equals(this.XML_DS_YDATA)) {
            Double d3 = this.getNextDouble(string4);
            this.yData.add(d3);
        } else if (string3.equals(this.XML_DS_YTHRESHOLDDATA)) {
            Double d4 = this.getNextDouble(string4);
            this.yThresholdData.add(d4);
        } else if (string3.equals(this.XML_DS_SERIESLABEL)) {
            this.seriesLabel = string4;
            if (!this.inSeries) {
                this.seriesLabels.add(this.seriesLabel);
                this.seriesLabel = null;
            }
        } else if (string3.equals(this.XML_DS_TRACK_LABEL)) {
            this.trackLabel = string4;
            if (!this.inSeries) {
                this.trackLabels.add(this.trackLabel);
                this.trackLabel = null;
            }
        } else if (string3.equals(this.XML_DS_POINTLABEL)) {
            this.pointLabel = string4;
            if (!this.inPoint) {
                this.pointLabels.add(this.pointLabel);
                this.pointLabel = null;
            }
        } else if (string3.equals(this.XML_DS_DATA_THRESHOLD)) {
            double[] dArray = this.processListToDoubles(this.yThresholdData);
            this.dataThreshold.setYValues(dArray);
            this.yThresholds.add(this.dataThreshold);
            this.dataThreshold = null;
            this.yThresholdData = null;
        } else if (string3.equals(this.XML_DS_SERIES)) {
            this.processXYData();
            this.seriesLabels.add(this.seriesLabel);
            this.seriesLabel = null;
            this.trackLabels.add(this.trackLabel);
            this.trackLabel = null;
            this.yDataThresholdsList.add(this.yThresholds);
            this.yThresholds = null;
            this.inSeries = false;
        } else if (string3.equals(this.XML_DS_POINT)) {
            this.processXYData();
            this.pointLabels.add(this.pointLabel);
            this.pointLabel = null;
            this.inPoint = false;
        } else if (string3.equals(this.XML_DS)) {
            if (this.xData != null) {
                double[] dArray = this.processListToDoubles(this.xData);
                this.xDataArrays.add(dArray);
                this.xData = null;
            }
            this.processDataArrays();
        }
        this.sb = null;
    }

    public void handleCharacters(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        if (this.localeHandler != null) {
            string = this.localizeString(string);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected double[] processListToDoubles(List<Double> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        double[] dArray = new double[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Double d2 = list.get(i2);
            dArray[i2] = d2;
        }
        return dArray;
    }

    protected ImageMapInfo[] processListToImageMapInfoArray(List<ImageMapInfo> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ImageMapInfo[] imageMapInfoArray = new ImageMapInfo[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            imageMapInfoArray[i2] = list.get(i2);
        }
        return imageMapInfoArray;
    }

    protected void processXYData() throws SAXException {
        double[] dArray = this.processListToDoubles(this.yData);
        this.yDataArrays.add(dArray);
        this.yDataLabelsList.add(this.dataLabels);
        this.pointImageMapArrays.add(this.processListToImageMapInfoArray(this.pointImageMapInfo));
        this.yData = null;
        this.dataLabels = null;
        this.pointImageMapInfo = null;
        if (this.inSeries) {
            double[] dArray2 = this.processListToDoubles(this.xData);
            if (dArray2 != null) {
                this.xDataArrays.add(dArray2);
            }
            this.xData = null;
        }
        if (this.inPoint && this.xData != null && this.xData.size() < this.yDataArrays.size()) {
            this.xData.add(new Double(this.xData.size() - 1));
            this.clusterImageMapInfo.add(new ImageMapInfo());
        }
    }

    protected double[] fillOutDoubleArray(double[] dArray, int n2) {
        int n3;
        if (dArray != null && dArray.length >= n2) {
            return dArray;
        }
        double[] dArray2 = new double[n2];
        int n4 = n3 = dArray == null ? 0 : dArray.length;
        if (n3 > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n3);
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            dArray2[i2] = this.baseDS.getHoleValue();
        }
        return dArray2;
    }

    protected ImageMapInfo[] fillOutImageMapInfoArray(ImageMapInfo[] imageMapInfoArray, int n2) {
        int n3;
        if (imageMapInfoArray != null && imageMapInfoArray.length >= n2) {
            return imageMapInfoArray;
        }
        ImageMapInfo[] imageMapInfoArray2 = new ImageMapInfo[n2];
        int n4 = n3 = imageMapInfoArray == null ? 0 : imageMapInfoArray.length;
        if (n3 > 0) {
            System.arraycopy(imageMapInfoArray, 0, imageMapInfoArray2, 0, n3);
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            imageMapInfoArray2[i2] = null;
        }
        return imageMapInfoArray2;
    }

    protected String[] processLabels(List<String> list, int n2) {
        if (n2 <= 0 || list == null || list.size() == 0) {
            return null;
        }
        boolean bl = false;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 < list.size()) {
                String string = list.get(i2);
                if (string != null) {
                    bl = true;
                }
                if (string == null || string.length() == 0) {
                    string = "";
                }
                stringArray[i2] = string;
                continue;
            }
            stringArray[i2] = null;
        }
        return bl ? stringArray : null;
    }

    protected boolean checkListofImageMapInfoArrays(List<ImageMapInfo[]> list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (ImageMapInfo[] imageMapInfoArray : list) {
            if (ImageMapInfo.isEmpty(imageMapInfoArray)) continue;
            return true;
        }
        return false;
    }

    protected void processDataArrays() {
        Object object;
        int n2;
        Object object2;
        int n3;
        int n4;
        List<JCDataThreshold> list22;
        int n5 = this.xDataArrays.size();
        int n6 = 0;
        if (this.usingSeries) {
            n6 = this.yDataArrays.size();
        } else {
            for (double[] dArray : this.yDataArrays) {
                if (dArray == null) continue;
                n6 = Math.max(n6, dArray.length);
            }
        }
        boolean bl = this.checkListofImageMapInfoArrays(this.pointImageMapArrays);
        if (bl) {
            this.baseDS.pointImageMapInfo = new ImageMapInfo[n6][];
        }
        boolean bl2 = false;
        ImageMapInfo[] imageMapInfoArray = null;
        if (n5 > 0) {
            imageMapInfoArray = this.processListToImageMapInfoArray(this.clusterImageMapInfo);
            bl2 = !ImageMapInfo.isEmpty(imageMapInfoArray);
        }
        boolean bl3 = false;
        for (List<JCDataThreshold> list22 : this.yDataThresholdsList) {
            if (list22 == null || list22.size() <= 0) continue;
            bl3 = true;
            break;
        }
        if (bl3) {
            this.baseDS.dataThresholds = new JCDataThreshold[n6][];
        }
        this.baseDS.dataLabels = new String[n6][];
        this.baseDS.xvalues = new double[n5 > 1 ? n5 : 1][];
        this.baseDS.yvalues = new double[n6][];
        int n7 = 0;
        if (n5 <= 1) {
            list22 = n5 == 1 ? this.xDataArrays.get(0) : null;
            int n8 = n7 = list22 == null ? 0 : ((Object)list22).length;
            if (this.usingSeries) {
                for (n4 = 0; n4 < n6; ++n4) {
                    double[] dArray = this.yDataArrays.get(n4);
                    if (dArray == null) continue;
                    n7 = Math.max(n7, dArray.length);
                }
            } else {
                n7 = Math.max(n7, this.yDataArrays.size());
            }
        }
        list22 = null;
        if (n5 == 0) {
            list22 = (List<JCDataThreshold>)new double[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                list22[n4] = (double)(n4 + 1);
            }
        } else if (n5 == 1) {
            list22 = (List<JCDataThreshold>)this.xDataArrays.get(0);
        }
        n4 = n7;
        for (n3 = 0; n3 < this.yDataArrays.size(); ++n3) {
            int n9;
            int n10;
            object2 = this.yDataArrays.get(n3);
            int n11 = n2 = object2 == null ? 0 : ((double[])object2).length;
            if (n5 <= 1) {
                if (n3 == 0) {
                    this.baseDS.xvalues[0] = this.fillOutDoubleArray((double[])list22, n7);
                }
            } else {
                list22 = (List<JCDataThreshold>)this.xDataArrays.get(n3);
                int n12 = list22 == null ? 0 : ((Object)list22).length;
                n7 = Math.max(n12, n2);
                n4 = Math.max(n7, n4);
                this.baseDS.xvalues[n3] = this.fillOutDoubleArray((double[])list22, n7);
            }
            if (n3 == 0 && bl2) {
                this.baseDS.clusterImageMapInfo = this.fillOutImageMapInfoArray(imageMapInfoArray, n7);
            }
            ImageMapInfo[] imageMapInfoArray2 = this.pointImageMapArrays.get(n3);
            if (this.usingSeries) {
                this.baseDS.yvalues[n3] = this.fillOutDoubleArray((double[])object2, n7);
                if (bl) {
                    this.baseDS.pointImageMapInfo[n3] = this.fillOutImageMapInfoArray(imageMapInfoArray2, n7);
                }
                this.baseDS.dataLabels[n3] = this.processLabels(this.yDataLabelsList.get(n3), n4);
            } else {
                object = this.processLabels(this.yDataLabelsList.get(n3), n2);
                for (n10 = 0; n10 < n6; ++n10) {
                    if (n3 == 0) {
                        this.baseDS.yvalues[n10] = new double[n7];
                        this.baseDS.dataLabels[n10] = new String[n7];
                        if (bl) {
                            this.baseDS.pointImageMapInfo[n10] = new ImageMapInfo[n7];
                        }
                    }
                    n9 = n10 >= n2 ? 1 : 0;
                    this.baseDS.yvalues[n10][n3] = n9 != 0 ? this.baseDS.getHoleValue() : object2[n10];
                    Object object3 = n9 != 0 ? null : (this.baseDS.dataLabels[n10][n3] = object != null ? object[n10] : null);
                    if (!bl) continue;
                    this.baseDS.pointImageMapInfo[n10][n3] = n9 != 0 ? null : imageMapInfoArray2[n10];
                }
            }
            if (!bl3) continue;
            object = this.yDataThresholdsList.get(n3);
            int n12 = n10 = object == null ? 0 : object.size();
            if (n10 <= 0) continue;
            this.baseDS.dataThresholds[n3] = new JCDataThreshold[n10];
            for (n9 = 0; n9 < n10; ++n9) {
                this.baseDS.dataThresholds[n3][n9] = (JCDataThreshold)object.get(n9);
            }
        }
        this.xDataArrays = null;
        this.yDataArrays = null;
        this.pointImageMapArrays = null;
        this.yDataThresholdsList = null;
        this.yDataLabelsList = null;
        n3 = 0;
        object2 = this.baseDS.dataLabels;
        n2 = ((double[])object2).length;
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            object = object2[i2];
            if (object == null || ((double)object).length <= 0) continue;
            for (void var18_26 : object) {
                if (var18_26 == null || var18_26.length() <= 0) continue;
                n3 = 1;
                continue block7;
            }
        }
        if (n3 == 0) {
            this.baseDS.dataLabels = null;
        }
        if (!ImageMapInfo.isEmpty((ImageMapInfo[])(object2 = (Object)this.processListToImageMapInfoArray(this.seriesImageMapInfo)))) {
            this.baseDS.seriesImageMapInfo = (ImageMapInfo[])object2;
        }
        if (!ImageMapInfo.isEmpty((ImageMapInfo[])(object2 = (Object)this.processListToImageMapInfoArray(this.legendImageMapInfo)))) {
            this.baseDS.legendImageMapInfo = (ImageMapInfo[])object2;
        }
        this.baseDS.seriesLabels = this.processLabels(this.seriesLabels, n6);
        this.baseDS.trackLabels = this.processLabels(this.trackLabels, n6);
        this.baseDS.pointLabels = this.processLabels(this.pointLabels, n4);
        this.seriesLabels = null;
        this.trackLabels = null;
        this.pointLabels = null;
    }

    protected ImageMapInfo processURL(Attributes attributes, String string, String string2) {
        String string3 = null;
        String string4 = null;
        if (attributes != null) {
            int n2 = attributes.getIndex(string);
            if (n2 > -1) {
                string3 = attributes.getValue(n2);
            }
            if ((n2 = attributes.getIndex(string2)) > -1) {
                string4 = attributes.getValue(n2);
            }
            if (this.localeHandler != null) {
                string3 = this.localizeString(string3);
                string4 = this.localizeString(string4);
            }
        }
        return new ImageMapInfo(string3, string4);
    }

    protected void processDataLabel(Attributes attributes, List<String> list) {
        int n2;
        String string = "";
        if (attributes != null && (n2 = attributes.getIndex(this.XML_DS_DATA_LABEL)) > -1) {
            string = attributes.getValue(n2);
        }
        if (list != null) {
            list.add(string);
        }
    }

    protected void processURLToList(Attributes attributes, String string, String string2, List<ImageMapInfo> list) {
        list.add(this.processURL(attributes, string, string2));
    }

    protected Double getNextDouble(String string) throws SAXException {
        Double d2;
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            d2 = new Double(this.baseDS.getHoleValue());
        } else if (string.equalsIgnoreCase("MAX")) {
            d2 = new Double(Double.MAX_VALUE);
        } else if (string.equalsIgnoreCase("MIN")) {
            d2 = new Double(Double.MIN_VALUE);
        } else if (string.equalsIgnoreCase("INFINITY")) {
            d2 = new Double(Double.POSITIVE_INFINITY);
        } else {
            try {
                d2 = Double.valueOf(string);
            }
            catch (Exception exception) {
                this.displayErrorMessage(2, string);
                throw new SAXException("Error in data file format - ");
            }
            if (d2 == null) {
                d2 = new Double(0.0);
            }
        }
        return d2;
    }

    protected void displayErrorMessage(int n2, String string) {
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = string2 + "Data must start with ARRAY or GENERAL and not ";
                break;
            }
            case 2: {
                string2 = string2 + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string2 = string2 + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + "'";
            string2 = string2 + string;
            string2 = string2 + "'";
        }
        System.err.println(string2);
    }

    public static String doubleToString(double d2, double d3, boolean bl) {
        String string = bl && d2 == d3 ? "hole" : (d2 == Double.MAX_VALUE ? "max" : (d2 == Double.MIN_VALUE ? "min" : String.valueOf(d2)));
        return string;
    }

    protected void writeString(Writer writer, StringBuffer stringBuffer, String string, int n2) throws IOException {
        if (writer == null && stringBuffer == null || string == null) {
            return;
        }
        StringBuffer stringBuffer2 = null;
        if (n2 > 0) {
            stringBuffer2 = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer2.append(" ");
            }
        }
        if (writer != null) {
            if (stringBuffer2 != null) {
                writer.write(stringBuffer2.toString());
            }
            writer.write(string);
        }
        if (stringBuffer != null) {
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append(string);
        }
    }

    protected int writeImageMapAttribute(Writer writer, StringBuffer stringBuffer, String string, String string2, String string3, int n2, int n3) throws IOException {
        if (string2 != null) {
            if (n3 > 0) {
                this.writeString(writer, stringBuffer, "\n", 0);
            }
            this.writeString(writer, stringBuffer, " " + string + "=\"" + XMLTextUtil.expandReservedCharacters(string2) + "\"", n3 > 0 ? n2 + n3 : 0);
            n3 = string3 == null ? 0 : string3.length();
        }
        return n3;
    }

    protected int writeImageMapInfo(Writer writer, StringBuffer stringBuffer, ImageMapInfo imageMapInfo, String string, String string2, String string3, int n2, int n3) throws IOException {
        if (imageMapInfo != null && !imageMapInfo.isEmpty()) {
            n3 = this.writeImageMapAttribute(writer, stringBuffer, string, imageMapInfo.getUrl(), string3, n2, n3);
            n3 = this.writeImageMapAttribute(writer, stringBuffer, string2, imageMapInfo.getExtra(), string3, n2, n3);
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    protected void writeDataToXML(ChartDataModel chartDataModel, Writer writer, StringBuffer stringBuffer, int n2, int n3, boolean bl) throws IOException {
        void var23_33;
        int n4;
        JCDataThreshold[][] jCDataThresholdArrayArray;
        String[] stringArray;
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0) {
            return;
        }
        if (writer == null && stringBuffer == null) {
            return;
        }
        int n5 = chartDataModel.getNumSeries();
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String string = null;
        if (chartDataModel instanceof LabelledChartDataModel) {
            stringArray = (String[])chartDataModel;
            stringArray2 = stringArray.getPointLabels();
            stringArray3 = stringArray.getSeriesLabels();
            string = stringArray.getDataSourceName();
        }
        stringArray = null;
        if (chartDataModel instanceof TimelineChartDataModel) {
            TimelineChartDataModel timelineChartDataModel = (TimelineChartDataModel)((Object)chartDataModel);
            stringArray = timelineChartDataModel.getTrackLabels();
        }
        boolean bl2 = false;
        double d2 = Double.MAX_VALUE;
        if (chartDataModel instanceof HoleValueChartDataModel) {
            d2 = ((HoleValueChartDataModel)((Object)chartDataModel)).getHoleValue();
            bl2 = true;
        }
        ImageMapInfo[][] imageMapInfoArrayArray = new ImageMapInfo[n5][];
        ImageMapInfo[] imageMapInfoArray = null;
        ImageMapInfo[] imageMapInfoArray2 = null;
        ImageMapInfo[] imageMapInfoArray3 = null;
        if (chartDataModel instanceof ImageMapChartDataModel) {
            jCDataThresholdArrayArray = (JCDataThreshold[][])chartDataModel;
            for (int i2 = 0; i2 < n5; ++i2) {
                imageMapInfoArrayArray[i2] = jCDataThresholdArrayArray.getPointImageMapInfo(i2);
            }
            imageMapInfoArray = jCDataThresholdArrayArray.getClusterImageMapInfo();
            imageMapInfoArray2 = jCDataThresholdArrayArray.getSeriesImageMapInfo();
            imageMapInfoArray3 = jCDataThresholdArrayArray.getLegendImageMapInfo();
        }
        jCDataThresholdArrayArray = new JCDataThreshold[n5][];
        if (chartDataModel instanceof ThresholdChartDataModel) {
            ThresholdChartDataModel thresholdChartDataModel = (ThresholdChartDataModel)((Object)chartDataModel);
            for (int i3 = 0; i3 < n5; ++i3) {
                jCDataThresholdArrayArray[i3] = thresholdChartDataModel.getDataThreshold(i3);
            }
        }
        double[][] dArrayArray = new double[n5][];
        double[][] dArrayArray2 = new double[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            double[] objectArray = chartDataModel.getXSeries(n4);
            if (n4 == 0 || objectArray != dArrayArray[0]) {
                dArrayArray[n4] = objectArray;
            }
            dArrayArray2[n4] = chartDataModel.getYSeries(n4);
        }
        if (dArrayArray.length > 1 && dArrayArray[1] == null) {
            double[] dArray = dArrayArray[0];
            dArrayArray = new double[][]{dArray};
        }
        n2 = Math.max(n2, 0);
        n3 = Math.max(n3, 0);
        if (bl) {
            this.writeString(writer, stringBuffer, "<?xml version=\"1.0\"?>\n", n2);
            this.writeString(writer, stringBuffer, "<!DOCTYPE chart-data SYSTEM \"JCChartData.dtd\">\n", n2);
        }
        this.writeString(writer, stringBuffer, "<" + this.XML_DS, n2);
        if (string != null && string.length() > 0) {
            this.writeString(writer, stringBuffer, " " + this.XML_DS_ATT_NAME + "=\"" + XMLTextUtil.expandReservedCharacters(string) + "\"", 0);
        }
        if (bl2 && d2 != Double.MAX_VALUE) {
            this.writeString(writer, stringBuffer, " " + this.XML_DS_ATT_HOLE + "=\"" + XMLDataHandler.doubleToString(d2, d2, false) + "\"", 0);
        }
        this.writeString(writer, stringBuffer, ">\n", 0);
        n2 += n3;
        if (stringArray2 != null && stringArray2.length > 0) {
            n4 = 0;
            for (String string2 : stringArray2) {
                if (string2 == null || string2.length() <= 0) continue;
                n4 = 1;
                break;
            }
            if (n4 != 0) {
                for (String string2 : stringArray2) {
                    this.writeString(writer, stringBuffer, "<" + this.XML_DS_POINTLABEL + ">", n2);
                    this.writeString(writer, stringBuffer, XMLTextUtil.expandReservedCharacters(string2), 0);
                    this.writeString(writer, stringBuffer, "</" + this.XML_DS_POINTLABEL + ">\n", 0);
                }
            }
        }
        DataLabelChartDataModel dataLabelChartDataModel = null;
        if (chartDataModel instanceof DataLabelChartDataModel) {
            dataLabelChartDataModel = (DataLabelChartDataModel)((Object)chartDataModel);
        }
        boolean bl3 = false;
        while (var23_33 < n5) {
            Object object;
            String string3;
            int n6;
            Object object2;
            String string2;
            String string4 = "<" + this.XML_DS_SERIES;
            this.writeString(writer, stringBuffer, string4, n2);
            int n7 = 0;
            string2 = imageMapInfoArray2 != null && var23_33 < imageMapInfoArray2.length ? imageMapInfoArray2[var23_33] : null;
            n7 = this.writeImageMapInfo(writer, stringBuffer, (ImageMapInfo)((Object)string2), this.XML_DS_SERIES_URL, this.XML_DS_SERIES_EXTRA, string4, n2, n7);
            string2 = imageMapInfoArray3 != null && var23_33 < imageMapInfoArray3.length ? imageMapInfoArray3[var23_33] : null;
            this.writeImageMapInfo(writer, stringBuffer, (ImageMapInfo)((Object)string2), this.XML_DS_LEGEND_URL, this.XML_DS_LEGEND_EXTRA, string4, n2, n7);
            this.writeString(writer, stringBuffer, ">\n", 0);
            n2 += n3;
            if (stringArray3 != null && var23_33 < stringArray3.length && stringArray3[var23_33] != null && stringArray3[var23_33].length() > 0) {
                this.writeString(writer, stringBuffer, "<" + this.XML_DS_SERIESLABEL + ">", n2);
                this.writeString(writer, stringBuffer, XMLTextUtil.expandReservedCharacters(stringArray3[var23_33]), 0);
                this.writeString(writer, stringBuffer, "</" + this.XML_DS_SERIESLABEL + ">\n", 0);
            }
            if (stringArray != null && var23_33 < stringArray.length && stringArray[var23_33] != null && stringArray[var23_33].length() > 0) {
                this.writeString(writer, stringBuffer, "<" + this.XML_DS_TRACK_LABEL + ">", n2);
                this.writeString(writer, stringBuffer, XMLTextUtil.expandReservedCharacters(stringArray[var23_33]), 0);
                this.writeString(writer, stringBuffer, "</" + this.XML_DS_TRACK_LABEL + ">\n", 0);
            }
            if (var23_33 == false || dArrayArray.length > 1) {
                for (int i2 = 0; i2 < dArrayArray[var23_33].length; ++i2) {
                    String string5 = "<" + this.XML_DS_XDATA;
                    this.writeString(writer, stringBuffer, string5, n2);
                    n7 = 0;
                    if (var23_33 == false && imageMapInfoArray != null && i2 < imageMapInfoArray.length) {
                        n7 = this.writeImageMapInfo(writer, stringBuffer, imageMapInfoArray[i2], this.XML_DS_CLUSTER_URL, this.XML_DS_CLUSTER_EXTRA, string5, n2, n7);
                    }
                    object2 = n7 > 0 ? "\n" : "";
                    this.writeString(writer, stringBuffer, ">" + (String)object2, 0);
                    this.writeString(writer, stringBuffer, XMLDataHandler.doubleToString(dArrayArray[var23_33][i2], d2, bl2) + (String)object2, n7 > 0 ? n2 : 0);
                    this.writeString(writer, stringBuffer, "</" + this.XML_DS_XDATA + ">\n", n7 > 0 ? n2 : 0);
                }
            }
            String[] stringArray4 = null;
            if (dataLabelChartDataModel != null) {
                stringArray4 = dataLabelChartDataModel.getDataLabel((int)var23_33);
            }
            for (n6 = 0; n6 < dArrayArray2[var23_33].length; ++n6) {
                object2 = "<" + this.XML_DS_YDATA;
                this.writeString(writer, stringBuffer, (String)object2, n2);
                n7 = 0;
                if (imageMapInfoArrayArray[var23_33] != null && n6 < imageMapInfoArrayArray[var23_33].length) {
                    n7 = this.writeImageMapInfo(writer, stringBuffer, imageMapInfoArrayArray[var23_33][n6], this.XML_DS_POINT_URL, this.XML_DS_POINT_EXTRA, (String)object2, n2, n7);
                }
                String string6 = string3 = n7 > 0 ? "\n" : "";
                if (stringArray4 != null && n6 < stringArray4.length && (object = stringArray4[n6]) != null && ((String)object).length() > 0) {
                    this.writeString(writer, stringBuffer, " " + this.XML_DS_DATA_LABEL + "=\"" + (String)object + "\"", 0);
                }
                this.writeString(writer, stringBuffer, ">" + string3, 0);
                this.writeString(writer, stringBuffer, XMLDataHandler.doubleToString(dArrayArray2[var23_33][n6], d2, bl2) + string3, n7 > 0 ? n2 : 0);
                this.writeString(writer, stringBuffer, "</" + this.XML_DS_YDATA + ">\n", n7 > 0 ? n2 : 0);
            }
            if (jCDataThresholdArrayArray[var23_33] != null && jCDataThresholdArrayArray[var23_33].length > 0) {
                for (n6 = 0; n6 < jCDataThresholdArrayArray[var23_33].length; ++n6) {
                    object2 = jCDataThresholdArrayArray[var23_33][n6];
                    if (object2 == null) continue;
                    string3 = "<" + this.XML_DS_DATA_THRESHOLD;
                    this.writeString(writer, stringBuffer, string3, n2);
                    this.writeImageMapInfo(writer, stringBuffer, ((JCAbstractThreshold)object2).getLegendImageMapInfo(), this.XML_DS_LEGEND_URL, this.XML_DS_LEGEND_EXTRA, string3, n2, 0);
                    this.writeString(writer, stringBuffer, ">\n", 0);
                    n2 += n3;
                    object = ((JCDataThreshold)object2).getYValues();
                    int n8 = object == null ? 0 : ((Object)object).length;
                    for (int i3 = 0; i3 < n8; ++i3) {
                        this.writeString(writer, stringBuffer, "<" + this.XML_DS_YTHRESHOLDDATA + ">", n2);
                        this.writeString(writer, stringBuffer, XMLDataHandler.doubleToString((double)object[i3], d2, bl2), 0);
                        this.writeString(writer, stringBuffer, "</" + this.XML_DS_YTHRESHOLDDATA + ">\n", 0);
                    }
                    this.writeString(writer, stringBuffer, "</" + this.XML_DS_DATA_THRESHOLD + ">\n", n2 -= n3);
                }
            }
            this.writeString(writer, stringBuffer, "</" + this.XML_DS_SERIES + ">\n", n2 -= n3);
            ++var23_33;
        }
        this.writeString(writer, stringBuffer, "</" + this.XML_DS + ">\n", n2 -= n3);
        if (writer != null) {
            writer.flush();
        }
    }

    public String writeDataToXML(ChartDataModel chartDataModel, int n2, int n3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.writeDataToXML(chartDataModel, null, stringBuffer, n2, n3, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void writeDataToXML(ChartDataModel chartDataModel, Writer writer, int n2, int n3, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || writer == null) {
            return;
        }
        this.writeDataToXML(chartDataModel, writer, null, n2, n3, bl);
    }

    public void writeDataToXML(ChartDataModel chartDataModel, String string, int n2, int n3) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeDataToXML(chartDataModel, fileOutputStream, n2, n3, true);
        fileOutputStream.close();
    }

    public void writeDataToXML(ChartDataModel chartDataModel, OutputStream outputStream, int n2, int n3, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || outputStream == null) {
            return;
        }
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(dataOutputStream);
        this.writeDataToXML(chartDataModel, outputStreamWriter, null, n2, n3, bl);
    }

    public void writeDataToXML(ChartDataModel chartDataModel, StringBuffer stringBuffer, int n2, int n3, boolean bl) {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || stringBuffer == null) {
            return;
        }
        try {
            this.writeDataToXML(chartDataModel, null, stringBuffer, n2, n3, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

