/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.util.io.HTMLTextUtil;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ChartDataSourceUtil {
    private static final String QUOTE = "'";
    private static final String NL = "\n";
    private static final String BLANK = " ";
    private static final String COMMENT = "#";
    private static final String commentLine1 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key167") + "\n";
    private static final String commentLine2 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key168") + "\n";
    private static final String commentLine3 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key169") + "\n";
    private static final String commentLine4 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key170") + "\n";

    public static void setCharacterBounds(int n2, int n3) {
        HTMLTextUtil.setCharacterBounds(n2, n3);
    }

    public static int getLowCharacterBound() {
        return HTMLTextUtil.getLowCharacterBound();
    }

    public static int getHighCharacterBound() {
        return HTMLTextUtil.getHighCharacterBound();
    }

    public static double[][] generateSingleXSeries(int n2) {
        double[][] dArray = new double[1][n2];
        for (int i2 = 0; i2 < dArray[0].length; ++i2) {
            dArray[0][i2] = i2;
        }
        return dArray;
    }

    public static double[][] generateMultipleXSeries(double[][] dArray) {
        if (dArray == null || dArray.length < 0) {
            return null;
        }
        double[][] dArrayArray = new double[dArray.length][];
        for (int i2 = 0; i2 < dArrayArray.length; ++i2) {
            dArrayArray[i2] = new double[dArray[i2].length];
            for (int i3 = 0; i3 < dArray[i2].length; ++i3) {
                dArrayArray[i2][i3] = i3;
            }
        }
        return dArrayArray;
    }

    protected static String doubleToString(double d2, double d3, boolean bl) {
        String string = bl && d2 == d3 ? "hole" : (d2 == Double.MAX_VALUE ? "max" : (d2 == Double.MIN_VALUE ? "min" : String.valueOf(d2)));
        return string;
    }

    public static String buildDataSourceString(ChartDataModel chartDataModel) {
        return ChartDataSourceUtil.buildDataSourceString(chartDataModel, true);
    }

    public static String buildDataSourceString(ChartDataModel chartDataModel, boolean bl) {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0) {
            return "";
        }
        int n2 = chartDataModel.getNumSeries();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = null;
        if (chartDataModel instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
            stringArray = labelledChartDataModel.getPointLabels();
            stringArray2 = labelledChartDataModel.getSeriesLabels();
            string = labelledChartDataModel.getDataSourceName();
        }
        boolean bl2 = false;
        double d2 = Double.MAX_VALUE;
        if (chartDataModel instanceof HoleValueChartDataModel) {
            d2 = ((HoleValueChartDataModel)((Object)chartDataModel)).getHoleValue();
            bl2 = true;
        }
        double[][] dArrayArray = new double[n2][];
        double[][] dArrayArray2 = new double[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] dArray = chartDataModel.getXSeries(i2);
            if (i2 == 0 || dArray != dArrayArray[0]) {
                dArrayArray[i2] = dArray;
            }
            dArrayArray2[i2] = chartDataModel.getYSeries(i2);
        }
        if (dArrayArray.length > 1 && dArrayArray[1] == null) {
            double[] dArray = dArrayArray[0];
            dArrayArray = new double[][]{dArray};
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (dArrayArray.length == 1) {
            int n3;
            int n4 = dArrayArray2.length;
            int n5 = dArrayArray2[0].length;
            stringBuffer.append(commentLine1);
            stringBuffer.append(commentLine2);
            stringBuffer.append(commentLine3);
            stringBuffer.append(commentLine4);
            stringBuffer.append("ARRAY ");
            if (string != null) {
                String string2 = bl ? HTMLTextUtil.expandText(string) : string;
                stringBuffer.append(QUOTE + string2 + QUOTE + BLANK);
            } else {
                stringBuffer.append("'' ");
            }
            stringBuffer.append(n4 + BLANK + n5 + BLANK + NL);
            if (bl2 && d2 != Double.MAX_VALUE) {
                stringBuffer.append("HOLE " + ChartDataSourceUtil.doubleToString(d2, d2, false) + NL);
            }
            ChartDataSourceUtil.writePointLabels(stringArray, stringBuffer, false, bl);
            for (n3 = 0; n3 < n5; ++n3) {
                stringBuffer.append(ChartDataSourceUtil.doubleToString(dArrayArray[0][n3], d2, bl2) + BLANK);
            }
            stringBuffer.append(NL);
            for (n3 = 0; n3 < n4; ++n3) {
                if (stringArray2 != null && n3 < stringArray2.length && stringArray2[n3] != null) {
                    String string3 = bl ? HTMLTextUtil.expandText(stringArray2[n3]) : stringArray2[n3];
                    stringBuffer.append(QUOTE + string3 + QUOTE + BLANK);
                } else {
                    stringBuffer.append("'' ");
                }
                for (int i3 = 0; i3 < n5; ++i3) {
                    stringBuffer.append(ChartDataSourceUtil.doubleToString(dArrayArray2[n3][i3], d2, bl2) + BLANK);
                }
                stringBuffer.append(NL);
            }
        } else {
            stringBuffer.append("GENERAL ");
            if (string != null) {
                stringBuffer.append(QUOTE + string + QUOTE + BLANK);
            } else {
                stringBuffer.append("'' ");
            }
            stringBuffer.append(dArrayArray2.length + BLANK);
            int n6 = 0;
            for (double[] dArray : dArrayArray2) {
                if (dArray == null || dArray.length <= n6) continue;
                n6 = dArray.length;
            }
            stringBuffer.append(n6 + NL);
            if (bl2 && d2 != Double.MAX_VALUE) {
                stringBuffer.append("HOLE " + ChartDataSourceUtil.doubleToString(d2, d2, false) + NL);
            }
            ChartDataSourceUtil.writePointLabels(stringArray, stringBuffer, true, bl);
            for (int i4 = 0; i4 < dArrayArray2.length; ++i4) {
                if (stringArray2 != null && i4 < stringArray2.length && stringArray2[i4] != null) {
                    String string4 = bl ? HTMLTextUtil.expandText(stringArray2[i4]) : stringArray2[i4];
                    stringBuffer.append(QUOTE + string4 + QUOTE + BLANK);
                } else {
                    stringBuffer.append("'' ");
                }
                if (dArrayArray2[i4] == null || dArrayArray2[i4].length <= 0) {
                    stringBuffer.append("0\n");
                    continue;
                }
                stringBuffer.append(dArrayArray2[i4].length + NL);
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                for (int i5 = 0; i5 < dArrayArray2[i4].length; ++i5) {
                    double[] dArray = dArrayArray[i4];
                    double d3 = dArray == null || i5 >= dArray.length ? (double)i5 : dArray[i5];
                    stringBuffer2.append(ChartDataSourceUtil.doubleToString(d3, d2, bl2) + BLANK);
                    stringBuffer3.append(ChartDataSourceUtil.doubleToString(dArrayArray2[i4][i5], d2, bl2) + BLANK);
                }
                stringBuffer.append(stringBuffer2 + NL);
                stringBuffer.append(stringBuffer3 + NL);
            }
        }
        return stringBuffer.toString();
    }

    public static boolean checkPointLabels(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null || string.length() <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static void writePointLabels(String[] stringArray, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (ChartDataSourceUtil.checkPointLabels(stringArray)) {
            if (bl) {
                stringBuffer.append("LABELS ");
            }
            for (String string : stringArray) {
                if (string != null) {
                    String string2 = bl2 ? HTMLTextUtil.expandText(string) : string;
                    stringBuffer.append(QUOTE + string2 + QUOTE + BLANK);
                    continue;
                }
                stringBuffer.append("'' ");
            }
            stringBuffer.append(NL);
        }
    }

    public static void writeDataSource(ChartDataModel chartDataModel, String string, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ChartDataSourceUtil.writeDataSource(chartDataModel, fileOutputStream, bl);
        fileOutputStream.close();
    }

    public static void writeDataSource(ChartDataModel chartDataModel, OutputStream outputStream, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || outputStream == null) {
            return;
        }
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        String string = ChartDataSourceUtil.buildDataSourceString(chartDataModel, bl);
        if (string != null) {
            dataOutputStream.write(string.getBytes());
        }
    }

    public static void writeDataSource(ChartDataModel chartDataModel, OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || outputStreamWriter == null) {
            return;
        }
        String string = ChartDataSourceUtil.buildDataSourceString(chartDataModel, bl);
        if (string != null) {
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
        }
    }
}

