/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JPropertyPage;
import com.klg.jclass.chart.customizer.JSpinBox;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JFontEditor
extends JPropertyPage
implements ActionListener,
ItemListener,
AdjustmentListener,
PropertyEditor {
    protected JComboBox fontNameCombo = null;
    protected JComboBox fontStyleCombo = null;
    protected JSpinBox fontSizeSpin = null;
    protected JTextField fontSizeField = null;
    protected JButton useFontButton = null;
    static int[] font_style_values = new int[]{0, 1, 2, 3};
    static String[] font_style_names = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    String long_label = "      " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key129") + "       ";
    String short_label = " " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key129") + " ";
    protected PropertyChangeSupport listeners = null;

    public JFontEditor() {
        this.setToolTipText(JFontEditor.getPageTitle());
        this.init();
    }

    public void init() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].indexOf(46) >= 0) continue;
            ++n2;
        }
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (stringArray[i3].indexOf(46) >= 0) continue;
            stringArray2[n3] = new String(stringArray[i3]);
            ++n3;
        }
        Box box = new Box(0);
        this.fontNameCombo = new JComboBox<String>(stringArray2);
        this.fontNameCombo.addItemListener(this);
        box.add(this.fontNameCombo);
        box.add(Box.createHorizontalStrut(3));
        this.fontStyleCombo = new JComboBox<String>(font_style_names);
        this.fontStyleCombo.addItemListener(this);
        box.add(this.fontStyleCombo);
        box.add(Box.createHorizontalStrut(3));
        this.fontSizeSpin = new JSpinBox();
        this.fontSizeSpin.setMinimum(8);
        this.fontSizeSpin.setMaximum(36);
        this.fontSizeField = this.fontSizeSpin.getTextField();
        this.fontSizeField.addActionListener(this);
        this.fontSizeSpin.getScrollBar().addAdjustmentListener(this);
        box.add(this.fontSizeSpin);
        this.add("West", box);
        JPanel jPanel = new JPanel(new FlowLayout());
        this.useFontButton = new JButton(this.long_label);
        this.useFontButton.addActionListener(this);
        jPanel.add(this.useFontButton);
        this.add("South", jPanel);
    }

    public void setValue(Object object) {
        if (object instanceof Font) {
            this.setEditFont((Font)object);
        }
    }

    public Object getValue() {
        return this.getEditFont();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        String string;
        Font font = this.getEditFont();
        switch (font.getStyle()) {
            case 1: {
                string = "Font.BOLD";
                break;
            }
            case 2: {
                string = "Font.ITALIC";
                break;
            }
            case 3: {
                string = "Font.BOLD + Font.ITALIC";
                break;
            }
            default: {
                string = "Font.PLAIN";
            }
        }
        return "new Font(" + font.getName() + ", " + string + ", " + font.getSize() + ")";
    }

    public String getAsText() {
        Font font = this.getEditFont();
        return font.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Font getEditFont() {
        Font font = null;
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            int n2 = this.fontStyleCombo.getSelectedIndex();
            int n3 = font_style_values[n2];
            String string2 = this.fontSizeField.getText();
            int n4 = Integer.parseInt(string2);
            font = new Font(string, n3, n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return font;
    }

    public void setEditFont(Font font) {
        int n2;
        int n3;
        String string = font.getName();
        int n4 = this.fontNameCombo.getItemCount();
        boolean bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!string.equalsIgnoreCase((String)this.fontNameCombo.getItemAt(n3))) continue;
            if (this.fontNameCombo.getSelectedIndex() != n3) {
                this.fontNameCombo.setSelectedIndex(n3);
            }
            bl = true;
        }
        if (!bl) {
            try {
                this.fontNameCombo.addItem(string);
                this.fontNameCombo.setSelectedItem(string);
            }
            catch (Exception exception) {
                System.out.println(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key24") + " " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key112") + " " + string);
            }
        }
        n3 = font.getStyle();
        for (n2 = 0; n2 < font_style_values.length; ++n2) {
            if (n3 != font_style_values[n2]) continue;
            if (this.fontStyleCombo.getSelectedIndex() == n2) break;
            this.fontStyleCombo.setSelectedIndex(n2);
            break;
        }
        n2 = font.getSize();
        this.fontSizeSpin.setIntValue(n2);
        this.fontChanged();
    }

    private void fontChanged() {
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            String string2 = (String)this.fontStyleCombo.getSelectedItem();
            String string3 = this.fontSizeField.getText();
            if (string != "" && string2 != "" && string3 != "") {
                int n2 = JCTypeConverter.toEnum(string2, font_style_names, font_style_values, 0);
                Integer n3 = new Integer(string3);
                int n4 = n3;
                Font font = new Font(string, n2, n4);
                if (n4 > 14) {
                    this.useFontButton.setText(this.short_label);
                } else {
                    this.useFontButton.setText(this.long_label);
                }
                this.useFontButton.setFont(font);
            }
        }
        catch (Exception exception) {
            System.out.println(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key130") + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key112") + ":" + exception.getMessage());
        }
    }

    private void comboChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox == this.fontNameCombo || jComboBox == this.fontStyleCombo) {
            this.fontChanged();
        }
    }

    private void textChanged(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        if (jTextField == this.fontSizeField) {
            this.fontChanged();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            this.comboChanged(itemEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            try {
                this.fontSizeSpin.setTextValue(actionEvent.getActionCommand());
                this.textChanged(actionEvent);
            }
            catch (Exception exception) {
                System.out.println(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key130") + ": " + exception.getMessage());
            }
        } else if (actionEvent.getSource() instanceof JButton && this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.fontSizeSpin.getScrollBar()) {
            this.fontSizeSpin.setIntValue(adjustmentEvent.getValue());
            this.fontChanged();
        }
    }

    public void setBackground(Color color) {
        if (this.fontNameCombo != null) {
            this.fontNameCombo.setBackground(color);
        }
        if (this.fontStyleCombo != null) {
            this.fontStyleCombo.setBackground(color);
        }
        if (this.fontSizeField != null) {
            this.fontSizeField.setBackground(color);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JFontEditor.getPageTitle());
        serializable = new JFontEditor();
        ((JFontEditor)serializable).setBackground(Color.lightGray);
        jFrame.getContentPane().add((Component)serializable);
        ((JFontEditor)serializable).setValue(new Font("Dialog", 1, 12));
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        jFrame.setSize(dimension.width + 200, dimension.height + 100);
        jFrame.setVisible(true);
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key131");
    }

    public static String getPageName() {
        return "JFontEditor";
    }
}

