/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JPropertyPage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JEnumEditor
extends JPropertyPage
implements ItemListener,
PropertyEditor {
    private String[] strings;
    private int[] enumValues;
    private JComboBox comboBox = null;
    private String prepend = "";
    private Object[] itemValues = null;
    private boolean settingObjectItems = false;
    protected PropertyChangeSupport listeners = null;

    public JEnumEditor() {
        this(null, null);
    }

    public JEnumEditor(String[] stringArray, int[] nArray) {
        this.setToolTipText(JEnumEditor.getPageTitle());
        this.setLayout(new GridLayout(1, 1));
        this.comboBox = new JComboBox();
        this.strings = stringArray;
        this.enumValues = nArray;
        this.itemValues = this.strings;
        if (stringArray != null && nArray != null) {
            this.setItems(stringArray);
        }
        this.comboBox.addItemListener(this);
        this.add(this.comboBox);
    }

    public void setItems(String[] stringArray, Object[] objectArray) {
        this.settingObjectItems = true;
        if (!this.sameStrings(stringArray)) {
            this.strings = stringArray;
            this.itemValues = objectArray;
            if (stringArray != null && objectArray != null) {
                this.setItems(stringArray);
            }
        }
        this.settingObjectItems = false;
    }

    public Object[] getItems() {
        return this.itemValues;
    }

    public Object getItem(int n2) {
        Object object = null;
        if (this.itemValues != null && n2 < this.itemValues.length) {
            object = this.itemValues[n2];
        }
        return object;
    }

    public JEnumEditor(String[] stringArray, int[] nArray, String string) {
        this(stringArray, nArray);
        this.prepend = string;
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            int n2;
            int n3 = (Integer)object;
            int n4 = this.indexOf(n3);
            if (n4 < 0) {
                n4 = n3;
            }
            if (n4 != (n2 = this.comboBox.getSelectedIndex())) {
                try {
                    this.comboBox.setSelectedIndex(n4);
                }
                catch (Exception exception) {
                    this.comboBox.insertItemAt(new String(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key24") + n4), 0);
                    this.comboBox.setSelectedIndex(0);
                }
            }
        } else if (object instanceof String) {
            int n5 = this.indexOf((String)object);
            int n6 = this.comboBox.getSelectedIndex();
            if (n5 >= 0 && n5 != n6) {
                this.comboBox.setSelectedIndex(n5);
            }
        } else if (object instanceof Object) {
            int n7 = this.indexOf(object);
            int n8 = this.comboBox.getSelectedIndex();
            if (n7 >= 0 && n7 != n8) {
                this.comboBox.setSelectedIndex(n7);
            }
        }
    }

    public Object getValue() {
        int n2 = this.comboBox.getSelectedIndex();
        int n3 = -1;
        n3 = this.enumValues != null ? this.enumValues[n2] : n2;
        return new Integer(n3);
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        return this.prepend + this.getAsText();
    }

    public String getAsText() {
        return (String)this.comboBox.getSelectedItem();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return this.strings;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.settingObjectItems) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public int indexOf(int n2) {
        if (this.enumValues != null) {
            for (int i2 = 0; i2 < this.enumValues.length; ++i2) {
                if (this.enumValues[i2] != n2) continue;
                return i2;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        if (this.enumValues != null) {
            for (int i2 = 0; i2 < this.enumValues.length; ++i2) {
                if (!string.equalsIgnoreCase((String)this.comboBox.getItemAt(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    public int indexOf(Object object) {
        if (this.itemValues != null) {
            for (int i2 = 0; i2 < this.itemValues.length; ++i2) {
                if (this.itemValues[i2] != object) continue;
                return i2;
            }
        }
        return -1;
    }

    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    private void setItems(String[] stringArray) {
        this.comboBox.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.comboBox.addItem(new String(stringArray[i2]));
        }
    }

    private boolean sameStrings(String[] stringArray) {
        if (this.strings == null) {
            return false;
        }
        boolean bl = stringArray.length == this.strings.length;
        for (int i2 = 0; i2 < stringArray.length && bl; ++i2) {
            if (this.strings[i2].compareTo(stringArray[i2]) == 0) continue;
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JEnumEditor.getPageTitle());
        serializable = new JEnumEditor();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((JPropertyPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        jFrame.setSize(dimension.width + 200, dimension.height + 100);
        jFrame.setVisible(true);
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key162");
    }

    public static String getPageName() {
        return "JEnumEditor";
    }
}

