/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.customizer.JBooleanEditor;
import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JDoubleEditor;
import com.klg.jclass.chart.customizer.JFieldEditor;
import com.klg.jclass.chart.customizer.JPropertyPage;
import com.klg.jclass.chart.customizer.JSpinBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataViewDataPage
extends JPropertyPage
implements AdjustmentListener {
    private JFieldEditor seriesNameField;
    private JFieldEditor seriesLabelField;
    private JDoubleEditor firstPointField;
    private JDoubleEditor lastPointField;
    private JDoubleEditor dataHoleField;
    private JSpinBox numPointsSpin;
    private JBooleanEditor includedCheck;
    private JBooleanEditor visibleCheck;
    private JBooleanEditor visibleLegendCheck;
    private JDoubleEditor xValueField;
    private JDoubleEditor yValueField;
    private ChartDataView view = null;
    private ChartDataViewSeries series = null;
    private int currentPoint = 0;

    public void init() {
        super.init();
        this.setToolTipText(DataViewDataPage.getPageTitle());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        jPanel.setLayout(new FlowLayout(1, 3, 3));
        jPanel.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key145") + ":"));
        this.seriesNameField = new JFieldEditor("", 12);
        this.seriesNameField.addPropertyChangeListener(this);
        jPanel.add(this.seriesNameField);
        jPanel.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key267") + ":"));
        this.seriesLabelField = new JFieldEditor("", 12);
        this.seriesLabelField.addPropertyChangeListener(this);
        jPanel.add(this.seriesLabelField);
        this.add((Component)jPanel, "North");
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key146") + ":"));
        this.firstPointField = new JDoubleEditor(4);
        this.firstPointField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.firstPointField, gridBagConstraints);
        jPanel2.add(this.firstPointField);
        jPanel2.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key147") + ":"));
        this.lastPointField = new JDoubleEditor(4);
        this.lastPointField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.lastPointField, gridBagConstraints);
        jPanel2.add(this.lastPointField);
        jPanel2.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key148") + ":"));
        this.dataHoleField = new JDoubleEditor(8);
        this.dataHoleField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.dataHoleField, gridBagConstraints);
        jPanel2.add(this.dataHoleField);
        jPanel2.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key150") + ":"));
        this.numPointsSpin = new JSpinBox();
        this.numPointsSpin.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.numPointsSpin, gridBagConstraints);
        jPanel2.add(this.numPointsSpin);
        jPanel2.add(new JLabel("X " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key97") + ":"));
        this.xValueField = new JDoubleEditor(8);
        this.xValueField.addPropertyChangeListener(this);
        this.xValueField.textField.setEditable(false);
        gridBagLayout.setConstraints(this.xValueField, gridBagConstraints);
        jPanel2.add(this.xValueField);
        jPanel2.add(new JLabel("Y " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key97") + ":"));
        this.yValueField = new JDoubleEditor(8);
        this.yValueField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.yValueField, gridBagConstraints);
        jPanel2.add(this.yValueField);
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        this.includedCheck = new JBooleanEditor(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key149"));
        this.includedCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.includedCheck, gridBagConstraints);
        jPanel3.add(this.includedCheck);
        this.visibleCheck = new JBooleanEditor(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key27"));
        this.visibleCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.visibleCheck, gridBagConstraints);
        jPanel3.add(this.visibleCheck);
        this.visibleLegendCheck = new JBooleanEditor(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key28"));
        this.visibleLegendCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.visibleLegendCheck, gridBagConstraints);
        jPanel3.add(this.visibleLegendCheck);
        this.add((Component)jPanel3, "West");
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
            this.setObject(this.view);
        } else if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        } else if (object instanceof ChartDataViewSeries) {
            double d2;
            this.series = (ChartDataViewSeries)object;
            this.view = this.series.getParent();
            this.seriesNameField.setValue(this.series.getName());
            this.seriesLabelField.setValue(this.series.getLabel());
            int n2 = this.series.getFirstPoint();
            int n3 = this.series.getLastPoint();
            this.firstPointField.textField.setText("" + n2);
            this.lastPointField.textField.setText("" + n3);
            this.includedCheck.setValue(new Boolean(this.series.isIncluded()));
            this.visibleCheck.setValue(new Boolean(this.series.isVisible()));
            this.visibleLegendCheck.setValue(new Boolean(this.series.isVisibleInLegend()));
            this.numPointsSpin.setIntValue(this.currentPoint);
            this.numPointsSpin.setMinimum(this.series.getFirstPoint());
            this.numPointsSpin.setMaximum(this.series.getLastPoint());
            try {
                d2 = this.series.getX(this.currentPoint);
                this.xValueField.setValue(new Double(d2));
            }
            catch (Exception exception) {
                this.xValueField.textField.setText("");
            }
            try {
                d2 = this.series.getY(this.currentPoint);
                this.yValueField.setValue(new Double(d2));
            }
            catch (Exception exception) {
                this.yValueField.textField.setText("");
            }
        }
        if (this.view != null) {
            Double d3 = new Double(this.view.getHoleValue());
            this.dataHoleField.setValue(d3);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.series == null || object2 == null) {
            return;
        }
        if (object == this.includedCheck) {
            this.series.setIncluded((Boolean)object2);
        } else if (object == this.visibleCheck) {
            this.series.setVisible((Boolean)object2);
        } else if (object == this.visibleLegendCheck) {
            this.series.setVisibleInLegend((Boolean)object2);
        } else if (object == this.seriesNameField) {
            this.series.setName((String)object2);
            if (this.getParent() instanceof JPropertyPage) {
                JPropertyPage jPropertyPage = (JPropertyPage)this.getParent();
                jPropertyPage.setObject();
                jPropertyPage.repaint();
            }
        } else if (object == this.seriesLabelField) {
            this.series.setLabel((String)object2);
        } else if (object == this.yValueField) {
            int n2 = this.numPointsSpin.getIntValue();
            this.series.editPoint(n2, (Double)object2);
        } else if (object == this.dataHoleField) {
            if (this.view != null) {
                double d2 = (Double)object2;
                this.view.setHoleValue(d2);
            }
        } else if (object == this.firstPointField) {
            Double d3 = (Double)object2;
            try {
                this.series.setFirstPoint(d3.intValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DataViewDataPage.showError(illegalArgumentException.getMessage());
            }
        } else if (object == this.lastPointField) {
            Double d4 = (Double)object2;
            try {
                this.series.setLastPoint(d4.intValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DataViewDataPage.showError(illegalArgumentException.getMessage());
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.numPointsSpin.getScrollBar()) {
            this.numPointsSpin.setIntValue(adjustmentEvent.getValue());
            this.currentPoint = this.numPointsSpin.getIntValue();
            this.setObject(this.series);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(DataViewDataPage.getPageTitle());
        serializable = new DataViewDataPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((DataViewDataPage)serializable).init();
        ((DataViewDataPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        jFrame.setSize(dimension.width + 200, dimension.height + 100);
        jFrame.setVisible(true);
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key151");
    }

    public static String getPageName() {
        return "DataViewDataPage";
    }
}

