/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.JCChartBeanBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class RadioEditor
extends JPanel
implements PropertyEditor,
ItemListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected ButtonGroup radioG;
    protected JRadioButton[] radioB;
    protected int radioSel = -1;
    protected int numOfRadios = 0;
    protected String[] radioNames = null;
    protected String radioTitle = null;
    protected String propertyTitle = null;
    Object valueObj = null;

    public RadioEditor(String string, String[] stringArray) {
        this.numOfRadios = stringArray.length;
        this.radioNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.radioNames, 0, stringArray.length);
        this.radioTitle = string;
        this.init();
    }

    protected void init() {
        if (this.radioNames == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.radioTitle));
        jPanel.setLayout(new GridLayout(1, this.radioNames.length));
        this.radioG = new ButtonGroup();
        this.radioB = new JRadioButton[this.radioNames.length];
        for (int i2 = 0; i2 < this.radioNames.length; ++i2) {
            this.radioB[i2] = new JRadioButton(this.radioNames[i2]);
            this.radioG.add(this.radioB[i2]);
            jPanel.add(this.radioB[i2]);
            this.radioB[i2].addItemListener(this);
        }
        this.radioB[0].setSelected(true);
        this.add("North", jPanel);
        JPanel jPanel2 = this.makePropertyPanel();
        if (jPanel2 != null) {
            this.add("Center", jPanel2);
        }
    }

    protected abstract JPanel makePropertyPanel();

    public void setValue(Object object) {
        this.valueObj = object;
    }

    protected void switchItem(JRadioButton jRadioButton) {
        if (this.radioB == null) {
            return;
        }
        for (int i2 = 0; i2 < this.radioB.length; ++i2) {
            if (jRadioButton != this.radioB[i2]) continue;
            this.radioSel = i2;
            this.switchValues(this.radioSel);
            break;
        }
    }

    protected abstract void switchValues(int var1);

    public Object getValue() {
        return this.valueObj;
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "\"" + this.valueObj + "\"";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(200, 0);
        return dimension;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n2);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (itemEvent.getStateChange() == 1) {
                this.switchItem(jRadioButton);
            }
        }
    }

    public void setIntIsDefProperty(String string, int[] nArray, boolean[] blArray, int n2) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n2]) {
                blArray[n2] = true;
                nArray[n2] = Integer.MAX_VALUE;
                this.support.firePropertyChange("", null, null);
            }
        } else {
            int n3 = Integer.valueOf(string2);
            if (n3 != nArray[n2]) {
                nArray[n2] = n3;
                blArray[n2] = false;
                this.support.firePropertyChange("", null, null);
            }
        }
    }

    public void setIntProperty(String string, int[] nArray, int n2) {
        this.setIntProperty(string, nArray, n2, 0);
    }

    public void setIntProperty(String string, int[] nArray, int n2, int n3) {
        String string2 = this.checkForEmptyString(string);
        int n4 = string2 != null ? Integer.valueOf(string2) : n3;
        if (n4 != nArray[n2]) {
            nArray[n2] = n4;
            this.support.firePropertyChange("", null, null);
        }
    }

    public void setDoubleIsDefProperty(String string, double[] dArray, boolean[] blArray, int n2) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n2]) {
                blArray[n2] = true;
                dArray[n2] = Double.MAX_VALUE;
                this.support.firePropertyChange("", null, null);
            }
        } else {
            double d2 = Double.valueOf(string2);
            if (d2 != dArray[n2]) {
                dArray[n2] = d2;
                blArray[n2] = false;
                this.support.firePropertyChange("", null, null);
            }
        }
    }

    public void setDoubleProperty(String string, double[] dArray, int n2) {
        this.setDoubleProperty(string, dArray, n2, 0.0);
    }

    public void setDoubleProperty(String string, double[] dArray, int n2, double d2) {
        String string2 = this.checkForEmptyString(string);
        double d3 = string2 != null ? Double.valueOf(string2) : d2;
        if (d3 != dArray[n2]) {
            dArray[n2] = d3;
            this.support.firePropertyChange("", null, null);
        }
    }

    public void setStringIsDefProperty(String string, String[] stringArray, boolean[] blArray, int n2) {
        String string2 = this.checkForEmptyString(string);
        if (string2 == null) {
            if (!blArray[n2]) {
                blArray[n2] = true;
                stringArray[n2] = "";
                this.support.firePropertyChange("", null, null);
            }
        } else if (!string2.equals(stringArray[n2])) {
            stringArray[n2] = string2;
            blArray[n2] = false;
            this.support.firePropertyChange("", null, null);
        }
    }

    public String checkForEmptyString(String string) {
        String string2;
        String string3 = string2 = string == null ? null : string.trim();
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }
}

