/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.beans.ColorEditorPanel;
import com.klg.jclass.chart.beans.BaseEditor;
import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.OutlineStyleWrapper;
import com.klg.jclass.util.style.JCStyleEnumMappings;
import com.klg.jclass.util.swing.JCColumnLayout;
import com.klg.jclass.util.swing.JCSpinNumberBox;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OutlineStyleEditor
extends BaseEditor
implements ActionListener,
FocusListener,
PropertyChangeListener,
JCValueListener {
    protected JCSpinNumberBox sbWidth;
    protected ColorEditorPanel colorEditor;
    protected JComboBox comboPattern;
    protected JComboBox comboJoin;
    protected JComboBox comboCap;
    protected int[] patternValues = JCStyleEnumMappings.linePattern_values;
    protected int[] joinValues = JCStyleEnumMappings.lineJoin_values;
    protected int[] capValues = JCStyleEnumMappings.lineCap_values;
    OutlineStyleWrapper wrap = null;

    protected void setEnumArrays() {
    }

    protected JPanel makePropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key164")));
        jPanel.setLayout(new JCColumnLayout(0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 15, 5, 10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.add(new JLabel("Width: "));
        this.sbWidth = new JCSpinNumberBox();
        this.sbWidth.setValueRange(new Integer(0), new Integer(10000));
        this.sbWidth.addValueListener(this);
        gridBagLayout.setConstraints(this.sbWidth, gridBagConstraints);
        jPanel2.add(this.sbWidth);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key206") + ": "));
        this.colorEditor = new ColorEditorPanel();
        this.colorEditor.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.colorEditor, gridBagConstraints);
        jPanel3.add(this.colorEditor);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        this.comboPattern = new JComboBox<String>(JCStyleEnumMappings.linePattern_i18n_strings);
        this.comboPattern.addActionListener(this);
        jPanel4.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key207") + ": "));
        gridBagLayout.setConstraints(this.comboPattern, gridBagConstraints);
        jPanel4.add(this.comboPattern);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        this.comboJoin = new JComboBox<String>(JCStyleEnumMappings.lineJoin_i18n_strings);
        this.comboJoin.addActionListener(this);
        jPanel5.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key297") + ": "));
        gridBagLayout.setConstraints(this.comboJoin, gridBagConstraints);
        jPanel5.add(this.comboJoin);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(gridBagLayout);
        this.comboCap = new JComboBox<String>(JCStyleEnumMappings.lineCap_i18n_strings);
        this.comboCap.addActionListener(this);
        jPanel6.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key298") + ": "));
        gridBagLayout.setConstraints(this.comboCap, gridBagConstraints);
        jPanel6.add(this.comboCap);
        jPanel.add(jPanel6);
        this.add("Center", jPanel);
        return jPanel;
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (OutlineStyleWrapper)object;
            }
            catch (ClassCastException classCastException) {
                this.wrap = new OutlineStyleWrapper();
            }
        }
        if (this.wrap == null) {
            this.wrap = new OutlineStyleWrapper();
        }
        this.switchValues();
    }

    protected void switchValues() {
        int n2;
        if (this.wrap == null) {
            return;
        }
        if (this.sbWidth != null) {
            this.sbWidth.setValue(new Integer(this.wrap.width));
        }
        if (this.colorEditor != null) {
            this.colorEditor.setValue(this.wrap.color);
        }
        if (this.comboPattern != null && (n2 = this.indexOf(this.patternValues, this.wrap.pattern)) >= 0) {
            this.comboPattern.setSelectedIndex(n2);
        }
        if (this.comboJoin != null && (n2 = this.indexOf(this.joinValues, this.wrap.join)) >= 0) {
            this.comboJoin.setSelectedIndex(n2);
        }
        if (this.comboCap != null && (n2 = this.indexOf(this.capValues, this.wrap.cap)) >= 0) {
            this.comboCap.setSelectedIndex(n2);
        }
    }

    protected int indexOf(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public Object getValue() {
        return this.wrap;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 5) {
            throw new IllegalArgumentException();
        }
        try {
            int n2 = Integer.parseInt((String)vector.elementAt(0));
            Color color = JCSwingTypeConverter.toColor((String)vector.elementAt(1));
            int n3 = Integer.parseInt((String)vector.elementAt(2));
            int n4 = Integer.parseInt((String)vector.elementAt(3));
            int n5 = Integer.parseInt((String)vector.elementAt(4));
            OutlineStyleWrapper outlineStyleWrapper = new OutlineStyleWrapper(n2, color, n3, n4, n5);
            this.setValue(outlineStyleWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.OutlineStyleWrapper(" + this.wrap + ")";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 450;
        return dimension;
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        Object object = jCValueEvent.getSource();
        if (object instanceof JCSpinNumberBox) {
            this.checkProperties(object);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JCSpinNumberBox) {
            this.checkProperties(object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            this.checkProperties(object);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ColorEditorPanel) {
            this.checkProperties(object);
        }
    }

    public void checkProperties(Object object) {
        try {
            Color color;
            if (object == this.sbWidth) {
                int n2 = this.sbWidth.getValue().intValue();
                if (n2 < 0) {
                    n2 = 0;
                    this.sbWidth.setValue(new Integer(n2));
                }
                if (this.wrap.width != n2) {
                    this.wrap.width = n2;
                    this.support.firePropertyChange("", null, null);
                }
            } else if (object == this.comboPattern) {
                int n3;
                int n4 = this.comboPattern.getSelectedIndex();
                if (n4 >= 0 && this.wrap.pattern != (n3 = this.patternValues[n4])) {
                    this.wrap.pattern = n3;
                    this.support.firePropertyChange("", null, null);
                }
            } else if (object == this.comboJoin) {
                int n5;
                int n6 = this.comboJoin.getSelectedIndex();
                if (n6 >= 0 && this.wrap.join != (n5 = this.joinValues[n6])) {
                    this.wrap.join = n5;
                    this.support.firePropertyChange("", null, null);
                }
            } else if (object == this.comboCap) {
                int n7;
                int n8 = this.comboCap.getSelectedIndex();
                if (n8 >= 0 && this.wrap.cap != (n7 = this.capValues[n8])) {
                    this.wrap.cap = n7;
                    this.support.firePropertyChange("", null, null);
                }
            } else if (object == this.colorEditor && !(color = (Color)this.colorEditor.getValue()).equals(this.wrap.color)) {
                this.wrap.color = color;
                this.support.firePropertyChange("", null, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

