/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataRange;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.util.JCUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLineState
implements LegendEntry,
Cloneable,
Serializable {
    protected String label = null;
    protected JCChartStyle chartStyle = null;
    protected boolean visibleInLegend = false;
    protected ChartDataView dataView = null;
    protected boolean clearState = false;
    protected List<JCDataRange> dataRanges = new Vector<JCDataRange>();

    public TimeLineState() {
        this(null, null, null, false, false, null);
    }

    public TimeLineState(ChartDataView chartDataView, String string, JCChartStyle jCChartStyle, boolean bl) {
        this(chartDataView, string, jCChartStyle, bl, false, null);
    }

    public TimeLineState(ChartDataView chartDataView, String string, JCChartStyle jCChartStyle, boolean bl, boolean bl2, JCDataRange jCDataRange) {
        this.dataView = chartDataView;
        this.label = string;
        if (jCChartStyle == null && !bl2) {
            jCChartStyle = this.createDefaultChartStyle();
        }
        this.chartStyle = jCChartStyle;
        this.visibleInLegend = bl;
        this.clearState = bl2;
        if (jCDataRange == null) {
            jCDataRange = this.createDefaultDataRange();
        }
        this.addDataRange(jCDataRange);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public JCChartStyle getChartStyle() {
        return this.chartStyle;
    }

    public void setChartStyle(JCChartStyle jCChartStyle) {
        this.chartStyle = jCChartStyle == null ? this.createDefaultChartStyle() : jCChartStyle;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public void setVisibleInLegend(boolean bl) {
        this.visibleInLegend = bl;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    @Override
    public boolean isVisibleInLegend() {
        return !this.clearState && this.visibleInLegend;
    }

    public boolean isClearState() {
        return this.clearState;
    }

    public void setClearState(boolean bl) {
        this.clearState = bl;
        if (!bl && this.chartStyle == null) {
            this.chartStyle = this.createDefaultChartStyle();
        }
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    @Override
    public int getDrawType() {
        return 4;
    }

    public List<JCDataRange> getDataRanges() {
        return this.dataRanges;
    }

    public JCDataRange getDataRange(int n2) {
        if (n2 < 0 || n2 >= this.dataRanges.size()) {
            throw new IllegalArgumentException("Invalid data range index");
        }
        return this.dataRanges.get(n2);
    }

    public int getNumDataRanges() {
        return this.dataRanges.size();
    }

    public void addDataRange(JCDataRange jCDataRange) {
        if (jCDataRange == null) {
            return;
        }
        this.dataRanges.add(jCDataRange);
        jCDataRange.setParent(this);
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public void addDataRange(int n2, JCDataRange jCDataRange) {
        if (jCDataRange == null) {
            return;
        }
        if (n2 < 0 || n2 > this.dataRanges.size()) {
            throw new IllegalArgumentException("Invalid data range index");
        }
        this.dataRanges.add(n2, jCDataRange);
        jCDataRange.setParent(this);
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public void removeDataRange(JCDataRange jCDataRange) {
        if (jCDataRange == null) {
            return;
        }
        this.dataRanges.remove(jCDataRange);
        jCDataRange.setParent(null);
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public JCDataRange removeDataRange(int n2) {
        if (n2 < 0 || n2 >= this.dataRanges.size()) {
            throw new IllegalArgumentException("Invalid data range index");
        }
        JCDataRange jCDataRange = this.dataRanges.remove(n2);
        if (jCDataRange != null) {
            jCDataRange.setParent(null);
        }
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
        return jCDataRange;
    }

    public void removeAllDataRanges() {
        for (JCDataRange jCDataRange : this.dataRanges) {
            if (jCDataRange == null) continue;
            jCDataRange.setParent(null);
        }
        this.dataRanges.clear();
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    protected JCDataRange createDefaultDataRange() {
        if (this.dataView != null) {
            double d2 = this.dataView.getNumTimeLineStates();
            return new JCDataRange(d2, d2);
        }
        return null;
    }

    protected JCChartStyle createDefaultChartStyle() {
        if (this.dataView != null) {
            return JCChartStyle.makeDefault(this.dataView.getParent());
        }
        return JCChartStyle.makeDefault(null);
    }

    @Override
    public ChartDataView getParent() {
        return this.dataView;
    }

    public void setParent(ChartDataView chartDataView) {
        this.dataView = chartDataView;
    }

    public double getDataValue() {
        for (JCDataRange jCDataRange : this.dataRanges) {
            double d2;
            if (jCDataRange == null || (d2 = jCDataRange.getValueInRange()) == Double.NaN) continue;
            return d2;
        }
        return Double.NaN;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.chartStyle == null ? 0 : this.chartStyle.hashCode();
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + ((Object)this.dataRanges).hashCode();
        int n4 = this.label == null ? 0 : this.label.hashCode();
        n2 = 37 * n2 + n4;
        n2 = 37 * n2 + (this.clearState ? 1231 : 1237);
        n2 = 37 * n2 + (this.visibleInLegend ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        TimeLineState timeLineState;
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass()) && (this == (timeLineState = (TimeLineState)object) || JCChartStyle.equalChartStyles(this.chartStyle, timeLineState.getChartStyle()) && this.clearState == timeLineState.isClearState() && this.visibleInLegend == timeLineState.isVisibleInLegend() && ((Object)this.dataRanges).equals(timeLineState.getDataRanges()) && JCUtil.equalStrings(this.label, timeLineState.getLabel()))) {
            bl = true;
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        TimeLineState timeLineState = (TimeLineState)super.clone();
        timeLineState.label = this.label;
        timeLineState.chartStyle = (JCChartStyle)this.chartStyle.clone();
        timeLineState.visibleInLegend = this.visibleInLegend;
        Vector<JCDataRange> vector = new Vector<JCDataRange>();
        for (JCDataRange jCDataRange : this.dataRanges) {
            JCDataRange jCDataRange2 = (JCDataRange)jCDataRange.clone();
            jCDataRange2.setParent(timeLineState);
            vector.add(jCDataRange2);
        }
        timeLineState.dataRanges = vector;
        timeLineState.clearState = this.clearState;
        timeLineState.dataView = null;
        return timeLineState;
    }

    public String toString() {
        return "TimeLineState: label=" + this.label + ", chartStyle=" + this.chartStyle + ", visibleInLegend=" + this.visibleInLegend + ", dataView=" + this.dataView + ", clearState=" + this.clearState + ", dataRanges=" + this.dataRanges;
    }
}

