/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCGrid;
import com.klg.jclass.chart.LinearAxisHandler;
import com.klg.jclass.chart.LinearAxisScaleHandler;
import com.klg.jclass.chart.LinearAxisUtil;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.RectangularChartAxisHandler;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;

class RectangularChartLinearAxisHandler
extends RectangularChartAxisHandler
implements LinearAxisHandler {
    RectangularChartLinearAxisHandler() {
        this.axisScaleHandler = new LinearAxisScaleHandler();
    }

    protected double toData(int n2) {
        double d2;
        double d3 = d2 = this.parent.i_vertical ? ((double)(this.parent.getHeight() - n2) - this.shift) / this.scale : ((double)n2 - this.shift) / this.scale;
        if (this.parent.hasTimeExclusions()) {
            d2 = this.adjustValueAddExclusions(this.parent.min.value, this.parent.max.value, d2);
        }
        return d2;
    }

    protected double toScreenLocation(double d2) {
        return this.toScreenLocationInternal(d2, AxisHandler.ClusterAdjustment.NONE);
    }

    protected double toScreenLocationInternal(double d2, AxisHandler.ClusterAdjustment clusterAdjustment) {
        if (this.parent.hasTimeExclusions()) {
            long l2 = this.parent.getTimeUnit();
            if (clusterAdjustment == AxisHandler.ClusterAdjustment.NONE) {
                AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
                Date date = annotationHandler.dataToTime(d2, l2);
                annotationHandler.getDateFormatter().roundTime(date, 1000L, JCChartDateFormat.AdjustType.ZERO);
                if (this.isTimeExcluded(date)) {
                    return Double.MAX_VALUE;
                }
            }
            double d3 = this.parent.getMin();
            d3 = this.adjustValueForward(d3, this.parent.getMax());
            double d4 = this.getDaylightSavingsTimeCorrection(d3, d2, l2, true);
            d2 = this.adjustValueRemExclusions(d3, d2, clusterAdjustment);
            d2 += d4;
        }
        return this.scale * d2 + this.shift;
    }

    protected int toPixel(double d2) {
        return this.toPixelInternal(d2, AxisHandler.ClusterAdjustment.NONE);
    }

    protected int toPixelInternal(double d2, AxisHandler.ClusterAdjustment clusterAdjustment) {
        if ((d2 = this.toScreenLocationInternal(d2, clusterAdjustment)) == Double.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n2 = (d2 += 0.5) >= 0.0 ? (int)d2 : (int)Math.floor(d2);
        return this.parent.i_vertical ? this.parent.getHeight() - n2 : n2;
    }

    protected double toPixelDouble(double d2) {
        if ((d2 = this.toScreenLocation(d2)) == Double.MAX_VALUE) {
            return d2;
        }
        return this.parent.i_vertical ? (double)this.parent.getHeight() - d2 : d2;
    }

    protected void calcParams() {
        JCGrid jCGrid;
        List<JCGrid> list;
        double d2;
        double d3;
        double d4;
        if (this.parent == null) {
            return;
        }
        int n2 = this.parent.chartType;
        boolean bl = n2 == 9 || n2 == 10;
        boolean bl2 = n2 == 5 || n2 == 6;
        boolean bl3 = n2 == 7;
        boolean bl4 = n2 == 13;
        MinMax minMax = this.parent.dataLimits;
        double d5 = minMax == null ? 0.0 : minMax.min;
        double d6 = minMax == null ? 100.0 : minMax.max;
        double d7 = d5;
        double d8 = d6;
        DerivedDouble derivedDouble = this.parent.numSpacing;
        double d9 = derivedDouble.value;
        DerivedDouble derivedDouble2 = this.parent.tickSpacing;
        double d10 = derivedDouble2.value;
        do {
            this.calcPrecision();
        } while (this.axisScaleHandler.fixBounds());
        double d11 = d8;
        double d12 = d7;
        int n3 = this.parent.getPrecision();
        d7 = JCChartUtil.precFloor(n3, d7);
        if ((d8 = JCChartUtil.precCeil(n3, d8)) <= d7) {
            n3 = this.parent.getPrecision();
            if (this.parent.max.isDefault) {
                do {
                    d8 = d7 + JCChartUtil.pow10(-n3);
                    --n3;
                } while (d8 <= d7);
            } else {
                do {
                    d7 = d8 - JCChartUtil.pow10(-n3);
                    --n3;
                } while (d8 <= d7);
            }
        }
        d7 = this.parent.min.isDefault ? d7 : this.parent.min.value;
        d8 = this.parent.max.isDefault ? d8 : this.parent.max.value;
        double d13 = this.calcOrigin(d7, d8);
        double d14 = this.parent.min.isDefault ? JCChartUtil.min(d7, d13) : d7;
        double d15 = this.parent.max.isDefault ? JCChartUtil.max(d8, d13) : d8;
        boolean bl5 = false;
        int n4 = this.parent.getAnnotationMethod();
        for (int i2 = 0; i2 < 2 && !bl5; ++i2) {
            d4 = LinearAxisUtil.calcMinUsed(this.parent, d7, d13);
            d3 = LinearAxisUtil.calcMaxUsed(this.parent, d8, d13);
            d7 = d4;
            d8 = d3;
            d2 = 0.5 * JCChartUtil.pow10(-this.parent.getPrecision() - 1);
            d9 = derivedDouble.value;
            d10 = derivedDouble2.value;
            int n5 = this.calcMaxAnnoSize(d7, d8);
            if (derivedDouble.isDefault && derivedDouble2.isDefault) {
                if (this.parent.getAnnotationRotation() == 4) {
                    n5 = this.calcRotatedAnnoSpacing(d7, d8);
                }
                int n6 = n5 == 0 ? 0 : this.parent.pixelLength() / (n5 + this.parent.gap + 2);
                double d16 = JCChartUtil.abs(d3 - d4);
                if (n6 <= 0) {
                    d9 = 1.0;
                    d10 = 1.0;
                } else {
                    double d17 = d16 / (double)n6;
                    DoubleCoord doubleCoord = JCChartUtil.calcTik(d17, this.parent.getPrecision(), d16, this.parent.isAnnotateToRange());
                    d10 = doubleCoord.x;
                    d9 = doubleCoord.y;
                }
            } else if (derivedDouble2.isDefault) {
                d9 = JCChartUtil.precCorrect(this.parent.getPrecision(), d9);
                double d18 = derivedDouble.value;
                d10 = n4 == 0 ? d18 / 2.0 : d18;
            } else if (derivedDouble.isDefault) {
                d9 = 2.0 * d10;
                d9 = JCChartUtil.precCorrect(this.parent.getPrecision(), d9);
            }
            if (d9 != 0.0) {
                if (n2 != 13) {
                    d7 = LinearAxisUtil.updateMinValue(d7, d13, d9);
                    if (JCChartUtil.abs((d8 = LinearAxisUtil.updateMaxValue(d8, d13, d9)) - d7) < d2) {
                        d8 = d7 + d9;
                    }
                }
            } else if (JCChartUtil.abs(d8 - d7) < d2) {
                d8 = d7 + 1.0;
            }
            if (!(JCChartUtil.abs(d7 - d4) > d2) && !(JCChartUtil.abs(d8 - d3) > d2)) continue;
            bl5 = true;
            if (d8 - d9 >= d15) {
                d8 -= d9;
            } else {
                bl5 = false;
            }
            if (d7 + d9 <= d14) {
                d7 += d9;
                continue;
            }
            bl5 = false;
        }
        if (!this.parent.i_vertical && n4 == 2) {
            d8 = d6;
            d7 = d5;
            if (d8 <= d7) {
                n3 = 0;
                do {
                    d8 = d7 + JCChartUtil.pow10(n3);
                    d7 -= d8 - d7;
                    ++n3;
                } while (d8 <= d7);
            }
            d14 = d7;
            d15 = d8;
        }
        MinMax minMax2 = this.parent.originalDataLimits;
        if (minMax != null && minMax2 != null && (n4 == 3 && (this.parent.isPrimary || bl4) || this.parent.isPrimary && (bl || bl2 || bl3))) {
            d4 = d12;
            d3 = d11;
            d2 = 0.0;
            double d19 = 100.0;
            if (minMax2 != null) {
                d2 = minMax2.min;
                d19 = minMax2.max;
            }
            if (this.parent.min.isDefault) {
                d4 = d2 - this.parent.step / 2.0;
            }
            if (this.parent.max.isDefault) {
                d3 = d19 + this.parent.step / 2.0;
            }
            if (d4 < minMax.min) {
                d7 = d14 = JCChartUtil.min(d12, d4);
            }
            if (d3 > minMax.max) {
                d8 = d15 = JCChartUtil.max(d11, d3);
            }
        }
        if (this.parent.hasTimeExclusions()) {
            d7 = this.adjustValueForward(d7, d8);
            d8 = this.adjustValueBackward(d8, d7);
            d14 = d7;
            d15 = d8;
        }
        LinearAxisUtil.setAxisMinMax(this.parent, d7, d8, d14, d15);
        d13 = this.calcOrigin(this.parent.min.value, this.parent.max.value);
        if (this.parent.origin.isDefault) {
            this.parent.origin.value = d13;
        }
        if (derivedDouble2.isDefault) {
            derivedDouble2.value = d10;
        }
        if (derivedDouble.isDefault) {
            derivedDouble.value = d9;
        }
        if ((list = this.parent.getGridList()).size() > 0 && (jCGrid = list.get(0)) != null && jCGrid.getIncrementIsDefault()) {
            jCGrid.incrementValue.value = derivedDouble.value;
        }
    }

    protected void calcTransformation() {
        int n2 = Math.max(this.parent.pixelLength(), 1);
        this.computeTransformation(this.parent.min.value, this.parent.max.value, n2);
    }

    private int calcMaxAnnoSize(double d2, double d3) {
        Dimension dimension = new Dimension();
        if (this.parent.getAnnotationRotation() == 4 && this.parent.getAnnotationMethod() != 0) {
            dimension = this.parent.getAnnotationHandler().getMaxRotatedAnnoDimensions();
        } else {
            this.getAnnoExtent(dimension, d3, this.parent.getPrecision());
            this.getAnnoExtent(dimension, d2, this.parent.getPrecision());
        }
        if (this.parent.i_vertical) {
            int n2 = this.parent.visible ? dimension.width + 1 + this.parent.tickLength / 2 : 0;
            this.parent.setSize(n2, this.parent.getHeight());
        } else {
            int n3 = this.parent.visible ? dimension.height + 1 + this.parent.tickLength / 2 : 0;
            this.parent.setSize(this.parent.getWidth(), n3);
        }
        return this.parent.i_vertical ? dimension.height : dimension.width;
    }
}

