/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.XYProjection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

abstract class RectangularChartAxisHandler
extends AxisHandler {
    RectangularChartAxisHandler() {
    }

    protected void drawTickMark(Graphics graphics, JCValueLabel jCValueLabel, int n2) {
        JCAnno jCAnno;
        if (jCValueLabel != null && (jCAnno = jCValueLabel.getAnno()) != null && jCAnno.getDrawTicks()) {
            boolean bl = this.parent.getAnnotationMethod() == 2;
            double d2 = this.parent.max.value;
            if (this.parent.hasTimeExclusions()) {
                d2 = this.adjustValueBackward(this.parent.max.value, this.parent.min.value);
            }
            double d3 = bl ? 0.0 : JCChartUtil.calcError(jCAnno.getPrecision());
            double d4 = jCValueLabel.getValue();
            if (this.parent.hasTimeExclusions()) {
                d4 = JCChartUtil.precCorrect(5, d4);
            }
            if (this.parent.usingDoublePixels) {
                double d5 = this.parent.toPixelDouble(d4);
                if (d4 >= this.parent.min.value - d3 && d4 <= d2 + d3) {
                    this.drawTick(graphics, n2, d5, jCAnno);
                }
            } else {
                int n3 = this.parent.toPixel(d4);
                if (d4 >= this.parent.min.value - d3 && d4 <= d2 + d3) {
                    this.drawTick(graphics, n2, n3, jCAnno);
                }
            }
        }
    }

    protected void drawTick(Graphics graphics, int n2, int n3, JCAnno jCAnno) {
        boolean bl;
        int n4 = (int)Math.round(this.getInnerExtent(jCAnno));
        int n5 = (int)Math.round(this.getOuterExtent(jCAnno));
        if (this.parent.isReversed()) {
            n4 *= -1;
            n5 *= -1;
        }
        Color color = graphics.getColor();
        Color color2 = this.getTickColor(jCAnno);
        boolean bl2 = bl = color2 != null && !color2.equals(color);
        if (bl) {
            graphics.setColor(color2);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.parent.i_vertical) {
            graphics2D.drawLine(n2 + n4, n3, n2 - n5, n3);
        } else {
            graphics2D.drawLine(n3, n2 - n4, n3, n2 + n5);
        }
        if (bl) {
            graphics.setColor(color);
        }
    }

    protected void drawTick(Graphics graphics, int n2, double d2, JCAnno jCAnno) {
        boolean bl;
        double d3 = this.getInnerExtent(jCAnno);
        double d4 = this.getOuterExtent(jCAnno);
        if (this.parent.isReversed()) {
            d3 *= -1.0;
            d4 *= -1.0;
        }
        Color color = graphics.getColor();
        Color color2 = this.getTickColor(jCAnno);
        boolean bl2 = bl = color2 != null && !color2.equals(color);
        if (bl) {
            graphics.setColor(color2);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.parent.i_vertical) {
            graphics2D.draw(new Line2D.Double((double)n2 + d3, d2, (double)n2 - d4, d2));
        } else {
            graphics2D.draw(new Line2D.Double(d2, (double)n2 - d3, d2, (double)n2 + d4));
        }
        if (bl) {
            graphics.setColor(color);
        }
    }

    protected void getAnnoExtent(Dimension dimension, double d2, int n2) {
        Dimension dimension2 = this.getAnnoDimension(d2, n2);
        if (dimension2 == null) {
            return;
        }
        if (this.parent.getAnnotationRotation() == 4) {
            int n3;
            double d3 = this.parent.getAnnotationRotationAngle(2);
            AnnotationHandler annotationHandler = this.parent.getAnnotationHandler();
            XYProjection xYProjection = annotationHandler.getXYProjection(dimension2.width, dimension2.height, d3);
            int n4 = (int)Math.round(xYProjection.x1 + xYProjection.x2);
            if (dimension.width < n4) {
                dimension.width = n4;
            }
            if (dimension.height < (n3 = (int)Math.round(xYProjection.y1 + xYProjection.y2))) {
                dimension.height = n3;
            }
        } else {
            this.getAnnotationExtent(dimension, d2, n2);
        }
    }

    protected abstract double toData(int var1);

    protected abstract int toPixel(double var1);

    protected abstract int toPixelInternal(double var1, AxisHandler.ClusterAdjustment var3);

    protected abstract double toPixelDouble(double var1);
}

