/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaRadarChartDraw;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.PolarChartDraw;
import java.awt.Point;
import java.awt.geom.Line2D;

public class RadarChartDraw
extends PolarChartDraw {
    protected int firstPoint = Integer.MIN_VALUE;
    protected int lastPoint = Integer.MAX_VALUE;
    double thetaEditPoint = 0.0;

    public RadarChartDraw() {
        this.isRadar = true;
    }

    public void recalc(int n2, int n3, int n4) {
        super.recalc(n2, n3, n4);
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.firstPoint = Integer.MIN_VALUE;
        this.lastPoint = Integer.MAX_VALUE;
        int n5 = n4 == -1 ? 0 : n4;
        int n6 = n4 == -1 ? this.seriesList.size() : n4 + 1;
        for (int i2 = n5; i2 < n6; ++i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            int n7 = chartDataViewSeries.getFirstPoint();
            if (n7 > this.firstPoint) {
                this.firstPoint = n7;
            }
            if ((n7 = chartDataViewSeries.getLastPoint()) >= this.lastPoint) continue;
            this.lastPoint = n7;
        }
    }

    protected PlotPoint getPlotPoint(int n2, int n3, double d2, double d3) {
        PlotPoint plotPoint = new PlotPoint();
        if (this.xaxis != null && this.yaxis != null && d3 != this.holeValue) {
            double d4 = JCChartUtil.getRadarAngle(2, n3, n2, false);
            Point point = this.yaxis.toPixelPolar(d4, d3, true);
            plotPoint.px = point.x;
            plotPoint.py = point.y;
            plotPoint.drawPoint = true;
            plotPoint.valid = true;
        } else {
            plotPoint.px = 2.147483647E9;
            plotPoint.py = 2.147483647E9;
            plotPoint.drawPoint = false;
            plotPoint.valid = false;
        }
        return plotPoint;
    }

    protected double getThetaValue(int n2, int n3, int n4, double[] dArray) {
        int n5 = n4 - n3 + 1;
        return JCChartUtil.getRadarAngle(2, n5, n2 - n3, false);
    }

    protected int getFirstPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.firstPoint;
    }

    protected int getLastPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.lastPoint;
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        double d2 = chartDataViewSeries.getY(n2);
        int[] nArray = ChartDataView.getFirstLastPoints(this.dataObject);
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = n5 - n4 + 1;
        double d3 = JCChartUtil.getRadarAngle(2, n6, n2 - n4, false);
        if (this.yaxis != null && d2 != this.holeValue && d3 != this.holeValue) {
            return this.yaxis.toPixelPolar(d3, d2, true);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        this.last = null;
        this.next = null;
        this.prev = null;
        int[] nArray = ChartDataView.getFirstLastPoints(this.dataObject);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = n3 - n2 + 1;
        int n5 = jCDataIndex.point;
        double d3 = jCDataIndex.series.getX(n5);
        double d4 = jCDataIndex.series.getY(n5);
        if (this instanceof AreaRadarChartDraw) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        }
        if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != this.dataObject.getHoleValue() && d4 != this.dataObject.getHoleValue()) {
            double d5;
            this.thetaEditPoint = d5 = JCChartUtil.getRadarAngle(2, n4, n5 - n2, this.xaxis.isReversed());
            double d6 = this.yaxis.isReversed() ? this.yaxis.min.value : this.yaxis.max.value;
            double d7 = JCChartUtil.boundAngle(2, d5 + 1.5707963267948966);
            Point point = this.yaxis.toPixelPolar(d7, d6, true);
            d7 = JCChartUtil.boundAngle(2, d5 - 1.5707963267948966);
            Point point2 = this.yaxis.toPixelPolar(d7, d6, true);
            this.perpendicular = new Line2D.Double(point.x, point.y, point2.x, point2.y);
        }
        int n6 = n5 - 1 < n2 ? n3 : n5 - 1;
        d3 = jCDataIndex.series.getX(n6);
        d4 = jCDataIndex.series.getY(n6);
        if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != this.dataObject.getHoleValue() && d4 != this.dataObject.getHoleValue()) {
            d2 = JCChartUtil.getRadarAngle(2, n4, n6 - n2, this.xaxis.isReversed());
            this.prev = this.yaxis.toPixelPolar(d2, d4, true);
        }
        n6 = n5 + 1 > n3 ? n2 : n5 + 1;
        d3 = jCDataIndex.series.getX(n6);
        d4 = jCDataIndex.series.getY(n6);
        if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != this.dataObject.getHoleValue() && d4 != this.dataObject.getHoleValue()) {
            d2 = JCChartUtil.getRadarAngle(2, n4, n6 - n2, this.xaxis.isReversed());
            this.next = this.yaxis.toPixelPolar(d2, d4, true);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d2 = this.perpendicular.ptLineDist(n2, n3);
        int n4 = this.perpendicular.relativeCCW(n2, n3);
        if (n4 == -1) {
            d2 *= -1.0;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getYAxis();
        this.last = jCAxis.toPixelPolar(this.thetaEditPoint, d2, false);
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }
}

