/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.PickShapePie;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.chart.PiePercent;
import com.klg.jclass.chart.PiePosition;
import com.klg.jclass.chart.PieSortAscending;
import com.klg.jclass.chart.PieSortDescending;
import com.klg.jclass.chart.PieSortPoint;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.ProcessShapePie;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChartDraw
extends ChartDraw {
    public static final int COORD_DEFAULT_VALUE = -2;
    public static final int COORD_ZERO_SLICE = -1;
    public static final int INDEX_HOLE = -2;
    public static final int INDEX_NOT_DRAWN = -1;
    public static final int HIT_NOWHERE = 0;
    public static final int HIT_TOP = 1;
    public static final int HIT_EDGE = 2;
    public static final String ERRMSG_BIG_ERROR = "Big Error!";
    protected PieChartInfo pieInfo = null;
    protected JCPieChartFormat pcf = null;
    protected int delta_y = 0;
    protected DefineShape defineShape = null;
    protected int num_pies = 0;
    protected int num_lines = 0;
    protected int num_pies_line = 0;
    protected int box_width = 0;
    protected int box_height = 0;
    protected int pie_offset = 0;
    protected int first_point = 0;
    protected int graph_left = 0;
    protected int graph_top = 0;
    protected transient ChartText[] cLabels;
    protected int label_height = 0;
    protected int explode_offset = 0;
    protected boolean recalcTransientData = false;

    public PieChartInfo getPieChartInfo() {
        return this.pieInfo;
    }

    @Override
    public void recalc() {
        int n2;
        int n3;
        super.recalc();
        this.calcTransientData();
        this.pieInfo = (PieChartInfo)this.dataObject.getTransientData();
        Rectangle rectangle = this.chartArea.getPlotRect();
        this.graph_left = rectangle.x;
        this.graph_top = rectangle.y;
        int n4 = Math.max(rectangle.width - 1, 0);
        int n5 = Math.max(rectangle.height - 1, 0);
        int n6 = this.dataObject.getNumPointLabels();
        if (n6 > 0) {
            n3 = 0;
            for (n2 = 0; n2 < n6; ++n2) {
                String string = this.dataObject.getPointLabel(n2);
                if (string == null || string.equals("")) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                n6 = 0;
            }
        }
        this.label_height = 0;
        this.cLabels = new ChartText[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            String string = this.dataObject.getPointLabel(n3);
            if (string != null) {
                this.cLabels[n3] = new ChartText();
                this.cLabels[n3].setText(string);
                this.cLabels[n3].setParentChart((JCChart)this.chartArea.getParent());
                this.cLabels[n3].setParentRegion(this.chartArea);
                int n7 = this.cLabels[n3].getHeight();
                this.label_height = Math.max(this.label_height, n7);
                continue;
            }
            this.cLabels[n3] = null;
        }
        if (this.num_pies == 0) {
            return;
        }
        int[] nArray = this.pieLayout(this.num_pies, rectangle);
        this.num_lines = nArray[0];
        this.num_pies_line = nArray[1];
        this.box_width = n4 / this.num_pies_line;
        this.box_height = n5 / this.num_lines;
        this.explode_offset = this.pcf.getExplodeList() == null ? 0 : this.pcf.getExplodeOffset();
        n2 = this.label_height == 0 && this.explode_offset == 0 ? 3 : 2;
        int n8 = Math.max(this.box_width - this.label_height * 2 - this.explode_offset * 2 - n2, 0);
        int n9 = Math.max(this.box_height - this.label_height * 2 - this.explode_offset * 2 - n2, 0);
        double d2 = JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation()));
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = (double)this.chartArea.getDepth() / 100.0;
        int n10 = (double)n8 * (d4 + d5 * d3) < (double)n9 ? n8 : (int)((double)n9 / (d4 + d5 * d3));
        int n11 = (int)((double)n10 * d4);
        this.chartArea.setDeltaX(0);
        this.delta_y = (int)((double)n10 * d5 * d3);
        this.chartArea.setDeltaY(this.delta_y);
        if (n10 != (n10 | 1) && (n10 = (n10 | 1) - 2) < 1) {
            n10 = 1;
        }
        if (n11 != (n11 | 1) && (n11 = (n11 | 1) - 2) < 1) {
            n11 = 1;
        }
        this.pieInfo.width = n10;
        this.pieInfo.height = n11;
        this.pie_offset = (int)((double)(this.box_width - n10) / 2.0);
        if (this.pie_offset < 0) {
            this.pie_offset = 0;
        }
    }

    @Override
    public void draw(Graphics graphics) {
        if (!this.okToProceed(graphics)) {
            return;
        }
        JCLineStyle jCLineStyle = this.dataObject.getOutlineStyle();
        if (this.pcf.getOutlineStyle() == 2) {
            jCLineStyle = new JCLineStyle(1, this.chartArea.getForeground(), 1);
        }
        RenderShape renderShape = new RenderShape(graphics, jCLineStyle, null, null);
        int n2 = 0;
        int n3 = this.graph_left;
        int n4 = this.graph_top;
        for (int i2 = 0; i2 < this.num_lines; ++i2) {
            for (int i3 = 0; i3 < this.num_pies_line; ++i3) {
                if (n2 < this.num_pies) {
                    this.drawPie(renderShape, n2, n3, n4);
                }
                ++n2;
                n3 += this.box_width;
            }
            n3 = this.graph_left;
            n4 += this.box_height;
        }
        this.defineShape = null;
    }

    protected void drawSinglePie(ProcessShape processShape, Graphics graphics, int n2, int n3, int n4) {
        if (!this.okToProceed(graphics)) {
            return;
        }
        this.drawPie(processShape, n2, n3, n4);
        this.defineShape = null;
    }

    private boolean okToProceed(Graphics graphics) {
        if (graphics != null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null && (rectangle.width == 0 || rectangle.height == 0)) {
                return false;
            }
            if (graphics instanceof DefineShape) {
                this.defineShape = (DefineShape)((Object)graphics);
            }
        }
        if (this.pieInfo == null) {
            this.recalc();
        }
        return this.num_pies != 0;
    }

    protected Point getPointLabelLocation(ChartText chartText, int n2, int n3) {
        Point point = new Point();
        int n4 = n3 + (this.box_height - this.pieInfo.height - this.delta_y - this.label_height) / 2;
        if (chartText != null) {
            int n5 = chartText.getWidth();
            point.setLocation(n2 + (this.box_width - n5) / 2, n4 + this.pieInfo.height + this.delta_y + this.explode_offset);
        }
        return point;
    }

    private void drawPie(ProcessShape processShape, int n2, int n3, int n4) {
        Serializable serializable;
        int n5 = n3 + this.pie_offset;
        int n6 = n4 + (this.box_height - this.pieInfo.height - this.delta_y - this.label_height) / 2;
        if (processShape instanceof ProcessShapePie) {
            ((ProcessShapePie)((Object)processShape)).setPieData(this.pieInfo.data[n2]);
        }
        if (!this.pieInfo.data[n2].zero_pie) {
            serializable = new Rectangle2D.Double(n5, n6, this.pieInfo.width, this.pieInfo.height);
            if (this.delta_y != 0) {
                this.drawPiePlane(processShape, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n5, n6 + this.delta_y, n2, false, (Rectangle2D)((Object)serializable));
                this.drawPieEdge(processShape, this.pieInfo.data[n2], this.pieInfo, n5, n6, n2, (Rectangle2D)((Object)serializable));
            }
            this.drawPiePlane(processShape, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n5, n6, n2, true, (Rectangle2D)((Object)serializable));
            this.drawPieLines(processShape, this.pieInfo.data[n2], this.pieInfo, n5, n6, n2);
        }
        if (processShape.getShapeType() == 0 && n2 + this.first_point < this.cLabels.length) {
            serializable = (RenderShape)processShape;
            ChartText chartText = this.cLabels[n2 + this.first_point];
            if (chartText != null) {
                Point point = this.getPointLabelLocation(chartText, n3, n4);
                chartText.setLocation(point.x, point.y);
                chartText.draw(((RenderShape)serializable).getGC());
            }
        }
        if (!this.pieInfo.data[n2].zero_pie) {
            this.drawPieCircle(processShape, this.pieInfo.data[n2], this.pieInfo, n5, n6, n2);
        }
    }

    private int[] pieLayout(int n2, Rectangle rectangle) {
        int n3 = rectangle.height == 0 ? n2 : (int)Math.min((double)n2, Math.sqrt(n2) * (double)rectangle.width / (double)rectangle.height);
        if (n3 < 1) {
            n3 = 1;
        }
        double d2 = Math.ceil((double)n2 / (double)n3);
        int n4 = (int)Math.min((double)(rectangle.width / n3), (double)rectangle.height / d2);
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl) {
            int n5 = n3;
            n5 = bl2 ? ++n5 : --n5;
            if (n5 > n2) {
                if (bl3 || bl4) {
                    bl = true;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (n5 == 0) {
                bl = true;
                continue;
            }
            d2 = Math.ceil((double)n2 / (double)n5);
            int n6 = (int)Math.min((double)(rectangle.width / n5), (double)rectangle.height / d2);
            if (n6 > n4) {
                n3 = n5;
                n4 = n6;
                if (bl2) {
                    bl3 = true;
                    continue;
                }
                bl4 = true;
                continue;
            }
            if (bl3 || bl4) {
                bl = true;
                continue;
            }
            if (bl2) {
                bl2 = false;
                continue;
            }
            bl = true;
        }
        int n7 = n2 / n3;
        if ((double)n7 != (double)n2 / (double)n3) {
            // empty if block
        }
        int[] nArray = new int[]{++n7, n3};
        return nArray;
    }

    private ArrayList<Point> getExplodeAllPoints() {
        ArrayList<Point> arrayList = null;
        Point[] pointArray = this.pcf.getExplodeList();
        if (pointArray != null) {
            arrayList = new ArrayList<Point>();
            for (Point point : pointArray) {
                if (point.x != -20) continue;
                arrayList.add(point);
            }
        }
        return arrayList;
    }

    private int computeOtherSlice(List<ChartDataViewSeries> list, int n2, int n3, PieData pieData, List<Point> list2) {
        int n4;
        int n5;
        int n6 = Math.min(n3, this.pcf.getMinSlices());
        double d2 = this.pcf.getThresholdValue() / 100.0;
        double d3 = this.dataObject.getHoleValue();
        double d4 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            double d5 = chartDataViewSeries.getX(n2);
            double d6 = chartDataViewSeries.getY(n2);
            pieData.sortPoints[i2].index = i2;
            if (d6 == d3 || d5 == d3 || !chartDataViewSeries.isVisible()) {
                d6 = -1.0;
                pieData.sortPoints[i2].index = -2;
            } else if (d6 < 0.0) {
                d6 = 0.0;
            } else {
                d4 += d6;
            }
            pieData.sortPoints[i2].y = d6;
        }
        pieData.zero_pie = d4 == 0.0;
        Point[] pointArray = this.pcf.getExplodeList();
        if (pointArray != null) {
            boolean bl = false;
            for (Point point : pointArray) {
                if (point == null || point.x != n2 && point.x != -20 || point.y != -20) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (int i3 = 0; i3 < pieData.exploded.length; ++i3) {
                    pieData.exploded[i3] = true;
                }
            } else {
                for (Point point : pointArray) {
                    if (n2 != point.x) continue;
                    if (point.y == -10) {
                        n5 = pieData.exploded.length - 1;
                        pieData.exploded[n5] = true;
                        continue;
                    }
                    if (point.y >= n3) continue;
                    pieData.exploded[point.y] = true;
                }
                if (list2 != null) {
                    for (Point point : list2) {
                        if (point == null) continue;
                        if (point.y == -10) {
                            int n7 = pieData.exploded.length - 1;
                            pieData.exploded[n7] = true;
                            continue;
                        }
                        if (point.y < 0 || point.y >= n3) continue;
                        pieData.exploded[point.y] = true;
                    }
                }
            }
        }
        switch (this.pcf.sortOrder) {
            case 1: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending(false));
                break;
            }
            case 2: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortDescending(false));
                break;
            }
        }
        for (n4 = 0; n4 < n3; ++n4) {
            pieData.percents[n4].pct = pieData.sortPoints[n4].y >= 0.0 ? (pieData.zero_pie ? 0.0 : pieData.sortPoints[n4].y / d4) : 0.0;
            pieData.percents[n4].index = pieData.sortPoints[n4].index;
        }
        if (n3 == n6) {
            pieData.num_slices_pie = n3;
            pieData.other_flag = 0;
            return pieData.other_flag;
        }
        pieData.other_slice = -1;
        n4 = 0;
        double d7 = 0.0;
        int n8 = 0;
        int n9 = n3;
        n5 = 1;
        switch (this.pcf.sortOrder) {
            case 1: {
                int n10;
                for (n10 = 0; n10 < n3 && n3 - n10 >= n6; ++n10) {
                    if (pieData.sortPoints[n10].y >= 0.0) {
                        double d8 = pieData.percents[n10].pct;
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                n5 = d7 + d8 < d2 ? 1 : 0;
                                break;
                            }
                            case 0: {
                                n5 = d8 < d2 ? 1 : 0;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        n5 = 1;
                    }
                    if (n5 == 0) continue;
                    pieData.percents[n10].pct += d7;
                    d7 = pieData.percents[n10].pct;
                    n4 = 1;
                    n8 = n10;
                }
                if (n4 == 0) break;
                if (pieData.percents[n8].pct > 0.0) {
                    n9 = n3 - n8;
                    pieData.other_slice = n9 - 1;
                    pieData.percents[n3].pct = pieData.percents[n8].pct;
                    pieData.percents[n3].index = n3;
                } else {
                    n9 = n3 - n8 - 1;
                    n4 = 0;
                }
                for (n10 = n8 + 1; n10 <= n3; ++n10) {
                    pieData.percents[n10 - n8 - 1].pct = pieData.percents[n10].pct;
                    pieData.percents[n10 - n8 - 1].index = pieData.percents[n10].index;
                }
                break;
            }
            case 2: {
                n8 = n3 - 1;
                int n11 = n3 - 1;
                while (n11 >= 0 && n11 + 1 >= n6) {
                    if (pieData.sortPoints[n11].y >= 0.0) {
                        double d9 = pieData.percents[n11].pct;
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                n5 = d7 + d9 < d2 ? 1 : 0;
                                break;
                            }
                            case 0: {
                                n5 = d9 < d2 ? 1 : 0;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        n5 = 1;
                    }
                    if (n5 == 0) break;
                    pieData.percents[n11].pct += d7;
                    d7 = pieData.percents[n11].pct;
                    n8 = n11--;
                    n4 = 1;
                }
                if (n4 == 0) break;
                if (pieData.percents[n8].pct > 0.0) {
                    pieData.percents[n8].index = n3;
                    n9 = n8 + 1;
                    pieData.other_slice = n8;
                    break;
                }
                n9 = n8;
                n4 = 0;
                break;
            }
            case 0: {
                if (pieData.sortPoints != null) {
                    Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending(false));
                }
                pieData.percents[n3].pct = 0.0;
                pieData.percents[n3].index = n3;
                for (int i4 = 0; i4 < n3 && n9 >= n6; ++i4) {
                    double d10 = 0.0;
                    if (pieData.sortPoints[i4].y >= 0.0) {
                        d10 = pieData.zero_pie ? 0.0 : pieData.sortPoints[i4].y / d4;
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                n5 = d7 + d10 < d2 ? 1 : 0;
                                break;
                            }
                            case 0: {
                                n5 = d10 < d2 ? 1 : 0;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        n5 = 1;
                    }
                    if (n5 == 0) continue;
                    pieData.percents[n9].pct += d10;
                    d7 = pieData.percents[n9].pct;
                    for (n8 = 0; n8 < n9; ++n8) {
                        if (pieData.percents[n8].pct != d10) continue;
                        ++n8;
                        break;
                    }
                    while (n8 <= n9) {
                        pieData.percents[n8 - 1].pct = pieData.percents[n8].pct;
                        pieData.percents[n8 - 1].index = pieData.percents[n8].index;
                        ++n8;
                    }
                    if (d10 > 0.0) {
                        n4 = 1;
                    }
                    --n9;
                }
                if (n4 == 0) break;
                pieData.other_slice = n9++;
                break;
            }
            default: {
                System.out.println(ERRMSG_BIG_ERROR);
            }
        }
        pieData.num_slices_pie = n9;
        pieData.other_flag = n4 != 0 ? 1 : 0;
        return pieData.other_flag;
    }

    private JCDataIndex getDataIndex(ProcessShapePie processShapePie, int n2, int n3) {
        int n4;
        ChartDataViewSeries chartDataViewSeries = null;
        PieData pieData = processShapePie.getPieData();
        if (pieData.other_flag != 0 && n2 == pieData.other_slice) {
            n4 = -10;
        } else {
            chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
            n4 = pieData.percents[n2].index;
        }
        return new JCDataIndex(this.dataObject, chartDataViewSeries, n4, n3);
    }

    private void setShapeProperties(ProcessShape processShape, int n2, int n3, JCFillStyle jCFillStyle) {
        JCDataIndex jCDataIndex = null;
        if (processShape instanceof ProcessShapePie) {
            jCDataIndex = this.getDataIndex((ProcessShapePie)((Object)processShape), n2, n3);
        }
        processShape.tagData(jCDataIndex);
        processShape.setFillStyle(jCFillStyle);
    }

    private Shape getShape(Point2D.Double[] doubleArray, boolean bl) {
        Shape shape;
        if (bl) {
            Polygon polygon = new Polygon();
            for (Point2D.Double double_ : doubleArray) {
                polygon.addPoint((int)Math.round(double_.x), (int)Math.round(double_.y));
            }
            shape = polygon;
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
            for (int i2 = 1; i2 < doubleArray.length; ++i2) {
                generalPath.lineTo((float)doubleArray[i2].x, (float)doubleArray[i2].y);
            }
            generalPath.closePath();
            shape = generalPath;
        }
        return shape;
    }

    private void drawPiePlane(ProcessShape processShape, List<ChartDataViewSeries> list, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4, boolean bl, Rectangle2D rectangle2D) {
        double d2 = this.pcf.getStartAngle();
        double d3 = 0.0;
        for (int i2 = 0; i2 < pieData.num_slices_pie; ++i2) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, i2);
            this.setShapeProperties(processShape, i2, n4, jCFillStyle);
            double d4 = pieData.percents[i2].pct * 360.0;
            if (i2 == pieData.lastDrawnSlice) {
                if (d3 >= 360.0) {
                    d4 = 0.0;
                } else {
                    d4 = d2 - this.pcf.getStartAngle();
                    if (d4 < 0.0 || d4 == 0.0 && d3 == 0.0) {
                        d4 += 360.0;
                    }
                }
            }
            if (d4 == 0.0) continue;
            if (pieData.exploded[pieData.percents[i2].index]) {
                double d5 = d4 / 2.0;
                this.calcExplodeOffset(d2, d5, this.explode_offset, pieChartInfo.pos[n4].offset[i2]);
            }
            Point point = pieChartInfo.pos[n4].offset[i2];
            processShape.updateFillOrientation(rectangle2D, 0);
            if (this.defineShape != null) {
                JCDataIndex jCDataIndex = this.getDataIndex(i2, pieData, n4, list);
                this.defineShape.beginShape(jCDataIndex);
            }
            if (bl) {
                processShape.fillArc(n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, d2, -d4);
            } else {
                processShape.fillArcShadow(n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, d2, -d4);
            }
            if (this.defineShape != null) {
                this.defineShape.endShape(true);
            }
            processShape.resetFillOrientation();
            d2 -= d4;
            d3 += d4;
            if (!(d2 < 0.0)) continue;
            d2 += 360.0;
        }
    }

    private JCDataIndex getDataIndex(int n2, PieData pieData, int n3, List<ChartDataViewSeries> list) {
        JCDataIndex jCDataIndex;
        if (n2 == pieData.other_slice) {
            jCDataIndex = new JCDataIndex(this.dataObject, null, -10, n3);
        } else {
            int n4 = pieData.percents[n2].index;
            ChartDataViewSeries chartDataViewSeries = list.get(n4);
            jCDataIndex = new JCDataIndex(n3, chartDataViewSeries);
        }
        return jCDataIndex;
    }

    private boolean isSliceVisible() {
        return true;
    }

    private Point2D.Double createPoint(double d2, double d3, double d4, double d5, double d6) {
        return new Point2D.Double(d2 + Math.cos(d4) * d5, d3 - Math.sin(d4) * d6);
    }

    private Point computeExplodeOffset(PieChartInfo pieChartInfo, int n2, int n3, double d2, double d3) {
        double d4 = d3 / 2.0;
        this.calcExplodeOffset(d2, d4, this.explode_offset, pieChartInfo.pos[n2].offset[n3]);
        return (Point)pieChartInfo.pos[n2].offset[n3].clone();
    }

    private void drawSidePanel(ProcessShape processShape, JCFillStyle jCFillStyle, Rectangle2D rectangle2D, int n2, PieData pieData, PieChartInfo pieChartInfo, int n3, int n4, int n5, double d2) {
        int n6 = pieChartInfo.width;
        int n7 = pieChartInfo.height;
        double d3 = (double)n6 / 2.0;
        double d4 = (double)n7 / 2.0;
        double d5 = (double)n3 + d3;
        double d6 = (double)n4 + d4;
        this.setShapeProperties(processShape, n2, n5, jCFillStyle);
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        doubleArray[0] = new Point2D.Double(d5, d6);
        doubleArray[1] = new Point2D.Double(doubleArray[0].x, doubleArray[0].y + (double)this.delta_y);
        d2 = JCChartUtil.convertAngle(1, 2, d2);
        doubleArray[3] = this.createPoint(d5, d6, d2, d3, d4);
        doubleArray[2] = new Point2D.Double(doubleArray[3].x, doubleArray[3].y + (double)this.delta_y);
        Shape shape = this.getShape(doubleArray, processShape.getShapeType() == 2);
        processShape.updateFillOrientation(rectangle2D, 0);
        if (this.defineShape != null) {
            JCDataIndex jCDataIndex = this.getDataIndex(n2, pieData, n5, this.seriesList);
            this.defineShape.beginShape(jCDataIndex);
        }
        processShape.fillPolygonShadow(shape);
        if (this.defineShape != null) {
            this.defineShape.endShape(true);
        }
        processShape.resetFillOrientation();
        processShape.drawLine(doubleArray[0].x, doubleArray[0].y, doubleArray[1].x, doubleArray[1].y);
        processShape.drawLine(doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
        processShape.drawLine(doubleArray[1].x, doubleArray[1].y, doubleArray[2].x, doubleArray[2].y);
    }

    private Point2D.Double[] drawFilledParallelogram(ProcessShape processShape, JCFillStyle jCFillStyle, Rectangle2D rectangle2D, int n2, PieData pieData, PieChartInfo pieChartInfo, int n3, int n4, int n5, double d2, double d3) {
        Point2D.Double[] doubleArray = this.computePanelVertices(pieChartInfo, n3, n4, d2, d3);
        this.setShapeProperties(processShape, n2, n5, jCFillStyle);
        this.drawFilledParallelogram(processShape, pieData, n2, n5, doubleArray, rectangle2D);
        return doubleArray;
    }

    private Point2D.Double[] computePanelVertices(PieChartInfo pieChartInfo, int n2, int n3, double d2, double d3) {
        int n4 = pieChartInfo.width;
        int n5 = pieChartInfo.height;
        double d4 = (double)n4 / 2.0;
        double d5 = (double)n5 / 2.0;
        double d6 = (double)n2 + d4;
        double d7 = (double)n3 + d5;
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        double d8 = JCChartUtil.convertAngle(1, 2, d2);
        doubleArray[0] = this.createPoint(d6, d7, d8, d4, d5);
        doubleArray[1] = new Point2D.Double(doubleArray[0].x, doubleArray[0].y + (double)this.delta_y);
        d8 = JCChartUtil.convertAngle(1, 2, d3);
        doubleArray[3] = this.createPoint(d6, d7, d8, d4, d5);
        doubleArray[2] = new Point2D.Double(doubleArray[3].x, doubleArray[3].y + (double)this.delta_y);
        return doubleArray;
    }

    private void drawFilledParallelogram(ProcessShape processShape, PieData pieData, int n2, int n3, Point2D.Double[] doubleArray, Rectangle2D rectangle2D) {
        if (com.klg.jclass.util.style.JCFillStyle.getAlpha() == 255) {
            Shape shape = this.getShape(doubleArray, processShape.getShapeType() == 2);
            processShape.updateFillOrientation(rectangle2D, 0);
            if (this.defineShape != null) {
                JCDataIndex jCDataIndex = this.getDataIndex(n2, pieData, n3, this.seriesList);
                this.defineShape.beginShape(jCDataIndex);
            }
            processShape.fillPolygonShadow(shape);
            if (this.defineShape != null) {
                this.defineShape.endShape(true);
            }
            processShape.resetFillOrientation();
        }
    }

    private void drawFrontPanel(ProcessShape processShape, JCFillStyle jCFillStyle, Rectangle2D rectangle2D, int n2, PieData pieData, PieChartInfo pieChartInfo, int n3, int n4, int n5, double d2, double d3) {
        Point2D.Double[] doubleArray = this.drawFilledParallelogram(processShape, jCFillStyle, rectangle2D, n2, pieData, pieChartInfo, n3, n4, n5, d2, d3);
        processShape.drawLine(doubleArray[0].x, doubleArray[0].y, doubleArray[1].x, doubleArray[1].y);
        processShape.drawLine(doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
        double d4 = JCChartUtil.precCorrect(8, d3 - d2);
        processShape.drawArc(n3, n4 + this.delta_y, pieChartInfo.width, pieChartInfo.height, d2, d4);
    }

    private void drawPieCircle(ProcessShape processShape, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4) {
        double d2 = this.pcf.getStartAngle();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < pieData.num_slices_pie; ++i2) {
            double d5 = pieData.percents[i2].pct * 360.0;
            if (i2 == pieData.lastDrawnSlice) {
                if (!pieData.exploded[pieData.percents[i2].index]) {
                    d4 = 0.0;
                }
                if (d3 >= 360.0) {
                    d5 = 0.0;
                } else {
                    d5 = d2 - d4 - this.pcf.getStartAngle();
                    if (d5 < 0.0 || d5 == 0.0 && d3 == 0.0) {
                        d5 += 360.0;
                    }
                }
            }
            if (d5 == 0.0) continue;
            if (pieData.exploded[pieData.percents[i2].index]) {
                if (d4 != 0.0) {
                    processShape.drawArc(n2, n3, pieChartInfo.width, pieChartInfo.height, d2, -d4);
                    d2 -= d4;
                    d3 += d4;
                    if (d2 < 0.0) {
                        d2 += 360.0;
                    }
                    d4 = 0.0;
                }
                Point point = pieChartInfo.pos[n4].offset[i2];
                processShape.drawArc(n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, d2, -d5);
                d2 -= d5;
                d3 += d5;
                if (!(d2 < 0.0)) continue;
                d2 += 360.0;
                continue;
            }
            d4 += d5;
        }
        if (d4 != 0.0) {
            processShape.drawArc(n2, n3, pieChartInfo.width, pieChartInfo.height, d2, -d4);
        }
    }

    private void drawPieEdge(ProcessShape processShape, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4, Rectangle2D rectangle2D) {
        Point point;
        int n5;
        int n6;
        Object object;
        boolean bl;
        int n7;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        int n8 = Integer.MAX_VALUE;
        double d4 = this.pcf.getStartAngle();
        if ((d4 = JCChartUtil.boundAngle(1, d4)) > 90.0) {
            d4 -= 360.0;
        }
        pieData.sortPoints = new PieSortPoint[pieData.num_slices_pie + 1];
        for (n7 = 0; n7 < pieData.num_slices_pie; ++n7) {
            d3 = pieData.percents[n7].pct * 360.0;
            d2 = d4 - d3;
            if (d2 <= -270.0) {
                d2 += 360.0;
            }
            pieData.sortPoints[n7] = new PieSortPoint(d4, n7);
            if ((d4 > 90.0 && d4 < 270.0 || d4 > -270.0 && d4 < -90.0) && (d2 < 90.0 && d2 > -90.0 || d2 > 270.0)) {
                n8 = n7;
            }
            d4 = d2;
        }
        pieData.sortPoints[n7] = new PieSortPoint(d4, n7);
        if (n8 != Integer.MAX_VALUE) {
            d2 = pieData.sortPoints[n8].y;
            d3 = pieData.percents[n8].pct * 360.0;
            bl = this.isSliceVisible();
            if (bl && d3 != 0.0) {
                Point point2;
                object = this.getPieSliceFillStyle(pieData, n8);
                n6 = pieData.exploded[pieData.percents[n8].index];
                int n9 = n2;
                n5 = n3;
                if (n6 != 0) {
                    point2 = this.computeExplodeOffset(pieChartInfo, n4, n8, d2 - d3, -d3);
                    n9 += point2.x;
                    n5 += point2.y;
                }
                this.drawSidePanel(processShape, (JCFillStyle)object, rectangle2D, n8, pieData, pieChartInfo, n9, n5, n4, d2 - d3);
                n9 = n2;
                n5 = n3;
                if (n6 != 0) {
                    point2 = this.computeExplodeOffset(pieChartInfo, n4, n8, d2, d3);
                    n9 += point2.x;
                    n5 += point2.y;
                }
                this.drawSidePanel(processShape, (JCFillStyle)object, rectangle2D, n8, pieData, pieChartInfo, n9, n5, n4, d2);
            }
        }
        object = pieData.sortPoints[0];
        pieData.sortPoints[0] = new PieSortPoint(Double.MAX_VALUE, 0);
        Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortDescending(true));
        pieData.sortPoints[0] = object;
        n6 = 0;
        while (n6 < pieData.num_slices_pie) {
            n7 = pieData.sortPoints[++n6].index - 1;
            d2 = pieData.sortPoints[n6].y;
            if (d2 < -90.0) break;
            d3 = pieData.percents[n7].pct * 360.0;
            if (d3 == 0.0) continue;
            if (d3 < 0.0) {
                d3 += 360.0;
            }
            if (!(bl = this.isSliceVisible())) continue;
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
            n5 = n2;
            int n10 = n3;
            if (pieData.exploded[pieData.percents[n7].index]) {
                point = this.computeExplodeOffset(pieChartInfo, n4, n7, d2 + d3, d3);
                n5 += point.x;
                n10 += point.y;
            }
            if (d2 < 0.0) {
                d4 = d2 + d3;
                if (d4 > 0.0) {
                    d4 = 0.0;
                }
                this.drawFrontPanel(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n10, n4, d4, d2);
            }
            if (n7 == n8) continue;
            this.drawSidePanel(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n10, n4, d2);
        }
        Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending(true));
        for (n6 = 0; n6 < pieData.num_slices_pie + 1; ++n6) {
            n7 = pieData.sortPoints[n6].index;
            if (n7 == pieData.num_slices_pie) continue;
            d4 = pieData.sortPoints[n6].y;
            if (d4 > -90.0) break;
            d3 = pieData.percents[n7].pct * 360.0;
            if (d3 == 0.0) continue;
            if (d3 < 0.0) {
                d3 += 360.0;
            }
            if (!(bl = this.isSliceVisible())) continue;
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
            n5 = n2;
            int n11 = n3;
            if (pieData.exploded[pieData.percents[n7].index]) {
                point = this.computeExplodeOffset(pieChartInfo, n4, n7, d4, d3);
                n5 += point.x;
                n11 += point.y;
            }
            if (d4 > -180.0) {
                d2 = d4 - d3;
                if (d2 < -180.0) {
                    d2 = -180.0;
                }
                this.drawFrontPanel(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n11, n4, d4, d2);
            }
            if (n7 == n8) continue;
            this.drawSidePanel(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n11, n4, d4);
        }
        if (pieData.num_slices_pie > 0) {
            double d5;
            if (n6 < pieData.num_slices_pie + 1) {
                d3 = pieData.percents[n7].pct * 360.0;
                d2 = d4 - d3;
                d5 = d4 > 0.0 ? 0.0 : d4;
            } else {
                for (n6 = 0; n6 < pieData.num_slices_pie + 1; ++n6) {
                    n7 = pieData.sortPoints[n6].index;
                    if (n7 == pieData.num_slices_pie) continue;
                    d4 = pieData.sortPoints[n6].y;
                    d3 = pieData.percents[n7].pct * 360.0;
                    if (d3 == 0.0) continue;
                    d2 = d4 - d3;
                    if (d2 <= -270.0) {
                        d2 += 360.0;
                    }
                    if (d3 > 180.0) break;
                }
                d5 = 0.0;
            }
            if (n6 < pieData.num_slices_pie + 1 && (bl = this.isSliceVisible())) {
                JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
                if (d2 < -180.0) {
                    d2 = -180.0;
                }
                n5 = n2;
                int n12 = n3;
                if (pieData.exploded[pieData.percents[n7].index]) {
                    point = this.computeExplodeOffset(pieChartInfo, n4, n7, d4, d3);
                    n5 += point.x;
                    n12 += point.y;
                }
                if (d3 >= 180.0) {
                    if (d5 <= 0.0 && d5 > -90.0) {
                        this.drawFilledParallelogram(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n12, n4, d5, -90.0);
                    }
                    if (d2 < -90.0 && d2 >= -180.0) {
                        this.drawFilledParallelogram(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n12, n4, -90.0, d2);
                    }
                }
                this.drawFrontPanel(processShape, jCFillStyle, rectangle2D, n7, pieData, pieChartInfo, n5, n12, n4, d5, d2);
            }
        }
    }

    private void drawPieLines(ProcessShape processShape, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        double d2 = (double)pieChartInfo.width / 2.0;
        double d3 = (double)pieChartInfo.height / 2.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = (double)n2 + d2;
        double d7 = (double)n3 + d3;
        double d8 = 0.0;
        double d9 = 0.0;
        pieChartInfo.pos[n4].cx = (int)Math.round(d6);
        pieChartInfo.pos[n4].cy = (int)Math.round(d7);
        int n6 = -1;
        double d10 = this.pcf.getStartAngle();
        double d11 = 0.0;
        int n7 = pieData.lastDrawnSlice;
        boolean bl2 = false;
        boolean bl3 = bl = pieData.num_slices_pie > 1;
        if (bl) {
            for (n5 = 0; n5 < pieData.num_slices_pie; ++n5) {
                if (pieData.percents[n5].pct != 1.0) continue;
                bl = false;
            }
        }
        for (n5 = 0; n5 < pieData.num_slices_pie; ++n5) {
            double d12 = -1.0;
            double d13 = -1.0;
            int n8 = pieData.percents[n7].index;
            boolean bl4 = n5 != 0 && pieData.exploded[n8];
            double d14 = pieData.percents[n5].pct * 360.0;
            if (n5 == pieData.lastDrawnSlice) {
                if (d11 >= 360.0) {
                    d14 = 0.0;
                } else {
                    d14 = d10 - this.pcf.getStartAngle();
                    if (d14 < 0.0 || d14 == 0.0 && d11 == 0.0) {
                        d14 += 360.0;
                    }
                }
            }
            if (d14 != 0.0) {
                double d15;
                if (d11 == 0.0) {
                    d15 = JCChartUtil.degToRad(d10);
                    d13 = d6 + Math.cos(d15) * d2;
                    d12 = d7 - Math.sin(d15) * d3;
                    d4 = d13;
                    d5 = d12;
                    bl2 = pieData.exploded[pieData.percents[n5].index];
                } else {
                    d13 = d8;
                    d12 = d9;
                }
                d10 -= d14;
                d11 += d14;
                if (d10 < 0.0) {
                    d10 += 360.0;
                }
                d15 = JCChartUtil.degToRad(d10);
                d8 = d6 + Math.cos(d15) * d2;
                d9 = d7 - Math.sin(d15) * d3;
                if (bl) {
                    Point point;
                    if (pieData.exploded[pieData.percents[n5].index]) {
                        point = pieChartInfo.pos[n4].offset[n5];
                        processShape.drawLine(d6 + (double)point.x, d7 + (double)point.y, d13 + (double)point.x, d12 + (double)point.y);
                    } else if (bl4) {
                        processShape.drawLine(d6, d7, d13, d12);
                    }
                    if (pieData.exploded[pieData.percents[n5].index]) {
                        point = pieChartInfo.pos[n4].offset[n5];
                        processShape.drawLine(d6 + (double)point.x, d7 + (double)point.y, d8 + (double)point.x, d9 + (double)point.y);
                    } else {
                        processShape.drawLine(d6, d7, d8, d9);
                    }
                }
                n7 = n5;
            }
            pieChartInfo.pos[n4].coord[n5].x = (int)Math.round(d13);
            pieChartInfo.pos[n4].coord[n5].y = (int)Math.round(d12);
            if (!(d13 >= 0.0)) continue;
            for (int i2 = n5 - 1; i2 >= 0 && pieChartInfo.pos[n4].coord[i2].x == -1; --i2) {
                pieChartInfo.pos[n4].coord[i2].x = (int)Math.round(d13);
                pieChartInfo.pos[n4].coord[i2].y = (int)Math.round(d12);
            }
            n6 = n5;
        }
        if (!bl2 && pieData.exploded[pieData.percents[n7].index] && bl) {
            processShape.drawLine(d6, d7, d4, d5);
        }
        for (n5 = n6 + 1; n5 < pieData.num_slices_pie; ++n5) {
            pieChartInfo.pos[n4].coord[n5].x = pieChartInfo.pos[n4].coord[0].x;
            pieChartInfo.pos[n4].coord[n5].y = pieChartInfo.pos[n4].coord[0].y;
        }
    }

    private JCFillStyle getPieSliceFillStyle(PieData pieData, int n2) {
        JCFillStyle jCFillStyle = null;
        if (n2 == pieData.other_slice && pieData.other_flag != 0) {
            jCFillStyle = this.pcf.getOtherStyle().getFillStyle();
        } else {
            int n3 = pieData.percents[n2].index;
            if (n3 >= 0) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
                jCFillStyle = chartDataViewSeries.getStyle().getFillStyle();
            }
        }
        return jCFillStyle;
    }

    @Override
    protected void calcTransientData() {
        int n2;
        if (!this.dataObject.isChanged() && this.dataObject.getTransientData() != null && !this.recalcTransientData) {
            return;
        }
        this.recalcTransientData = false;
        this.seriesList = this.dataObject.getSeries();
        this.pcf = (JCPieChartFormat)this.dataObject.getChartFormat();
        int n3 = this.dataObject.getNumSeries();
        Point point = this.dataObject.getFirstLast();
        if (point == null) {
            this.num_pies = 0;
            return;
        }
        this.num_pies = Math.max(point.y - point.x + 1, 0);
        if (this.num_pies == 0) {
            return;
        }
        PieChartInfo pieChartInfo = new PieChartInfo();
        pieChartInfo.pos = new PiePosition[this.num_pies];
        pieChartInfo.data = new PieData[this.num_pies];
        pieChartInfo.num_pies = this.num_pies;
        for (int i2 = 0; i2 < this.num_pies; ++i2) {
            pieChartInfo.pos[i2] = new PiePosition();
            pieChartInfo.pos[i2].coord = new Point[n3 + 1];
            pieChartInfo.pos[i2].offset = new Point[n3 + 1];
            for (n2 = 0; n2 <= n3; ++n2) {
                pieChartInfo.pos[i2].coord[n2] = new Point(-2, -2);
                pieChartInfo.pos[i2].offset[n2] = new Point(0, 0);
            }
            pieChartInfo.pos[i2].order = new short[n3 + 1];
            pieChartInfo.data[i2] = new PieData();
            pieChartInfo.data[i2].sortPoints = new PieSortPoint[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                pieChartInfo.data[i2].sortPoints[n2] = new PieSortPoint();
            }
            pieChartInfo.data[i2].percents = new PiePercent[n3 + 1];
            pieChartInfo.data[i2].exploded = new boolean[n3 + 1];
            for (n2 = 0; n2 < n3 + 1; ++n2) {
                pieChartInfo.data[i2].percents[n2] = new PiePercent();
                pieChartInfo.data[i2].exploded[n2] = false;
            }
        }
        this.first_point = ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        pieChartInfo.other_flag = 0;
        ArrayList<Point> arrayList = this.getExplodeAllPoints();
        for (n2 = 0; n2 < this.num_pies; ++n2) {
            int n4;
            int n5 = this.computeOtherSlice(this.seriesList, n2 + this.first_point, n3, pieChartInfo.data[n2], arrayList);
            int n6 = pieChartInfo.data[n2].other_slice;
            int n7 = pieChartInfo.data[n2].num_slices_pie;
            for (n4 = 0; n4 < n7; ++n4) {
                pieChartInfo.pos[n2].order[n4] = (short)pieChartInfo.data[n2].percents[n4].index;
                if (!(pieChartInfo.data[n2].percents[n4].pct > 0.0)) continue;
                pieChartInfo.data[n2].lastDrawnSlice = n4;
            }
            while (n4 <= n3) {
                pieChartInfo.pos[n2].order[n4] = -1;
                ++n4;
            }
            if (n5 > 0) {
                pieChartInfo.pos[n2].order[n6] = -10;
            }
            pieChartInfo.other_flag |= n5;
        }
        this.dataObject.setTransientData(pieChartInfo);
        this.dataObject.setChanged(false, 0);
    }

    protected void setRecalcFlag() {
        this.recalcTransientData = true;
    }

    @Override
    public JCDataIndex pick(Point point, int n2) {
        int n3;
        int n4;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        JCDataIndex jCDataIndex = null;
        PieData pieData = new PieData();
        pieData.sortPoints = null;
        pieData.percents = null;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n5 = this.seriesList.size();
        if (n5 == 0) {
            return jCDataIndex;
        }
        pieData.sortPoints = new PieSortPoint[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            pieData.sortPoints[n4] = new PieSortPoint();
        }
        pieData.percents = new PiePercent[n5 + 1];
        pieData.exploded = new boolean[n5 + 1];
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            pieData.percents[n4] = new PiePercent();
            pieData.exploded[n4] = false;
        }
        if (this.pieInfo == null) {
            return jCDataIndex;
        }
        n4 = this.pieInfo.width;
        int n6 = this.pieInfo.height;
        if (n4 == 0 || n6 == 0) {
            return jCDataIndex;
        }
        int n7 = point2.x / this.box_width;
        if (n7 >= this.num_pies_line) {
            n7 = this.num_pies_line - 1;
        }
        if ((n3 = point2.y / this.box_height) >= this.num_lines) {
            n3 = this.num_lines - 1;
        }
        int n8 = ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        int n9 = n3 * this.num_pies_line + n7 + n8;
        int n10 = 0;
        int n11 = 0;
        ArrayList<Point> arrayList = this.getExplodeAllPoints();
        if (n9 < this.num_pies + n8 && point2.x >= (n10 += n7 * this.box_width) && point2.x <= n10 + this.box_width && point2.y >= (n11 += n3 * this.box_height) && point2.y <= n11 + this.box_height) {
            int n12 = this.computeOtherSlice(this.seriesList, n9, n5, pieData, arrayList);
            Picker picker = new Picker(point2.x, point2.y, n2);
            PickShapePie pickShapePie = new PickShapePie(picker);
            this.drawSinglePie(pickShapePie, null, n9, n10, n11);
            if (n12 != 0 && picker.series == -10) {
                if (picker.point >= 0) {
                    jCDataIndex = new JCDataIndex(picker.point, null, -10);
                    jCDataIndex.distance = picker.distance;
                }
            } else if (picker.series >= 0 && picker.point >= 0) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(picker.series);
                jCDataIndex = new JCDataIndex(picker.point, chartDataViewSeries, picker.series);
                jCDataIndex.distance = picker.distance;
            }
        }
        return jCDataIndex;
    }

    @Override
    public Point unpick(int n2, int n3) {
        double d2;
        Point point = new Point();
        double d3 = this.unpickInternal(n2, n3, point);
        double d4 = d2 = this.dataObject == null ? Double.MAX_VALUE : this.dataObject.getHoleValue();
        if (d3 == d2) {
            return null;
        }
        return point;
    }

    protected double unpickInternal(int n2, int n3, Point point) {
        double d2;
        double d3 = d2 = this.dataObject == null ? Double.MAX_VALUE : this.dataObject.getHoleValue();
        if (this.pieInfo == null || this.pieInfo.data == null || this.pieInfo.data.length <= n2 || point == null) {
            return d2;
        }
        PieData pieData = this.pieInfo.data[n2];
        d2 = this.findPoint(n3, n2, point);
        if (point.x < 0 || point.y < 0) {
            return d2;
        }
        int n4 = this.findSliceIndex(n3, n2);
        if (n4 >= 0 && pieData.exploded[pieData.percents[n4].index]) {
            int n5 = (int)Math.round(Math.cos(d2) * (double)this.explode_offset);
            int n6 = (int)Math.round(-Math.sin(d2) * (double)this.explode_offset);
            point.x += n5;
            point.y += n6;
        }
        return d2;
    }

    private int findSliceIndex(int n2, int n3) {
        int n4 = this.seriesList.size();
        for (int i2 = 0; i2 < n4 + 1; ++i2) {
            int n5 = n3 - ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
            if (n5 < 0 || n5 >= this.pieInfo.pos.length) {
                return -1;
            }
            short s = this.pieInfo.pos[n5].order[i2];
            if (s != n2) continue;
            return i2;
        }
        return -1;
    }

    public double getSliceAngle(int n2, int n3) {
        return this.findPoint(n2, n3, new Point());
    }

    protected double findPoint(int n2, int n3, Point point) {
        double d2 = this.dataObject == null ? Double.MAX_VALUE : this.dataObject.getHoleValue();
        point.x = -1;
        point.y = -1;
        int n4 = this.seriesList.size();
        if (n2 < 0 && n2 != -10 || n2 >= n4) {
            return d2;
        }
        if (n2 != -10 && !((ChartDataViewSeries)this.seriesList.get(n2)).isVisible()) {
            return d2;
        }
        double d3 = JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation()));
        double d4 = Math.cos(d3);
        for (int i2 = 0; i2 < n4 + 1; ++i2) {
            double d5;
            double d6;
            double d7;
            int n5 = n3 - ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
            if (n5 < 0 || n5 >= this.pieInfo.pos.length) {
                return d2;
            }
            PiePosition piePosition = this.pieInfo.pos[n5];
            short s = piePosition.order[i2];
            if (s == -1) {
                return d2;
            }
            if (s == -2 || s != n2) continue;
            double d8 = piePosition.coord[i2].x;
            double d9 = piePosition.coord[i2].y;
            if (d8 == -2.0) {
                return d2;
            }
            if (i2 == n4 || piePosition.order[i2 + 1] == -1) {
                d7 = piePosition.coord[0].x;
                d6 = piePosition.coord[0].y;
            } else {
                d7 = piePosition.coord[i2 + 1].x;
                d6 = piePosition.coord[i2 + 1].y;
            }
            d9 = (d9 - (double)piePosition.cy) / d4 + (double)piePosition.cy;
            d6 = (d6 - (double)piePosition.cy) / d4 + (double)piePosition.cy;
            double d10 = Math.atan2((double)piePosition.cy - d9, d8 - (double)piePosition.cx);
            double d11 = Math.atan2((double)piePosition.cy - d6, d7 - (double)piePosition.cx);
            d2 = d10 - d11;
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            } else if (d2 == 0.0 && (d5 = this.pieInfo.data[n5].percents[i2].pct) > 0.5) {
                d2 += Math.PI * 2;
            }
            d2 = d10 - d2 / 2.0;
            if (d2 <= -Math.PI) {
                d2 += Math.PI * 2;
            }
            if (d2 == 1.5707963267948966) {
                point.x = piePosition.cx;
                point.y = piePosition.cy - this.pieInfo.height / 2;
                break;
            }
            if (d2 == -1.5707963267948966) {
                point.x = piePosition.cx;
                point.y = piePosition.cy + this.pieInfo.height / 2;
                break;
            }
            d5 = (double)this.pieInfo.width / 2.0;
            double d12 = Math.tan(d2);
            d8 = Math.sqrt(d5 * d5 / (1.0 + d12 * d12));
            if (d2 > 1.5707963267948966 || d2 < -1.5707963267948966) {
                d8 = -d8;
            }
            d9 = d8 * d12 * d4;
            point.x = (int)((double)piePosition.cx + d8);
            point.y = (int)((double)piePosition.cy - d9);
            break;
        }
        return d2;
    }

    private void calcExplodeOffset(double d2, double d3, double d4, Point point) {
        double d5 = d2 - d3;
        if (d5 < 0.0) {
            d5 += 360.0;
        }
        if (d5 >= 0.0 && d5 <= 90.0) {
            double d6 = JCChartUtil.degToRad(d5);
            point.x = (int)Math.round(Math.cos(d6) * d4);
            point.y = -((int)Math.round(Math.sin(d6) * d4));
        } else if (d5 > 90.0 && d5 <= 180.0) {
            double d7 = JCChartUtil.degToRad(d5 -= 90.0);
            point.x = -((int)Math.round(Math.sin(d7) * d4));
            point.y = -((int)Math.round(Math.cos(d7) * d4));
        } else if (d5 > 180.0 && d5 <= 270.0) {
            double d8 = JCChartUtil.degToRad(d5 -= 180.0);
            point.x = -((int)Math.round(Math.cos(d8) * d4));
            point.y = (int)Math.round(Math.sin(d8) * d4);
        } else if (d5 > 270.0 && d5 <= 360.0) {
            double d9 = JCChartUtil.degToRad(d5 -= 270.0);
            point.x = (int)Math.round(Math.sin(d9) * d4);
            point.y = (int)Math.round(Math.cos(d9) * d4);
        }
    }

    @Override
    public Point calcDataIndexPosition(JCChartLabel jCChartLabel, JCDataIndex jCDataIndex, int n2) {
        double d2;
        if (jCChartLabel == null || jCChartLabel.getComponent() == null || jCDataIndex == null) {
            return null;
        }
        if (n2 < 1 || n2 > 3) {
            return null;
        }
        int n3 = jCDataIndex.getPoint();
        int n4 = jCDataIndex.getSeriesIndex();
        Point point = new Point();
        double d3 = this.unpickInternal(n3, n4, point);
        double d4 = d2 = this.dataObject == null ? Double.MAX_VALUE : this.dataObject.getHoleValue();
        if (d3 == d2) {
            return null;
        }
        if (n2 == 2) {
            return point;
        }
        JComponent jComponent = jCChartLabel.getComponent();
        double d5 = (double)jComponent.getWidth() / 2.0;
        double d6 = (double)jComponent.getHeight() / 2.0;
        double d7 = Math.sqrt(2.0);
        double d8 = 1.3089969389957472;
        double d9 = 1.832595714594046;
        double d10 = 0.0;
        if (n2 == 3) {
            d10 = d7 * d6;
        } else if (n2 == 1) {
            double d11 = Math.cos(d3) * d5;
            double d12 = Math.sin(d3) * d6;
            d10 = -Math.sqrt(d11 * d11 + d12 * d12) * d7;
        }
        int n5 = (int)Math.round(Math.cos(d3) * d10);
        int n6 = (int)Math.round(-Math.sin(d3) * d10);
        point.x += n5;
        point.y += n6;
        if (n2 == 3) {
            if (d3 >= -d8 && d3 <= d8) {
                point.x = (int)((double)point.x + d5);
            } else if (d3 >= d8 && d3 <= d9) {
                point.y = (int)((double)point.y - d6);
            } else if (d3 >= d9 || d3 <= -d9) {
                point.x = (int)((double)point.x - d5);
            } else if (d3 >= -d9 && d3 <= -d8) {
                point.x = (int)((double)point.x + d6);
            }
        }
        return point;
    }
}

