/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.BaseAxisScaleHandler;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCValueLabel;
import java.util.Vector;

class LogAxisScaleHandler
extends BaseAxisScaleHandler {
    LogAxisScaleHandler() {
    }

    public boolean fixBounds() {
        JCChart jCChart;
        String string;
        boolean bl = super.fixBounds();
        if (this.parent == null) {
            return bl;
        }
        if (!this.parent.max.isDefault && this.parent.max.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key104", this.parent.locale);
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key130", this.parent.locale);
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key130", this.parent.locale);
            JCChart jCChart2 = jCChart = this.parent != null ? this.parent.getParentChart() : null;
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage(string);
            }
            this.parent.max.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && this.parent.min.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key106", this.parent.locale);
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key132", this.parent.locale);
            JCChart jCChart3 = jCChart = this.parent != null ? this.parent.getParentChart() : null;
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage(string);
            }
            this.parent.min.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && !this.parent.max.isDefault) {
            double d2 = JCChartUtil.log10(this.parent.min.value);
            double d3 = JCChartUtil.log10(this.parent.max.value);
            if (d3 - d2 < Double.MIN_VALUE) {
                string = JCChartBundle.string("com.klg.jclass.chart.Key7", this.parent.locale);
                string = string + JCChartBundle.string("com.klg.jclass.chart.Key130", this.parent.locale);
                JCChart jCChart4 = jCChart = this.parent != null ? this.parent.getParentChart() : null;
                if (jCChart != null) {
                    jCChart.getErrorLog().logErrorMessage(string);
                }
                this.parent.max.isDefault = true;
                bl = true;
            }
        }
        return bl;
    }

    public void calcPrecision() {
        int n2;
        if (this.parent == null) {
            return;
        }
        if (this.parent.precision.isDefault) {
            if (this.parent.getAnnotationMethod() == 2 || this.parent.dataLimits == null) {
                this.parent.precision.value = 0;
                this.parent.getDefaultLabels().precision.value = 0;
            } else {
                this.parent.precision.value = n2 = 0;
                this.parent.updateAnnoDefPrecision(n2);
            }
        }
        n2 = JCChartUtil.clamp(this.parent.getPrecision(), this.parent.getMinPrecision(), this.parent.getMaxPrecision());
        this.parent.setPrecisionInternal(n2);
    }

    public void updateAnnoObject(JCAnno jCAnno) {
        this.updateAnnoObject(jCAnno, this.parent.min.value, this.parent.max.value, 0.0);
    }

    public void makeTickLabels(JCAnno jCAnno) {
        double d2;
        if (jCAnno == null) {
            return;
        }
        Vector<JCValueLabel> vector = this.parent.getAnnotations();
        double d3 = jCAnno.getStopValueIsDefault() ? this.parent.max.value : jCAnno.getStopValue();
        double d4 = d2 = jCAnno.getStartValueIsDefault() ? this.parent.min.value : jCAnno.getStartValue();
        if (d3 <= 0.0) {
            d3 = 1.0;
            d2 = 0.1;
        } else if (d2 < 0.0) {
            d2 = d3 / 10.0;
        }
        double d5 = JCChartUtil.precCorrect(10, JCChartUtil.log10(d2));
        double d6 = JCChartUtil.precCorrect(10, JCChartUtil.log10(d3));
        int n2 = JCChartUtil.ifloor(d5);
        int n3 = JCChartUtil.iceil(d6);
        for (int i2 = n2; i2 <= n3; ++i2) {
            double d7 = JCChartUtil.pow10(i2);
            if (jCAnno.getType() == 10) {
                if (d7 < this.parent.min.value || d7 > this.parent.max.value || this.isDuplicateLabel(jCAnno, d7)) continue;
                JCValueLabel jCValueLabel = new JCValueLabel(this.parent, i2, jCAnno.getPrecision());
                jCValueLabel.setAnno(jCAnno);
                vector.add(jCValueLabel);
                continue;
            }
            for (int i3 = 1; i3 < 10; ++i3) {
                double d8 = (double)i3 * d7;
                if (d8 < this.parent.min.value || d8 > this.parent.max.value || this.isDuplicateLabel(jCAnno, d8)) continue;
                JCValueLabel jCValueLabel = new JCValueLabel(jCAnno, d8);
                vector.add(jCValueLabel);
            }
        }
    }

    public double range() {
        if (this.parent == null) {
            return Double.MAX_VALUE;
        }
        int n2 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.min.value));
        int n3 = JCChartUtil.iceil(JCChartUtil.log10(this.parent.max.value));
        return n3 - n2;
    }

    public void translate(double d2) {
        if (this.parent == null) {
            return;
        }
        double d3 = JCChartUtil.log10(this.parent.min.value);
        double d4 = JCChartUtil.log10(this.parent.max.value);
        if (this.parent.reversed) {
            d2 = -d2;
        }
        this.parent.min.value = Math.pow(10.0, d3 + d2);
        this.parent.max.value = Math.pow(10.0, d4 + d2);
    }

    public String format(double d2, int n2) {
        return JCChartUtil.logFormat((int)d2);
    }
}

