/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;

class LinearAxisUtil {
    LinearAxisUtil() {
    }

    static double calcMaxUsed(JCAxis jCAxis, double d2, double d3) {
        d2 = JCChartUtil.precCeil(jCAxis.getPrecision(), d2);
        d2 = jCAxis.max.isDefault ? d2 : jCAxis.max.value;
        return jCAxis.max.isDefault ? JCChartUtil.max(d2, d3) : d2;
    }

    static double calcMinUsed(JCAxis jCAxis, double d2, double d3) {
        d2 = JCChartUtil.precFloor(jCAxis.getPrecision(), d2);
        d2 = jCAxis.min.isDefault ? d2 : jCAxis.min.value;
        return jCAxis.min.isDefault ? JCChartUtil.min(d2, d3) : d2;
    }

    static void setAxisMinMax(JCAxis jCAxis, double d2, double d3, double d4, double d5) {
        if (jCAxis.visible || jCAxis.usePrecisionCalculatedBoundsForInvisibleAxis) {
            if (jCAxis.min.isDefault) {
                jCAxis.min.value = d2;
            }
            if (jCAxis.max.isDefault) {
                jCAxis.max.value = d3;
            }
        } else {
            if (jCAxis.min.isDefault) {
                jCAxis.min.value = d4;
            }
            if (jCAxis.max.isDefault) {
                jCAxis.max.value = d5;
            }
        }
    }

    static double updateMinValue(double d2, double d3, double d4) {
        if (d4 != 0.0) {
            double d5 = (d2 - d3) / d4;
            d2 = d5 != Math.floor(d5) ? d3 + Math.floor(d5 - 1.0) * d4 : d3 + Math.floor(d5) * d4;
        }
        return d2;
    }

    static double updateMaxValue(double d2, double d3, double d4) {
        if (d4 != 0.0) {
            double d5 = (d2 - d3) / d4;
            d2 = d5 != Math.floor(d5) ? d3 + Math.floor(d5 + 1.0) * d4 : d3 + Math.floor(d5) * d4;
        }
        return d2;
    }
}

