/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.BaseAxisScaleHandler;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCValueLabel;
import java.util.List;
import java.util.Vector;

class LinearAxisScaleHandler
extends BaseAxisScaleHandler {
    LinearAxisScaleHandler() {
    }

    public void calcPrecision() {
        if (this.parent == null || this.parent.getAnnotationList() == null) {
            return;
        }
        if (this.parent.chartType == 2 && !this.parent.i_vertical) {
            return;
        }
        double d2 = this.parent.min.isDefault && this.parent.dataLimits != null ? this.parent.dataLimits.min : this.parent.min.value;
        double d3 = this.parent.max.isDefault && this.parent.dataLimits != null ? this.parent.dataLimits.max : this.parent.max.value;
        double d4 = d3 <= d2 ? d3 : d3 - d2;
        int n2 = JCChartUtil.nicePrecision(d4);
        List<JCAnno> list = this.parent.getAnnotationList();
        for (JCAnno jCAnno : list) {
            if (jCAnno == null) continue;
            jCAnno.defPrecision = !jCAnno.getIncrementIsDefault() ? JCChartUtil.tickBasedPrecision(jCAnno.getIncrementValue()) : JCChartUtil.clamp(n2, this.parent.getMinPrecision(), this.parent.getMaxPrecision());
            if (!jCAnno.getPrecisionIsDefault()) continue;
            jCAnno.precision.value = jCAnno.defPrecision;
        }
    }

    public void updateAnnoObject(JCAnno jCAnno) {
        if (jCAnno != null) {
            int n2 = jCAnno.getType();
            double d2 = n2 == 10 ? this.parent.numSpacing.value : this.parent.tickSpacing.value;
            this.updateAnnoObject(jCAnno, this.parent.min.value, this.parent.max.value, d2);
        }
    }

    public void makeTickLabels(JCAnno jCAnno) {
        block7: {
            int n2;
            int n3;
            double d2;
            double d3;
            double d4;
            double d5;
            Vector<JCValueLabel> vector;
            block6: {
                if (jCAnno == null) {
                    return;
                }
                vector = this.parent.getAnnotations();
                d5 = jCAnno.getIncrementValue();
                if (jCAnno.getStartValueIsDefault()) {
                    jCAnno.startValue.value = this.parent.firstInc(d5);
                }
                d4 = jCAnno.getStartValue();
                d3 = jCAnno.getStopValue();
                d2 = JCChartUtil.calcError(jCAnno.getPrecision());
                if (JCChartUtil.abs(d5) <= d2) {
                    return;
                }
                if (d4 + d5 == d4) {
                    return;
                }
                this.parent.scientificNotation = this.isUsingScientificNotation();
                n3 = this.parent.pixelLength() * 2;
                n2 = 0;
                if (!(d4 <= d3) || !(d5 > 0.0)) break block6;
                for (double d6 = d4; d6 <= d3 + d2 && n2 < n3; d6 += d5, ++n2) {
                    if (this.isDuplicateLabel(jCAnno, d6)) continue;
                    JCValueLabel jCValueLabel = new JCValueLabel(jCAnno, d6);
                    vector.add(jCValueLabel);
                }
                break block7;
            }
            if (!(d4 >= d3) || !(d5 < 0.0)) break block7;
            for (double d7 = d4; d7 >= d3 - d2 && n2 < n3; d7 += d5, ++n2) {
                if (this.isDuplicateLabel(jCAnno, d7)) continue;
                JCValueLabel jCValueLabel = new JCValueLabel(jCAnno, d7);
                vector.add(jCValueLabel);
            }
        }
    }

    public double range() {
        double d2 = Double.MAX_VALUE;
        if (this.parent != null) {
            d2 = this.parent.max.value - this.parent.min.value;
        }
        return d2;
    }

    public void translate(double d2) {
        if (this.parent == null) {
            return;
        }
        if (this.parent.isReversed()) {
            d2 = -d2;
        }
        this.parent.min.value += d2;
        this.parent.max.value += d2;
    }

    public String format(double d2, int n2) {
        return JCChartUtil.format(d2, n2);
    }
}

