/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.PercentageOfAvailableHeight;
import java.io.Serializable;

public class JCTimeLineChartFormat
implements JCChartTypeFormat,
PercentageOfAvailableHeight,
Serializable {
    public static final int INTERVAL_LABEL_NONE = 0;
    public static final int INTERVAL_LABEL_SERIES = 1;
    public static final int INTERVAL_LABEL_DATA = 2;
    public static final int INTERVAL_LABEL_STATE = 4;
    protected Changeable parent = null;
    protected int barHeightMode = 2;
    protected int intervalLabelMode = 1;
    protected int labelInset = 5;
    protected double labelThreshold = 1.0;
    protected int maxSymbolLabelWidth = 100;
    protected int maxTrackHeight = Integer.MAX_VALUE;
    protected boolean mergeTracks = true;
    protected int percentageHeight = 70;
    protected int trackPosition = 1;
    protected boolean truncateLabels = false;
    protected int truncateMode = 5;
    protected boolean useEllipsisWhenTruncating = true;
    protected int layoutType = 0;
    protected boolean ascendingTracks = false;

    public JCTimeLineChartFormat() {
    }

    public JCTimeLineChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public void setMaxTrackHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxTrackHeight must be positive");
        }
        if (this.maxTrackHeight == n2) {
            return;
        }
        this.maxTrackHeight = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getMaxTrackHeight() {
        return this.maxTrackHeight;
    }

    public void setBarHeightMode(int n2) {
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException("barHeightMode must be one of HEIGHT_MODE_PIXEL or HEIGHT_MODE_PERCENTAGE");
        }
        if (this.barHeightMode == n2) {
            return;
        }
        this.barHeightMode = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getBarHeightMode() {
        return this.barHeightMode;
    }

    public void setPercentageHeight(int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("PercentageHeight must be between 0 and 100");
        }
        if (this.percentageHeight == n2) {
            return;
        }
        this.percentageHeight = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getPercentageHeight() {
        return this.percentageHeight;
    }

    public void setLabelThreshold(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("LabelThreshold must be non-negative.");
        }
        if (this.labelThreshold == d2) {
            return;
        }
        this.labelThreshold = d2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getLabelThreshold() {
        return this.labelThreshold;
    }

    public void setIntervalLabelMode(int n2) {
        if (n2 < 0 || n2 >= 8) {
            throw new IllegalArgumentException("intervalLabelMode must be INTERVAL_LABEL_NONE or some OR'ed combination of INTERVAL_LABEL_SERIES,INTERVAL_LABEL_DATA, and INTERVAL_LABEL_STATE.");
        }
        if (this.intervalLabelMode == n2) {
            return;
        }
        this.intervalLabelMode = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getIntervalLabelMode() {
        return this.intervalLabelMode;
    }

    public void setMergeTracks(boolean bl) {
        this.mergeTracks = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isMergeTracks() {
        return this.mergeTracks;
    }

    public void setLabelInset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("LabelInset must be non-negative.");
        }
        if (this.labelInset == n2) {
            return;
        }
        this.labelInset = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getLabelInset() {
        return this.labelInset;
    }

    public void setTruncateLabels(boolean bl) {
        this.truncateLabels = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isTruncateLabels() {
        return this.truncateLabels;
    }

    public void setUseEllipsisWhenTruncating(boolean bl) {
        this.useEllipsisWhenTruncating = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isUseEllipsisWhenTruncating() {
        return this.useEllipsisWhenTruncating;
    }

    public void setTruncateMode(int n2) {
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("truncateMode must be one of JCUtil.TRUNCATE_LEFT, JCUtil.TRUNCATE_RIGHT, JCUtil.TRUNCATE_MIDDLE, JCUtil.TRUNCATE_END, JCUtil.TRUNCATE_LEADING, or JCUtil.TRUNCATE_TRAILING.");
        }
        if (this.truncateMode == n2) {
            return;
        }
        this.truncateMode = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getTruncateMode() {
        return this.truncateMode;
    }

    public void setMaxSymbolLabelWidth(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxLabelWdith must be non-negative.");
        }
        if (this.maxSymbolLabelWidth == n2) {
            return;
        }
        this.maxSymbolLabelWidth = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getMaxSymbolLabelWidth() {
        return this.maxSymbolLabelWidth;
    }

    public void setTrackPosition(int n2) {
        if (n2 != 1 && n2 != 0 && n2 != 3) {
            throw new IllegalArgumentException("trackPosition must be one of SwingConstants.TOP, SwingConstants.CENTER, or SwingConstants.BOTTOM.");
        }
        if (this.trackPosition == n2) {
            return;
        }
        this.trackPosition = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getTrackPosition() {
        return this.trackPosition;
    }

    public void setLayoutType(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("layoutPosition must be one of TimeLineLayout.LAYOUT_DEFAULT orTimeLineLayout.LAYOUT_STEPPED.");
        }
        if (this.layoutType == n2) {
            return;
        }
        this.layoutType = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public void setAscendingTracks(boolean bl) {
        if (this.ascendingTracks == bl) {
            return;
        }
        this.ascendingTracks = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isAscendingTracks() {
        return this.ascendingTracks;
    }
}

