/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;

public class JCThreshold
extends JCAbstractThreshold {
    public static final int LIMIT_TYPE_STEPPED = 0;
    public static final int LIMIT_TYPE_ENVELOPE = 1;
    protected double startValue = -1.7976931348623157E308;
    protected double endValue = Double.MAX_VALUE;
    protected Point2D.Double[] startValues = null;
    protected Point2D.Double[] startValuesInternal = null;
    protected Point2D.Double[] endValues = null;
    protected Point2D.Double[] endValuesInternal = null;
    protected int limitType = 1;
    protected boolean associatedWithYAxis = true;
    protected JCLineStyle startLineStyle = null;
    protected JCLineStyle endLineStyle = null;
    protected boolean drawJustBeforeData = false;
    private JCChartArea area;
    private JCAxis axis;
    private JCAxis oppositeAxis;
    private double adjStartValue;
    private double adjEndValue;
    private boolean isRectangular = false;
    private boolean isRadar = false;
    private boolean isWebbed = false;
    private boolean isCircular = false;
    private Rectangle plotAreaRect = null;

    public JCThreshold() {
    }

    public JCThreshold(String string, double d2, double d3, boolean bl) {
        this(string, d2, d3, bl, null);
    }

    public JCThreshold(String string, double d2, double d3, boolean bl, Color color) {
        if (color != null) {
            JCFillStyle jCFillStyle = new JCFillStyle(color, 1);
            this.chartStyle = new JCChartStyle();
            this.chartStyle.setFillStyle(jCFillStyle);
            this.chartStyleDefault = false;
        }
        this.label = string;
        this.startValue = d2;
        this.endValue = d3;
        this.associatedWithYAxis = bl;
    }

    public JCThreshold(String string, double d2, double d3, boolean bl, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, JCLineStyle jCLineStyle2, boolean bl2) {
        this.label = string;
        this.startValue = d2;
        this.endValue = d3;
        this.associatedWithYAxis = bl;
        if (jCFillStyle != null) {
            this.chartStyle = new JCChartStyle();
            this.chartStyle.setFillStyle(jCFillStyle);
            this.chartStyleDefault = false;
        }
        this.startLineStyle = jCLineStyle;
        this.endLineStyle = jCLineStyle2;
        this.visibleInLegend = bl2;
    }

    public JCThreshold(String string, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, int n2, boolean bl, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, JCLineStyle jCLineStyle2, boolean bl2) {
        this.label = string;
        this.startValues = doubleArray;
        this.startValuesInternal = doubleArray;
        double d2 = this.getHoleValue();
        if (!JCThreshold.checkValues(doubleArray, true, d2)) {
            this.startValuesInternal = this.sortArray(doubleArray);
        }
        this.endValues = doubleArray2;
        this.endValuesInternal = doubleArray2;
        if (!JCThreshold.checkValues(doubleArray2, false, d2)) {
            this.endValuesInternal = this.sortArray(doubleArray2);
        }
        this.limitType = n2;
        this.associatedWithYAxis = bl;
        if (jCFillStyle != null) {
            this.chartStyle = new JCChartStyle();
            this.chartStyle.setFillStyle(jCFillStyle);
        }
        this.chartStyleDefault = false;
        this.startLineStyle = jCLineStyle;
        this.endLineStyle = jCLineStyle2;
        this.visibleInLegend = bl2;
        if (this.startValuesInternal != null && !JCThreshold.checkValues(this.startValuesInternal, true, d2)) {
            String string2 = "Illegal start threshold limit list.  This list must have at least two valid points and the X values must be strictly increasing.  Using startValue instead.";
            throw new IllegalArgumentException(string2);
        }
        if (this.endValuesInternal != null && !JCThreshold.checkValues(this.endValuesInternal, false, d2)) {
            String string3 = "Illegal end threshold limit list.  This list must have at least two valid points and the X values must be strictly increasing.  Using endValue instead.";
            throw new IllegalArgumentException(string3);
        }
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double d2) {
        this.startValue = d2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public double getEndValue() {
        return this.endValue;
    }

    public void setEndValue(double d2) {
        this.endValue = d2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public Point2D.Double[] getStartValues() {
        return this.startValues;
    }

    public void setStartValues(Point2D.Double[] doubleArray) {
        this.startValues = doubleArray;
        this.startValuesInternal = doubleArray;
        double d2 = this.getHoleValue();
        if (!JCThreshold.checkValues(doubleArray, true, d2)) {
            this.startValuesInternal = this.sortArray(doubleArray);
        }
        if (this.startValuesInternal != null && !JCThreshold.checkValues(this.startValuesInternal, true, d2)) {
            String string = "Illegal start threshold limit list.  This list must have at least two valid points and the X values must be strictly increasing.  Using startValue instead.";
            throw new IllegalArgumentException(string);
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public Point2D.Double[] getEndValues() {
        return this.endValues;
    }

    public void setEndValues(Point2D.Double[] doubleArray) {
        this.endValues = doubleArray;
        this.endValuesInternal = doubleArray;
        double d2 = this.getHoleValue();
        if (!JCThreshold.checkValues(doubleArray, false, d2)) {
            this.endValuesInternal = this.sortArray(doubleArray);
        }
        if (this.endValuesInternal != null && !JCThreshold.checkValues(this.endValuesInternal, false, d2)) {
            String string = "Illegal end threshold limit list.  This list must have at least two valid points and the X values must be strictly increasing.  Using endValue instead.";
            throw new IllegalArgumentException(string);
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public Point2D.Double[] getPoints(boolean bl, boolean bl2) {
        double d2;
        if (!bl2) {
            return bl ? this.startValues : this.endValues;
        }
        this.calcValues();
        if (this.axis == null || this.oppositeAxis == null) {
            return null;
        }
        double d3 = d2 = bl ? this.startValue : this.endValue;
        if (!JCThreshold.isValid(d2, this.getHoleValue())) {
            d2 = bl ? this.adjStartValue : this.adjEndValue;
        }
        double d4 = this.oppositeAxis.getMin();
        double d5 = this.oppositeAxis.getMax();
        Point2D.Double[] doubleArray = new Point2D.Double[]{new Point2D.Double(this.associatedWithYAxis ? d4 : d2, this.associatedWithYAxis ? d2 : d4), new Point2D.Double(this.associatedWithYAxis ? d5 : d2, this.associatedWithYAxis ? d2 : d5)};
        return doubleArray;
    }

    public double getConstantLimitValue(boolean bl) {
        double d2;
        double d3 = d2 = bl ? this.startValue : this.endValue;
        if (!JCThreshold.isValid(d2, this.getHoleValue())) {
            d2 = bl ? this.adjStartValue : this.adjEndValue;
        }
        return d2;
    }

    public int getLimitType() {
        return this.limitType;
    }

    public void setLimitType(int n2) {
        this.limitType = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isAssociatedWithYAxis() {
        return this.associatedWithYAxis;
    }

    public void setAssociatedWithYAxis(boolean bl) {
        this.associatedWithYAxis = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCFillStyle getFillStyle() {
        if (this.chartStyle == null && this.chartStyleDefault) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        return this.chartStyle == null ? null : this.chartStyle.getFillStyle();
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (jCFillStyle == null) {
            this.chartStyle = null;
        } else {
            if (this.chartStyle == null) {
                this.chartStyle = this.calcDefaultChartStyle();
            }
            if (this.chartStyle != null) {
                this.chartStyle.setFillStyle(jCFillStyle);
            }
        }
        this.chartStyleDefault = false;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isFillStyleDefault() {
        return this.chartStyleDefault;
    }

    public void setFillStyleDefault(boolean bl) {
        if (this.chartStyleDefault == bl) {
            return;
        }
        this.chartStyleDefault = bl;
        if (bl) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCLineStyle getStartLineStyle() {
        return this.startLineStyle;
    }

    public void setStartLineStyle(JCLineStyle jCLineStyle) {
        this.startLineStyle = jCLineStyle;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCLineStyle getEndLineStyle() {
        return this.endLineStyle;
    }

    public void setEndLineStyle(JCLineStyle jCLineStyle) {
        this.endLineStyle = jCLineStyle;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public void setDrawJustBeforeData(boolean bl) {
        this.drawJustBeforeData = bl;
    }

    public boolean isDrawJustBeforeData() {
        return this.drawJustBeforeData;
    }

    protected void adjustMinMax(MinMax minMax, boolean bl) {
        double d2;
        boolean bl2;
        if (minMax == null || this.parent == null) {
            return;
        }
        this.calcValues();
        if (this.axis == null) {
            return;
        }
        if (!bl && (this.axis.isPolar() || this.axis.isRadar())) {
            return;
        }
        boolean bl3 = this.axis.isLogarithmic();
        boolean bl4 = this.area.isPolarRadar();
        double d3 = this.getHoleValue();
        boolean bl5 = !bl4 && this.associatedWithYAxis && JCThreshold.checkValues(this.startValuesInternal, true, d3);
        boolean bl6 = !bl4 && this.associatedWithYAxis && JCThreshold.checkValues(this.endValuesInternal, false, d3);
        boolean bl7 = bl2 = !(bl ^ this.associatedWithYAxis);
        if (bl5) {
            for (Point2D.Double double_ : this.startValuesInternal) {
                if (double_ == null || !JCThreshold.isValid(double_.getX(), d3) || !JCThreshold.isValid(double_.getY(), d3)) continue;
                d2 = bl ? double_.getY() : double_.getX();
                minMax.setMinMax(d2, d3, bl3);
            }
        } else if (JCThreshold.isValid(this.startValue, d3) && bl2) {
            minMax.setMinMax(this.startValue, d3, bl3);
        }
        if (bl6) {
            for (Point2D.Double double_ : this.endValuesInternal) {
                if (double_ == null || !JCThreshold.isValid(double_.getX(), d3) || !JCThreshold.isValid(double_.getY(), d3)) continue;
                d2 = bl ? double_.getY() : double_.getX();
                minMax.setMinMax(d2, d3, bl3);
            }
        } else if (JCThreshold.isValid(this.endValue, d3) && bl2) {
            minMax.setMinMax(this.endValue, d3, bl3);
        }
    }

    private void calcValues() {
        if (this.parent == null) {
            return;
        }
        if (this.chartStyle == null && this.chartStyleDefault) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        this.axis = this.associatedWithYAxis ? this.parent.getYAxis() : this.parent.getXAxis();
        JCAxis jCAxis = this.oppositeAxis = this.associatedWithYAxis ? this.parent.getXAxis() : this.parent.getYAxis();
        if (this.axis == null || this.oppositeAxis == null) {
            return;
        }
        this.area = this.axis.getChartArea();
        int n2 = this.parent.getChartType();
        boolean bl = n2 == 3 || n2 == 4;
        int n3 = bl ? ChartDataView.getNumRadarSpokes(this.parent) : 0;
        double d2 = this.axis.getMin();
        double d3 = this.axis.getMax();
        if (bl && !this.associatedWithYAxis) {
            d2 = 0.0;
            d3 = n3;
        }
        this.adjStartValue = JCNumberUtil.clamp(this.startValue, d2, d3);
        this.adjEndValue = JCNumberUtil.clamp(this.endValue, d2, d3);
    }

    public boolean isValidLimit(double d2, boolean bl) {
        return JCThreshold.isValidLimit(d2, this.getHoleValue(), bl);
    }

    protected static boolean isValidLimit(double d2, double d3, boolean bl) {
        if (bl) {
            if (d3 == -1.7976931348623157E308) {
                return d2 != Double.MAX_VALUE;
            }
            return d2 != d3 && d2 != Double.MAX_VALUE;
        }
        if (d3 == Double.MAX_VALUE) {
            return d2 != -1.7976931348623157E308;
        }
        return d2 != d3 && d2 != -1.7976931348623157E308;
    }

    public static boolean checkValues(Point2D.Double[] doubleArray, boolean bl, double d2) {
        if (doubleArray == null) {
            return false;
        }
        if (doubleArray.length < 2) {
            return false;
        }
        Point2D.Double double_ = doubleArray[0];
        double d3 = double_ == null ? d2 : double_.getX();
        double d4 = double_ == null ? d2 : double_.getY();
        boolean bl2 = JCThreshold.isValid(d3, d2) && JCThreshold.isValidLimit(d4, d2, bl);
        int n2 = bl2 ? 1 : 0;
        for (int i2 = 1; i2 < doubleArray.length; ++i2) {
            Point2D.Double double_2 = doubleArray[i2];
            if (double_2 == null) continue;
            double d5 = double_2.getX();
            double d6 = double_2.getY();
            if (!JCThreshold.isValid(d5, d2) || !JCThreshold.isValidLimit(d6, d2, bl)) continue;
            ++n2;
            if (bl2 && d3 >= d5) {
                return false;
            }
            d3 = d5;
            bl2 = true;
        }
        return n2 >= 2;
    }

    protected Point2D.Double[] sortArray(Point2D.Double[] doubleArray) {
        if (doubleArray == null || doubleArray.length < 2) {
            return doubleArray;
        }
        Point2D.Double[] doubleArray2 = (Point2D.Double[])doubleArray.clone();
        Arrays.sort(doubleArray2, new DataSortAscending());
        return doubleArray2;
    }

    protected int getValidPointIndex(Point[] pointArray, boolean bl) {
        if (pointArray == null || pointArray.length == 0) {
            return -1;
        }
        int n2 = bl ? 0 : pointArray.length - 1;
        int n3 = bl ? pointArray.length : -1;
        int n4 = bl ? 1 : -1;
        for (int i2 = n2; i2 != n3; i2 += n4) {
            if (pointArray[i2] == null) continue;
            return i2;
        }
        return -1;
    }

    protected Point[] transformLimitArray(Point2D.Double[] doubleArray, double d2, boolean bl) {
        if (doubleArray == null) {
            return null;
        }
        boolean bl2 = !this.area.draw3D;
        boolean bl3 = this.limitType == 0;
        boolean bl4 = this.parent != null && this.parent.isUsingDoublePixels();
        int n2 = bl3 ? 1 : 0;
        Point[] pointArray = new Point[bl3 ? 2 * doubleArray.length + 1 : doubleArray.length];
        double d3 = this.getHoleValue();
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            int n3;
            int n4;
            Point2D.Double double_ = doubleArray[i2];
            if (double_ == null) continue;
            double d4 = double_.getX();
            double d5 = double_.getY();
            if (!JCThreshold.isValid(d4, d3) || !JCThreshold.isValidLimit(d5, d3, bl)) continue;
            if (!JCThreshold.isValid(d5, d3)) {
                d5 = d2;
            }
            if (bl4) {
                n4 = this.fastTransformDouble(d4, this.oppositeAxis, bl2);
                n3 = this.fastTransformDouble(d5, this.axis, bl2);
            } else {
                n4 = this.fastTransformInt(d4, this.oppositeAxis, bl2);
                n3 = this.fastTransformInt(d5, this.axis, bl2);
            }
            boolean bl5 = true;
            if (bl3 && i2 != 0) {
                Point point = pointArray[n2 - 1];
                pointArray[n2] = this.axis.i_vertical ? new Point(n4, point.y) : new Point(point.x, n4);
                ++n2;
                boolean bl6 = bl5 = n3 != point.y;
            }
            if (!bl5) continue;
            pointArray[n2] = this.axis.i_vertical ? new Point(n4, n3) : new Point(n3, n4);
            ++n2;
        }
        return pointArray;
    }

    protected Point[] transformLimit(double d2, double d3, Rectangle rectangle) {
        int n2;
        boolean bl = !this.area.draw3D;
        boolean bl2 = this.limitType == 0;
        double d4 = JCThreshold.isValid(d2, this.getHoleValue()) ? d2 : d3;
        int n3 = this.transform(d4, this.axis, bl);
        Point[] pointArray = new Point[bl2 ? 4 : 2];
        int n4 = n2 = bl2 ? 1 : 0;
        if (this.axis.i_vertical) {
            pointArray[n2++] = new Point(rectangle.x, n3);
            pointArray[n2] = new Point(rectangle.x + rectangle.width + 1, n3);
        } else {
            pointArray[n2++] = new Point(n3, rectangle.y + rectangle.height + 1);
            pointArray[n2] = new Point(n3, rectangle.y);
        }
        return pointArray;
    }

    protected void draw(Graphics graphics, boolean bl, boolean bl2, boolean bl3, Rectangle rectangle) {
        this.isRectangular = bl;
        this.isRadar = bl2;
        this.isWebbed = bl3;
        this.isCircular = !bl && (!bl2 || !bl3);
        this.plotAreaRect = rectangle;
        this.calcValues();
        if (this.area == null || this.parent == null || this.axis == null) {
            return;
        }
        boolean bl4 = graphics instanceof DefineShape;
        Graphics graphics2 = bl4 ? graphics.create() : graphics;
        Shape shape = graphics2.getClip();
        Rectangle rectangle2 = this.drawJustBeforeData ? this.area.clipToEntirePlotRect() : this.area.clipForDrawing(0);
        graphics2.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        RenderShape renderShape = new RenderShape(graphics2, graphics2, this.parent.isUsingDoublePixels());
        renderShape.setFillStyle(this.getFillStyle());
        this.processThreshold(renderShape);
        if (bl4) {
            graphics2.dispose();
        } else {
            graphics2.setClip(shape);
        }
    }

    protected JCPickItem pick(Point point) {
        this.calcValues();
        if (this.area == null || this.parent == null || this.axis == null || this.isRectangular && this.plotAreaRect == null || this.pickFocus == 3) {
            return null;
        }
        Point point2 = this.area.getLocation();
        int n2 = point.x - point2.x;
        int n3 = point.y - point2.y;
        boolean bl = this.associatedWithYAxis ^ this.axis.i_vertical;
        int n4 = this.isRectangular ? this.pickFocus : 0;
        Picker picker = new Picker(n2, n3, n4);
        PickShape pickShape = new PickShape(picker, false, bl);
        pickShape.setFillStyle(this.getFillStyle());
        this.processThreshold(pickShape);
        JCPickItem jCPickItem = null;
        if (picker.distance <= 0) {
            jCPickItem = new JCPickItem(this, this.area, 0);
        }
        return jCPickItem;
    }

    protected void processThreshold(ProcessShape processShape) {
        if (processShape == null) {
            return;
        }
        if (this.isRectangular) {
            this.processRectangular(processShape);
        } else if (this.isRadar && this.isWebbed) {
            this.processWebbed(processShape);
        } else if (this.isCircular) {
            this.processCircular(processShape);
        }
    }

    protected void processRectangular(ProcessShape processShape) {
        Point[] pointArray;
        boolean bl;
        if (this.plotAreaRect == null) {
            return;
        }
        JCFillStyle jCFillStyle = this.getFillStyle();
        if (jCFillStyle == null && this.startLineStyle == null && this.endLineStyle == null) {
            return;
        }
        double d2 = this.getHoleValue();
        boolean bl2 = this.associatedWithYAxis && JCThreshold.checkValues(this.startValuesInternal, true, d2);
        boolean bl3 = bl = this.associatedWithYAxis && JCThreshold.checkValues(this.endValuesInternal, false, d2);
        if (!bl2 && !bl && this.adjEndValue <= this.adjStartValue) {
            return;
        }
        Polygon polygon = new Polygon();
        Point[] pointArray2 = bl2 ? this.transformLimitArray(this.startValuesInternal, this.axis.getMin(), true) : this.transformLimit(this.startValue, this.adjStartValue, this.plotAreaRect);
        Point[] pointArray3 = pointArray = bl ? this.transformLimitArray(this.endValuesInternal, this.axis.getMax(), false) : this.transformLimit(this.endValue, this.adjEndValue, this.plotAreaRect);
        if (this.limitType == 0) {
            Point point;
            Point point2;
            int n2 = this.getValidPointIndex(pointArray2, true);
            int n3 = this.getValidPointIndex(pointArray, true);
            if (n2 >= 0 && n3 >= 0) {
                point2 = pointArray2[n2];
                point = pointArray[n3];
                if (this.axis.i_vertical) {
                    if (point2.x > point.x) {
                        pointArray2[0] = new Point(point.x, point2.y);
                    } else if (point2.x < point.x) {
                        pointArray[0] = new Point(point2.x, point.y);
                    }
                } else if (point2.y > point.y) {
                    pointArray[0] = new Point(point.x, point2.y);
                } else if (point2.y < point.y) {
                    pointArray2[0] = new Point(point2.x, point.y);
                }
            }
            n2 = this.getValidPointIndex(pointArray2, false);
            n3 = this.getValidPointIndex(pointArray, false);
            if (n2 >= 0 && n3 >= 0) {
                point2 = pointArray2[n2];
                point = pointArray[n3];
                if (this.axis.i_vertical) {
                    if (point2.x > point.x) {
                        pointArray[n3 + 1] = new Point(point2.x, point.y);
                    } else if (point2.x < point.x) {
                        pointArray2[n2 + 1] = new Point(point.x, point2.y);
                    }
                } else if (point2.y > point.y) {
                    pointArray2[n2 + 1] = new Point(point2.x, point.y);
                } else if (point2.y < point.y) {
                    pointArray[n3 + 1] = new Point(point.x, point2.y);
                }
            }
        }
        for (Point point : pointArray2) {
            if (point == null) continue;
            polygon.addPoint(point.x, point.y);
        }
        for (int i2 = pointArray.length - 1; i2 >= 0; --i2) {
            if (pointArray[i2] == null) continue;
            polygon.addPoint(pointArray[i2].x, pointArray[i2].y);
        }
        if (jCFillStyle != null) {
            jCFillStyle.updateAnchorRect(polygon.getBounds());
            processShape.fillPolygon(polygon);
            jCFillStyle.updateAnchorRect(null);
        }
        if (bl2 || JCThreshold.isValid(this.startValue, d2)) {
            this.processThresholdLine(processShape, pointArray2, true);
        }
        if (bl || JCThreshold.isValid(this.endValue, d2)) {
            this.processThresholdLine(processShape, pointArray, false);
        }
    }

    protected void processCircular(ProcessShape processShape) {
        JCAxis jCAxis = this.parent.getXAxis();
        if (jCAxis == null) {
            return;
        }
        JCFillStyle jCFillStyle = this.getFillStyle();
        if (jCFillStyle == null && this.startLineStyle == null && this.endLineStyle == null) {
            return;
        }
        processShape.setFillStyle(jCFillStyle);
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d2 = Math.round(polarAxisParams.xCenter);
        double d3 = Math.round(polarAxisParams.yCenter);
        double d4 = Math.round(polarAxisParams.radius);
        if (this.associatedWithYAxis) {
            if (this.adjEndValue <= this.adjStartValue) {
                return;
            }
            Point point = jCAxis.toPixelPolar(0.0, this.adjStartValue, true);
            Point point2 = jCAxis.toPixelPolar(0.0, this.adjEndValue, true);
            if (jCFillStyle != null && jCFillStyle.getPattern() != 0) {
                processShape.fillArcRegion(point, point2, d2, d3);
            }
            double d5 = point2.distance(d2, d3);
            double d6 = point.distance(d2, d3);
            double d7 = this.getHoleValue();
            if (JCThreshold.isValid(this.startValue, d7) && this.startValue == this.adjStartValue) {
                this.processCircularBoundingLine(processShape, jCAxis, this.startLineStyle, d6);
            }
            if (JCThreshold.isValid(this.endValue, d7) && this.endValue == this.adjEndValue) {
                this.processCircularBoundingLine(processShape, jCAxis, this.endLineStyle, d5);
            }
        } else {
            this.processCircularRegion(processShape, jCAxis, jCFillStyle, d2, d3, d4);
        }
    }

    protected void processCircularRegion(ProcessShape processShape, JCAxis jCAxis, JCFillStyle jCFillStyle, double d2, double d3, double d4) {
        Shape shape = null;
        if (this.isWebbed) {
            shape = processShape.getClip();
            int n2 = ChartDataView.getNumRadarSpokes(this.parent);
            GeneralPath generalPath = jCAxis.createWebbedShape(d4, n2);
            processShape.setClip(generalPath);
        }
        if (this.adjStartValue == this.adjEndValue && this.adjStartValue != this.startValue && this.adjEndValue != this.endValue) {
            return;
        }
        if (jCFillStyle != null) {
            double d5 = this.area.getAngleFromXValue(this.parent, this.adjStartValue, this.isRadar, 1);
            double d6 = this.area.getAngleFromXValue(this.parent, this.adjEndValue, this.isRadar, 1);
            double d7 = 2.0 * d4;
            double d8 = d6 - d5;
            if (d8 < 0.0 ^ jCAxis.isReversed()) {
                d8 += d8 < 0.0 ? 360.0 : -360.0;
            }
            if (processShape.isWithinClip()) {
                double d9 = d2 - d4;
                double d10 = d3 - d4;
                jCFillStyle.updateAnchorRect(new Rectangle((int)d9, (int)d10, (int)d7, (int)d7));
                processShape.fillArc(d9, d10, d7, d7, d5, d8);
                jCFillStyle.updateAnchorRect(null);
            }
        }
        this.processRadialThresholdLine(processShape, jCAxis, this.adjStartValue, true);
        this.processRadialThresholdLine(processShape, jCAxis, this.adjEndValue, false);
        if (this.isWebbed) {
            processShape.setClip(shape);
        }
    }

    protected void processWebbed(ProcessShape processShape) {
        JCAxis jCAxis = this.parent.getXAxis();
        if (jCAxis == null) {
            return;
        }
        JCFillStyle jCFillStyle = this.getFillStyle();
        if (jCFillStyle == null && this.startLineStyle == null && this.endLineStyle == null) {
            return;
        }
        processShape.setFillStyle(jCFillStyle);
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d2 = Math.round(polarAxisParams.xCenter);
        double d3 = Math.round(polarAxisParams.yCenter);
        double d4 = Math.rint(jCAxis.polarAxisParams.radius);
        int n2 = ChartDataView.getNumRadarSpokes(this.parent);
        if (n2 <= 0) {
            return;
        }
        double d5 = JCChartUtil.getRadarAngle(2, n2, 1, false);
        if (this.associatedWithYAxis) {
            double d6;
            if (this.adjEndValue <= this.adjStartValue) {
                return;
            }
            Point point = jCAxis.toPixelPolar(0.0, this.adjStartValue, true);
            Point point2 = jCAxis.toPixelPolar(0.0, this.adjEndValue, true);
            double d7 = point2.distance(d2, d3);
            double d8 = point.distance(d2, d3);
            if (jCFillStyle != null) {
                Point point3 = point;
                Point point4 = point2;
                for (int i2 = 0; i2 < n2 + 1; ++i2) {
                    double d9 = i2 == n2 ? 0.0 : (double)i2 * d5;
                    Point point5 = jCAxis.toPixelPolar(d9, d8, false);
                    Point point6 = jCAxis.toPixelPolar(d9, d7, false);
                    Polygon polygon = new Polygon();
                    polygon.addPoint(point3.x, point3.y);
                    polygon.addPoint(point4.x, point4.y);
                    polygon.addPoint(point6.x, point6.y);
                    polygon.addPoint(point5.x, point5.y);
                    processShape.fillOutlinePolygon(polygon, jCFillStyle.getColor());
                    point3 = point5;
                    point4 = point6;
                }
            }
            if (JCThreshold.isValid(this.startValue, d6 = this.getHoleValue()) && this.startValue == this.adjStartValue) {
                this.processWebLine(processShape, true, d8, n2);
            }
            if (JCThreshold.isValid(this.endValue, d6) && this.endValue == this.adjEndValue) {
                this.processWebLine(processShape, false, d7, n2);
            }
        } else {
            this.processCircularRegion(processShape, jCAxis, jCFillStyle, d2, d3, d4);
        }
    }

    protected void processThresholdLine(ProcessShape processShape, Point[] pointArray, boolean bl) {
        JCLineStyle jCLineStyle;
        JCLineStyle jCLineStyle2 = jCLineStyle = bl ? this.startLineStyle : this.endLineStyle;
        if (jCLineStyle != null && pointArray != null && pointArray.length > 1) {
            GeneralPath generalPath = new GeneralPath();
            int n2 = this.getValidPointIndex(pointArray, true);
            if (n2 < 0) {
                return;
            }
            Point point = pointArray[n2];
            generalPath.moveTo(point.x, point.y);
            for (int i2 = n2 + 1; i2 < pointArray.length; ++i2) {
                Point point2 = pointArray[i2];
                if (point2 == null) continue;
                generalPath.lineTo(point2.x, point2.y);
            }
            processShape.setLineStyle(jCLineStyle);
            processShape.drawShape(generalPath);
        }
    }

    protected void processRadialThresholdLine(ProcessShape processShape, JCAxis jCAxis, double d2, boolean bl) {
        JCLineStyle jCLineStyle;
        JCLineStyle jCLineStyle2 = jCLineStyle = bl ? this.startLineStyle : this.endLineStyle;
        if (jCLineStyle != null && this.area != null) {
            double d3;
            PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
            int n2 = (int)Math.round(polarAxisParams.xCenter);
            int n3 = (int)Math.round(polarAxisParams.yCenter);
            if (this.isRadar) {
                int n4 = ChartDataView.getNumRadarSpokes(this.parent);
                d3 = JCChartUtil.getRadarAngle(2, n4, d2, false);
            } else {
                d3 = JCChartUtil.convertAngle(this.area.getAngleUnit(), 2, d2);
            }
            Point point = jCAxis.toPixelPolar(d3, Math.round(polarAxisParams.radius), false);
            processShape.setLineStyle(jCLineStyle);
            processShape.drawShape(new Line2D.Double(n2, n3, point.x, point.y));
        }
    }

    protected void processWebLine(ProcessShape processShape, boolean bl, double d2, int n2) {
        JCLineStyle jCLineStyle;
        JCAxis jCAxis = this.parent.getXAxis();
        if (jCAxis == null) {
            return;
        }
        JCLineStyle jCLineStyle2 = jCLineStyle = bl ? this.startLineStyle : this.endLineStyle;
        if (jCLineStyle != null) {
            GeneralPath generalPath = jCAxis.createWebbedShape(d2, n2);
            processShape.setLineStyle(jCLineStyle);
            processShape.drawShape(generalPath);
        }
    }

    protected void processCircularBoundingLine(ProcessShape processShape, JCAxis jCAxis, JCLineStyle jCLineStyle, double d2) {
        if (jCLineStyle == null) {
            return;
        }
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d3 = Math.round(polarAxisParams.radius);
        if (d2 < 0.0 || d2 > d3) {
            throw new IllegalArgumentException("Bounding line radius must be between 0 and the plot area radius=" + d3);
        }
        processShape.setLineStyle(jCLineStyle);
        processShape.drawCircle(Math.round(polarAxisParams.xCenter), Math.round(polarAxisParams.yCenter), d2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataSortAscending
    implements Comparator<Point2D.Double> {
        DataSortAscending() {
        }

        @Override
        public int compare(Point2D.Double double_, Point2D.Double double_2) {
            if (double_ == null) {
                return 1;
            }
            if (double_2 == null) {
                return -1;
            }
            if (double_.x > double_2.x) {
                return 1;
            }
            if (double_.x < double_2.x) {
                return -1;
            }
            return 0;
        }
    }
}

