/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.OutlineConfigurable;
import java.io.Serializable;

public class JCPolarRadarChartFormat
implements JCChartTypeFormat,
OutlineConfigurable,
Serializable {
    protected Changeable parent = null;
    protected int outlineStyle = 0;

    public JCPolarRadarChartFormat() {
    }

    public JCPolarRadarChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    protected JCAxis getYAxis() {
        JCAxis jCAxis = null;
        if (this.parent != null && this.parent instanceof ChartDataView) {
            jCAxis = ((ChartDataView)this.parent).getYAxis();
        }
        return jCAxis;
    }

    protected JCAxis getThetaAxis() {
        JCAxis jCAxis = null;
        if (this.parent != null && this.parent instanceof ChartDataView) {
            jCAxis = ((ChartDataView)this.parent).getXAxis();
        }
        return jCAxis;
    }

    protected int getCurrentAngleUnit() {
        if (this.parent != null && this.parent instanceof ChartDataView) {
            ChartDataView chartDataView = (ChartDataView)this.parent;
            return chartDataView.getParent().getChartArea().getAngleUnit();
        }
        return 2;
    }

    public void setYAxisAngle(double d2) {
        this.setYAxisAngle(this.getCurrentAngleUnit(), d2);
    }

    public void setYAxisAngle(int n2, double d2) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            jCAxis.setYAxisAngle(n2, d2);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public double getYAxisAngle() {
        return this.getYAxisAngle(this.getCurrentAngleUnit());
    }

    public double getYAxisAngle(int n2) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            return jCAxis.getYAxisAngle(n2);
        }
        return 0.0;
    }

    public void setOriginBase(double d2) {
        this.setOriginBase(this.getCurrentAngleUnit(), d2);
    }

    public void setOriginBase(int n2, double d2) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setOriginBase(n2, d2);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public double getOriginBase() {
        return this.getOriginBase(this.getCurrentAngleUnit());
    }

    public double getOriginBase(int n2) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            return jCAxis.polarAxisParams.getOriginBase(n2);
        }
        return 0.0;
    }

    public void setHalfRange(boolean bl) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setPolarHalfRange(bl);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public boolean isHalfRange() {
        JCAxis jCAxis = this.getThetaAxis();
        return jCAxis != null && jCAxis.polarAxisParams.isPolarHalfRange();
    }

    public void setRadarCircularGrid(boolean bl) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setCircularGrid(bl);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public boolean isRadarCircularGrid() {
        JCAxis jCAxis = this.getYAxis();
        return jCAxis == null || jCAxis.polarAxisParams.isCircularGrid();
    }

    public int getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("OutlineStyle must be one of OUTLINE_STYLE, SERIES_LINE_STYLE, or CHART_AREA_FOREGROUND.");
        }
        this.outlineStyle = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }
}

