/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.PercentageOfAvailableWidth;
import java.io.Serializable;

public class JCHLOCChartFormat
implements JCChartTypeFormat,
PercentageOfAvailableWidth,
Serializable {
    protected boolean isShowingOpen = true;
    protected boolean isShowingClose = true;
    protected boolean isOpenCloseFullWidth = false;
    protected ChartDataView parent = null;
    protected int openCloseWidthMode = 1;
    protected int percentageWidth = 40;

    public JCHLOCChartFormat() {
    }

    public JCHLOCChartFormat(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public ChartDataView getParent() {
        return this.parent;
    }

    public boolean isShowingOpen() {
        return this.isShowingOpen;
    }

    public void setShowingOpen(boolean bl) {
        if (this.isShowingOpen == bl) {
            return;
        }
        this.isShowingOpen = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isShowingClose() {
        return this.isShowingClose;
    }

    public void setShowingClose(boolean bl) {
        if (this.isShowingClose == bl) {
            return;
        }
        this.isShowingClose = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isOpenCloseFullWidth() {
        return this.isOpenCloseFullWidth;
    }

    public void setOpenCloseFullWidth(boolean bl) {
        if (this.isOpenCloseFullWidth == bl) {
            return;
        }
        this.isOpenCloseFullWidth = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCChartStyle getHiloStyle(int n2) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData());
        }
        return jCChartStyle;
    }

    public void setHiloStyle(int n2, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n2 * this.parent.getNumSeriesPerData(), jCChartStyle);
        }
    }

    public int getTickSize(int n2) {
        JCChartStyle jCChartStyle;
        int n3 = 0;
        if (this.parent != null && (jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData())) != null) {
            n3 = jCChartStyle.getSymbolSize();
        }
        return n3;
    }

    public void setTickSize(int n2, int n3) {
        JCChartStyle jCChartStyle;
        if (this.parent != null && (jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData())) != null) {
            jCChartStyle.setSymbolSize(n3);
        }
    }

    public int getOpenCloseWidthMode() {
        return this.openCloseWidthMode;
    }

    public void setOpenCloseWidthMode(int n2) {
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException("OpenCloseWidthMode must be one ofWIDTH_MODE_PIXEL or WIDTH_MODE_PERCENTAGE");
        }
        this.openCloseWidthMode = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public int getPercentageWidth() {
        return this.percentageWidth;
    }

    public void setPercentageWidth(int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("PercentageWidth must be between 0 and 100");
        }
        if (this.percentageWidth == n2) {
            return;
        }
        this.percentageWidth = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }
}

