/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;

public class JCGrid
implements Serializable {
    protected JCAxis parent = null;
    protected String name = null;
    protected DerivedDouble startValue = new DerivedDouble(0.0, true);
    protected DerivedDouble stopValue = new DerivedDouble(100.0, true);
    protected DerivedDouble incrementValue = new DerivedDouble(10.0, true);
    protected JCChartStyle gridStyle = new JCChartStyle(JCGrid.makeDefaultLineStyle(null), JCFillStyle.makeDefault(null), JCSymbolStyle.makeDefault(null));

    public JCGrid() {
    }

    public JCGrid(JCAxis jCAxis) {
        this.parent = jCAxis;
        this.startValue = new DerivedDouble(jCAxis.min.value, true);
        this.stopValue = new DerivedDouble(jCAxis.max.value, true);
        this.incrementValue = new DerivedDouble(jCAxis.numSpacing.value, true);
        this.setGridStyle(new JCChartStyle(JCGrid.makeDefaultLineStyle(jCAxis), JCFillStyle.makeDefault(null), JCSymbolStyle.makeDefault(null)));
    }

    public JCGrid(JCAxis jCAxis, double d2, double d3, double d4, JCChartStyle jCChartStyle) {
        this.parent = jCAxis;
        this.startValue = new DerivedDouble(d2, false);
        this.stopValue = new DerivedDouble(d3, false);
        this.incrementValue = new DerivedDouble(d4, false);
        this.gridStyle = jCChartStyle;
    }

    public JCAxis getParent() {
        return this.parent;
    }

    public void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getIncrementValue() {
        return this.incrementValue.value;
    }

    public boolean getIncrementIsDefault() {
        return this.incrementValue.isDefault;
    }

    public double getStartValue() {
        return this.startValue.value;
    }

    public boolean getStartValueIsDefault() {
        return this.startValue.isDefault;
    }

    public double getStopValue() {
        return this.stopValue.value;
    }

    public boolean getStopValueIsDefault() {
        return this.stopValue.isDefault;
    }

    public JCChartStyle getGridStyle() {
        return this.gridStyle;
    }

    public void setIncrementValue(double d2) {
        this.incrementValue.value = d2;
        this.incrementValue.isDefault = false;
    }

    public void setIncrementIsDefault(boolean bl) {
        this.incrementValue.isDefault = bl;
    }

    public void setStartValue(double d2) {
        this.startValue.value = d2;
        this.startValue.isDefault = false;
    }

    public void setStartValueIsDefault(boolean bl) {
        this.startValue.isDefault = bl;
    }

    public void setStopValue(double d2) {
        this.stopValue.value = d2;
        this.stopValue.isDefault = false;
    }

    public void setStopValueIsDefault(boolean bl) {
        this.stopValue.isDefault = bl;
    }

    public void setGridStyle(JCChartStyle jCChartStyle) {
        this.gridStyle = jCChartStyle;
    }

    public String toString() {
        String string = super.toString();
        string = string + ", name=" + this.name + ", startValue=" + this.startValue.value + ", stopValue=" + this.stopValue.value + ", incrementValue=" + this.incrementValue.value + ", lineStyle.color=" + this.gridStyle.getLineStyle().getColor() + ", lineStyle.width=" + this.gridStyle.getLineStyle().getWidth() + ", lineStyle.pattern=" + this.gridStyle.getLineStyle().getPattern() + ", lineStyle.join=" + this.gridStyle.getLineStyle().getJoin() + ", lineStyle.cap=" + this.gridStyle.getLineStyle().getCap();
        return string;
    }

    public static JCLineStyle makeDefaultLineStyle(JCAxis jCAxis) {
        Color color = jCAxis != null ? jCAxis.getForeground() : null;
        return new JCLineStyle(1, color, 1);
    }

    private static boolean equivalentGridLineColors(JCLineStyle jCLineStyle, JCLineStyle jCLineStyle2, JCAxis jCAxis) {
        Color color;
        Color color2 = jCLineStyle.getColor();
        Color color3 = jCLineStyle2.getColor();
        Color color4 = color = jCAxis != null ? jCAxis.getForeground() : null;
        boolean bl = color2 == null ? color3 == null || color != null && color3.equals(color) : (color3 == null ? color != null && color2.equals(color) : color2.equals(color3));
        return bl;
    }

    public static boolean equivalentGridLineStyles(JCLineStyle jCLineStyle, JCLineStyle jCLineStyle2, JCAxis jCAxis) {
        return jCLineStyle.getJoin() == jCLineStyle2.getJoin() && jCLineStyle.getCap() == jCLineStyle2.getCap() && jCLineStyle.getPattern() == jCLineStyle2.getPattern() && jCLineStyle.getWidth() == jCLineStyle2.getWidth() && JCGrid.equivalentGridLineColors(jCLineStyle, jCLineStyle2, jCAxis) && Arrays.equals(jCLineStyle.getCustomPatternArray(), jCLineStyle2.getCustomPatternArray()) && Arrays.equals(jCLineStyle.getCustomLegendPatternArray(), jCLineStyle2.getCustomLegendPatternArray());
    }

    public boolean isDefault() {
        return this.getStartValueIsDefault() && this.getStopValueIsDefault() && this.getIncrementIsDefault() && JCGrid.equivalentGridLineStyles(this.getGridStyle().getLineStyle(), JCGrid.makeDefaultLineStyle(this.parent), this.parent);
    }
}

