/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCAreaDataIndex;
import com.klg.jclass.chart.JCAutoLabelGenerator;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDataRange;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.util.ImageMapInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDefaultChartLabelManager
implements JCChartLabelManager,
Serializable {
    public static final String ERRMSG_INVALID_LABEL_INDEX = "Invalid ChartLabel index";
    protected Vector<JCChartLabel> labels = new Vector();
    protected Vector<JCChartLabel> dwellLabels = null;
    protected JCChartLabel currentDwellLabel = null;
    protected Hashtable<ChartDataView, JCChartLabel[][]> autoLabelListHashtable = new Hashtable();
    protected JCChart parentChart = null;

    @Override
    public void setParentChart(JCChart jCChart) {
        this.parentChart = jCChart;
    }

    @Override
    public JCChart getParentChart() {
        return this.parentChart;
    }

    @Override
    public void paintConnectors(Graphics graphics) {
        for (JCChartLabel jCChartLabel : this.labels) {
            if (jCChartLabel == null || jCChartLabel.component == null || !jCChartLabel.component.isShowing() || !jCChartLabel.isConnected() || !jCChartLabel.isDwellLabel()) continue;
            jCChartLabel.drawConnector(graphics);
        }
    }

    @Override
    public void addChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.appendChartLabel(jCChartLabel);
        jCChartLabel.setChanged(true, 2);
    }

    protected void appendChartLabel(JCChartLabel jCChartLabel) {
        for (JCChartLabel serializable2 : this.labels) {
            if (serializable2 == null || serializable2 != jCChartLabel) continue;
            return;
        }
        this.labels.addElement(jCChartLabel);
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            jCChartLabel.component.setLocale(jCChart.getLocale());
        }
        if (!jCChartLabel.isDwellLabel() && jCChart != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                jCChart.add((Component)jCChartLabel.line, 0);
            }
            jCChart.add((Component)jCChartLabel.component, 0);
        } else {
            this.addToDwellLabels(jCChartLabel);
        }
        jCChartLabel.setParentManager(this);
        JCDataIndex jCDataIndex = jCChartLabel.getDataIndex();
        if (jCDataIndex != null && jCDataIndex.getDataView() == null && jCChart != null) {
            jCDataIndex.setDataView(jCChart.getDataView(0));
        }
    }

    @Override
    public void addToDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels != null && this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        if (jCChartLabel.isDwellLabel()) {
            if (this.dwellLabels == null) {
                this.dwellLabels = new Vector();
                JCChart jCChart = this.getParentChart();
                if (jCChart != null) {
                    jCChart.registerForTooltips();
                }
            }
            this.dwellLabels.addElement(jCChartLabel);
        }
    }

    @Override
    public boolean locateCurrentDwellLabel(int n2, int n3) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.dwellLabels != null && this.dwellLabels.size() != 0) {
            List<ChartDataView> list = jCChart.getDataView();
            if (list == null || list.size() <= 0) {
                this.currentDwellLabel = null;
                return false;
            }
            JCDataIndex[] jCDataIndexArray = new JCDataIndex[list.size()];
            Iterator<ChartDataView> iterator = list.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                jCDataIndexArray[n4] = jCChart.pick(new Point(n2, n3), iterator.next());
                ++n4;
            }
            JCChartLabel jCChartLabel = null;
            int n5 = Integer.MAX_VALUE;
            for (JCChartLabel jCChartLabel2 : this.dwellLabels) {
                if (jCChartLabel2 == null) continue;
                JCDataIndex jCDataIndex = null;
                int n6 = list.indexOf(jCChartLabel2.getDataView());
                if (n6 >= 0) {
                    jCDataIndex = jCDataIndexArray[n6];
                }
                if (jCDataIndex == null || !jCChartLabel2.shouldPopupHere(jCDataIndex) || jCDataIndex.getDistance() > n5) continue;
                jCChartLabel = jCChartLabel2;
                n5 = jCDataIndex.getDistance();
            }
            if (jCChartLabel != null) {
                this.currentDwellLabel = jCChartLabel;
                return true;
            }
            this.currentDwellLabel = null;
            return false;
        }
        this.currentDwellLabel = null;
        return false;
    }

    @Override
    public Point getCurrentDwellLabelAttachPoint() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getAttachPoint();
        }
        return null;
    }

    @Override
    public JComponent getCurrentDwellLabelComponent() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getComponent();
        }
        return null;
    }

    @Override
    public JCChartLabel getCurrentDwellLabel() {
        return this.currentDwellLabel;
    }

    @Override
    public void removeChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.deleteChartLabel(jCChartLabel);
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    protected void deleteChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        JCChart jCChart = this.getParentChart();
        if (!jCChartLabel.isDwellLabel() && jCChart != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                jCChart.remove(jCChartLabel.line);
            }
            jCChart.remove(jCChartLabel.component);
        } else {
            this.removeFromDwellLabels(jCChartLabel);
        }
        this.labels.removeElement(jCChartLabel);
    }

    @Override
    public void removeFromDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels == null || !this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        this.dwellLabels.removeElement(jCChartLabel);
        if (this.dwellLabels.size() == 0) {
            JCChart jCChart = this.getParentChart();
            if (jCChart != null) {
                jCChart.unregisterForTooltips(this);
            }
            this.dwellLabels = null;
            this.currentDwellLabel = null;
        }
    }

    @Override
    public int getNumChartLabels() {
        int n2 = 0;
        if (this.labels != null) {
            n2 = this.labels.size();
        }
        return n2;
    }

    @Override
    public void removeAllChartLabels() {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            for (JCChartLabel object : this.labels) {
                if (object.isConnected() && object.line != null) {
                    jCChart.remove(object.line);
                }
                jCChart.remove(object.component);
            }
        }
        this.labels.removeAllElements();
        if (this.dwellLabels != null) {
            this.dwellLabels.removeAllElements();
            this.dwellLabels = null;
        }
        if (jCChart != null) {
            List<ChartDataView> list = jCChart.getDataView();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                this.autoLabelListHashtable.remove(chartDataView);
                chartDataView.setAutoLabel(false);
            }
            jCChart.setChanged(true, 1);
        }
    }

    @Override
    public JCChartLabel getChartLabels(int n2) {
        if (n2 < 0 || n2 >= this.labels.size()) {
            throw new IllegalArgumentException("Invalid ChartLabel index Index:" + n2 + " Size:" + this.labels.size());
        }
        return this.labels.elementAt(n2);
    }

    @Override
    public void setChartLabels(int n2, JCChartLabel jCChartLabel) {
        if (n2 < 0 || n2 > this.labels.size()) {
            throw new IllegalArgumentException("Invalid ChartLabel index Index:" + n2 + " Size:" + this.labels.size());
        }
        JCChart jCChart = this.getParentChart();
        if (n2 < this.labels.size()) {
            JCChartLabel jCChartLabel2 = this.labels.elementAt(n2);
            if (jCChartLabel == null) {
                this.removeChartLabel(jCChartLabel2);
            } else {
                if (!this.labels.contains(jCChartLabel)) {
                    this.removeFromDwellLabels(jCChartLabel2);
                    if (jCChart != null && jCChartLabel2 != null) {
                        jCChart.remove(jCChartLabel2.component);
                    }
                    this.labels.setElementAt(jCChartLabel, n2);
                    if (!jCChartLabel.isDwellLabel() && jCChart != null) {
                        if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                            jCChart.add((Component)jCChartLabel.line, 0);
                        }
                        jCChart.add((Component)jCChartLabel.component, 0);
                    } else {
                        this.addToDwellLabels(jCChartLabel);
                    }
                }
                jCChartLabel.setParentManager(this);
            }
        } else {
            this.addChartLabel(jCChartLabel);
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    @Override
    public List<JCChartLabel> getChartLabels() {
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        return new Vector<JCChartLabel>(this.labels);
    }

    @Override
    public void setChartLabels(List<JCChartLabel> list) {
        JCChart jCChart = this.getParentChart();
        if (this.labels != null && jCChart != null) {
            for (JCChartLabel object : this.labels) {
                if (object == null) continue;
                jCChart.remove(object.component);
            }
        }
        this.labels = new Vector();
        boolean bl = false;
        if (jCChart != null) {
            bl = jCChart.isBatched();
            jCChart.setBatched(false);
        }
        if (list != null && list.size() > 0) {
            for (JCChartLabel jCChartLabel : list) {
                if (jCChartLabel == null) continue;
                this.labels.addElement(jCChartLabel);
                if (!jCChartLabel.isDwellLabel() && jCChart != null) {
                    if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                        jCChart.add((Component)jCChartLabel.line, 0);
                    }
                    jCChart.add((Component)jCChartLabel.component, 0);
                    continue;
                }
                this.addToDwellLabels(jCChartLabel);
            }
            for (JCChartLabel jCChartLabel : list) {
                if (jCChartLabel == null) continue;
                jCChartLabel.setParentManager(this);
            }
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
            jCChart.setBatched(bl);
        }
    }

    @Override
    public void markAllChartLabelsForRecalc() {
        for (JCChartLabel jCChartLabel : this.labels) {
            if (jCChartLabel == null) continue;
            jCChartLabel.setChanged(true, 2, false);
        }
    }

    @Override
    public void recalcChangedChartLabels() {
        for (JCChartLabel jCChartLabel : this.labels) {
            if (jCChartLabel == null || !jCChartLabel.getChanged(2)) continue;
            jCChartLabel.recalc();
        }
    }

    @Override
    public JCChartLabel[][] getAutoLabelList(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return null;
        }
        return this.autoLabelListHashtable.get(chartDataView);
    }

    @Override
    public void generateAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = this.autoLabelListHashtable.get(chartDataView);
        List<ChartDataViewSeries> list = chartDataView.getSeries();
        int n2 = list.size();
        JCChartLabel[][] jCChartLabelArrayArray = new JCChartLabel[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            int n3 = chartDataViewSeries.maxIndex() + 1;
            if (chartDataViewSeries.getX() == null || chartDataViewSeries.getY() == null) {
                n3 = 0;
            }
            jCChartLabelArrayArray[i2] = new JCChartLabel[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                if (jCChartLabelArray != null && i2 < jCChartLabelArray.length && jCChartLabelArray[i2] != null && i3 < jCChartLabelArray[i2].length) {
                    this.deleteChartLabel(jCChartLabelArray[i2][i3]);
                }
                jCChartLabelArrayArray[i2][i3] = this.createAutoLabel(this.createAutoLabelText(chartDataView, i2, i3), chartDataViewSeries, i3);
                this.appendChartLabel(jCChartLabelArrayArray[i2][i3]);
            }
        }
        this.autoLabelListHashtable.put(chartDataView, jCChartLabelArrayArray);
    }

    protected JCChartLabel createAutoLabel(String string, ChartDataViewSeries chartDataViewSeries, int n2) {
        int n3;
        JCChartLabel jCChartLabel = new JCChartLabel(string);
        ChartDataView chartDataView = chartDataViewSeries.getParent();
        int n4 = n3 = chartDataView == null ? -1 : chartDataView.getChartType();
        if (n3 == 8 || n3 == 12) {
            boolean bl = chartDataViewSeries.isYHole(n2, chartDataView.getYAxis().isLogarithmic());
            jCChartLabel.setDataIndex(new JCAreaDataIndex(n2, chartDataViewSeries, bl));
        } else {
            jCChartLabel.setDataIndex(new JCDataIndex(n2, chartDataViewSeries));
        }
        jCChartLabel.setAttachMethod(3);
        jCChartLabel.setAnchor(10);
        jCChartLabel.component.setBorder(BorderFactory.createRaisedBevelBorder());
        jCChartLabel.setDataView(chartDataViewSeries.getParent());
        jCChartLabel.setOffset(new Point(0, -1));
        jCChartLabel.setDwellLabel(true);
        jCChartLabel.setSaveLabel(false);
        return jCChartLabel;
    }

    @Override
    public String createAutoLabelText(ChartDataView chartDataView, int n2, int n3) {
        Object object;
        if (chartDataView == null) {
            return " ";
        }
        ChartDataViewSeries chartDataViewSeries = null;
        if (n2 >= 0) {
            chartDataViewSeries = chartDataView.getSeries(n2);
            if (n3 < 0 || n3 >= chartDataViewSeries.maxXIndex() || n3 >= chartDataViewSeries.maxYIndex()) {
                return " ";
            }
        }
        String string = chartDataViewSeries == null ? null : chartDataViewSeries.getDataLabel(n3);
        int n4 = chartDataView.getAutoLabelType();
        if (n4 == 1) {
            return string == null ? " " : " " + string + " ";
        }
        if (n4 == 2) {
            Object object2 = null;
            JCAutoLabelGenerator jCAutoLabelGenerator = chartDataView.getAutoLabelGenerator();
            if (jCAutoLabelGenerator != null) {
                double d2 = chartDataViewSeries == null ? 0.0 : chartDataViewSeries.getCalculatedY(n3);
                object2 = jCAutoLabelGenerator.makeLabel(chartDataViewSeries, n3, d2, string);
            }
            return object2 == null ? " " : " " + object2.toString() + " ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        double d3 = 0.0;
        double d4 = 0.0;
        String string2 = "";
        JCAxis jCAxis = chartDataView.getYAxis();
        JCChartTypeFormat jCChartTypeFormat = chartDataView.getChartFormat();
        int n5 = chartDataView.getChartType();
        if (n2 == -10 && n5 == 11) {
            string2 = ((JCPieChartFormat)jCChartTypeFormat).getOtherLabel();
        } else if (chartDataViewSeries != null) {
            d3 = chartDataViewSeries.getX(n3);
            d4 = chartDataViewSeries.getCalculatedY(n3);
            string2 = jCAxis.getNumberFormatter().localize("" + d4);
        }
        if (jCAxis.getLabelGenerator() != null) {
            object = jCAxis.getLabelGenerator().makeLabel(d4, jCAxis.getPrecision());
            string2 = object instanceof String ? (String)object : object.toString();
        }
        switch (n5) {
            case 0: 
            case 1: {
                object = jCAxis.getNumberFormatter().localize("" + d3);
                JCAxis jCAxis2 = chartDataView.getXAxis();
                JCLabelGenerator jCLabelGenerator = jCAxis2.getLabelGenerator();
                if (jCLabelGenerator != null) {
                    object = (String)jCLabelGenerator.makeLabel(d3, jCAxis2.getPrecision());
                }
                stringBuffer.append(" (");
                stringBuffer.append((String)object);
                stringBuffer.append(",");
                stringBuffer.append(string2);
                stringBuffer.append(") ");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                break;
            }
            case 13: {
                String string3;
                double d5 = chartDataViewSeries == null ? 0.0 : chartDataViewSeries.getY(n3);
                TimeLineState timeLineState = this.getTimeLineState(chartDataView.getTimeLineStates(), d5);
                if (timeLineState == null || timeLineState.isClearState()) break;
                String string4 = "";
                String string5 = string3 = chartDataViewSeries == null ? "" : chartDataViewSeries.getLabel();
                if (string3 != null && string3.trim().length() > 0) {
                    string4 = string3.trim() + ":";
                }
                string4 = string4 + timeLineState.label;
                stringBuffer.append(" ");
                stringBuffer.append(string4);
                stringBuffer.append(" ");
                break;
            }
            default: {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private TimeLineState getTimeLineState(List<TimeLineState> list, double d2) {
        for (TimeLineState timeLineState : list) {
            List<JCDataRange> list2 = timeLineState.getDataRanges();
            if (list2 == null) continue;
            for (JCDataRange jCDataRange : list2) {
                if (jCDataRange == null || !(jCDataRange.getMin() <= d2) || !(d2 <= jCDataRange.getMax())) continue;
                return timeLineState;
            }
        }
        return null;
    }

    @Override
    public void setAutoLabelText(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = this.autoLabelListHashtable.get(chartDataView);
        JCChartLabel jCChartLabel = jCChartLabelArray[n2][n3];
        if (jCChartLabel != null) {
            jCChartLabel.setText(this.createAutoLabelText(chartDataView, n2, n3));
        }
    }

    @Override
    public void addAutoLabels(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List<ChartDataViewSeries> list = chartDataView.getSeries();
        int n4 = list.size();
        if (n2 != -1 && n3 == -1) {
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n2);
            if (jCChartLabelArray2.length > n2) {
                System.arraycopy(jCChartLabelArray2, n2 + 1, jCChartLabelArray, n2 + 1, n4 - n2 - 1);
            }
            ChartDataViewSeries chartDataViewSeries = list.get(n2);
            int n5 = chartDataViewSeries.maxIndex() + 1;
            jCChartLabelArray[n2] = new JCChartLabel[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                jCChartLabelArray[n2][i2] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n2, i2), chartDataViewSeries, i2);
                this.appendChartLabel(jCChartLabelArray[n2][i2]);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n3 != -1) {
            int n6 = 0;
            if (n2 != -1) {
                n4 = n2 + 1;
                n6 = n2;
            }
            for (int i3 = n6; i3 < n4; ++i3) {
                ChartDataViewSeries chartDataViewSeries = list.get(i3);
                int n7 = jCChartLabelArray[i3].length + 1;
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[i3];
                jCChartLabelArray[i3] = new JCChartLabel[n7];
                if (n3 != 0) {
                    System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[i3], 0, n3);
                }
                if (n3 != n7 - 1) {
                    System.arraycopy(jCChartLabelArray3, n3, jCChartLabelArray[i3], n3 + 1, n7 - n3 - 1);
                }
                jCChartLabelArray[i3][n3] = this.createAutoLabel(this.createAutoLabelText(chartDataView, i3, n3), chartDataViewSeries, n3);
                this.appendChartLabel(jCChartLabelArray[i3][n3]);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    @Override
    public void removeAutoLabels(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List<ChartDataViewSeries> list = chartDataView.getSeries();
        int n4 = list.size();
        if (n2 != -1 && n3 == -1) {
            if (jCChartLabelArray[n2] != null) {
                int n5 = jCChartLabelArray[n2].length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    this.deleteChartLabel(jCChartLabelArray[n2][i2]);
                }
            }
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n2);
            if (jCChartLabelArray2.length > n2) {
                System.arraycopy(jCChartLabelArray2, n2 + 1, jCChartLabelArray, n2, n4 - n2 - 1);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n3 != -1) {
            int n6 = 0;
            if (n2 != -1) {
                n4 = n2 + 1;
                n6 = n2;
            }
            for (int i3 = n6; i3 < n4; ++i3) {
                int n7 = jCChartLabelArray[i3].length;
                this.deleteChartLabel(jCChartLabelArray[i3][n3]);
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[i3];
                jCChartLabelArray[i3] = new JCChartLabel[n7 - 1];
                System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[i3], 0, n3);
                System.arraycopy(jCChartLabelArray3, n3 + 1, jCChartLabelArray[i3], n3, n7 - n3 - 1);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    @Override
    public void removeAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        this.autoLabelListHashtable.remove(chartDataView);
        for (JCChartLabel[] jCChartLabelArray2 : jCChartLabelArray) {
            if (jCChartLabelArray2 == null) continue;
            for (JCChartLabel jCChartLabel : jCChartLabelArray2) {
                this.deleteChartLabel(jCChartLabel);
            }
        }
    }

    @Override
    public void clearAutoLabels(ChartDataView chartDataView) {
        this.autoLabelListHashtable.remove(chartDataView);
    }

    @Override
    public void updateParent(int n2) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                jCChart.invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n2 & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }

    @Override
    public boolean hasImageMapInfo() {
        if (this.labels == null) {
            return false;
        }
        for (JCChartLabel jCChartLabel : this.labels) {
            ImageMapInfo imageMapInfo;
            if (jCChartLabel == null || (imageMapInfo = jCChartLabel.getImageMapInfo()) == null || imageMapInfo.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

