/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.util.style.JCShape;
import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;

public class JCChartStyle
implements Serializable,
Cloneable {
    protected JCLineStyle lineStyle = null;
    protected JCFillStyle fillStyle = null;
    protected JCSymbolStyle symbolStyle = null;
    protected Vector<Changeable> parents = new Vector();

    public JCChartStyle(JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this.lineStyle = jCLineStyle;
        this.fillStyle = jCFillStyle;
        this.symbolStyle = jCSymbolStyle;
        if (this.lineStyle != null) {
            this.lineStyle.parent = this;
        }
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        if (this.symbolStyle != null) {
            this.symbolStyle.parent = this;
        }
    }

    public JCChartStyle() {
        this.lineStyle = JCLineStyle.makeDefault(null);
        this.fillStyle = JCFillStyle.makeDefault(null);
        this.symbolStyle = JCSymbolStyle.makeDefault(null);
        this.lineStyle.parent = this;
        this.fillStyle.parent = this;
        this.symbolStyle.parent = this;
    }

    public static JCChartStyle makeDefault(JCChart jCChart) {
        return JCChartStyle.makeDefault(jCChart, null, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable) {
        return JCChartStyle.makeDefault(jCChart, changeable, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable, boolean bl) {
        JCChartStyle jCChartStyle = new JCChartStyle(JCLineStyle.makeDefault(jCChart), JCFillStyle.makeDefault(jCChart, bl), JCSymbolStyle.makeDefault(jCChart));
        if (changeable != null) {
            jCChartStyle.parents.addElement(changeable);
        } else if (jCChart != null) {
            jCChartStyle.parents.addElement(jCChart.getChartArea());
        }
        return jCChartStyle;
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        if (this.lineStyle == jCLineStyle) {
            return;
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }

    public int getLinePattern() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getPattern();
    }

    public void setLinePattern(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setPattern(n2);
    }

    public int getLineJoin() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getJoin();
    }

    public void setLineJoin(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setJoin(n2);
    }

    public int getLineCap() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getCap();
    }

    public void setLineCap(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setCap(n2);
    }

    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getWidth();
    }

    public void setLineWidth(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setWidth(n2);
    }

    public Color getLineColor() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getColor();
    }

    public void setLineColor(Color color) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setColor(color);
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        if (this.symbolStyle == jCSymbolStyle) {
            return;
        }
        this.symbolStyle = jCSymbolStyle;
        this.symbolStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }

    public int getSymbolShape() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getShape();
    }

    public void setSymbolShape(int n2) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setShape(n2);
    }

    public Color getSymbolColor() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getColor();
    }

    public void setSymbolColor(Color color) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setColor(color);
    }

    public int getSymbolSize() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getSize();
    }

    public void setSymbolSize(int n2) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setSize(n2);
    }

    public JCShape getSymbolCustomShape() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getCustomShape();
    }

    public void setSymbolCustomShape(JCShape jCShape) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setCustomShape(jCShape);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle == jCFillStyle) {
            return;
        }
        this.fillStyle = jCFillStyle;
        this.fillStyle.parent = this;
        this.callParentSetChanged(true, 33);
    }

    public Color getFillColor() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getColor();
    }

    public void setFillColor(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setColor(color);
    }

    public Color getFillBackground() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getBackground();
    }

    public void setFillBackground(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setBackground(color);
    }

    public int getFillPattern() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getPattern();
    }

    public void setFillPattern(int n2) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setPattern(n2);
    }

    public Image getFillImage() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getImage();
    }

    public void setFillImage(Image image) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setImage(image);
    }

    public int getFillOrientation() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getFillOrientation();
    }

    public void setFillOrientation(int n2) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setFillOrientation(n2);
    }

    public int getImageLayoutHint() {
        if (this.fillStyle == null) {
            return 1;
        }
        return this.fillStyle.getImageLayoutHint();
    }

    public void setImageLayoutHint(int n2) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setFillOrientation(n2);
    }

    void callParentSetChanged(boolean bl, int n2) {
        if (this.parents == null) {
            return;
        }
        for (int i2 = 0; i2 < this.parents.size(); ++i2) {
            this.parents.elementAt(i2).setChanged(true, n2);
        }
    }

    public void addParent(Changeable changeable) {
        for (int i2 = 0; i2 < this.parents.size(); ++i2) {
            if (this.parents.elementAt(i2) != changeable) continue;
            return;
        }
        this.parents.addElement(changeable);
    }

    public void removeParent(Changeable changeable) {
        for (int i2 = 0; i2 < this.parents.size(); ++i2) {
            if (this.parents.elementAt(i2) != changeable) continue;
            this.parents.removeElementAt(i2);
        }
    }

    public void clearParents() {
        this.parents = new Vector();
    }

    public static boolean equalChartStyles(JCChartStyle jCChartStyle, JCChartStyle jCChartStyle2) {
        boolean bl = false;
        if (jCChartStyle == null) {
            if (jCChartStyle2 == null) {
                bl = true;
            }
        } else if (jCChartStyle2 != null) {
            bl = jCChartStyle.equals(jCChartStyle2);
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass())) {
            JCChartStyle jCChartStyle = (JCChartStyle)object;
            if (this == jCChartStyle) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3 = this.lineStyle != null && this.lineStyle.equals(jCChartStyle.getLineStyle()) || this.lineStyle == null && jCChartStyle.getLineStyle() == null;
                boolean bl4 = this.symbolStyle != null && this.symbolStyle.equals(jCChartStyle.getSymbolStyle()) || this.symbolStyle == null && jCChartStyle.getSymbolStyle() == null;
                boolean bl5 = bl2 = this.fillStyle != null && this.fillStyle.equals(jCChartStyle.getFillStyle()) || this.fillStyle == null && jCChartStyle.getFillStyle() == null;
                if (bl3 && bl4 && bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + (this.lineStyle != null ? this.lineStyle.hashCode() : 0);
        n2 = 37 * n2 + (this.symbolStyle != null ? this.symbolStyle.hashCode() : 0);
        n2 = 37 * n2 + (this.fillStyle != null ? this.fillStyle.hashCode() : 0);
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        JCChartStyle jCChartStyle = (JCChartStyle)super.clone();
        jCChartStyle.lineStyle = this.lineStyle == null ? null : (JCLineStyle)this.lineStyle.clone();
        jCChartStyle.fillStyle = this.fillStyle == null ? null : (JCFillStyle)this.fillStyle.clone();
        jCChartStyle.symbolStyle = this.symbolStyle == null ? null : (JCSymbolStyle)this.symbolStyle.clone();
        jCChartStyle.parents = new Vector();
        return jCChartStyle;
    }
}

