/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.CachedSeriesProps;
import com.klg.jclass.chart.CachedViewProps;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.DataViewIterator;
import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.JCEnvelope;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCMarker;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.JCThreshold;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.chart.OutlineConfigurable;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.util.JCName;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.style.JCStyle;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChartLegendManager
implements JCLegendPopulator,
JCLegendRenderer,
Serializable {
    protected List<List<JCLegendItem>> legendItems = null;
    protected transient CachedViewProps[] cachedView = null;
    protected JCChart chart;

    public JCChartLegendManager(JCChart jCChart) {
        this.chart = jCChart;
    }

    @Override
    public List<List<JCLegendItem>> getLegendItems(FontMetrics fontMetrics) {
        this.legendItems = new Vector<List<JCLegendItem>>();
        Vector<CachedViewProps> vector = new Vector<CachedViewProps>();
        DataViewIterator dataViewIterator = new DataViewIterator(this.chart, true, false, false, false);
        while (dataViewIterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
            Vector<JCLegendItem> vector2 = new Vector<JCLegendItem>();
            this.legendItems.add(vector2);
            CachedViewProps cachedViewProps = this.createLegendItems(chartDataView, vector2, fontMetrics);
            if (cachedViewProps == null) continue;
            vector.add(cachedViewProps);
        }
        this.cachedView = new CachedViewProps[vector.size()];
        vector.copyInto(this.cachedView);
        return this.legendItems;
    }

    private CachedViewProps createLegendItems(ChartDataView chartDataView, List<JCLegendItem> list, FontMetrics fontMetrics) {
        boolean bl;
        int n2 = chartDataView.getChartType();
        boolean bl2 = n2 == 11;
        boolean bl3 = n2 == 0 || n2 == 1;
        boolean bl4 = n2 == 13;
        boolean bl5 = chartDataView.isVisibleInLegend();
        List<JCMarker> list2 = chartDataView.getMarkers();
        List<JCEnvelope> list3 = chartDataView.getEnvelopes();
        boolean bl6 = !bl2 && this.checkForLegendEntries(list2);
        boolean bl7 = !bl2 && this.checkForThresholdLegendEntries(chartDataView);
        boolean bl8 = bl3 && this.checkForLegendEntries(list3);
        List<TimeLineState> list4 = chartDataView.getTimeLineStates();
        boolean bl9 = bl = bl4 && this.checkForLegendEntries(list4);
        if (!(bl5 || bl7 || bl8 || bl6 || bl)) {
            return null;
        }
        CachedViewProps cachedViewProps = new CachedViewProps();
        this.cacheViewProperties(cachedViewProps, chartDataView, chartDataView.getSeries());
        chartDataView.calcTransientData();
        String string = chartDataView.getName();
        JCLegendItem jCLegendItem = new JCLegendItem();
        this.setTextContents(jCLegendItem, string, fontMetrics, true);
        jCLegendItem.itemInfo = new JCDataIndex(chartDataView, null, -1, -1);
        list.add(jCLegendItem);
        if (bl5 && !bl4) {
            bl5 = this.createLegendItemsSeries(chartDataView, list, fontMetrics);
        }
        if (bl) {
            this.createTimeLineLegendEntries(chartDataView, list, fontMetrics);
        }
        if (bl6) {
            this.createLegendEntries(list, fontMetrics, list2);
        }
        if (bl7) {
            this.createThresholdLegendEntries(list, fontMetrics, chartDataView);
        }
        if (bl8) {
            this.createLegendEntries(list, fontMetrics, list3);
        }
        if (!(bl5 && !bl4 || bl7 || bl8 || bl6 || bl)) {
            return null;
        }
        return cachedViewProps;
    }

    private void createTimeLineLegendEntries(ChartDataView chartDataView, List<JCLegendItem> list, FontMetrics fontMetrics) {
        List<TimeLineState> list2;
        int n2 = chartDataView.getChartType();
        if (n2 == 13 && (list2 = chartDataView.getTimeLineStates()) != null) {
            boolean bl = chartDataView.isLegendSeriesReversed();
            ArrayList<JCLegendItem> arrayList = new ArrayList<JCLegendItem>();
            for (TimeLineState timeLineState : list2) {
                boolean bl2;
                if (timeLineState == null || !timeLineState.isVisibleInLegend() || timeLineState.isClearState()) continue;
                JCLegendItem jCLegendItem = new JCLegendItem();
                jCLegendItem.contents = timeLineState.label;
                jCLegendItem.itemInfo = timeLineState;
                JCStyle jCStyle = null;
                JCChartStyle jCChartStyle = timeLineState.getChartStyle();
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = bl2 = jCSymbolStyle != null && jCSymbolStyle.getShape() != 0;
                if (jCFillStyle != null && jCFillStyle.getPattern() != 0) {
                    jCStyle = jCFillStyle;
                } else if (jCLineStyle != null && jCLineStyle.getPattern() != 0) {
                    jCStyle = jCLineStyle;
                    bl3 = true;
                    bl4 = bl2;
                } else if (bl2) {
                    jCStyle = jCSymbolStyle;
                    bl4 = true;
                }
                if (jCStyle == null) continue;
                jCLegendItem.drawStyle = jCStyle;
                int n3 = 0;
                if (timeLineState.label != null) {
                    n3 = fontMetrics.stringWidth(timeLineState.label);
                }
                int n4 = fontMetrics.getHeight();
                jCLegendItem.textDim = new Dimension(n3, n4);
                jCLegendItem.drawType = timeLineState.getDrawType();
                jCLegendItem.symbolDim = this.getLegendItemSymbolDimension(jCChartStyle, bl3, bl4, true);
                if (bl) {
                    arrayList.add(0, jCLegendItem);
                    continue;
                }
                arrayList.add(jCLegendItem);
            }
            list.addAll(arrayList);
        }
    }

    private boolean createLegendItemsSeries(ChartDataView chartDataView, List<JCLegendItem> list, FontMetrics fontMetrics) {
        int n2 = chartDataView.getChartType();
        List<ChartDataViewSeries> list2 = chartDataView.getSeries();
        if (list2 == null) {
            return false;
        }
        int n3 = chartDataView.getNumSeriesPerData();
        int n4 = list2.size() / n3;
        if (n4 == 0) {
            return false;
        }
        JCLegend jCLegend = this.chart.getLegend();
        JCPieChartFormat jCPieChartFormat = (JCPieChartFormat)chartDataView.getChartFormat(11);
        boolean bl = jCLegend.getItemRenderMode() == 1;
        int n5 = this.getOutlineStyle(chartDataView);
        boolean bl2 = chartDataView.isLegendSeriesReversed();
        ArrayList<JCLegendItem> arrayList = new ArrayList<JCLegendItem>();
        if (n2 == 11 && jCPieChartFormat.getThresholdValue() > 0.0) {
            Object object;
            PieChartInfo pieChartInfo = (PieChartInfo)chartDataView.getTransientData();
            if (pieChartInfo == null) {
                return false;
            }
            JCLegendItem[] jCLegendItemArray = new JCLegendItem[list2.size() + 1];
            for (int i2 = 0; i2 < pieChartInfo.num_pies; ++i2) {
                PieData pieData = pieChartInfo.data[i2];
                for (int i3 = 0; i3 < pieData.num_slices_pie; ++i3) {
                    Serializable serializable;
                    if (pieData.other_flag != 0 && i3 == pieData.other_slice) {
                        if (jCLegendItemArray[list2.size()] != null) continue;
                        JCLegendItem jCLegendItem = new JCLegendItem();
                        jCLegendItem.itemInfo = new JCDataIndex(chartDataView, null, -10, -1);
                        object = jCPieChartFormat.getOtherLabel();
                        this.setTextContents(jCLegendItem, (String)object, fontMetrics, false);
                        serializable = jCPieChartFormat.getOtherStyle();
                        this.calcSymbolSize(jCLegendItem, null, (JCChartStyle)serializable, n2);
                        jCLegendItemArray[list2.size()] = jCLegendItem;
                        continue;
                    }
                    int n6 = pieData.percents[i3].index;
                    if (n6 < 0 || jCLegendItemArray[n6] != null || !((ChartDataViewSeries)(object = list2.get(n6))).isVisibleInLegend()) continue;
                    serializable = new JCLegendItem();
                    serializable.itemInfo = new JCDataIndex(chartDataView, (ChartDataViewSeries)object, n6, -1);
                    this.setTextContents((JCLegendItem)serializable, ((ChartDataViewSeries)object).getLabel(), fontMetrics, false);
                    this.calcSymbolSize((JCLegendItem)serializable, (ChartDataViewSeries)object, ((ChartDataViewSeries)object).getStyle(), n2);
                    jCLegendItemArray[n6] = serializable;
                }
            }
            for (JCLegendItem jCLegendItem : jCLegendItemArray) {
                if (jCLegendItem == null) continue;
                if (n5 == 0 && (object = chartDataView.getOutlineStyle()) != null) {
                    jCLegendItem.drawStyle = bl ? object : new JCLineStyle(1, ((com.klg.jclass.util.style.JCLineStyle)object).getColor(), 1);
                }
                object = (JCDataIndex)jCLegendItem.itemInfo;
                if (bl2 && ((JCDataIndex)object).getSeriesIndex() != -10) {
                    arrayList.add(0, jCLegendItem);
                    continue;
                }
                arrayList.add(jCLegendItem);
            }
        } else {
            for (int i4 = 0; i4 < n4; ++i4) {
                int n7;
                int n8;
                int n9 = i4 * n3;
                ChartDataViewSeries chartDataViewSeries = list2.get(n9);
                JCLegendItem jCLegendItem = new JCLegendItem();
                jCLegendItem.itemInfo = new JCDataIndex(chartDataView, chartDataViewSeries, n9, -1);
                String string = chartDataViewSeries.getLabel();
                jCLegendItem.contents = string;
                if (n5 != 2) {
                    JCLineStyle jCLineStyle = n5 == 1 ? chartDataViewSeries.getStyle().getLineStyle() : chartDataView.getOutlineStyle();
                    Object object = jCLegendItem.drawStyle = bl ? jCLineStyle : new JCLineStyle(1, jCLineStyle.getColor(), 1);
                }
                if (TextRenderer.isHTML(string)) {
                    TextRenderer textRenderer = jCLegend.getTextRenderer();
                    Dimension dimension = textRenderer.calcHTMLTextSize(string);
                    n8 = dimension.width;
                    n7 = dimension.height;
                } else {
                    n8 = fontMetrics.stringWidth(string);
                    n7 = fontMetrics.getHeight();
                }
                boolean bl3 = true;
                int n10 = n9;
                int n11 = 0;
                while (n11 < n3) {
                    ChartDataViewSeries chartDataViewSeries2 = list2.get(n10);
                    if (!chartDataViewSeries2.isVisibleInLegend()) {
                        bl3 = false;
                        break;
                    }
                    ++n11;
                    ++n10;
                }
                if (!bl3 || !chartDataViewSeries.isVisibleInLegend()) continue;
                jCLegendItem.textDim = new Dimension(n8, n7);
                this.calcSymbolSize(jCLegendItem, chartDataViewSeries, chartDataViewSeries.getStyle(), n2);
                if (bl2) {
                    arrayList.add(0, jCLegendItem);
                    continue;
                }
                arrayList.add(jCLegendItem);
            }
        }
        list.addAll(arrayList);
        return true;
    }

    private int getOutlineStyle(ChartDataView chartDataView) {
        JCChartTypeFormat jCChartTypeFormat;
        int n2 = 2;
        if (chartDataView != null && (jCChartTypeFormat = chartDataView.getChartFormat()) instanceof OutlineConfigurable) {
            OutlineConfigurable outlineConfigurable = (OutlineConfigurable)((Object)jCChartTypeFormat);
            n2 = outlineConfigurable.getOutlineStyle();
        }
        return n2;
    }

    protected Dimension getLegendItemSymbolDimension(JCChartStyle jCChartStyle, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        JCLegend jCLegend = this.chart.getLegend();
        boolean bl4 = jCLegend.getItemRenderMode() == 1;
        int n3 = jCLegend.getSymbolSize();
        int n4 = jCLegend.getAscent() + jCLegend.getDescent();
        JCSymbolStyle jCSymbolStyle = jCChartStyle == null ? null : jCChartStyle.getSymbolStyle();
        int n5 = n2 = jCSymbolStyle == null ? 0 : jCSymbolStyle.getShape();
        if (bl2 && n2 == 11) {
            int n6 = Math.max(bl4 ? n4 : n3, jCSymbolStyle.getSize());
            JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
            int n7 = n6;
            if (bl && jCLineStyle != null && jCLineStyle.getPattern() != 0) {
                n7 += n4;
            }
            return new Dimension(n7, n6);
        }
        if (bl4 && bl2 && n2 != 0) {
            n3 = Math.max(n3, jCSymbolStyle.getSize());
        }
        int n8 = n3;
        int n9 = Math.max(n3, n4);
        if (bl4 && (bl || bl3)) {
            n8 = n3 + n4;
        }
        return new Dimension(n8, n9);
    }

    private void createLegendEntries(List<JCLegendItem> list, FontMetrics fontMetrics, List<? extends LegendEntry> list2) {
        boolean bl;
        boolean bl2 = bl = this.chart.getLegend().getItemRenderMode() == 1;
        if (list2 != null) {
            for (LegendEntry legendEntry : list2) {
                LegendEntry legendEntry2;
                if (legendEntry == null) continue;
                ChartDataView chartDataView = legendEntry.getParent();
                if (!legendEntry.isVisibleInLegend() || chartDataView == null) continue;
                JCLegendItem jCLegendItem = new JCLegendItem();
                String string = legendEntry.getLabel();
                this.setTextContents(jCLegendItem, string, fontMetrics, true);
                jCLegendItem.itemInfo = legendEntry;
                jCLegendItem.drawType = legendEntry.getDrawType();
                boolean bl3 = false;
                boolean bl4 = false;
                JCChartStyle jCChartStyle = null;
                JCLineStyle jCLineStyle = null;
                if (legendEntry instanceof JCDataThreshold) {
                    legendEntry2 = (JCDataThreshold)legendEntry;
                    int n2 = this.getOutlineStyle(chartDataView);
                    if (n2 != 2) {
                        jCLineStyle = n2 == 1 ? ((jCChartStyle = ((JCAbstractThreshold)legendEntry2).getChartStyle()) == null ? null : jCChartStyle.getLineStyle()) : chartDataView.getOutlineStyle();
                    }
                } else if (legendEntry instanceof JCThreshold) {
                    legendEntry2 = (JCThreshold)legendEntry;
                    JCLineStyle jCLineStyle2 = ((JCThreshold)legendEntry2).getStartLineStyle();
                    JCLineStyle jCLineStyle3 = ((JCThreshold)legendEntry2).getEndLineStyle();
                    if (jCLineStyle2 != null || jCLineStyle3 != null) {
                        if (jCLineStyle2 == null) {
                            jCLineStyle = jCLineStyle3;
                        } else if (jCLineStyle3 == null) {
                            jCLineStyle = jCLineStyle2;
                        } else if (jCLineStyle2.equals(jCLineStyle3) || !bl) {
                            jCLineStyle = jCLineStyle2;
                        } else {
                            ArrayList<JCLineStyle> arrayList = new ArrayList<JCLineStyle>(2);
                            arrayList.add(jCLineStyle3);
                            arrayList.add(jCLineStyle2);
                            jCLegendItem.drawStyle = arrayList;
                        }
                    }
                } else if (legendEntry instanceof JCEnvelope) {
                    legendEntry2 = (JCEnvelope)legendEntry;
                    jCChartStyle = ((JCAbstractThreshold)legendEntry2).getChartStyle();
                    jCLineStyle = jCChartStyle == null ? null : jCChartStyle.getLineStyle();
                    bl3 = jCLineStyle != null && jCLineStyle.getPattern() != 0;
                    JCSymbolStyle jCSymbolStyle = jCChartStyle == null ? null : jCChartStyle.getSymbolStyle();
                    bl4 = jCSymbolStyle != null && jCSymbolStyle.getShape() != 0;
                } else if (legendEntry instanceof JCMarker) {
                    legendEntry2 = (JCMarker)legendEntry;
                    jCLineStyle = ((JCMarker)legendEntry2).getLineStyle();
                    boolean bl5 = bl3 = jCLineStyle != null && jCLineStyle.getPattern() != 0;
                }
                if (jCLineStyle != null) {
                    jCLegendItem.drawStyle = bl ? jCLineStyle : new JCLineStyle(1, jCLineStyle.getColor(), 1);
                }
                jCLegendItem.symbolDim = this.getLegendItemSymbolDimension(jCChartStyle, bl3, bl4, false);
                list.add(jCLegendItem);
            }
        }
    }

    private void createThresholdLegendEntries(List<JCLegendItem> list, FontMetrics fontMetrics, ChartDataView chartDataView) {
        List<ChartDataViewSeries> list2 = chartDataView.getSeries();
        if (list2 != null) {
            for (ChartDataViewSeries chartDataViewSeries : list2) {
                List<JCDataThreshold> list3 = chartDataViewSeries.getDataThresholds();
                if (!this.checkForLegendEntries(list3)) continue;
                this.createLegendEntries(list, fontMetrics, list3);
            }
        }
        this.createLegendEntries(list, fontMetrics, chartDataView.getThresholds());
    }

    private boolean checkForLegendEntries(List<? extends LegendEntry> list) {
        boolean bl = false;
        if (list != null) {
            for (LegendEntry legendEntry : list) {
                if (!legendEntry.isVisibleInLegend() || legendEntry.getParent() == null) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean checkForThresholdLegendEntries(ChartDataView chartDataView) {
        List<ChartDataViewSeries> list = chartDataView.getSeries();
        if (list != null) {
            for (ChartDataViewSeries chartDataViewSeries : list) {
                if (!this.checkForLegendEntries(chartDataViewSeries.getDataThresholds())) continue;
                return true;
            }
        }
        return this.checkForLegendEntries(chartDataView.getThresholds());
    }

    private void setTextContents(JCLegendItem jCLegendItem, String string, FontMetrics fontMetrics, boolean bl) {
        if (TextRenderer.isHTML(string)) {
            TextRenderer textRenderer = this.chart.getLegend().getTextRenderer();
            jCLegendItem.textDim = textRenderer.calcHTMLTextSize(string);
            jCLegendItem.contents = string;
        } else if (!bl || string != null && string.length() > 0) {
            jCLegendItem.textDim = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            jCLegendItem.contents = string;
        } else {
            jCLegendItem.textDim = new Dimension(0, 0);
            jCLegendItem.contents = null;
        }
    }

    protected void calcSymbolSize(JCLegendItem jCLegendItem, ChartDataViewSeries chartDataViewSeries, JCChartStyle jCChartStyle, int n2) {
        boolean bl;
        boolean bl2 = n2 == 9 || n2 == 10;
        boolean bl3 = n2 == 8 || n2 == 12 || n2 == 4;
        boolean bl4 = n2 == 11;
        boolean bl5 = n2 == 1;
        boolean bl6 = n2 == 0 || bl5 || n2 == 2 || n2 == 3 || n2 == 13;
        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
        Image image = jCFillStyle == null ? null : jCFillStyle.getImage();
        int n3 = jCFillStyle == null ? 0 : jCFillStyle.getPattern();
        boolean bl7 = n3 == 11;
        boolean bl8 = bl = n3 == 12;
        if (image != null && (bl2 && (bl || bl7) || (bl3 || bl4) && bl7)) {
            jCLegendItem.drawType = bl ? 2 : 3;
            jCLegendItem.symbolDim = new Dimension(image.getWidth(null), image.getHeight(null));
        } else {
            jCLegendItem.drawType = chartDataViewSeries == null ? 1 : chartDataViewSeries.getDrawType();
            jCLegendItem.symbolDim = this.getLegendItemSymbolDimension(jCChartStyle, bl6 && !bl5, bl6, false);
        }
        jCLegendItem.symbol = image;
    }

    protected void cacheViewProperties(CachedViewProps cachedViewProps, ChartDataView chartDataView, List<ChartDataViewSeries> list) {
        if (cachedViewProps == null || chartDataView == null) {
            return;
        }
        cachedViewProps.view = chartDataView;
        cachedViewProps.visible = chartDataView.isVisible();
        cachedViewProps.visibleInLegend = chartDataView.isVisibleInLegend();
        cachedViewProps.chartType = chartDataView.getChartType();
        cachedViewProps.seriesPerData = chartDataView.getNumSeriesPerData();
        JCAxis jCAxis = chartDataView.getXAxis();
        cachedViewProps.inverted = jCAxis != null && jCAxis.i_vertical;
        cachedViewProps.outlineColor = chartDataView.getOutlineColor();
        if (list == null) {
            cachedViewProps.seriesList = null;
            cachedViewProps.seriesProps = null;
            return;
        }
        cachedViewProps.seriesList = list;
        cachedViewProps.seriesProps = new CachedSeriesProps[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            cachedViewProps.seriesProps[i2] = new CachedSeriesProps();
            cachedViewProps.seriesProps[i2].series = chartDataViewSeries;
            cachedViewProps.seriesProps[i2].visible = chartDataViewSeries.isVisible();
            cachedViewProps.seriesProps[i2].visibleInLegend = chartDataViewSeries.isVisibleInLegend();
        }
    }

    @Override
    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        int n2;
        int n3;
        if (jCLegendItem == null) {
            return;
        }
        CachedViewProps cachedViewProps = null;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        Color color = null;
        JCLegend jCLegend = this.chart.getLegend();
        int n5 = jCLegend.getItemRenderMode();
        int n6 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
        int n7 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
        int n8 = jCLegendItem.symbolDim == null ? 0 : jCLegendItem.symbolDim.width;
        int n9 = jCLegendItem.symbolDim == null ? 0 : jCLegendItem.symbolDim.height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (graphics2D.getColor() != jCLegend.getForeground()) {
            graphics2D.setColor(jCLegend.getForeground());
        }
        if (graphics2D.getFont() != font) {
            graphics2D.setFont(font);
        }
        if (jCLegendItem.itemInfo instanceof JCMarker) {
            JCMarker jCMarker = (JCMarker)jCLegendItem.itemInfo;
            this.drawLine(graphics2D, jCMarker.getLineStyle(), n6, n7, n8, n9);
            return;
        }
        if (jCLegendItem.itemInfo instanceof JCEnvelope) {
            JCEnvelope jCEnvelope = (JCEnvelope)jCLegendItem.itemInfo;
            JCChartStyle jCChartStyle = jCEnvelope.getChartStyle();
            if (jCChartStyle == null) return;
            this.drawLine(graphics2D, jCChartStyle.getLineStyle(), n6, n7, n8, n9);
            this.drawSymbol(graphics2D, jCChartStyle.getSymbolStyle(), n6, n7, n8, n9);
            return;
        }
        if (jCLegendItem.itemInfo instanceof TimeLineState) {
            TimeLineState timeLineState = (TimeLineState)jCLegendItem.itemInfo;
            JCChartStyle jCChartStyle = timeLineState.getChartStyle();
            Object object = jCLegendItem.drawStyle;
            if (object instanceof JCFillStyle) {
                JCFillStyle jCFillStyle = (JCFillStyle)object;
                if (n5 == 1) {
                    jCFillStyle.fillRect((Graphics)graphics2D, n6, n7, n8, n9);
                    return;
                } else {
                    jCFillStyle.fillOutlineRect(graphics2D, n6, n7, n8, n9);
                }
                return;
            } else if (object instanceof JCLineStyle) {
                this.drawLine(graphics2D, (JCLineStyle)object, n6, n7, n8, n9);
                JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                if (jCSymbolStyle == null) return;
                this.drawSymbol(graphics2D, jCSymbolStyle, n6, n7, n8, n9);
                return;
            } else {
                if (!(object instanceof JCSymbolStyle)) return;
                this.drawSymbol(graphics2D, (JCSymbolStyle)object, n6, n7, n8, n9);
            }
            return;
        }
        JCDataIndex jCDataIndex = null;
        if (jCLegendItem.itemInfo instanceof JCDataIndex) {
            jCDataIndex = (JCDataIndex)jCLegendItem.itemInfo;
        }
        if (jCDataIndex == null) {
            return;
        }
        ChartDataView chartDataView = jCDataIndex.getDataView();
        if (chartDataView != null && this.cachedView != null) {
            CachedViewProps[] cachedViewPropsArray = this.cachedView;
            n3 = cachedViewPropsArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Serializable serializable;
                CachedViewProps cachedViewProps2 = cachedViewPropsArray[n2];
                if (cachedViewProps2.view != chartDataView) continue;
                cachedViewProps = cachedViewProps2;
                bl = cachedViewProps.inverted;
                n4 = cachedViewProps.chartType;
                bl2 = true;
                bl3 = true;
                bl4 = false;
                color = cachedViewProps.outlineColor;
                if (n4 == 6) {
                    serializable = (JCHLOCChartFormat)chartDataView.getChartFormat();
                    bl2 = ((JCHLOCChartFormat)serializable).isShowingOpen();
                    bl3 = ((JCHLOCChartFormat)serializable).isShowingClose();
                    bl4 = ((JCHLOCChartFormat)serializable).isOpenCloseFullWidth();
                }
                if (n4 != 7) break;
                serializable = (JCCandleChartFormat)chartDataView.getChartFormat();
                bl5 = ((JCCandleChartFormat)serializable).isComplex();
                break;
            }
        }
        if (color == null) {
            color = this.chart.getChartArea().getForeground();
        }
        int n10 = Math.min(n8, n9);
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.getSeries();
        if (chartDataViewSeries != null) {
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
            int n11 = n5 == 0 ? 1 : jCLineStyle.getWidth();
            JCLineStyle jCLineStyle2 = new JCLineStyle(n11, jCLineStyle.getColor(), jCLineStyle.getPattern(), jCLineStyle.getCap(), jCLineStyle.getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray());
            switch (chartDataView.getChartType()) {
                case 0: 
                case 2: 
                case 3: {
                    this.drawLine(graphics2D, jCLineStyle2, n6, n7, n8, n9);
                }
                case 1: {
                    this.drawSymbol(graphics2D, jCChartStyle.getSymbolStyle(), n6, n7, n8, n9);
                    return;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return;
                }
                case 5: 
                case 6: {
                    int n12;
                    int n13;
                    if (!jCLineStyle2.updateGraphics(graphics2D)) return;
                    if (bl) {
                        n13 = n6;
                        n3 = n6 + (n8 - 1);
                        n2 = n12 = n7 + n10 / 2;
                    } else {
                        n13 = n3 = n6 + n8 / 2;
                        n2 = n7;
                        n12 = n7 + n10;
                    }
                    graphics2D.draw(new Line2D.Double(n13, n2, n3, n12));
                    if (n4 == 5) return;
                    if (bl2) {
                        if (bl) {
                            n13 = n3 = n6 + 2;
                            n2 = n7 + 1;
                            n12 = bl4 ? n7 + n10 - 2 : n7 + n10 / 2;
                        } else {
                            n13 = n6 + 2;
                            n3 = bl4 ? n6 - 3 + n8 : n6 + n8 / 2;
                            n2 = n12 = n7 + (int)Math.round(2.0 * (double)n10 / 3.0);
                        }
                        graphics2D.draw(new Line2D.Double(n13, n2, n3, n12));
                    }
                    if (bl3) {
                        if (bl) {
                            n13 = n3 = n6 - 3 + n8;
                            n2 = bl4 ? n7 + 1 : n7 + n10 / 2;
                            n12 = n7 + n10 - 2;
                        } else {
                            n13 = bl4 ? n6 + 2 : n6 + n8 / 2;
                            n3 = n6 - 3 + n8;
                            n2 = n12 = n7 + n10 / 3;
                        }
                        graphics2D.draw(new Line2D.Double(n13, n2, n3, n12));
                    }
                    jCLineStyle2.resetGraphics(graphics2D);
                    return;
                }
                case 7: {
                    JCLineStyle jCLineStyle3;
                    JCLineStyle jCLineStyle4;
                    int n14;
                    int n15;
                    int n16;
                    int n17 = n16 = n8 % 2 == 0 ? n8 : n8 - 1;
                    if (bl) {
                        n15 = n6;
                        n3 = n6 + 2;
                        n2 = n14 = n7 + n10 / 2;
                    } else {
                        n15 = n3 = n6 + n16 / 2;
                        n2 = n7;
                        n14 = n7 + n10 / 3;
                    }
                    if (jCLineStyle2.updateGraphics(graphics2D)) {
                        graphics2D.draw(new Line2D.Double(n15, n2, n3, n14));
                        if (bl) {
                            n15 = n6 - 3 + n16;
                            n3 = n6 + (n16 - 1);
                            n2 = n14 = n7 + n10 / 2;
                        } else {
                            n15 = n3 = n6 + n16 / 2;
                            n2 = n7 + n10 * 2 / 3;
                            n14 = n7 + n10;
                        }
                        graphics2D.draw(new Line2D.Double(n15, n2, n3, n14));
                        jCLineStyle2.resetGraphics(graphics2D);
                    }
                    if (bl) {
                        n15 = n6 + 3;
                        n2 = n7 + 3;
                        n3 = n16 - 7;
                        n14 = n10 - 7;
                    } else {
                        n15 = n6 + 3;
                        n2 = n7 + n10 / 3;
                        n3 = n16 - 6;
                        n14 = (int)Math.round((double)n10 / 3.0);
                    }
                    JCChartStyle jCChartStyle2 = jCChartStyle;
                    if (bl5) {
                        int n18 = jCDataIndex.getSeriesIndex();
                        int n19 = cachedViewProps != null ? n18 / cachedViewProps.seriesPerData : 0;
                        JCCandleChartFormat jCCandleChartFormat = (JCCandleChartFormat)chartDataView.getChartFormat();
                        JCChartStyle jCChartStyle3 = jCCandleChartFormat.getRisingCandleStyle(n19);
                        jCChartStyle2 = jCCandleChartFormat.getCandleOutlineStyle(n19);
                        jCChartStyle3.getFillStyle().fillRect((Graphics)graphics2D, n15, n2, n3, n14);
                    }
                    if (!(jCLineStyle4 = new JCLineStyle(1, (jCLineStyle3 = jCChartStyle2.getLineStyle()).getColor(), jCLineStyle3.getPattern(), jCLineStyle3.getCap(), jCLineStyle3.getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray())).updateGraphics(graphics2D)) return;
                    graphics2D.draw(new Rectangle2D.Double(n15, n2, n3, n14));
                    jCLineStyle4.resetGraphics(graphics2D);
                    return;
                }
                default: {
                    if (!jCLineStyle2.updateGraphics(graphics2D)) return;
                    graphics2D.draw(new Line2D.Double(n6, n7 - n9 / 2, n6 + n8, n7 - n9 / 2));
                    jCLineStyle2.resetGraphics(graphics2D);
                }
            }
            return;
        } else {
            if (chartDataView == null) return;
            switch (n4) {
                case 11: {
                    JCPieChartFormat jCPieChartFormat = (JCPieChartFormat)chartDataView.getChartFormat();
                    JCFillStyle jCFillStyle = jCPieChartFormat.getOtherStyle().getFillStyle();
                    jCFillStyle.fillOutlineRect((Graphics)graphics2D, n6, n7, n8 - 1, n9 - 1, color);
                }
            }
        }
    }

    private void drawLine(Graphics2D graphics2D, JCLineStyle jCLineStyle, int n2, int n3, int n4, int n5) {
        if (jCLineStyle == null) {
            return;
        }
        int n6 = n4 - 1;
        int n7 = jCLineStyle.getPattern();
        if (n7 >= 6) {
            n6 = -1;
        }
        if (jCLineStyle.updateGraphics(graphics2D, n6)) {
            double d2 = (double)n3 + (double)Math.round((double)n5 / 2.0);
            graphics2D.draw(new Line2D.Double(n2, d2, n2 + n4 - 1, d2));
            jCLineStyle.resetGraphics(graphics2D);
        }
    }

    private void drawSymbol(Graphics2D graphics2D, JCSymbolStyle jCSymbolStyle, int n2, int n3, int n4, int n5) {
        if (jCSymbolStyle == null) {
            return;
        }
        JCLegend jCLegend = this.chart.getLegend();
        int n6 = jCLegend.getItemRenderMode();
        int n7 = n6 == 0 ? jCLegend.getSymbolSize() : jCSymbolStyle.getSize();
        jCSymbolStyle.draw((Graphics)graphics2D, n2 + n4 / 2, n3 + (int)Math.round((double)n5 / 2.0), n7);
    }

    @Override
    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    @Override
    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.chart.getChartArea().getForeground();
    }

    @Override
    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        Serializable serializable;
        JCName jCName;
        Serializable serializable2;
        Serializable serializable3;
        if (graphics == null || jCLegendItem == null) {
            return;
        }
        JCFillStyle jCFillStyle = null;
        if (jCLegendItem.itemInfo instanceof JCDataIndex) {
            serializable3 = (JCDataIndex)jCLegendItem.itemInfo;
            serializable2 = ((JCDataIndex)serializable3).getDataView();
            jCName = ((JCDataIndex)serializable3).getSeries();
            if (jCName != null) {
                serializable = ((ChartDataViewSeries)jCName).getStyle();
                if (serializable != null) {
                    jCFillStyle = ((JCChartStyle)serializable).getFillStyle();
                }
            } else if (serializable2 != null && ((ChartDataView)serializable2).getChartType() == 11) {
                serializable = (JCPieChartFormat)((ChartDataView)serializable2).getChartFormat();
                jCFillStyle = ((JCPieChartFormat)serializable).getOtherStyle().getFillStyle();
            }
        } else if (jCLegendItem.itemInfo instanceof JCAbstractThreshold) {
            serializable3 = (JCAbstractThreshold)jCLegendItem.itemInfo;
            serializable2 = ((JCAbstractThreshold)serializable3).getChartStyle();
            JCFillStyle jCFillStyle2 = jCFillStyle = serializable2 == null ? null : ((JCChartStyle)serializable2).getFillStyle();
            if ((jCFillStyle == null || jCFillStyle.getPattern() == 0) && (jCName = ((JCAbstractThreshold)serializable3).getParent()) != null && (serializable = ((ChartDataView)jCName).getParent()) != null) {
                PlotArea plotArea = ((JCChart)serializable).getChartArea().getPlotArea();
                jCFillStyle = new JCFillStyle(plotArea.getBackground(), 1);
            }
        }
        if (jCFillStyle != null) {
            boolean bl;
            int n2 = jCLegendItem.getDrawType();
            boolean bl2 = n2 == 1 || n2 == 6;
            boolean bl3 = bl = jCFillStyle.getPattern() == 14;
            if (bl2 && bl) {
                int n3 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
                int n4 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
                Dimension dimension = jCLegendItem.symbolDim;
                jCFillStyle.updateAnchorRect(new Rectangle(n3, n4, dimension.width, dimension.height));
            }
            jCFillStyle.updateGraphics(graphics);
        }
    }

    @Override
    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        if (jCLegendItem != null && (jCLegendItem.itemInfo == null || jCLegendItem.itemInfo instanceof JCDataIndex)) {
            JCDataIndex jCDataIndex = (JCDataIndex)jCLegendItem.itemInfo;
            if (jCLegendItem.symbolDim == null && (jCDataIndex == null || jCDataIndex.getSeries() == null)) {
                return true;
            }
        }
        return false;
    }
}

