/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.DataViewIterator;
import com.klg.jclass.chart.Deltas;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCEnvelope;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCMarker;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.JCThreshold;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.chart.resources.LocaleBundle;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChartArea
extends ChartRegion {
    public static final int MAX_ELEVATION = 45;
    public static final int MAX_ROTATION = 45;
    public static final int MAX_DEPTH = 500;
    public static final String ERRMSG_INVALID_XAXIS_INDEX = "Invalid X axis index";
    public static final String ERRMSG_INVALID_YAXIS_INDEX = "Invalid Y axis index";
    protected static final int INVALID_INDEX = -1;
    protected Vector<JCAxis> xaxes = new Vector();
    protected Vector<JCAxis> yaxes = new Vector();
    protected int angleUnit = 2;
    protected JCAxis horizActionAxis;
    protected JCAxis vertActionAxis;
    protected boolean axisBoundingBox = false;
    protected boolean fillOverAxisBoundingBox = false;
    protected boolean fastAction = false;
    protected boolean inAction = false;
    protected int depth = 0;
    protected int elevation = 0;
    protected int rotation = 0;
    protected ImageMapInfo imageMapInfo = null;
    private transient Hashtable<ChartDataView, ChartDraw> drawables = new Hashtable();
    private PlotArea plotArea = new PlotArea(this);
    protected Rectangle chartAreaRect = new Rectangle(0, 0, 0, 0);
    public Rectangle plotRect = new Rectangle(0, 0, 0, 0);
    protected PolarAxisParams polarChartParams = new PolarAxisParams();
    public int deltaX = 0;
    public int deltaY = 0;
    public boolean draw3D = false;
    public boolean hasBar = false;
    protected boolean axisDrawOkay = false;
    public boolean pieFirst = false;
    public boolean polarFirst = false;
    public boolean radarFirst = false;
    protected boolean drawError = false;
    protected Rectangle backplane;
    protected JCFillStyle fillStyle;
    protected int symbolPad = 0;
    protected transient ActionHandler handler = null;
    protected transient boolean saveDBState = false;
    private transient Graphics prevSetGraphics = null;
    private static boolean errorMessagesPrinted = false;
    protected Graphics rbGC = null;
    protected Point last = new Point(0, 0);
    protected boolean inSuperReshape = false;

    public JCChartArea() {
        this(Locale.getDefault());
    }

    public JCChartArea(Locale locale) {
        this.setOpaque(false);
        this.setLocale(locale);
        JCChart jCChart = (JCChart)this.getParent();
        JCAxis jCAxis = new JCAxis(this, false, 0);
        jCAxis.setParentChart(jCChart);
        jCAxis.setName(JCChartBundle.string("com.klg.jclass.chart.Key28", locale));
        JCAxis jCAxis2 = new JCAxis(this, true, 0);
        jCAxis2.setParentChart(jCChart);
        jCAxis2.setName(JCChartBundle.string("com.klg.jclass.chart.Key29", locale));
        this.xaxes.add(jCAxis);
        this.yaxes.add(jCAxis2);
        this.setHorizActionAxis(jCAxis);
        this.setVertActionAxis(jCAxis2);
    }

    protected void setParentOnAxes(JCChart jCChart) {
        for (JCAxis jCAxis : this.xaxes) {
            jCAxis.setParentChart(jCChart);
            if (jCChart == null) continue;
            jCAxis.chartArea = jCChart.getChartArea();
        }
        for (JCAxis jCAxis : this.yaxes) {
            jCAxis.setParentChart(jCChart);
            if (jCChart == null) continue;
            jCAxis.chartArea = jCChart.getChartArea();
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 34);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public int getAngleUnit() {
        return this.angleUnit;
    }

    public void setAngleUnit(int n2) {
        if (!JCChartUtil.validUnit(n2)) {
            throw new IllegalArgumentException("Invalid value for AngleUnit.  Must be one of DEGREES, RADIANS or GRADS");
        }
        this.angleUnit = n2;
        Iterator<ChartDataView> iterator = this.getDataViews();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = iterator.next();
            if (chartDataView == null || chartDataView.getChartType() != 2 || chartDataView.getXAxis() == null) continue;
            chartDataView.getXAxis().updateAnnoDefaultPrecision(2);
        }
        this.setChanged(true, 2);
    }

    public JCAxis getXAxis(int n2) {
        if (this.xaxes == null) {
            return null;
        }
        return this.xaxes.get(n2);
    }

    public void setXAxis(int n2, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n2 < 0 || n2 >= this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            this.removeAxis(n2, this.xaxes);
        } else {
            if (n2 < 0 || n2 > this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            if (n2 < this.xaxes.size()) {
                this.removeAxis(n2, this.xaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n2, this.xaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setXAxes(List<JCAxis> list) {
        this.xaxes = new Vector();
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.setParentChart((JCChart)this.getParent());
            jCAxis.i_vertical = false;
            this.xaxes.add(jCAxis);
        }
        this.setChanged(true, 2);
    }

    public List<JCAxis> getXAxes() {
        return this.xaxes;
    }

    public JCAxis getYAxis(int n2) {
        if (this.yaxes == null) {
            return null;
        }
        return this.yaxes.get(n2);
    }

    public void setYAxis(int n2, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n2 < 0 || n2 >= this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            this.removeAxis(n2, this.yaxes);
        } else {
            if (n2 < 0 || n2 > this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            if (n2 < this.yaxes.size()) {
                this.removeAxis(n2, this.yaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n2, this.yaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setYAxes(List<JCAxis> list) {
        this.yaxes = new Vector();
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.setParentChart((JCChart)this.getParent());
            jCAxis.i_vertical = true;
            this.yaxes.add(jCAxis);
        }
        this.setChanged(true, 2);
    }

    public List<JCAxis> getYAxes() {
        return this.yaxes;
    }

    private void removeAxis(int n2, List<JCAxis> list) {
        if (n2 < list.size()) {
            list.remove(n2);
        }
    }

    private void addAxis(int n2, List<JCAxis> list, JCAxis jCAxis) {
        jCAxis.setParentChart((JCChart)this.getParent());
        list.add(n2, jCAxis);
    }

    public void setHorizActionAxis(JCAxis jCAxis) {
        if (jCAxis != null && (jCAxis.i_vertical || !this.xaxes.contains(jCAxis) && !this.yaxes.contains(jCAxis))) {
            throw new IllegalArgumentException("Invalid horizontal action axis");
        }
        this.horizActionAxis = jCAxis;
    }

    public JCAxis getHorizActionAxis() {
        return this.horizActionAxis;
    }

    public void setVertActionAxis(JCAxis jCAxis) {
        if (!(jCAxis == null || jCAxis.i_vertical && (this.xaxes.contains(jCAxis) || this.yaxes.contains(jCAxis)))) {
            throw new IllegalArgumentException("Invalid vertical action axis");
        }
        this.vertActionAxis = jCAxis;
    }

    public JCAxis getVertActionAxis() {
        return this.vertActionAxis;
    }

    public void setAxisBoundingBox(boolean bl) {
        if (bl == this.axisBoundingBox) {
            return;
        }
        this.axisBoundingBox = bl;
        this.setChanged(true, 1);
    }

    public boolean getAxisBoundingBox() {
        return this.axisBoundingBox;
    }

    public boolean isFillOverAxisBoundingBox() {
        return this.fillOverAxisBoundingBox;
    }

    public void setFillOverAxisBoundingBox(boolean bl) {
        if (bl == this.fillOverAxisBoundingBox) {
            return;
        }
        this.fillOverAxisBoundingBox = bl;
        this.setChanged(true, 1);
    }

    public boolean getFastAction() {
        return this.fastAction;
    }

    public void setFastAction(boolean bl) {
        if (bl == this.fastAction) {
            return;
        }
        this.fastAction = bl;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n2) {
        int n3 = (int)JCChartUtil.clamp((double)n2, 0.0, 500.0);
        if (this.depth == n3) {
            return;
        }
        this.depth = n3;
        this.setChanged(true, 2);
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int n2) {
        int n3 = (int)JCChartUtil.clamp((double)n2, -45.0, 45.0);
        if (n3 == this.elevation) {
            return;
        }
        this.elevation = n3;
        this.setChanged(true, 2);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n2) {
        int n3 = (int)JCChartUtil.clamp((double)n2, -45.0, 45.0);
        if (n3 == this.rotation) {
            return;
        }
        this.rotation = n3;
        this.setChanged(true, 2);
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    @Override
    public boolean getChanged() {
        return super.getChanged() || this.isDirty();
    }

    @Override
    public void setChanged(boolean bl, int n2) {
        Object object;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        this.ensureDrawables();
        Enumeration<ChartDataView> enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ChartDraw trackChange = this.drawables.get(object);
            trackChange.setChanged(true, n2, false);
            if (bl) continue;
            trackChange.dataObject.setChanged(false, 0, false);
        }
        this.changed = bl;
        this.changedFlag = this.changed ? (this.changedFlag |= n2) : n2;
        if (this.changed) {
            if (!jCChart.isBatched()) {
                object = jCChart.getLegend();
                if (object != null && (n2 & 0x20) > 0) {
                    ((JCLegend)object).setChanged(true, 2, false);
                    ((JCLegend)object).recalc();
                }
                if (object != null && (n2 & 0x10) > 0) {
                    ((JCLegend)object).setChanged(true, 1, false);
                }
                if ((n2 & 2) > 0) {
                    this.recalc();
                    jCChart.repaint();
                } else if ((n2 & 1) > 0) {
                    jCChart.repaint();
                }
            }
            return;
        }
        for (JCAxis jCAxis : this.xaxes) {
            if (jCAxis == null) continue;
            jCAxis.setChanged(false, 0, false);
        }
        for (JCAxis jCAxis : this.yaxes) {
            if (jCAxis == null) continue;
            jCAxis.setChanged(false, 0, false);
        }
    }

    public PlotArea getPlotArea() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea(this);
        }
        return this.plotArea;
    }

    protected void printErrorMessages(String string, String string2, String[] stringArray) {
        if (!errorMessagesPrinted) {
            if (string != null) {
                System.err.println(string);
            }
            if (string2 != null) {
                System.err.println(string2);
            }
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    if (string3 == null) continue;
                    System.err.println(string3);
                }
            }
            errorMessagesPrinted = true;
        }
    }

    @Override
    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        Object object;
        if (this.getParent() == null || graphics == null || !this.isVisible()) {
            return;
        }
        super.paintComponent(graphics);
        JCChart jCChart = (JCChart)this.getParent();
        boolean bl = false;
        for (Class<?> clazz = jCChart.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            object = clazz.getName();
            if (object == null) continue;
            if (((String)object).equals("com.klg.jclass.schart.JCServerChart")) break;
            if (!((String)object).equals("com.klg.jclass.chart.JCChart")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = graphics.getClipBounds();
            Font font = new Font("Dialog", 1, 12);
            graphics.setColor(Color.blue);
            graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics.setColor(Color.yellow);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = new String[]{LocaleBundle.string("Invalid use of JCChart within JCServerChart!"), LocaleBundle.string("It is not recommended that JCServerChart and"), LocaleBundle.string("JCChart jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerChart jar must be first.")};
            this.printErrorMessages(null, null, stringArray);
            Rectangle rectangle = fontMetrics.getStringBounds(stringArray[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * rectangle.getHeight());
            float f3 = (float)((double)((Rectangle)object).height / 2.0) - f2 * (float)((double)(stringArray.length + 1) / 2.0);
            for (String string : stringArray) {
                if (string == null) continue;
                rectangle = fontMetrics.getStringBounds(string, graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)object).width - rectangle.getWidth()) / 2.0);
                graphics2D.drawString(string, f4, f3 += f2);
            }
            return;
        }
        object = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        ((Graphics)object).translate(rectangle.x, rectangle.y);
        Rectangle rectangle2 = ((Graphics)object).getClipBounds();
        Graphics2D graphics2D = (Graphics2D)object;
        RenderProperties renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
        if (renderProperties != null) {
            GraphicsUtil.setAntiAliasing(graphics2D, renderProperties.getAntiAliasing());
        }
        Rectangle rectangle3 = new Rectangle(0, 0, this.chartAreaRect.width, this.chartAreaRect.height);
        boolean bl2 = this.isRadar();
        boolean bl3 = bl2 && this.isWebbedRadarChart();
        try {
            serializable = this.clipForDrawing(this.symbolPad);
            graphics2D.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            this.drawBackplane(graphics2D);
            graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            Rectangle rectangle4 = this.clipToEntirePlotRect();
            if (this.pieFirst) {
                this.ensureDrawables();
                DataViewIterator dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
                    ChartDraw chartDraw = this.getDrawable(chartDataView);
                    graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    chartDraw.draw(graphics2D);
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else if (this.radarFirst) {
                this.ensureDrawables();
                graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                DataViewIterator dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
                    ChartDraw chartDraw = this.getDrawable(chartDataView);
                    this.preDrawGrids((Graphics)graphics2D, chartDataView);
                    chartDataView.drawMarkers(graphics2D, false, true, bl3, true);
                    chartDraw.draw(graphics2D);
                    chartDataView.drawMarkers(graphics2D, false, true, bl3, false);
                    this.drawAxes((Graphics)graphics2D, chartDataView);
                    if (this.fastAction && this.inAction) continue;
                    this.drawAxisAnnotationsAndTitle((Graphics)graphics2D, chartDataView);
                }
                graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else if (this.polarFirst) {
                ChartDataView chartDataView;
                this.ensureDrawables();
                graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                DataViewIterator dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    this.preDrawGrids((Graphics)graphics2D, chartDataView);
                }
                this.drawMarkers(graphics2D, jCChart, false, false, true);
                dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    ChartDraw chartDraw = this.getDrawable(chartDataView);
                    chartDraw.draw(graphics2D);
                }
                this.drawMarkers(graphics2D, jCChart, false, false, false);
                dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    this.drawAxes((Graphics)graphics2D, chartDataView);
                    if (this.fastAction && this.inAction) continue;
                    this.drawAxisAnnotationsAndTitle((Graphics)graphics2D, chartDataView);
                }
                graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else if (this.draw3D) {
                ChartDataView chartDataView;
                this.ensureDrawables();
                JCAxis jCAxis = null;
                JCAxis jCAxis2 = null;
                DataViewIterator dataViewIterator = new DataViewIterator(jCChart, false, true, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    jCAxis = chartDataView.getXAxis();
                    jCAxis2 = chartDataView.getYAxis();
                }
                if (this.axisDrawOkay) {
                    graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDraw3DAxes(graphics2D, jCAxis, jCAxis2);
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (this.axisBoundingBox) {
                        graphics2D.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        graphics2D.setColor(this.plotArea.getForeground());
                        graphics2D.drawRect(this.backplane.x, this.backplane.y, this.backplane.width, this.backplane.height);
                        graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    graphics2D.clipRect(this.backplane.x + 1, this.backplane.y + 1, this.backplane.width - 1, this.backplane.height - 1);
                    if (!this.fastAction || !this.inAction) {
                        this.preDrawGrids((Graphics)graphics2D, this.xaxes);
                        this.preDrawGrids((Graphics)graphics2D, this.yaxes);
                    }
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    if (jCAxis != null && jCAxis.visible) {
                        jCAxis.preDrawOutlineTrough(graphics2D);
                    }
                    if (jCAxis2 != null && jCAxis2.visible) {
                        jCAxis2.preDrawOutlineTrough(graphics2D);
                    }
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (this.axisDrawOkay) {
                    graphics2D.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawBpAxes(graphics2D, this.xaxes);
                    this.drawBpAxes(graphics2D, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawBpAxisAnnotationsAndTitle(graphics2D, this.xaxes);
                        this.drawBpAxisAnnotationsAndTitle(graphics2D, this.yaxes);
                    }
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.drawMarkers(graphics2D, jCChart, true, false, true);
                this.drawThresholds(graphics2D, jCChart, true, bl2, bl3, true);
                dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    this.drawClipped(chartDataView.getChartType(), graphics2D, (Rectangle)serializable, rectangle4, this.getDrawable(chartDataView), rectangle2);
                }
                dataViewIterator = new DataViewIterator(jCChart, false, true, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    this.drawClipped(chartDataView.getChartType(), graphics2D, (Rectangle)serializable, rectangle4, this.getDrawable(chartDataView), rectangle2);
                }
                if (this.axisDrawOkay) {
                    graphics2D.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawFpAxes(graphics2D, this.xaxes);
                    this.drawFpAxes(graphics2D, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawFpAxisAnnotationsAndTitle(graphics2D, this.xaxes);
                        this.drawFpAxisAnnotationsAndTitle(graphics2D, this.yaxes);
                    }
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                dataViewIterator = new DataViewIterator(jCChart, false, false, true, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    chartDataView.drawEnvelopes(graphics2D, true);
                    this.drawClipped(chartDataView.getChartType(), graphics2D, (Rectangle)serializable, rectangle4, this.getDrawable(chartDataView), rectangle2);
                }
                this.drawMarkers(graphics2D, jCChart, true, false, false);
            } else {
                ChartDataView chartDataView;
                if (!(!this.axisDrawOkay || this.fastAction && this.inAction)) {
                    graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDrawGrids((Graphics)graphics2D, this.xaxes);
                    this.preDrawGrids((Graphics)graphics2D, this.yaxes);
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.ensureDrawables();
                this.drawMarkers(graphics2D, jCChart, true, false, true);
                this.drawThresholds(graphics2D, jCChart, true, bl2, bl3, true);
                graphics2D.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                DataViewIterator dataViewIterator = new DataViewIterator(jCChart, false, false, false, false);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    this.getDrawable(chartDataView).draw(graphics2D);
                }
                graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.axisDrawOkay) {
                    graphics2D.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawAxes((Graphics)graphics2D, this.xaxes);
                    this.drawAxes((Graphics)graphics2D, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawAxisAnnotationsAndTitle((Graphics)graphics2D, this.xaxes);
                        this.drawAxisAnnotationsAndTitle((Graphics)graphics2D, this.yaxes);
                    }
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                dataViewIterator = new DataViewIterator(jCChart, false, false, false, true);
                while (dataViewIterator.hasNext()) {
                    chartDataView = (ChartDataView)dataViewIterator.next();
                    chartDataView.drawEnvelopes(graphics2D, true);
                    graphics2D.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                    this.getDrawable(chartDataView).draw(graphics2D);
                    graphics2D.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.drawMarkers(graphics2D, jCChart, true, false, false);
            }
            this.drawError = false;
        }
        catch (Exception exception) {
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage("drawError", exception);
            }
            this.drawError = true;
        }
        if (object != null) {
            ((Graphics)object).dispose();
        }
        this.rbGC = graphics;
        if (this.handler != null) {
            this.handler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
        serializable = (JCChart)this.getParent();
        if (((JCChart)serializable).hasChartLabelManager()) {
            ((JCChart)serializable).getChartLabelManager().recalcChangedChartLabels();
        }
        this.setChanged(false, 0);
    }

    public boolean getDrawError() {
        return this.drawError;
    }

    private void drawClipped(int n2, Graphics graphics, Rectangle rectangle, Rectangle rectangle2, ChartDraw chartDraw, Rectangle rectangle3) {
        if (n2 == 0 || n2 == 1) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        chartDraw.draw(graphics);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
    }

    private void drawRotatedWatermark(Graphics2D graphics2D, double d2, String string) {
    }

    private void drawDevelopmentWatermark(Graphics2D graphics2D, String string) {
    }

    void showAction(int n2, int n3) {
        if (this.last.x == n2 && this.last.y == n3) {
            return;
        }
        this.last.x = n2;
        this.last.y = n3;
        this.handler.animate(n2, n3);
    }

    void endAction(int n2, int n3) {
        if (this.handler == null) {
            return;
        }
        ActionHandler actionHandler = this.handler;
        this.handler = null;
        actionHandler.end(n2, n3);
    }

    void startAction(EventTrigger eventTrigger, int n2, int n3) {
        this.handler = ActionHandler.makeHandler(eventTrigger.getAction(), this);
        if (this.handler != null) {
            this.handler.start(n2, n3);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.ensureDrawables();
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension.width = 100;
            dimension.height = 100;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void checkAxisVertical() {
        JCChart jCChart = (JCChart)this.getParent();
        ChartDataView chartDataView = jCChart.getDataView(0);
        JCAxis jCAxis = chartDataView.getXAxis();
        JCAxis jCAxis2 = chartDataView.getYAxis();
        int n2 = chartDataView.getChartType();
        if (n2 == 2 || n2 == 3 || n2 == 4) {
            jCAxis.setVerticalInternal(false);
            jCAxis2.setVerticalInternal(true);
        } else {
            jCAxis.setVerticalInternal(jCAxis.vertical);
            jCAxis2.setVerticalInternal(jCAxis2.vertical);
        }
    }

    protected void checkTimelineAxisVertical() {
        for (JCAxis jCAxis : this.xaxes) {
            if (!jCAxis.isTimelineAbscissa()) continue;
            jCAxis.setVerticalInternal(false);
        }
        for (JCAxis jCAxis : this.yaxes) {
            if (!jCAxis.isTimelineOrdinateAxis()) continue;
            jCAxis.setVerticalInternal(true);
        }
    }

    public void recalc() {
        this.recalc(true);
    }

    protected void recalc(boolean bl) {
        List<ChartDataView> list;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (!this.isChanged() && this.isValid() && !this.isPolarRadar()) {
            return;
        }
        this.ensureDrawables();
        this.ensureRadarChartLabels();
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        this.resetPlotArea();
        this.checkAxisVertical();
        this.checkTimelineAxisVertical();
        this.calc3D();
        this.calcLimits();
        if (this.userProvidedAnnotations(this.xaxes) && this.rotatedAxisAnnotations(this.xaxes)) {
            this.makeAnnotations(this.xaxes);
        }
        if (this.userProvidedAnnotations(this.yaxes) && this.rotatedAxisAnnotations(this.yaxes)) {
            this.makeAnnotations(this.yaxes);
        }
        this.calcAxisParams(this.xaxes);
        this.calcAxisParams(this.yaxes);
        this.updateAnnotationsAndGrids(this.xaxes);
        this.updateAnnotationsAndGrids(this.yaxes);
        if (!this.inAction || !this.fastAction) {
            this.calcAnchors(this.xaxes);
            this.calcAnchors(this.yaxes);
            this.makeAnnotations(this.xaxes);
            this.makeAnnotations(this.yaxes);
            this.layoutAnnotations(this.xaxes);
            this.layoutAnnotations(this.yaxes);
            this.calcAnnotationExtents(this.xaxes, bl);
            this.calcAnnotationExtents(this.yaxes, false);
            this.updateAnnotationsAndGrids(this.xaxes);
            this.updateAnnotationsAndGrids(this.yaxes);
        }
        this.layoutChartArea();
        if (this.checkDeltaValues()) {
            this.layoutChartArea();
        }
        JCChartLabelManager jCChartLabelManager = jCChart.getChartLabelManager();
        if (bl && !this.doUserProvidedLabelsFit(this.xaxes)) {
            this.recalc(false);
        } else {
            this.calcGraphExtents();
            if (!(this.inAction && this.fastAction || !jCChart.hasChartLabelManager())) {
                jCChartLabelManager.markAllChartLabelsForRecalc();
            }
            this.setChanged(false, 0);
        }
        if (jCChart.hasChartLabelManager() && (list = jCChart.getDataView()) != null) {
            for (ChartDataView chartDataView : list) {
                if (!chartDataView.isVisible() || !chartDataView.getAutoLabel() || !chartDataView.generateAutoLabels) continue;
                jCChartLabelManager.generateAutoLabels(chartDataView);
                chartDataView.generateAutoLabels = false;
            }
        }
    }

    private void ensureRadarChartLabels() {
        ChartDataView chartDataView;
        if (this.isRadar() && (chartDataView = this.getFirstVisibleDataView()) != null && chartDataView.getXAxis() != null) {
            JCValueLabel[] jCValueLabelArray;
            int n2 = ChartDataView.getNumRadarSpokes(chartDataView);
            JCAxis jCAxis = chartDataView.getXAxis();
            int n3 = jCAxis.getAnnotationMethod();
            if (n3 == 3) {
                List<String> list = chartDataView.getPointLabels();
                if (list == null || list.size() == 0) {
                    list = new Vector<String>();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        list.add("");
                    }
                    chartDataView.setPointLabels(list);
                }
            } else if (n3 == 1 && ((jCValueLabelArray = jCAxis.getValueLabels()) == null || jCValueLabelArray.length == 0)) {
                ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(0);
                jCValueLabelArray = new JCValueLabel[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    jCValueLabelArray[i3] = new JCValueLabel(chartDataViewSeries.getX(i3), "", jCAxis, false, true, false);
                }
                jCAxis.setValueLabels(jCValueLabelArray);
            }
        }
    }

    protected boolean doUserProvidedLabelsFit(List<JCAxis> list) {
        if (list == null) {
            return false;
        }
        boolean bl = true;
        for (JCAxis jCAxis : list) {
            if (jCAxis.doUserProvidedLabelsFit()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void layoutChartArea() {
        this.resetPlotArea();
        this.symbolPad = (this.getBiggestSymbolSize() + 1) / 2;
        int n2 = this.axisBoundingBox ? 1 : 0;
        int n3 = this.chartAreaRect.width - this.plotArea.left.value - this.plotArea.right.value - n2;
        int n4 = this.chartAreaRect.height - this.plotArea.top.value - this.plotArea.bottom.value - n2;
        this.plotRect = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, n3, n4);
        boolean bl = this.isPolarRadar();
        if (!this.pieFirst) {
            Vector<JCAxis> vector = new Vector<JCAxis>();
            Vector<JCAxis> vector2 = new Vector<JCAxis>();
            this.getHorizVertAxes(vector2, vector);
            if (!bl) {
                this.adjustPlotRectForAxes(this.xaxes);
                this.adjustPlotRectForAxes(this.yaxes);
            }
            this.layoutAxes(this.xaxes, false);
            this.layoutAxes(this.yaxes, false);
            if (!bl) {
                this.adjustForExtents(vector2, vector);
                this.adjustForSymbols(vector2, vector);
                if (this.rotatedAxisAnnotations(this.xaxes) || this.rotatedAxisAnnotations(this.yaxes)) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        this.calcAnnotationExtents(this.xaxes, false);
                        this.calcAnnotationExtents(this.yaxes, false);
                        this.adjustForExtents(vector2, vector);
                    }
                }
                this.layoutAxes(this.xaxes, true);
                this.layoutAxes(this.yaxes, true);
                this.layoutOrigins(this.xaxes);
                this.layoutOrigins(this.yaxes);
            }
            if (bl) {
                Object object;
                ChartDataView chartDataView = this.getFirstVisibleDataView();
                if (chartDataView != null) {
                    object = new Deltas();
                    this.getPolarChartDeltas(chartDataView, (Deltas)object);
                    this.adjustForPolarAnnoExtents(chartDataView.getYAxis(), (Deltas)object);
                }
                if (this.isPolar()) {
                    object = this.getDataViews();
                    while (object.hasNext()) {
                        ChartDataView chartDataView2 = (ChartDataView)object.next();
                        if (chartDataView2 == chartDataView) continue;
                        chartDataView2.getYAxis().getAxisHandler().calcTransformation();
                    }
                }
            } else {
                this.adjustForOrthoExtents(vector2, vector);
            }
            if (!this.inAction || !this.fastAction) {
                this.layoutAnnotations(this.xaxes);
                this.layoutAnnotations(this.yaxes);
                this.checkAnnotations(this.xaxes);
                this.checkAnnotations(this.yaxes);
                this.updateAnnotationsAndGrids(this.xaxes);
                this.updateAnnotationsAndGrids(this.yaxes);
            }
        }
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = this.plotRect.y;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = this.plotRect.x;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = this.chartAreaRect.height - this.plotRect.y - this.plotRect.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = this.chartAreaRect.width - this.plotRect.x - this.plotRect.width;
        }
    }

    private boolean userProvidedAnnotations(List<JCAxis> list) {
        for (JCAxis jCAxis : list) {
            if (jCAxis.getAnnotationMethod() != 1 || jCAxis.annoHandler.userValueLabels == null || jCAxis.annoHandler.userValueLabels.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean rotatedAxisAnnotations(List<JCAxis> list) {
        for (JCAxis jCAxis : list) {
            if (jCAxis.getAnnotationRotation() != 4) continue;
            return true;
        }
        return false;
    }

    protected void adjustForPolarAnnoExtents(JCAxis jCAxis, Deltas deltas) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.adjustCenterAndRadius(deltas.dx, deltas.dy, deltas.dWidth);
    }

    protected Iterator<ChartDataView> getDataViews() {
        Iterator<ChartDataView> iterator = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            iterator = jCChart.getOriginalDataView().iterator();
        }
        return iterator;
    }

    protected ChartDataView getFirstVisibleDataView() {
        Iterator<ChartDataView> iterator;
        ChartDataView chartDataView = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (iterator = jCChart.getOriginalDataView().iterator()) != null) {
            while (iterator.hasNext()) {
                chartDataView = iterator.next();
                if (chartDataView == null || !chartDataView.isVisible()) continue;
                return chartDataView;
            }
        }
        return chartDataView;
    }

    protected ChartDataView getDataView(int n2) {
        List<ChartDataView> list;
        ChartDataView chartDataView = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (list = jCChart.getOriginalDataView()) != null && n2 >= 0 && n2 < list.size()) {
            chartDataView = list.get(n2);
        }
        return chartDataView;
    }

    protected boolean isPolar() {
        boolean bl = false;
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView != null) {
            bl = chartDataView.chartType == 2;
        }
        return bl;
    }

    protected boolean isRadar() {
        boolean bl = false;
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView != null) {
            bl = chartDataView.chartType == 3 || chartDataView.chartType == 4;
        }
        return bl;
    }

    protected boolean isPolarRadar() {
        return this.isPolar() || this.isRadar();
    }

    private int getIndexOfMatchingValue(double[] dArray, double d2, int n2, int n3) {
        int n4;
        boolean bl = false;
        for (n4 = n2; n4 <= n3; ++n4) {
            if (dArray[n4] != d2) continue;
            bl = true;
            break;
        }
        return bl ? n4 : -1;
    }

    private double getRadarLabelAngle(double[] dArray, JCValueLabel jCValueLabel, boolean bl, int n2, int n3) {
        int n4 = this.getIndexOfMatchingValue(dArray, jCValueLabel.value, n2, n3);
        if (n4 == -1) {
            return 0.0;
        }
        int n5 = n3 - n2 + 1;
        return JCChartUtil.getRadarAngle(2, n5, n4 - n2, bl);
    }

    protected void getPolarChartDeltas(ChartDataView chartDataView, Deltas deltas) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        Point point;
        Point point2;
        Point point3;
        Point point4;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        boolean bl;
        JCAxis jCAxis = chartDataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        AnnoBoundsInfo annoBoundsInfo = jCAxis.getPolarAnnotationBounds();
        if (annoBoundsInfo == null) {
            deltas.dx = 0;
            deltas.dy = 0;
            deltas.dWidth = 0;
            deltas.dHeight = 0;
            return;
        }
        JCAxis jCAxis2 = chartDataView.getYAxis();
        if (jCAxis2.polarAxisParams.radius <= 1.0 && annoBoundsInfo.x > 0) {
            int n2 = (annoBoundsInfo.width - this.chartAreaRect.width) / 2;
            int n3 = (annoBoundsInfo.height - this.chartAreaRect.height) / 2;
            deltas.dx = -annoBoundsInfo.x - n2;
            deltas.dy = -annoBoundsInfo.y - n3;
            deltas.dWidth = 0;
            deltas.dHeight = 0;
            return;
        }
        boolean bl2 = bl = chartDataView.chartType == 3 || chartDataView.chartType == 4;
        if (bl && jCAxis.getAnnotationMethod() != 0) {
            List<ChartDataViewSeries> list = chartDataView.getSeries();
            ChartDataViewSeries chartDataViewSeries = list.get(0);
            double[] dArray = chartDataViewSeries.getX();
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            int n4 = nArray[0];
            int n5 = nArray[1];
            d19 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMaxBoundsX, jCAxis.isReversed(), n4, n5);
            d18 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMaxBoundsY, jCAxis.isReversed(), n4, n5);
            d17 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMinBoundsX, jCAxis.isReversed(), n4, n5);
            d16 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMinBoundsY, jCAxis.isReversed(), n4, n5);
        } else {
            int n6 = jCAxis.isReversed() ? -1 : 1;
            d19 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, (double)n6 * annoBoundsInfo.valueLabelMaxBoundsX.value);
            d18 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, (double)n6 * annoBoundsInfo.valueLabelMaxBoundsY.value);
            d17 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, (double)n6 * annoBoundsInfo.valueLabelMinBoundsX.value);
            d16 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, (double)n6 * annoBoundsInfo.valueLabelMinBoundsY.value);
        }
        double d20 = d19 + jCAxis2.polarAxisParams.originBase;
        double d21 = d18 + jCAxis2.polarAxisParams.originBase;
        double d22 = d17 + jCAxis2.polarAxisParams.originBase;
        double d23 = d16 + jCAxis2.polarAxisParams.originBase;
        double d24 = jCAxis.polarAxisParams.originBase;
        double d25 = JCChartUtil.getAngleRatio(2, d19, d24);
        double d26 = JCChartUtil.getAngleRatio(2, d18, d24);
        double d27 = JCChartUtil.getAngleRatio(2, d17, d24);
        double d28 = JCChartUtil.getAngleRatio(2, d16, d24);
        double d29 = annoBoundsInfo.valueLabelMaxBoundsX.label.left.value + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value;
        double d30 = annoBoundsInfo.valueLabelMinBoundsX.label.left.value;
        double d31 = annoBoundsInfo.valueLabelMaxBoundsY.label.top.value + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
        double d32 = annoBoundsInfo.valueLabelMinBoundsY.label.top.value;
        if (!this.isWebShaped(jCAxis2)) {
            d29 = Math.max(d29, jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius);
            d30 = Math.min(d30, jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius);
            d31 = Math.max(d31, jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius);
            d32 = Math.min(d32, jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius);
        }
        double d33 = d29 - d30 - (double)this.chartAreaRect.width;
        double d34 = d31 - d32 - (double)this.chartAreaRect.height;
        double d35 = 0.0;
        double d36 = 0.0;
        if (this.isWebShaped(jCAxis2) || d29 > jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius) {
            if (d25 < 0.25) {
                d36 = d20;
                d35 = Math.cos(d36) * jCAxis2.polarAxisParams.radius;
            } else if (d25 > 0.75) {
                d36 = Math.PI * 2 - d20;
                d35 = Math.cos(d36) * jCAxis2.polarAxisParams.radius;
            }
        } else {
            d35 = jCAxis2.polarAxisParams.radius;
        }
        double d37 = 0.0;
        double d38 = 0.0;
        if (this.isWebShaped(jCAxis2) || d30 < jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius) {
            if (d27 < 0.5 && d27 > 0.25) {
                d38 = Math.PI - d22;
                d37 = Math.cos(d38) * jCAxis2.polarAxisParams.radius;
            } else if (d27 >= 0.5 && d27 < 0.75) {
                d38 = d22 - Math.PI;
                d37 = Math.cos(d38) * jCAxis2.polarAxisParams.radius;
            }
        } else {
            d37 = jCAxis2.polarAxisParams.radius;
        }
        double d39 = d37 + d35;
        if (d35 > d37) {
            d15 = d35 / d39;
            d14 = Math.cos(d36);
            d13 = d33 * d15;
            if (d14 != 0.0) {
                d13 /= d14;
            }
        } else if (d37 > d35) {
            d15 = d37 / d39;
            d14 = Math.cos(d38);
            d13 = d33 * d15;
            if (d14 != 0.0) {
                d13 /= d14;
            }
        } else {
            d13 = d36 != 1.5707963267948966 && d36 != 4.71238898038469 ? d33 * 0.5 / Math.cos(d36) : jCAxis2.polarAxisParams.radius * 0.1;
        }
        d15 = jCAxis2.polarAxisParams.radius - d13;
        if (this.isWebShaped(jCAxis2) || d31 > jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius) {
            if (d26 > 0.75) {
                d12 = Math.PI * 2 - d21;
                d14 = Math.sin(d12) * jCAxis2.polarAxisParams.radius;
            } else if (d26 < 0.75 && d26 >= Math.PI) {
                d12 = d21 - Math.PI;
                d14 = Math.sin(d12) * jCAxis2.polarAxisParams.radius;
            } else {
                d12 = 1.5707963267948966;
                d14 = jCAxis2.polarAxisParams.radius;
            }
        } else {
            d12 = 1.5707963267948966;
            d14 = jCAxis2.polarAxisParams.radius;
        }
        if (this.isWebShaped(jCAxis2) || d32 < jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius) {
            if (d28 < 0.25) {
                d11 = d23;
                d10 = Math.sin(d11) * jCAxis2.polarAxisParams.radius;
            } else if (d28 <= 0.5 && d28 > 0.25) {
                d11 = Math.PI - d23;
                d10 = Math.sin(d11) * jCAxis2.polarAxisParams.radius;
            } else {
                d11 = 1.5707963267948966;
                d10 = jCAxis2.polarAxisParams.radius;
            }
        } else {
            d11 = 1.5707963267948966;
            d10 = jCAxis2.polarAxisParams.radius;
        }
        d39 = d10 + d14;
        if (d14 > d10) {
            d9 = d14 / d39;
            d8 = Math.sin(d12);
            d13 = d34 * d9;
            if (d8 != 0.0) {
                d13 /= d8;
            }
        } else if (d10 > d14) {
            d9 = d10 / d39;
            d8 = Math.sin(d11);
            d13 = d34 * d9;
            if (d8 != 0.0) {
                d13 /= d8;
            }
        } else {
            d13 = d12 != 0.0 && d12 != Math.PI ? d34 * 0.5 / Math.sin(d12) : (double)annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
        }
        d9 = jCAxis2.polarAxisParams.radius - d13;
        d8 = Math.min(d15, d9);
        if (!this.isWebShaped(jCAxis2)) {
            d8 = Math.min(d8, jCAxis2.polarAxisParams.radius * 0.95);
        }
        d8 = Math.max(d8, 1.0);
        if (bl) {
            boolean bl3 = jCAxis.isReversed();
            double d40 = bl3 ? -d17 : d17;
            double d41 = bl3 ? -d16 : d16;
            double d42 = bl3 ? -d19 : d19;
            double d43 = bl3 ? -d18 : d18;
            point4 = jCAxis2.toPixelPolar(d40, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point3 = jCAxis2.toPixelPolar(d41, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point2 = jCAxis2.toPixelPolar(d42, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point = jCAxis2.toPixelPolar(d43, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
        } else {
            point4 = jCAxis2.toPixelPolar(d17, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point3 = jCAxis2.toPixelPolar(d16, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point2 = jCAxis2.toPixelPolar(d19, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
            point = jCAxis2.toPixelPolar(d18, (int)d8 + jCAxis.getThetaAxisLabelOffset(), false);
        }
        double d44 = Double.MIN_VALUE;
        double d45 = Double.MAX_VALUE;
        double d46 = Double.MIN_VALUE;
        double d47 = Double.MAX_VALUE;
        if (this.isWebShaped(jCAxis2) || d29 > jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius) {
            d44 = d25 < 0.25 || d25 > 0.75 ? (double)(point2.x + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value) : (double)(point2.x + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value / 2);
        }
        if (this.isWebShaped(jCAxis2)) {
            d7 = 0.0;
        } else {
            d7 = jCAxis2.polarAxisParams.xCenter + d8;
            d44 = Math.max(d44, d7);
        }
        if (this.isWebShaped(jCAxis2) || d30 < jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius) {
            d45 = d27 > 0.25 && d27 < 0.75 ? (double)(point4.x - annoBoundsInfo.valueLabelMinBoundsX.label.width.value) : (double)(point4.x - annoBoundsInfo.valueLabelMinBoundsX.label.width.value / 2);
        }
        if (this.isWebShaped(jCAxis2)) {
            d6 = Double.MAX_VALUE;
        } else {
            d6 = jCAxis2.polarAxisParams.xCenter - d8;
            d45 = Math.min(d45, d6);
        }
        double d48 = d44 - d45;
        double d49 = ((double)this.chartAreaRect.width - d48) / 2.0;
        if (d26 != 0.0 && d26 != 0.5) {
            if (this.isWebShaped(jCAxis2) || d31 > jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius) {
                d46 = point.y + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
            }
        } else {
            d46 = point.y + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value / 2;
        }
        if (this.isWebShaped(jCAxis2)) {
            d5 = 0.0;
        } else {
            d5 = jCAxis2.polarAxisParams.yCenter + d8;
            d46 = Math.max(d46, d5);
        }
        if (d28 != 0.0 && d28 != 0.5) {
            if (this.isWebShaped(jCAxis2) || d32 < jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius) {
                d47 = point3.y - annoBoundsInfo.valueLabelMinBoundsY.label.height.value;
            }
        } else {
            d47 = point3.y - annoBoundsInfo.valueLabelMinBoundsY.label.height.value / 2;
        }
        if (this.isWebShaped(jCAxis2)) {
            d4 = Double.MAX_VALUE;
        } else {
            d4 = jCAxis2.polarAxisParams.yCenter - d8;
            d47 = Math.min(d47, d4);
        }
        double d50 = d46 - d47;
        double d51 = ((double)this.chartAreaRect.height - d50) / 2.0;
        if (d45 < d6) {
            d3 = jCAxis2.polarAxisParams.xCenter - (double)point4.x;
            d2 = d27 != 0.25 && d27 != 0.75 ? (double)annoBoundsInfo.valueLabelMinBoundsX.label.width.value + d3 + d49 : (double)(annoBoundsInfo.valueLabelMinBoundsX.label.width.value / 2) + d49;
        } else if (d44 > d7) {
            d3 = (double)point2.x - jCAxis2.polarAxisParams.xCenter;
            d2 = d25 != 0.25 && d25 != 0.75 ? (double)this.chartAreaRect.width - ((double)annoBoundsInfo.valueLabelMaxBoundsX.label.width.value + d3 + d49) : (double)(annoBoundsInfo.valueLabelMaxBoundsX.label.width.value / 2) + d49;
        } else {
            d2 = (double)this.chartAreaRect.width / 2.0;
        }
        if (d47 < d4) {
            double d52 = jCAxis2.polarAxisParams.yCenter - (double)point3.y;
            d3 = d28 != 0.0 && d28 != 0.5 ? (double)annoBoundsInfo.valueLabelMinBoundsY.label.height.value + d52 + d51 : (double)(annoBoundsInfo.valueLabelMinBoundsY.label.height.value / 2) + d51;
        } else if (d46 > d5) {
            double d53 = (double)point.y - jCAxis2.polarAxisParams.yCenter;
            d3 = d26 != 0.0 && d26 != 0.5 ? (double)this.chartAreaRect.height - ((double)annoBoundsInfo.valueLabelMaxBoundsY.label.height.value + d53 + d51) : (double)(annoBoundsInfo.valueLabelMaxBoundsY.label.height.value / 2) + d51;
        } else {
            d3 = (double)this.chartAreaRect.height / 2.0;
        }
        deltas.dx = (int)(d2 - jCAxis2.polarAxisParams.xCenter);
        deltas.dy = (int)(d3 - jCAxis2.polarAxisParams.yCenter);
        deltas.dHeight = deltas.dWidth = (int)(d8 - jCAxis2.polarAxisParams.radius);
    }

    protected boolean isWebShaped(JCAxis jCAxis) {
        return jCAxis.isRadar() && !jCAxis.polarAxisParams.isCircularGrid();
    }

    protected int getBiggestSymbolSize() {
        int n2 = 0;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            List<ChartDataView> list = jCChart.getDataView();
            for (ChartDataView chartDataView : list) {
                JCChartStyle jCChartStyle;
                int n3 = chartDataView.getChartType();
                if (n3 == 8 || n3 == 12 || n3 == 4 || n3 == 9 || n3 == 10 || n3 == 11 || n3 == 5) continue;
                List<ChartDataViewSeries> list2 = chartDataView.getSeries();
                for (ChartDataViewSeries chartDataViewSeries : list2) {
                    if (!chartDataViewSeries.isVisible() || (jCChartStyle = chartDataViewSeries.getStyle()).getSymbolShape() == 0) continue;
                    n2 = Math.max(n2, jCChartStyle.getSymbolSize());
                }
                if (n3 != 0 && n3 != 1) continue;
                for (JCEnvelope jCEnvelope : chartDataView.getEnvelopes()) {
                    if (jCEnvelope == null || (jCChartStyle = jCEnvelope.getChartStyle()).getSymbolShape() == 0) continue;
                    n2 = Math.max(n2, jCChartStyle.getSymbolSize());
                }
            }
        }
        return n2;
    }

    public boolean isDirty() {
        this.ensureDrawables();
        Enumeration<ChartDataView> enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            Iterator<JCAxis> iterator = enumeration.nextElement();
            ChartDraw trackChange = this.drawables.get(iterator);
            if (!trackChange.dataObject.isChanged()) continue;
            return true;
        }
        for (JCAxis jCAxis : this.xaxes) {
            if (!jCAxis.isChanged()) continue;
            return true;
        }
        for (JCAxis jCAxis : this.yaxes) {
            if (!jCAxis.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (n2 == this.getLocation().x && n3 == this.getLocation().y && n4 == this.getSize().width && n5 == this.getSize().height) {
            return;
        }
        this.inSuperReshape = true;
        super.setBounds(n2, n3, n4, n5);
        this.inSuperReshape = false;
        this.changed = true;
        this.changedFlag |= 2;
        this.recalc();
    }

    @Override
    public void repaint() {
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.inSuperReshape) {
            return;
        }
        super.repaint();
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(int n2) {
        this.deltaX = n2;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(int n2) {
        this.deltaY = n2;
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public boolean getHasBar() {
        return this.hasBar;
    }

    public Rectangle getPlotRect() {
        return this.plotRect;
    }

    public Rectangle getChartAreaRect() {
        return this.chartAreaRect;
    }

    public ActionHandler getActionHandler() {
        return this.handler;
    }

    public boolean getInAction() {
        return this.inAction;
    }

    public void setInAction(boolean bl) {
        this.inAction = bl;
    }

    public JCAxis findAxisByName(String string) {
        JCAxis jCAxis = this.findAxisByName(string, true);
        if (jCAxis == null) {
            jCAxis = this.findAxisByName(string, false);
        }
        return jCAxis;
    }

    protected JCAxis findAxisByName(String string, boolean bl) {
        Vector<JCAxis> vector;
        Vector<JCAxis> vector2 = vector = bl ? this.xaxes : this.yaxes;
        if (vector == null) {
            return null;
        }
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            JCAxis jCAxis = (JCAxis)listIterator.next();
            if (jCAxis == null || !string.equals(jCAxis.getName())) continue;
            return jCAxis;
        }
        return null;
    }

    protected void layoutAnnotations(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.layoutAnnotations();
        }
    }

    private void addDrawable(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return;
        }
        if (this.hasMatchingDrawable(chartDataView)) {
            this.removeDrawable(chartDataView);
        }
        ChartDraw chartDraw = ChartDraw.makeDrawObject(chartDataView);
        this.drawables.put(chartDataView, chartDraw);
    }

    protected void removeDrawable(ChartDataView chartDataView) {
        if (this.drawables != null) {
            this.drawables.remove(chartDataView);
        }
    }

    protected void clearDrawables() {
        this.drawables = new Hashtable();
    }

    protected boolean hasMatchingDrawable(ChartDataView chartDataView) {
        if (this.drawables != null && this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw = this.drawables.get(chartDataView);
            if (chartDraw.chartType == chartDraw.dataObject.getChartType()) {
                return true;
            }
        }
        return false;
    }

    public ChartDraw getDrawable(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        if (this.drawables != null && this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw2 = this.drawables.get(chartDataView);
            if (chartDraw2.chartType == chartDraw2.dataObject.getChartType()) {
                chartDraw = chartDraw2;
            }
        }
        return chartDraw;
    }

    protected void calcAnchors(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.calcAnchors();
        }
    }

    protected void calcLimits() {
        this.clearLimits();
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        DataViewIterator dataViewIterator = new DataViewIterator(jCChart, true, false, false, false);
        while (dataViewIterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
            if (!chartDataView.isVisible()) continue;
            chartDataView.calcLimits();
        }
    }

    protected void clearLimits() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        for (ChartDataView chartDataView : jCChart.getOriginalDataView()) {
            if (chartDataView == null) continue;
            chartDataView.clearLimits();
        }
    }

    protected void cancel() {
        this.handler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    protected void reset() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        boolean bl = jCChart.isBatched();
        jCChart.setBatched(true);
        if (this.horizActionAxis != null) {
            this.horizActionAxis.min.isDefault = true;
            this.horizActionAxis.max.isDefault = true;
            this.horizActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.horizActionAxis);
        }
        if (this.vertActionAxis != null) {
            this.vertActionAxis.min.isDefault = true;
            this.vertActionAxis.max.isDefault = true;
            this.vertActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.vertActionAxis);
        }
        this.cancel();
        jCChart.setBatched(bl);
    }

    public void drawRubberBand(Point point, Point point2) {
        int n2;
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n3 = point2.x;
        int n4 = point2.y;
        int n5 = point.x;
        int n6 = point.y;
        if (this.rbGC == null && this.getParent() == null) {
            return;
        }
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics() : this.rbGC.create();
        if (n5 - n3 < 0) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        if (n6 - n4 < 0) {
            n2 = n6;
            n6 = n4;
            n4 = n2;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n3, n4, n5 - n3, n6 - n4);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n3 + 1, n4 + 1, n5 - n3, n6 - n4);
        graphics.dispose();
    }

    public void drawRubberLine(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(Color.white);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setXORMode(Color.black);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
        graphics.dispose();
    }

    protected JCDataIndex pick(Point point, ChartDataView chartDataView, int n2) {
        return this.pickInternal(chartDataView, n2, point, false);
    }

    protected JCDataIndex pickSeries(Point point, ChartDataView chartDataView, int n2) {
        return this.pickInternal(chartDataView, n2, point, true);
    }

    private JCDataIndex pickInternal(ChartDataView chartDataView, int n2, Point point, boolean bl) {
        ChartDraw chartDraw;
        ChartDataView chartDataView2;
        JCDataIndex jCDataIndex = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return null;
        }
        if (chartDataView != null) {
            ChartDraw chartDraw2 = this.getDrawable(chartDataView);
            if (chartDraw2 != null) {
                if (n2 == -1) {
                    n2 = chartDataView.getPickFocus();
                }
                if (n2 != 3) {
                    JCDataIndex jCDataIndex2 = jCDataIndex = bl ? chartDraw2.pickSeries(point, n2) : chartDraw2.pick(point, n2);
                }
            }
            if (jCDataIndex != null) {
                jCDataIndex.obj = this;
                jCDataIndex.dataView = chartDataView;
            }
            return jCDataIndex;
        }
        List<ChartDataView> list = jCChart.getOriginalDataView();
        ListIterator<ChartDataView> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            chartDataView2 = listIterator.previous();
            chartDraw = this.getDrawable(chartDataView2);
            if (chartDraw == null || chartDataView2.is3DChartType() || !chartDraw.drawFront) continue;
            jCDataIndex = this.pickOne(chartDraw, point, n2, jCDataIndex, bl);
        }
        listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            chartDataView2 = listIterator.previous();
            chartDraw = this.getDrawable(chartDataView2);
            if (chartDraw == null || !chartDataView2.is3DChartType()) continue;
            jCDataIndex = this.pickOne(chartDraw, point, n2, jCDataIndex, bl);
        }
        listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            chartDataView2 = listIterator.previous();
            chartDraw = this.getDrawable(chartDataView2);
            if (chartDraw == null || chartDraw.drawFront || chartDataView2.is3DChartType()) continue;
            jCDataIndex = this.pickOne(chartDraw, point, n2, jCDataIndex, bl);
        }
        return jCDataIndex;
    }

    protected JCPickItem pickOneDataViewAxisLabels(ChartDataView chartDataView, Point point) {
        JCPickItem jCPickItem = null;
        if (chartDataView != null) {
            JCAxis jCAxis = chartDataView.getXAxis();
            if (jCAxis != null && jCAxis.isVisible()) {
                jCPickItem = jCAxis.pick(point);
            }
            if (jCPickItem == null && (jCAxis = chartDataView.getYAxis()) != null && jCAxis.isVisible()) {
                jCPickItem = jCAxis.pick(point);
            }
        }
        return jCPickItem;
    }

    protected JCPickItem pickAxisLabels(List<JCAxis> list, Point point) {
        JCPickItem jCPickItem;
        block1: {
            jCPickItem = null;
            if (list == null) break block1;
            for (JCAxis jCAxis : list) {
                if (jCAxis.isVisible() && (jCPickItem = jCAxis.pick(point)) != null) break;
            }
        }
        return jCPickItem;
    }

    protected JCPickItem pickAxisLabels(ChartDataView chartDataView, Point point) {
        if (chartDataView != null) {
            return this.pickOneDataViewAxisLabels(chartDataView, point);
        }
        JCPickItem jCPickItem = this.pickAxisLabels(this.getXAxes(), point);
        if (jCPickItem == null) {
            jCPickItem = this.pickAxisLabels(this.getYAxes(), point);
        }
        return jCPickItem;
    }

    private JCDataIndex pickOne(ChartDraw chartDraw, Point point, int n2, JCDataIndex jCDataIndex, boolean bl) {
        JCDataIndex jCDataIndex2;
        if (n2 == -1) {
            n2 = chartDraw.dataObject.getPickFocus();
        }
        if (n2 == 3) {
            return jCDataIndex;
        }
        JCDataIndex jCDataIndex3 = jCDataIndex2 = bl ? chartDraw.pickSeries(point, n2) : chartDraw.pick(point, n2);
        if (jCDataIndex2 != null) {
            jCDataIndex2.obj = this;
            jCDataIndex2.dataView = chartDraw.dataObject;
        }
        if (jCDataIndex == null) {
            jCDataIndex = jCDataIndex2;
        } else if (jCDataIndex2 != null && jCDataIndex.distance > jCDataIndex2.distance) {
            jCDataIndex = jCDataIndex2;
        }
        return jCDataIndex;
    }

    protected JCPickItem pickThreshold(ChartDataView chartDataView, Point point) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || point == null) {
            return null;
        }
        if (chartDataView != null) {
            return this.pickOneThreshold(chartDataView, point);
        }
        List<ChartDataView> list = jCChart.getOriginalDataView();
        ListIterator<ChartDataView> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            ChartDataView chartDataView2 = listIterator.previous();
            JCPickItem jCPickItem = this.pickOneThreshold(chartDataView2, point);
            if (jCPickItem == null) continue;
            return jCPickItem;
        }
        return null;
    }

    protected JCPickItem pickMarker(ChartDataView chartDataView, Point point, boolean bl) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || point == null) {
            return null;
        }
        if (chartDataView != null) {
            return this.pickOneMarker(chartDataView, point, bl);
        }
        JCPickItem jCPickItem = null;
        int n2 = Integer.MAX_VALUE;
        List<ChartDataView> list = jCChart.getOriginalDataView();
        ListIterator<ChartDataView> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            ChartDataView chartDataView2 = listIterator.previous();
            JCPickItem jCPickItem2 = this.pickOneMarker(chartDataView2, point, bl);
            if (jCPickItem2 == null || jCPickItem2.getDistance() >= n2) continue;
            n2 = jCPickItem2.getDistance();
            jCPickItem = jCPickItem2;
        }
        return jCPickItem;
    }

    protected JCPickItem pickEnvelope(ChartDataView chartDataView, Point point) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || point == null) {
            return null;
        }
        if (chartDataView != null) {
            return this.pickOneEnvelope(chartDataView, point);
        }
        List<ChartDataView> list = jCChart.getOriginalDataView();
        ListIterator<ChartDataView> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            ChartDataView chartDataView2 = listIterator.previous();
            JCPickItem jCPickItem = this.pickOneEnvelope(chartDataView2, point);
            if (jCPickItem == null) continue;
            return jCPickItem;
        }
        return null;
    }

    protected JCPickItem pickOneThreshold(ChartDataView chartDataView, Point point) {
        if (chartDataView != null) {
            List<JCThreshold> list = chartDataView.getThresholds();
            ListIterator<JCThreshold> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                JCPickItem jCPickItem;
                JCThreshold jCThreshold = listIterator.previous();
                if (jCThreshold == null || (jCPickItem = jCThreshold.pick(point)) == null) continue;
                return jCPickItem;
            }
        }
        return null;
    }

    protected JCPickItem pickOneMarker(ChartDataView chartDataView, Point point, boolean bl) {
        JCPickItem jCPickItem = null;
        if (chartDataView != null) {
            int n2 = Integer.MAX_VALUE;
            List<JCMarker> list = chartDataView.getMarkers();
            ListIterator<JCMarker> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                JCPickItem jCPickItem2;
                JCMarker jCMarker = listIterator.previous();
                if (jCMarker == null || jCMarker.drawnBeforeData != bl || (jCPickItem2 = jCMarker.pick(point)) == null || jCPickItem2.getDistance() >= n2) continue;
                n2 = jCPickItem2.getDistance();
                jCPickItem = jCPickItem2;
            }
        }
        return jCPickItem;
    }

    protected JCPickItem pickOneEnvelope(ChartDataView chartDataView, Point point) {
        if (chartDataView != null) {
            int n2 = chartDataView.getChartType();
            if (n2 != 0 && n2 != 1) {
                return null;
            }
            List<JCEnvelope> list = chartDataView.getEnvelopes();
            ListIterator<JCEnvelope> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                JCPickItem jCPickItem;
                JCEnvelope jCEnvelope = listIterator.previous();
                if (jCEnvelope == null || (jCPickItem = jCEnvelope.pick(point)) == null) continue;
                return jCPickItem;
            }
        }
        return null;
    }

    boolean isXAxis(JCAxis jCAxis) {
        return this.xaxes.contains(jCAxis);
    }

    private void getHorizVertAxes(List<JCAxis> list, List<JCAxis> list2) {
        for (JCAxis jCAxis : this.xaxes) {
            if (jCAxis.i_vertical) {
                list2.add(jCAxis);
                continue;
            }
            list.add(jCAxis);
        }
        for (JCAxis jCAxis : this.yaxes) {
            if (jCAxis.i_vertical) {
                list2.add(jCAxis);
                continue;
            }
            list.add(jCAxis);
        }
    }

    protected double getAngleFromXValue(ChartDataView chartDataView, double d2, boolean bl, int n2) {
        double d3;
        if (chartDataView == null) {
            return d2;
        }
        JCAxis jCAxis = chartDataView.getXAxis();
        if (bl) {
            int n3 = ChartDataView.getNumRadarSpokes(chartDataView);
            d3 = JCChartUtil.getRadarAngle(n2, n3, d2, jCAxis.isReversed());
        } else {
            double d4 = jCAxis.isReversed() ? -1.0 : 1.0;
            d3 = JCChartUtil.convertAngle(this.getAngleUnit(), n2, d4 * d2);
        }
        return d3 += jCAxis.getOriginBase(n2);
    }

    protected void drawCircularBoundingLine(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || graphics == null || jCLineStyle == null) {
            return;
        }
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView == null) {
            return;
        }
        JCAxis jCAxis = chartDataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d3 = Math.round(polarAxisParams.radius);
        if (d2 < 0.0 || d2 > d3) {
            throw new IllegalArgumentException("Bounding line radius must be between 0 and the plot area radius=" + d3);
        }
        jCLineStyle.drawCircle(graphics, (int)Math.round(polarAxisParams.xCenter), (int)Math.round(polarAxisParams.yCenter), (int)d2);
    }

    protected void drawWebBoundingLine(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || graphics == null || jCLineStyle == null) {
            return;
        }
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView == null) {
            return;
        }
        JCAxis jCAxis = chartDataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        double d3 = Math.rint(jCAxis.polarAxisParams.radius);
        if (d2 < 0.0 || d2 > d3) {
            throw new IllegalArgumentException("Bounding line radius must be between 0 and the plot area radius=" + d3);
        }
        jCAxis.drawWebLine(graphics, jCLineStyle, d2, ChartDataView.getNumRadarSpokes(chartDataView));
    }

    protected void fillWebRegion(Graphics graphics, JCFillStyle jCFillStyle, double d2) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null || graphics == null || jCFillStyle == null) {
            return;
        }
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView == null) {
            return;
        }
        JCAxis jCAxis = chartDataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        double d3 = Math.rint(jCAxis.polarAxisParams.radius);
        if (d2 < 0.0 || d2 > d3) {
            throw new IllegalArgumentException("Web region radius must be between 0 and the plot area radius=" + d3);
        }
        int n2 = ChartDataView.getNumRadarSpokes(chartDataView);
        double d4 = JCChartUtil.getRadarAngle(2, n2, 1, false);
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point point = jCAxis.toPixelPolar(d4 * (double)i2, d2, false);
            polygon.addPoint(point.x, point.y);
        }
        jCFillStyle.fillPolygon(graphics, polygon);
    }

    private void drawThresholds(Graphics graphics, JCChart jCChart, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        DataViewIterator dataViewIterator = new DataViewIterator(jCChart, true, false, false, false);
        while (dataViewIterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
            chartDataView.drawThresholds(graphics, bl, bl2, bl3, this.backplane, bl4);
        }
    }

    private void drawEnvelopes(Graphics graphics, JCChart jCChart) {
        DataViewIterator dataViewIterator = new DataViewIterator(jCChart, true, false, false, false);
        while (dataViewIterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
            chartDataView.drawEnvelopes(graphics, false);
        }
    }

    private void drawMarkers(Graphics graphics, JCChart jCChart, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = bl2 && this.isWebbedRadarChart();
        DataViewIterator dataViewIterator = new DataViewIterator(jCChart, true, false, false, false);
        while (dataViewIterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)dataViewIterator.next();
            chartDataView.drawMarkers(graphics, bl, bl2, bl4, bl3);
        }
    }

    private boolean isWebbedRadarChart() {
        JCAxis jCAxis;
        boolean bl = false;
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        JCAxis jCAxis2 = jCAxis = chartDataView == null ? null : chartDataView.getXAxis();
        if (jCAxis != null) {
            bl = this.isWebShaped(jCAxis);
        }
        return bl;
    }

    private void drawBackplane(Graphics graphics) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        ChartDataView chartDataView = this.getFirstVisibleDataView();
        if (chartDataView != null && chartDataView.getChartType() == 11) {
            return;
        }
        JCFillStyle jCFillStyle = null;
        if (this.isOpaque() && this.plotArea.getOpaqueIsDefault() && this.plotArea.isOpaque()) {
            jCFillStyle = new JCFillStyle(this.plotArea.getBackground(), 1);
        }
        int n2 = this.plotRect.x;
        int n3 = this.plotRect.y;
        int n4 = this.plotRect.width;
        int n5 = this.plotRect.height;
        int n6 = chartDataView == null ? -1 : chartDataView.getChartType();
        boolean bl = n6 == 2;
        boolean bl2 = n6 == 3 || n6 == 4;
        JCAxis jCAxis = chartDataView == null ? null : chartDataView.getXAxis();
        boolean bl3 = false;
        if ((bl || bl2) && jCAxis != null) {
            bl3 = jCAxis.polarAxisParams.isCircularGrid();
        }
        if (bl || bl2 && bl3) {
            if (jCAxis != null) {
                PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
                if (jCFillStyle != null) {
                    int n7 = (int)Math.round(polarAxisParams.xCenter);
                    int n8 = (int)Math.round(polarAxisParams.yCenter);
                    int n9 = (int)Math.round(polarAxisParams.radius);
                    jCFillStyle.fillCircle(graphics, n7, n8, n9);
                }
                this.drawThresholds(graphics, jCChart, false, bl2, false, false);
                if (this.axisBoundingBox && (bl2 || bl && !jCAxis.isVisible())) {
                    Color color = this.plotArea.getForeground();
                    JCLineStyle jCLineStyle = new JCLineStyle(1, color, 1);
                    this.drawCircularBoundingLine(graphics, jCLineStyle, Math.round(polarAxisParams.radius));
                }
            }
        } else if (bl2 && !bl3) {
            if (jCAxis != null) {
                PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
                if (jCFillStyle != null) {
                    this.fillWebRegion(graphics, jCFillStyle, Math.rint(polarAxisParams.radius));
                }
                this.drawThresholds(graphics, jCChart, false, bl2, true, false);
                if (this.axisBoundingBox) {
                    Color color = this.plotArea.getForeground();
                    JCLineStyle jCLineStyle = new JCLineStyle(1, color, 1);
                    graphics.setColor(color);
                    this.drawWebBoundingLine(graphics, jCLineStyle, Math.rint(polarAxisParams.radius));
                }
            }
        } else if ((this.draw3D || this.axisBoundingBox) && !this.pieFirst) {
            if (this.draw3D && this.deltaX > 0) {
                n2 += this.deltaX;
            }
            if (this.draw3D && this.deltaY > 0) {
                n3 += this.deltaY;
            }
            int n10 = this.draw3D ? JCChartUtil.abs(this.deltaX) : 0;
            int n11 = this.draw3D ? JCChartUtil.abs(this.deltaY) : 0;
            n4 = Math.max(0, n4 - n10);
            n5 = Math.max(0, n5 - n11);
            if (jCFillStyle != null) {
                jCFillStyle.fillRect(graphics, n2, n3, n4, n5);
            }
            this.backplane = new Rectangle(n2, n3, n4, n5);
            this.drawThresholds(graphics, jCChart, true, bl2, false, false);
            this.drawEnvelopes(graphics, jCChart);
            if (this.axisBoundingBox) {
                graphics.setColor(this.plotArea.getForeground());
                graphics.drawRect(n2, n3, n4, n5);
            }
        } else {
            if (jCFillStyle != null) {
                jCFillStyle.fillRect(graphics, n2, n3, n4 + 1, n5 + 1);
            }
            this.backplane = new Rectangle(n2, n3, n4, n5);
            this.drawThresholds(graphics, jCChart, true, bl2, false, false);
            this.drawEnvelopes(graphics, jCChart);
        }
    }

    private boolean isCircularChartAxisOnly(JCAxis jCAxis) {
        boolean bl = true;
        Iterator<ChartDataView> iterator = this.getDataViews();
        if (iterator != null) {
            boolean bl2 = false;
            while (iterator.hasNext()) {
                ChartDataView chartDataView = iterator.next();
                if (chartDataView == null || chartDataView.xaxis != jCAxis && chartDataView.yaxis != jCAxis) continue;
                int n2 = chartDataView.getChartType();
                if (n2 != 11 && n2 != 2 && n2 != 3 && n2 != 4) {
                    bl = false;
                    break;
                }
                bl2 = true;
            }
            if (!bl2) {
                return false;
            }
        }
        return bl && iterator != null;
    }

    private void drawAxes(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolar();
        for (JCAxis jCAxis : list) {
            if (bl && !jCAxis.isPolar() || this.isCircularChartAxisOnly(jCAxis) || !jCAxis.isVisible()) continue;
            jCAxis.draw(graphics);
        }
    }

    private void drawAxes(Graphics graphics, ChartDataView chartDataView) {
        if (chartDataView == null || !chartDataView.isVisible()) {
            return;
        }
        JCAxis jCAxis = chartDataView.xaxis;
        if (jCAxis != null && jCAxis.isVisible()) {
            jCAxis.draw(graphics);
        }
        if ((jCAxis = chartDataView.yaxis) != null && jCAxis.isVisible()) {
            jCAxis.draw(graphics);
        }
    }

    private void drawBpAxes(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!jCAxis.visible || jCAxis.isBar()) continue;
            jCAxis.draw(graphics);
        }
    }

    private void drawFpAxes(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!jCAxis.visible || !jCAxis.isBar()) continue;
            jCAxis.draw(graphics);
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolar();
        for (JCAxis jCAxis : list) {
            if (bl && !jCAxis.isPolar() || this.isCircularChartAxisOnly(jCAxis) || !jCAxis.visible) continue;
            jCAxis.drawAnnotationsAndTitle(graphics);
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics graphics, ChartDataView chartDataView) {
        if (chartDataView == null || !chartDataView.isVisible()) {
            return;
        }
        JCAxis jCAxis = chartDataView.xaxis;
        if (jCAxis != null && jCAxis.isVisible()) {
            jCAxis.drawAnnotationsAndTitle(graphics);
        }
        if ((jCAxis = chartDataView.yaxis) != null && jCAxis.isVisible()) {
            jCAxis.drawAnnotationsAndTitle(graphics);
        }
    }

    private void drawBpAxisAnnotationsAndTitle(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!jCAxis.visible || jCAxis.isBar()) continue;
            jCAxis.drawAnnotationsAndTitle(graphics);
        }
    }

    private void drawFpAxisAnnotationsAndTitle(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!jCAxis.visible || !jCAxis.isBar()) continue;
            jCAxis.drawAnnotationsAndTitle(graphics);
        }
    }

    private void preDraw3DAxes(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2) {
        if (jCAxis == null || jCAxis2 == null) {
            return;
        }
        boolean bl = jCAxis.i_vertical;
        int n2 = jCAxis.getPlacement();
        int n3 = jCAxis2.getPlacement();
        if (n2 == 5) {
            if (jCAxis2.getOrigin() == jCAxis2.getMax()) {
                n2 = 2;
            } else if (jCAxis2.getOrigin() == jCAxis2.getMin()) {
                n2 = 1;
            }
        } else if (n2 == 4) {
            if (jCAxis.getPlacementLocation() == jCAxis2.getMax()) {
                n2 = 2;
            } else if (jCAxis.getPlacementLocation() == jCAxis2.getMin()) {
                n2 = 1;
            }
        }
        if (n3 == 5) {
            if (jCAxis.getOrigin() == jCAxis.getMax()) {
                n3 = 2;
            } else if (jCAxis.getOrigin() == jCAxis.getMin()) {
                n3 = 1;
            }
        } else if (n3 == 4) {
            if (jCAxis2.getPlacementLocation() == jCAxis.getMax()) {
                n3 = 2;
            } else if (jCAxis2.getPlacementLocation() == jCAxis.getMin()) {
                n3 = 1;
            }
        }
        if (jCAxis.isReversed()) {
            if (n3 == 1) {
                n3 = 2;
            } else if (n3 == 2) {
                n3 = 1;
            }
        }
        if (jCAxis2.isReversed()) {
            if (n2 == 1) {
                n2 = 2;
            } else if (n2 == 2) {
                n2 = 1;
            }
        }
        if (jCAxis.visible) {
            jCAxis.preDrawCalc();
        }
        if (jCAxis2.visible) {
            jCAxis2.preDrawCalc();
        }
        if (this.deltaX >= 0 && this.deltaY < 0) {
            if (n3 != 1 && n3 != 2 && n2 != 1 && n2 != 2) {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, false, true);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, false, false);
                }
            } else if (n3 == 2 || n3 != 2 && n3 != 1 && (bl ? n2 == 1 : n2 != 2)) {
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
            } else {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
            }
        } else if (this.deltaX < 0 && this.deltaY >= 0) {
            if (n3 != 1 && n3 != 2 && n2 != 1 && n2 != 2) {
                if (jCAxis2.visible) {
                    jCAxis.preDraw(graphics, false, false);
                }
                if (jCAxis.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis.preDraw(graphics, false, true);
                }
            } else if (n3 == 1 || n3 != 2 && n3 != 1 && (bl ? n2 != 1 : n2 == 2)) {
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
            } else {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
            }
        } else {
            if (jCAxis.visible) {
                jCAxis.preDraw(graphics, true, false);
            }
            if (jCAxis2.visible) {
                jCAxis2.preDraw(graphics, true, false);
            }
        }
    }

    private void preDrawGrids(Graphics graphics, List<JCAxis> list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolar();
        for (JCAxis jCAxis : list) {
            if (bl && !jCAxis.isPolar() || this.isCircularChartAxisOnly(jCAxis) || !jCAxis.visible && !jCAxis.showGridLinesOnInvisibleAxis) continue;
            jCAxis.drawGrid(graphics);
        }
    }

    private void preDrawGrids(Graphics graphics, ChartDataView chartDataView) {
        if (chartDataView == null || !chartDataView.isVisible()) {
            return;
        }
        JCAxis jCAxis = chartDataView.xaxis;
        if (jCAxis != null && jCAxis.isGridVisible()) {
            jCAxis.drawGrid(graphics);
        }
        if ((jCAxis = chartDataView.yaxis) != null && jCAxis.isGridVisible()) {
            jCAxis.drawGrid(graphics);
        }
    }

    private void adjustPlotRectForAxes(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        boolean bl = false;
        for (JCAxis jCAxis : list) {
            if (!jCAxis.visible) continue;
            bl = true;
            break;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JCAxis jCAxis = list.get(i2);
            if (bl && !jCAxis.visible || !bl && i2 > 0 || this.pieFirst || this.radarFirst || this.isCircularChartAxisOnly(jCAxis)) continue;
            if (jCAxis.i_vertical) {
                if (jCAxis.annoHandler.extents.ortho > jCAxis.getWidth()) {
                    jCAxis.setSize(jCAxis.annoHandler.extents.ortho, jCAxis.getHeight());
                }
                if (jCAxis.isLeftSide()) {
                    if (this.draw3D) {
                        n2 = Math.max(n2, jCAxis.getWidth());
                        continue;
                    }
                    n2 += jCAxis.getWidth();
                    continue;
                }
                if (!jCAxis.isRightSide()) continue;
                if (this.draw3D) {
                    n3 = Math.max(n3, jCAxis.getWidth());
                    continue;
                }
                n3 += jCAxis.getWidth();
                continue;
            }
            if (jCAxis.annoHandler.extents.ortho > jCAxis.getHeight()) {
                jCAxis.setSize(jCAxis.getWidth(), jCAxis.annoHandler.extents.ortho);
            }
            if (jCAxis.isTopSide()) {
                if (this.draw3D) {
                    n4 = Math.max(n4, jCAxis.getHeight());
                    continue;
                }
                n4 += jCAxis.getHeight();
                continue;
            }
            if (!jCAxis.isBottomSide()) continue;
            if (this.draw3D) {
                n5 = Math.max(n5, jCAxis.getHeight());
                continue;
            }
            n5 += jCAxis.getHeight();
        }
        PlotArea plotArea = this.getPlotArea();
        if (!plotArea.getLeftIsDefault()) {
            this.plotRect.x = plotArea.getLeft();
        }
        if (!plotArea.getTopIsDefault()) {
            this.plotRect.y = plotArea.getTop();
        }
        int n6 = this.plotRect.x;
        int n7 = plotArea.getRightIsDefault() ? this.plotRect.x + this.plotRect.width : this.chartAreaRect.width - plotArea.getRight();
        int n8 = this.plotRect.y;
        int n9 = plotArea.getBottomIsDefault() ? this.plotRect.y + this.plotRect.height : this.chartAreaRect.height - plotArea.getBottom();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            JCAxis jCAxis = list.get(i3);
            if (bl && !jCAxis.visible || !bl && i3 > 0 || this.pieFirst || this.radarFirst || this.isCircularChartAxisOnly(jCAxis)) continue;
            if (jCAxis.i_vertical) {
                if (jCAxis.isLeftSide()) {
                    if (plotArea.getLeftIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.setLocation(n6 + n2 - jCAxis.getWidth(), jCAxis.getTop());
                            continue;
                        }
                        jCAxis.setLocation(n6, jCAxis.getTop());
                        n6 += jCAxis.getWidth();
                        continue;
                    }
                    if (this.draw3D) {
                        jCAxis.setLocation(n6 - jCAxis.getWidth(), jCAxis.getTop());
                        continue;
                    }
                    jCAxis.setLocation(n6 - n2, jCAxis.getTop());
                    n6 += jCAxis.getWidth();
                    continue;
                }
                if (!jCAxis.isRightSide()) continue;
                if (plotArea.getRightIsDefault()) {
                    if (this.draw3D) {
                        jCAxis.setLocation(n7 - n3, jCAxis.getTop());
                        continue;
                    }
                    jCAxis.setLocation(n7 - n3, jCAxis.getTop());
                    n7 += jCAxis.getWidth();
                    continue;
                }
                if (this.draw3D) {
                    jCAxis.setLocation(n7, jCAxis.getTop());
                    continue;
                }
                jCAxis.setLocation(n7, jCAxis.getTop());
                n7 += jCAxis.getWidth();
                continue;
            }
            if (jCAxis.isTopSide()) {
                if (plotArea.getTopIsDefault()) {
                    if (this.draw3D) {
                        jCAxis.setLocation(jCAxis.getLeft(), n8 + n4 - jCAxis.getHeight());
                        continue;
                    }
                    jCAxis.setLocation(jCAxis.getLeft(), n8);
                    n8 += jCAxis.getHeight();
                    continue;
                }
                if (this.draw3D) {
                    jCAxis.setLocation(jCAxis.getLeft(), n8 - jCAxis.getHeight());
                    continue;
                }
                jCAxis.setLocation(jCAxis.getLeft(), n8 - n4);
                n8 += jCAxis.getHeight();
                continue;
            }
            if (!jCAxis.isBottomSide()) continue;
            if (plotArea.getBottomIsDefault()) {
                if (this.draw3D) {
                    jCAxis.setLocation(jCAxis.getLeft(), n9 - n5);
                    continue;
                }
                jCAxis.setLocation(jCAxis.getLeft(), n9 - n5);
                n9 += jCAxis.getHeight();
                continue;
            }
            if (this.draw3D) {
                jCAxis.setLocation(jCAxis.getLeft(), n9);
                continue;
            }
            jCAxis.setLocation(jCAxis.getLeft(), n9);
            n9 += jCAxis.getHeight();
        }
        if (plotArea.getLeftIsDefault()) {
            this.plotRect.x += n2;
            this.plotRect.width -= n2;
        }
        if (plotArea.getRightIsDefault()) {
            this.plotRect.width -= n3;
        }
        if (plotArea.getTopIsDefault()) {
            this.plotRect.y += n4;
            this.plotRect.height -= n4;
        }
        if (plotArea.getBottomIsDefault()) {
            this.plotRect.height -= n5;
        }
    }

    private void adjustForSymbols(List<JCAxis> list, List<JCAxis> list2) {
        int n2;
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        PlotArea plotArea = this.getPlotArea();
        if (plotArea.getLeftIsDefault() && (n2 = this.symbolPad - Math.max(this.plotRect.x - this.chartAreaRect.x + insets.left, 0)) > 0) {
            this.plotRect.x += n2;
            this.plotRect.width -= n2;
            this.adjust(list, n2, 0, -n2, 0);
            this.adjust(list2, n2, 0, 0, 0, 1);
        }
        if (plotArea.getRightIsDefault() && (n2 = this.symbolPad - (this.chartAreaRect.x + this.chartAreaRect.width - insets.right - this.plotRect.x - this.plotRect.width)) > 0) {
            this.plotRect.width -= n2;
            this.adjust(list, 0, 0, -n2, 0);
            this.adjust(list2, -n2, 0, 0, 0, 2);
        }
        if (plotArea.getTopIsDefault() && (n2 = this.symbolPad - Math.max(this.plotRect.y - this.chartAreaRect.y + insets.top, 0)) > 0) {
            this.plotRect.y += n2;
            this.plotRect.height -= n2;
            this.adjust(list2, 0, n2, 0, -n2);
            this.adjust(list, 0, n2, 0, 0, 2);
        }
        if (plotArea.getBottomIsDefault() && (n2 = this.symbolPad - (this.chartAreaRect.y + this.chartAreaRect.height - insets.bottom - this.plotRect.y - this.plotRect.height)) > 0) {
            this.plotRect.height -= n2;
            this.adjust(list2, 0, -n2, 0, -n2);
            this.adjust(list, 0, -n2, 0, 0, 1);
        }
    }

    private boolean inFirstVisibleDataView(JCAxis jCAxis) {
        JCChart jCChart = (JCChart)this.getParent();
        Iterator<ChartDataView> iterator = jCChart.getOriginalDataView().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ChartDataView chartDataView = iterator.next();
                if (chartDataView == null || !chartDataView.isVisible()) continue;
                return jCAxis == chartDataView.getXAxis() || jCAxis == chartDataView.getYAxis();
            }
        }
        return false;
    }

    private void layoutAxes(List<JCAxis> list, boolean bl) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!this.inFirstVisibleDataView(jCAxis) && (jCAxis.isPolar() || jCAxis.isRadar())) continue;
            jCAxis.layoutAxis(bl);
        }
    }

    private void layoutOrigins(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (!this.inFirstVisibleDataView(jCAxis) && (jCAxis.isPolar() || jCAxis.isRadar())) continue;
            jCAxis.layoutOrigin();
        }
    }

    private void checkAnnotations(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            jCAxis.checkAnnotations();
        }
    }

    protected void ensureDrawables() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new Hashtable();
        }
        this.axisDrawOkay = true;
        this.pieFirst = false;
        this.polarFirst = false;
        this.radarFirst = false;
        int n2 = 0;
        for (ChartDataView chartDataView : jCChart.getOriginalDataView()) {
            if (chartDataView.isVisible() && ++n2 == 1) {
                if (chartDataView.getChartType() == 11) {
                    this.pieFirst = true;
                    this.axisDrawOkay = false;
                } else if (chartDataView.getChartType() == 2) {
                    this.polarFirst = true;
                } else if (chartDataView.getChartType() == 3 || chartDataView.getChartType() == 4) {
                    this.radarFirst = true;
                }
            }
            if (!this.hasMatchingDrawable(chartDataView) && chartDataView.isVisible()) {
                this.addDrawable(chartDataView);
                continue;
            }
            if (!this.hasMatchingDrawable(chartDataView) || chartDataView.isVisible()) continue;
            this.removeDrawable(chartDataView);
        }
    }

    private void calcAxisParams(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        boolean bl = false;
        for (JCAxis jCAxis : list) {
            if (jCAxis.formula != null) {
                bl = true;
            }
            jCAxis.calcAxisParams(true);
        }
        if (!bl) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis.formula == null) continue;
            jCAxis.formula.calcRelatedParams();
        }
    }

    private void makeAnnotations(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            jCAxis.makeAnnotations();
        }
    }

    private void calcAnnotationExtents(List<JCAxis> list, boolean bl) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            boolean bl2 = bl;
            if (bl) {
                int n2 = jCAxis.getAnnotationMethod();
                bl2 = (n2 == 3 || n2 == 1) && !jCAxis.isPolarRadar();
            }
            jCAxis.calcAnnotationExtents(bl2);
        }
    }

    private void updateAnnotationsAndGrids(List<JCAxis> list) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (jCAxis == null) continue;
            jCAxis.updateAnnotations();
            jCAxis.updateGrids();
        }
    }

    private void calcGraphExtents() {
        if (this.drawables == null) {
            return;
        }
        if (this.pieFirst) {
            Enumeration<ChartDataView> enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = enumeration.nextElement();
                if (chartDataView.getChartType() != 11) continue;
                ChartDraw chartDraw = this.drawables.get(chartDataView);
                chartDraw.recalc();
                break;
            }
        } else if (this.radarFirst) {
            Enumeration<ChartDataView> enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = enumeration.nextElement();
                int n2 = chartDataView.getChartType();
                if (n2 != 3 && n2 != 4) continue;
                ChartDraw chartDraw = this.drawables.get(chartDataView);
                chartDraw.recalc();
                break;
            }
        } else if (this.polarFirst) {
            Enumeration<ChartDataView> enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = enumeration.nextElement();
                int n3 = chartDataView.getChartType();
                if (n3 != 2) continue;
                ChartDraw chartDraw = this.drawables.get(chartDataView);
                chartDraw.recalc();
            }
        } else {
            Enumeration<ChartDataView> enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = enumeration.nextElement();
                int n4 = chartDataView.getChartType();
                if (n4 == 11 || n4 == 2 || n4 == 3 || n4 == 4) continue;
                ChartDraw chartDraw = this.drawables.get(chartDataView);
                chartDraw.recalc();
            }
        }
    }

    private void adjustForExtents(List<JCAxis> list, List<JCAxis> list2) {
        Extents extents = new Extents();
        Extents extents2 = new Extents();
        this.findMaxExtents(list, extents);
        this.findMaxExtents(list2, extents2);
        int n2 = extents.minor - this.plotRect.x;
        if (n2 > 0 && this.plotArea.left.isDefault) {
            if (n2 > this.plotRect.width) {
                n2 = this.plotRect.width;
            }
            this.plotRect.width -= n2;
            this.plotRect.x += n2;
            this.adjust(list, n2, 0, -n2, 0);
            this.adjust(list2, n2, 0, 0, 0, 1);
        }
        if ((n2 = extents.major - (this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0 && this.plotArea.right.isDefault) {
            if (n2 > this.plotRect.width) {
                n2 = this.plotRect.width;
            }
            this.plotRect.width -= n2;
            this.adjust(list, 0, 0, -n2, 0);
            this.adjust(list2, -n2, 0, 0, 0, 2);
        }
        if ((n2 = extents2.major - (this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0 && this.plotArea.bottom.isDefault) {
            if (n2 > this.plotRect.height) {
                n2 = this.plotRect.height;
            }
            this.plotRect.height -= n2;
            this.adjust(list2, 0, 0, 0, -n2);
            this.adjust(list, 0, -n2, 0, 0, 1);
        }
        if ((n2 = extents2.minor - this.plotRect.y) > 0 && this.plotArea.top.isDefault) {
            if (n2 > this.plotRect.height) {
                n2 = this.plotRect.height;
            }
            this.plotRect.y += n2;
            this.plotRect.height -= n2;
            this.adjust(list2, 0, n2, 0, -n2);
            this.adjust(list, 0, n2, 0, 0, 2);
        }
    }

    private void adjustForOrthoExtents(List<JCAxis> list, List<JCAxis> list2) {
        Rectangle rectangle = new Rectangle(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        for (JCAxis jCAxis : list) {
            jCAxis.adjustForOrthoExtent();
        }
        for (JCAxis jCAxis : list2) {
            jCAxis.adjustForOrthoExtent();
        }
        if (this.plotRect.equals(rectangle)) {
            return;
        }
        this.adjust(list2, 0, this.plotRect.y - rectangle.y, 0, this.plotRect.height - rectangle.height);
        this.adjust(list, this.plotRect.x - rectangle.x, 0, this.plotRect.width - rectangle.width, 0);
        this.layoutOrigins(list);
        this.layoutOrigins(list2);
    }

    private void findMaxExtents(List<JCAxis> list, Extents extents) {
        if (list == null) {
            return;
        }
        for (JCAxis jCAxis : list) {
            Extents extents2 = jCAxis.getExtents();
            if (extents2 == null) continue;
            if (extents2.major > extents.major) {
                extents.major = extents2.major;
            }
            if (extents2.minor > extents.minor) {
                extents.minor = extents2.minor;
            }
            if (extents2.ortho <= extents.ortho) continue;
            extents.ortho = extents2.ortho;
        }
    }

    private void adjust(List<JCAxis> list, int n2, int n3, int n4, int n5) {
        this.adjust(list, n2, n3, n4, n5, 0);
    }

    private void adjust(List<JCAxis> list, int n2, int n3, int n4, int n5, int n6) {
        if (list == null) {
            return;
        }
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            return;
        }
        for (JCAxis jCAxis : list) {
            if (n6 != 0 && n6 != jCAxis.getAdjustedRealPlacement()) continue;
            int n7 = jCAxis.getLeft() + n2;
            int n8 = jCAxis.getTop() + n3;
            int n9 = jCAxis.getWidth() + n4;
            int n10 = jCAxis.getHeight() + n5;
            jCAxis.setBounds(n7, n8, n9, n10);
        }
    }

    private void calc3D() {
        List<ChartDataView> list;
        double d2 = JCChartUtil.degToRad(this.rotation);
        double d3 = JCChartUtil.degToRad(this.elevation);
        double d4 = Math.sin(d2);
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = (double)this.depth / 100.0;
        double d8 = JCChartUtil.max(1.0, this.getSize().width);
        double d9 = (d8 /= 1.0 + JCChartUtil.abs(d4) * d6 * d7) * d7;
        this.deltaX = (int)(d9 * d4 * d6);
        this.deltaY = (int)(-d9 * d5);
        this.checkDeltaValues();
        boolean bl = true;
        boolean bl2 = true;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (list = jCChart.getDataView()) != null) {
            for (ChartDataView chartDataView : list) {
                if (!chartDataView.isVisible()) continue;
                int n2 = chartDataView.getChartType();
                if (n2 != 0 && n2 != 1 && n2 != 12 && n2 != 8 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 2 && n2 != 3 && n2 != 4 && (n2 != 11 || bl2)) {
                    bl = false;
                    break;
                }
                if (!bl2) continue;
                bl2 = false;
            }
        }
        boolean bl3 = this.deltaX != 0 || this.deltaY != 0;
        this.hasBar = !bl;
        this.draw3D = !bl && bl3;
    }

    private boolean checkDeltaValues() {
        boolean bl = false;
        if (this.plotRect.width <= 0 || this.plotRect.height <= 0) {
            return bl;
        }
        int n2 = this.plotRect.width;
        if (Math.abs(this.deltaX) > n2) {
            this.deltaX = this.deltaX < 0 ? -n2 : n2;
            bl = true;
        }
        n2 = this.plotRect.height;
        if (Math.abs(this.deltaY) > n2) {
            this.deltaY = this.deltaY < 0 ? -n2 : n2;
            bl = true;
        }
        return bl;
    }

    protected Rectangle clipToEntirePlotRect() {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.axisBoundingBox && !this.draw3D && !this.fillOverAxisBoundingBox) {
            n5 = this.plotRect.x + 1;
            n4 = this.plotRect.y + 1;
            n3 = this.plotRect.width - 1;
            n2 = this.plotRect.height - 1;
        } else {
            n5 = this.plotRect.x;
            n4 = this.plotRect.y;
            n3 = this.plotRect.width + 1;
            n2 = this.plotRect.height + 1;
        }
        n5 = Math.max(0, n5);
        n4 = Math.max(0, n4);
        n3 = Math.min(n3, this.chartAreaRect.width - n5);
        n2 = Math.min(n2, this.chartAreaRect.height - n4);
        return new Rectangle(n5, n4, n3, n2);
    }

    protected Rectangle clipForDrawing(int n2) {
        int n3 = n2 * 2;
        int n4 = Math.max(0, this.plotRect.x - n3 / 2);
        int n5 = Math.max(0, this.plotRect.y - n3 / 2);
        int n6 = Math.min(this.plotRect.width + 1 + n3, this.chartAreaRect.width - n4);
        int n7 = Math.min(this.plotRect.height + 1 + n3, this.chartAreaRect.height - n5);
        return new Rectangle(n4, n5, n6, n7);
    }

    private void resetPlotArea() {
        this.chartAreaRect = this.getDrawingArea();
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = 0;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = 0;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = 0;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = 0;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }
}

