/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ErrorLog;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisFormula;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartEvent;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartLabelLine;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCChartLegendManager;
import com.klg.jclass.chart.JCChartListener;
import com.klg.jclass.chart.JCChartUI;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCCustomizerPage;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCEnvelope;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCMarker;
import com.klg.jclass.chart.JCPickEvent;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.JCPickItemEvent;
import com.klg.jclass.chart.JCPickItemListener;
import com.klg.jclass.chart.JCPickListener;
import com.klg.jclass.chart.JCPickSeriesListener;
import com.klg.jclass.chart.JCVersion;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.chart.PieChartDraw;
import com.klg.jclass.chart.PlotPriorityLayout;
import com.klg.jclass.chart.TrackChange;
import com.klg.jclass.chart.model.DataModel;
import com.klg.jclass.chart.model.DataPointException;
import com.klg.jclass.chart.model.DataSet;
import com.klg.jclass.chart.model.impl.DataSetConverter;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCName;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.graphics.JCFont;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.LegendAdjustLayout;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import com.klg.jclass.util.swing.JCExitFrame;
import com.klg.jclass.util.swing.ToolTipUser;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChart
extends JComponent
implements Changeable,
LegendComponentLayoutUser,
ToolTipUser,
ServerRenderable,
Serializable,
KeyListener,
MouseListener,
MouseMotionListener,
ComponentListener,
AncestorListener,
JCName,
RenderProperties {
    private static final String uiClassID = "JCChartUI";
    protected JCChartArea chartArea = null;
    protected JCLegend legend = null;
    protected JCChartLegendManager legendManager = null;
    protected JComponent footer = null;
    protected JComponent header = null;
    protected JCFillStyle fillStyle = null;
    protected Vector<ChartDataView> data = new Vector();
    protected Vector<EventTrigger> triggers = new Vector();
    protected JCListenerList listeners = null;
    protected JCListenerList pickListeners = null;
    protected JCListenerList pickSeriesListeners = null;
    protected JCListenerList pickItemListeners = null;
    protected JCChartLabelManager chartLabelManager = null;
    protected Applet chartApplet = null;
    protected Object userObject = null;
    protected boolean includedInAlignmentCalcs = true;
    protected int alignmentWidthGroup = -1;
    protected int alignmentHeightGroup = -1;
    protected ImageMapInfo imageMapInfo = null;
    protected ImageMapInfo footerImageMapInfo = null;
    protected ImageMapInfo headerImageMapInfo = null;
    private ErrorLog errorLog = new ErrorLog(this);
    private boolean warningOn = true;
    private boolean batched = false;
    private boolean allowUserChanges = false;
    protected boolean inServerPaint = false;
    public static final int NONE = -1;
    public static final int PLOT = 0;
    public static final int SCATTER_PLOT = 1;
    public static final int POLAR = 2;
    public static final int RADAR = 3;
    public static final int AREA_RADAR = 4;
    public static final int HILO = 5;
    public static final int HILO_OPEN_CLOSE = 6;
    public static final int CANDLE = 7;
    public static final int AREA = 8;
    public static final int BAR = 9;
    public static final int STACKING_BAR = 10;
    public static final int PIE = 11;
    public static final int STACKING_AREA = 12;
    public static final int TIMELINE = 13;
    public static final int LAST_PREDEFINED_CHART_TYPE = 13;
    public static final int PICK_TYPE_POINT = 1;
    public static final int PICK_TYPE_SERIES = 2;
    public static final int PICK_TYPE_MARKER = 4;
    public static final int PICK_TYPE_THRESHOLD = 8;
    public static final int PICK_TYPE_CHART_LABEL = 16;
    public static final int PICK_TYPE_AXIS_LABEL = 32;
    public static final int PICK_TYPE_ENVELOPE = 64;
    public static final int PICK_TYPE_CHART_ALL = 127;
    public static final int PICK_MODE_GET_SELECTED = 1;
    public static final int PICK_MODE_GET_CLOSEST = 2;
    public static final int PICK_MODE_GET_ALL = 3;
    public static final int DEFAULT_LAYOUT = 0;
    public static final int PLOT_PRIORITY_LAYOUT = 1;
    public static final int LEGEND_COMPONENT_LAYOUT = 2;
    protected int chartLayout = 0;
    protected int antiAliasing = 0;
    public static final String ERRMSG_INVALID_TRIGGER_INDEX = "Invalid EventTrigger index.";
    protected String customizerName = "com.klg.jclass.chart.customizer.ChartCustomizer";
    protected int lineColorIndex;
    protected int symbolColorIndex;
    protected int fillColorIndex;
    protected int symbolShapeIndex;
    protected int pickItemType = 127;
    protected int pickItemMode = 1;
    private Dimension curSize = new Dimension(-1, -1);
    protected Rectangle chartAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected int resetKey = 114;
    protected int cancelKey = 99;
    private boolean changed = false;
    protected transient Graphics prevSetGraphics = null;
    protected Graphics queryGraphics = null;
    protected DataSetConverter dataSetConverter = new DataSetConverter();
    protected Locale locale = Locale.getDefault();
    protected boolean usingDoublePixels = true;
    protected boolean layoutDone = false;
    protected boolean registeredForToolTips = false;
    protected Component toolTipComponent = null;
    public transient JCCustomizerPage customizer = null;

    protected void init() {
        this.setOpaque(true);
        this.setLayout(new LegendAdjustLayout());
        this.addComponentListener(this);
        this.createHeader();
        this.createFooter();
        this.createLegend();
        this.createChartArea();
        this.resetDefaults();
        this.addDataView(0);
        this.enableEvents(8L);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.registerUI();
        this.updateUI();
    }

    protected void createHeader() {
        this.header = new JCLabel();
        this.header.setLocale(this.locale);
        this.header.setVisible(false);
        this.add(this.header);
    }

    protected void createFooter() {
        this.footer = new JCLabel();
        this.footer.setLocale(this.locale);
        this.footer.setVisible(false);
        this.add(this.footer);
    }

    protected void createLegend() {
        this.legend = new JCGridLegend();
        this.legendManager = new JCChartLegendManager(this);
        this.legend.setLocale(this.locale);
        this.legend.setLegendPopulator(this.legendManager);
        this.legend.setLegendRenderer(this.legendManager);
        this.add(this.legend);
    }

    protected void createChartArea() {
        this.chartArea = new JCChartArea(this.locale);
        this.add(this.chartArea);
        this.chartArea.setParentOnAxes(this);
    }

    public void enableChartEvents(long l2) {
        this.enableEvents(l2);
    }

    public void disableChartEvents(long l2) {
        this.disableEvents(l2);
    }

    public void setPickItemMode(int n2) {
        this.pickItemMode = n2;
    }

    public int getPickItemMode() {
        return this.pickItemMode;
    }

    public void setPickItemType(int n2) {
        this.pickItemType = n2;
    }

    public int getPickItemType() {
        return this.pickItemType;
    }

    public boolean isPickItemClosest() {
        return this.pickItemMode == 2;
    }

    public void setPickItemClosest(boolean bl) {
        this.pickItemMode = 2;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 500: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 503: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        EventTrigger eventTrigger;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!mouseEvent.isMetaDown() && (mouseEvent.getModifiers() & 8) == 0 && this.isFocusTraversable()) {
            this.requestFocus();
        }
        if ((eventTrigger = this.findMatchingTrigger(mouseEvent.getModifiers())) != null) {
            if (!(this.allowUserChanges || eventTrigger.action != 3 && eventTrigger.action != 6)) {
                return;
            }
            if (eventTrigger.action == 4) {
                this.sendPickEvent(this.pick(new Point(n2, n3), null));
            } else if (eventTrigger.action == 7) {
                this.sendPickSeriesEvent(this.pickSeries(new Point(n2, n3), null));
            } else if (eventTrigger.action == 8) {
                int n4 = this.pickItemMode;
                this.sendPickItemEvent(this.pickItem(new Point(n2, n3), null, this.pickItemType, n4));
            } else if (eventTrigger.action == 6) {
                this.launchPropertyPage(new Point(n2, n3));
            } else if (eventTrigger.action != -1 && this.getComponentAt(n2, n3) == this.chartArea) {
                this.chartArea.startAction(eventTrigger, n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.chartArea.getActionHandler() != null) {
            this.chartArea.endAction(n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.chartArea.getActionHandler() == null) {
            return;
        }
        this.chartArea.showAction(n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        if (c2 == this.resetKey) {
            this.reset();
        } else if (c2 == this.cancelKey) {
            this.cancel();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        JCChartLabel jCChartLabel;
        ((JComponent)ancestorEvent.getSource()).removeAncestorListener(this);
        if (this.chartLabelManager != null && ((jCChartLabel = this.chartLabelManager.getCurrentDwellLabel()) != null && jCChartLabel.isConnected() || jCChartLabel == null)) {
            this.repaint();
        }
    }

    protected void launchPropertyPage(Point point) {
        if (!this.allowUserChanges) {
            return;
        }
        if (this.customizer == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Class<?> clazz = Class.forName(this.getCustomizerName());
                JCCustomizerPage jCCustomizerPage = (JCCustomizerPage)clazz.newInstance();
                jCCustomizerPage.init();
                this.customizer = jCCustomizerPage;
            }
            catch (Exception exception) {
                this.customizer = null;
                String string = JCChartBundle.string("com.klg.jclass.chart.Key20", this.locale);
                this.getErrorLog().logErrorMessage(string, exception);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.customizer != null) {
            this.customizer.setObject(this);
            this.customizer.launch();
        }
    }

    public JCChart(int n2) {
        this(n2, Locale.getDefault());
    }

    public JCChart() {
        this(0, Locale.getDefault());
    }

    public JCChart(Locale locale) {
        this(0, locale);
    }

    public JCChart(int n2, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.init();
        this.data.elementAt(0).setChartType(n2);
    }

    public static JCChart makeChart(String string) {
        JCChart jCChart;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            jCChart = (JCChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            jCChart = null;
        }
        return jCChart;
    }

    @Override
    public final boolean isChanged() {
        return this.getChanged();
    }

    @Override
    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    @Override
    public boolean getChanged() {
        return this.chartArea.isChanged() || this.legend.isChanged() || !this.chartArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    @Override
    public boolean getChanged(int n2) {
        return this.chartArea.isChanged(n2) || this.legend.isChanged(n2) || !this.chartArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    public void recalc() {
        if (!this.isChanged(2)) {
            return;
        }
        this.createQueryGraphics();
        try {
            this.chartArea.recalc();
            this.legend.recalc();
        }
        catch (Exception exception) {
            this.getErrorLog().logErrorMessage("recalc", exception);
        }
        this.disposeQueryGraphics();
        this.setChanged(false, 0);
    }

    @Override
    public void setChanged(boolean bl, int n2) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        if (this.changed) {
            int n3 = 0;
            if ((n2 & 0x20) > 0) {
                n3 |= 2;
            }
            if ((n2 & 0x10) > 0) {
                n3 |= 1;
            }
            if (n3 != 0) {
                this.legend.setChanged(true, n3, false);
            }
            int n4 = 0;
            if ((n2 & 4) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x200) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x100) > 0) {
                n4 |= 1;
            }
            if (n4 != 0) {
                this.chartArea.setChanged(true, n4, false);
            }
            if (this.isBatched()) {
                this.invalidate();
            } else if ((n2 & 2) > 0 || (n2 & 4) > 0) {
                this.update();
            } else if ((n2 & 1) > 0) {
                this.repaint();
            }
        }
    }

    @Override
    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.antiAliasing == 0) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Object object2 = RenderingHints.VALUE_ANTIALIAS_OFF;
            if (this.antiAliasing == 1) {
                object2 = RenderingHints.VALUE_ANTIALIAS_ON;
            }
            if (object2 != object) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
            super.paint(graphics);
            if (object != null && object2 != object) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
        this.firePaint();
    }

    public void firePaint() {
        Enumeration<Object> enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).paintChart(this);
        }
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        rectangle.setBounds(insets.left, insets.top, Math.max(0, this.getSize().width - (insets.left + insets.right)), Math.max(0, this.getSize().height - (insets.top + insets.bottom)));
    }

    @Override
    public int getDrawingAreaHeight() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n2);
    }

    @Override
    public int getDrawingAreaWidth() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n2);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.setChanged(true, 546);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.createQueryGraphics();
        Graphics graphics2 = graphics.create();
        if (this.isOpaque()) {
            Rectangle rectangle = this.getBounds();
            Color color = this.getBackground();
            if (color != null) {
                if (!graphics2.getColor().equals(color)) {
                    graphics2.setColor(color);
                }
                graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            if (this.fillStyle != null) {
                Insets insets = this.getInsets();
                int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
                int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
                Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(rectangle2);
                this.fillStyle.fillRect(graphics2, insets.left, insets.top, n2, n3);
                this.fillStyle.updateAnchorRect(null);
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.disposeQueryGraphics();
        this.setChanged(false, 0);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.inServerPaint) {
            return;
        }
        super.paintChildren(graphics);
        if (this.chartLabelManager != null) {
            this.chartLabelManager.paintConnectors(graphics);
        }
    }

    @Override
    public void printAll(Graphics graphics) {
        super.printAll(graphics);
    }

    @Override
    public void doLayout() {
        this.layoutDone = true;
        Dimension dimension = new Dimension();
        dimension.width = this.getDrawingAreaWidth();
        dimension.height = this.getDrawingAreaHeight();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        if (!this.chartArea.isChanged(8) && this.chartArea.isValid() && dimension.width == this.curSize.width && dimension.height == this.curSize.height && !this.legend.isChanged(2) && !this.legend.isChanged(8) && this.legend.isValid() && this.header != null && this.header.isValid() && this.footer != null && this.footer.isValid()) {
            if (this.chartArea.isChanged(2) || !this.chartArea.isValid()) {
                this.recalc();
            }
            this.repaint();
            return;
        }
        this.recalc();
        if (this.chartLabelManager != null) {
            this.chartLabelManager.markAllChartLabelsForRecalc();
        }
        this.curSize = dimension;
        this.createQueryGraphics();
        super.doLayout();
        this.disposeQueryGraphics();
        this.repaint();
    }

    @Override
    public void setLayoutHints(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return;
        }
        if (jComponent == this.chartArea) {
            this.chartAreaLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.legend) {
            this.legendLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.header) {
            this.headerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.footer) {
            this.footerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        jComponent.invalidate();
        this.validate();
    }

    @Override
    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent != null) {
            if (jComponent == this.chartArea) {
                return this.chartAreaLayoutHints;
            }
            if (jComponent == this.legend) {
                return this.legendLayoutHints;
            }
            if (jComponent == this.header) {
                return this.headerLayoutHints;
            }
            if (jComponent == this.footer) {
                return this.footerLayoutHints;
            }
        }
        return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!bl) {
            this.update();
        }
    }

    @Override
    public boolean isBatched() {
        return this.batched;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void update() {
        this.invalidate();
        if (!this.isShowing()) {
            ChartDraw chartDraw;
            ChartDataView chartDataView = this.getDataView(0);
            if (chartDataView.isChanged() && (chartDraw = this.getChartArea().getDrawable(chartDataView)) instanceof PieChartDraw) {
                ((PieChartDraw)chartDraw).setRecalcFlag();
            }
            return;
        }
        this.validate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.moreAddNotify();
    }

    protected void moreAddNotify() {
        this.doLayout();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fillStyle != null) {
            this.fillStyle.setColor(color);
        }
        this.setChanged(true, 514);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 546);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setChanged(true, 546);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        JCFont jCFont;
        JCFontMetrics jCFontMetrics;
        if (font instanceof JCFont && (jCFontMetrics = (jCFont = (JCFont)((Object)font)).getJCFontMetrics()) != null) {
            return jCFontMetrics.getEncoderFontMetrics();
        }
        return super.getFontMetrics(font);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.setChanged(true, 1);
    }

    public void setAllowUserChanges(boolean bl) {
        this.allowUserChanges = bl;
    }

    public boolean getAllowUserChanges() {
        return this.allowUserChanges;
    }

    public void setWarningDialog(boolean bl) {
        if (this.warningOn == bl) {
            return;
        }
        this.warningOn = bl;
    }

    public boolean isWarningDialog() {
        return this.warningOn;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    @Override
    public JComponent getHeader() {
        return this.header;
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
        this.setChanged(true, 548);
    }

    @Override
    public JComponent getFooter() {
        return this.footer;
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
        this.setChanged(true, 548);
    }

    @Override
    public JCLegend getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        if (this.legend.getLegendPopulator() == null) {
            this.legend.setLegendPopulator(this.legendManager);
        }
        if (this.legend.getLegendRenderer() == null) {
            this.legend.setLegendRenderer(this.legendManager);
        }
        this.add(this.legend);
        this.setChanged(true, 548);
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    @Override
    public JComponent getComponentArea() {
        return this.getChartArea();
    }

    public void setDataSetConverter(DataSetConverter dataSetConverter) {
        this.dataSetConverter = dataSetConverter;
    }

    public DataSetConverter getDataSetConverter() {
        return this.dataSetConverter;
    }

    public void setDataModel(DataModel dataModel) throws DataPointException {
        if (dataModel == null) {
            return;
        }
        List<DataSet> list2 = dataModel.getDataSets();
        if (list2 == null || this.dataSetConverter == null) {
            return;
        }
        Vector<ChartDataView> vector = new Vector<ChartDataView>();
        for (DataSet list3 : list2) {
            ChartDataView chartDataView = new ChartDataView(this);
            this.dataSetConverter.convertToDataView(list3, chartDataView, this);
            vector.add(chartDataView);
        }
        if (vector.size() > 0) {
            this.setDataView(vector);
        }
        Hashtable hashtable = new Hashtable();
        List<ChartDataView> list = this.getDataView();
        if (list != null) {
            for (ChartDataView chartDataView : list) {
                JCAxis jCAxis = chartDataView.getXAxis();
                hashtable.put(jCAxis, jCAxis);
                JCAxis jCAxis2 = chartDataView.getYAxis();
                hashtable.put(jCAxis2, jCAxis2);
            }
        }
        this.removeUnusedAxes(hashtable, this.getChartArea().getXAxes());
        this.removeUnusedAxes(hashtable, this.getChartArea().getYAxes());
    }

    public void replaceDataModel(DataModel dataModel) throws DataPointException {
        if (dataModel == null) {
            return;
        }
        List<DataSet> list = dataModel.getDataSets();
        if (list == null || this.dataSetConverter == null) {
            return;
        }
        Vector<ChartDataView> vector = new Vector<ChartDataView>();
        Iterator<DataSet> iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            DataSet dataSet = iterator.next();
            ChartDataView chartDataView = this.getDataView(n2);
            if (chartDataView == null) {
                chartDataView = new ChartDataView(this);
            }
            this.dataSetConverter.convertToDataView(dataSet, chartDataView, this);
            vector.add(chartDataView);
            ++n2;
        }
        if (vector.size() > 0) {
            this.setDataView(vector);
        }
    }

    public void addDataModel(DataModel dataModel) throws DataPointException {
        if (dataModel == null) {
            return;
        }
        List<DataSet> list = dataModel.getDataSets();
        if (list == null || this.dataSetConverter == null) {
            return;
        }
        List<ChartDataView> list2 = this.getDataView();
        int n2 = list2.size();
        for (DataSet dataSet : list) {
            ChartDataView chartDataView = new ChartDataView(this);
            this.dataSetConverter.convertToDataView(dataSet, chartDataView, this);
            this.setDataView(n2++, chartDataView);
        }
    }

    private void removeUnusedAxes(Hashtable<JCAxis, JCAxis> hashtable, List<JCAxis> list) {
        Iterator<JCAxis> iterator = list.iterator();
        while (iterator.hasNext()) {
            JCAxis jCAxis = iterator.next();
            if (hashtable.get(jCAxis) != null) continue;
            JCAxisFormula jCAxisFormula = jCAxis.getFormula();
            if (jCAxisFormula != null) {
                JCAxis jCAxis2 = jCAxisFormula.getOriginator();
                if (jCAxis2 != null) {
                    if (hashtable.get(jCAxis2) != null) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    public void setChartArea(JCChartArea jCChartArea) {
        if (jCChartArea == null) {
            return;
        }
        if (this.chartArea != null) {
            this.remove(this.chartArea);
        }
        this.chartArea = jCChartArea;
        this.add(this.chartArea);
        this.setChanged(true, 548);
    }

    public ChartDataView getDataView(int n2) {
        ChartDataView chartDataView = null;
        if (this.data != null && n2 >= 0 && n2 < this.data.size()) {
            chartDataView = this.data.get(n2);
        }
        return chartDataView;
    }

    public ChartDataView addDataView(int n2) {
        ChartDataView chartDataView = new ChartDataView(this.locale);
        this.setDataView(n2, chartDataView);
        return chartDataView;
    }

    public void setDataView(int n2, ChartDataView chartDataView) {
        if (this.data == null) {
            return;
        }
        if (n2 < 0 || n2 > this.data.size()) {
            throw new IllegalArgumentException("Invalid ChartDataView index in JCChart");
        }
        if (chartDataView != null) {
            chartDataView.setParent(this);
        }
        if (n2 >= 0 && n2 < this.data.size()) {
            this.data.set(n2, chartDataView);
        } else {
            this.data.add(n2, chartDataView);
        }
        this.reorderDataViews();
        if (this.chartArea == null) {
            return;
        }
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public void setDataView(List<ChartDataView> list) {
        this.data = new Vector();
        if (list == null) {
            return;
        }
        for (ChartDataView chartDataView : list) {
            if (chartDataView != null) {
                chartDataView.setParent(this);
            }
            this.data.add(chartDataView);
        }
        if (this.chartArea == null) {
            return;
        }
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public ChartDataView findDataView(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ChartDataView chartDataView = this.data.elementAt(i2);
            if (!chartDataView.getName().equals(string)) continue;
            return chartDataView;
        }
        return null;
    }

    public List<ChartDataView> getDataView() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        return new Vector<ChartDataView>(this.data);
    }

    protected List<ChartDataView> getOriginalDataView() {
        return this.data;
    }

    public int findDataViewIndex(ChartDataView chartDataView) {
        int n2 = -1;
        if (chartDataView != null && this.data != null && this.data.size() > 0) {
            for (int i2 = 0; i2 < this.data.size(); ++i2) {
                ChartDataView chartDataView2 = this.data.elementAt(i2);
                if (chartDataView != chartDataView2) continue;
                n2 = i2;
                break;
            }
        }
        return n2;
    }

    public void removeDataView(int n2) {
        if (this.chartArea == null || this.data == null) {
            return;
        }
        if (n2 < 0 || n2 > this.data.size()) {
            throw new IllegalArgumentException("Trying to remove invalid ChartDataView index: " + n2);
        }
        this.chartArea.removeDrawable(this.data.elementAt(n2));
        this.data.remove(n2);
        this.reorderDataViews();
        this.setChanged(true, 548);
    }

    public int getNumData() {
        int n2 = 0;
        if (this.data != null) {
            n2 = this.data.size();
        }
        return n2;
    }

    public EventTrigger getTrigger(int n2) {
        EventTrigger eventTrigger = null;
        if (this.triggers != null && (n2 >= 0 || n2 < this.triggers.size())) {
            eventTrigger = this.triggers.elementAt(n2);
        }
        return eventTrigger;
    }

    public int getNumTriggers() {
        int n2 = 0;
        if (this.triggers != null) {
            n2 = this.triggers.size();
        }
        return n2;
    }

    public EventTrigger addTrigger() {
        EventTrigger eventTrigger = new EventTrigger();
        if (this.triggers != null) {
            this.triggers.addElement(eventTrigger);
        }
        return eventTrigger;
    }

    public EventTrigger addTrigger(int n2, int n3) {
        EventTrigger eventTrigger = new EventTrigger(n2, n3);
        if (this.triggers != null) {
            this.triggers.addElement(eventTrigger);
        }
        return eventTrigger;
    }

    public void setTrigger(int n2, EventTrigger eventTrigger) {
        if (this.triggers == null) {
            return;
        }
        if (eventTrigger == null) {
            if (n2 < 0 || n2 >= this.triggers.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_TRIGGER_INDEX);
            }
            this.removeTrigger(n2);
        } else {
            if (n2 < 0 || n2 > this.triggers.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_TRIGGER_INDEX);
            }
            this.triggers.insertElementAt(eventTrigger, n2);
        }
    }

    public void removeTrigger(int n2) {
        if (this.triggers != null) {
            this.triggers.removeElementAt(n2);
        }
    }

    public EventTrigger findMatchingTrigger(int n2) {
        if (this.triggers == null) {
            return null;
        }
        EventTrigger eventTrigger = null;
        for (int i2 = 0; i2 < this.triggers.size(); ++i2) {
            EventTrigger eventTrigger2 = this.triggers.elementAt(i2);
            if (eventTrigger2.modifiers != n2) continue;
            eventTrigger = eventTrigger2;
            break;
        }
        return eventTrigger;
    }

    public void setResetKey(int n2) {
        this.resetKey = n2;
    }

    public int getResetKey() {
        return this.resetKey;
    }

    public void setCancelKey(int n2) {
        this.cancelKey = n2;
    }

    public int getCancelKey() {
        return this.cancelKey;
    }

    public void rotateStart() {
    }

    public void rotate() {
    }

    public void rotateEnd() {
    }

    public void zoom(double d2, double d3, JCAxis jCAxis, boolean bl) {
        double d4;
        if (jCAxis == null) {
            return;
        }
        double d5 = jCAxis.logarithmic ? Math.abs(JCChartUtil.log10(d2) - JCChartUtil.log10(d3)) : Math.abs(d2 - d3);
        if (d5 < (d4 = JCChartUtil.calcError(jCAxis.getPrecision()))) {
            return;
        }
        double d6 = d5 / 30.0;
        if (d2 + d6 == d2) {
            return;
        }
        if (d2 > d3) {
            double d7 = d2;
            d2 = d3;
            d3 = d7;
        }
        jCAxis.min.value = d2;
        jCAxis.min.isDefault = false;
        jCAxis.max.value = d3;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void scale(double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.value /= d2;
        jCAxis.min.isDefault = false;
        jCAxis.max.value /= d2;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void translateStart(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.isDefault = false;
        jCAxis.max.isDefault = false;
        this.sendEvent(jCAxis);
        jCAxis.setChanged(true, 2, false);
    }

    public void translate(double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.translate(d2);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void reset() {
        this.chartArea.reset();
    }

    public void cancel() {
        this.chartArea.cancel();
    }

    protected void reorderDataViews() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ChartDataView chartDataView = this.data.elementAt(i2);
            chartDataView.setDrawingOrder(i2);
        }
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setAbout(String string) {
    }

    public String getLicense() {
        return "Invalid License";
    }

    public void setLicense(String string) {
    }

    protected ChartDataView findData(JCAxis jCAxis) {
        if (jCAxis == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ChartDataView chartDataView = this.data.elementAt(i2);
            if (chartDataView.getXAxis() != jCAxis && chartDataView.getYAxis() != jCAxis || !chartDataView.isVisible()) continue;
            return chartDataView;
        }
        return null;
    }

    protected JCChartLabel getChartLabel(Component component) {
        if (this.chartLabelManager == null || component == null) {
            return null;
        }
        if (component instanceof JCChartLabelLine) {
            return ((JCChartLabelLine)component).getChartLabel();
        }
        List<JCChartLabel> list = this.chartLabelManager.getChartLabels();
        if (list != null) {
            for (JCChartLabel jCChartLabel : list) {
                JComponent jComponent;
                if (jCChartLabel == null || (jComponent = jCChartLabel.getComponent()) != component) continue;
                return jCChartLabel;
            }
        }
        return null;
    }

    public JCPickItem pickItem(Point point, ChartDataView chartDataView, int n2) {
        return this.pickItem(point, chartDataView, n2, 1);
    }

    public JCPickItem pickItem(Point point, ChartDataView chartDataView, int n2, int n3) {
        JCPickItem jCPickItem = new JCPickItem();
        if (point == null || n2 == 0) {
            return jCPickItem;
        }
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return jCPickItem;
        }
        jCPickItem.setComponent(component);
        JCChartLabel jCChartLabel = this.getChartLabel(component);
        if (jCChartLabel != null) {
            if ((n2 & 0x10) != 0) {
                jCPickItem.setItem(jCChartLabel);
                jCPickItem.setDistance(0);
                return jCPickItem;
            }
            component = this.getComponentAtIgnoreChartLabels(point.x, point.y);
            if (component != null) {
                jCPickItem.setComponent(component);
            } else {
                return jCPickItem;
            }
        }
        if (component != this) {
            Serializable serializable;
            Serializable serializable2;
            boolean bl = (n2 & 1) != 0;
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = (n2 & 4) != 0;
            boolean bl4 = (n2 & 8) != 0;
            boolean bl5 = (n2 & 0x40) != 0;
            boolean bl6 = (n2 & 0x20) != 0;
            boolean bl7 = n3 == 2;
            boolean bl8 = n3 == 3;
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            JCDataIndex jCDataIndex = null;
            if (bl2) {
                jCDataIndex = this.pickSeriesInternal(point, component, chartDataView);
            } else if (bl) {
                jCDataIndex = this.pickInternal(point, component, chartDataView);
            } else if (component instanceof JCLegend && (bl3 || bl4 || bl5)) {
                jCDataIndex = this.pickInternal(point, component, chartDataView);
            }
            if (component instanceof JCChartArea) {
                int n4;
                int n5;
                if (bl6 && (serializable2 = this.chartArea.pickAxisLabels(chartDataView, point)) != null) {
                    return serializable2;
                }
                serializable2 = null;
                if (bl3 && (serializable = this.chartArea.pickMarker(chartDataView, point, false)) != null) {
                    int n6 = n5 = chartDataView == null ? this.getDataView(0).getPickTolerance() : chartDataView.getPickTolerance();
                    if (((JCPickItem)serializable).getDistance() <= n5) {
                        if (bl7) {
                            serializable2 = serializable;
                        } else if (bl8) {
                            arrayList.add(serializable);
                        } else {
                            return serializable;
                        }
                    }
                }
                if (jCDataIndex != null) {
                    serializable = jCDataIndex.getDataView();
                    n5 = jCDataIndex.getDistance();
                    if (serializable != null && n5 <= ((ChartDataView)serializable).getPickTolerance()) {
                        jCPickItem.setItem(jCDataIndex);
                        jCPickItem.setDistance(n5);
                        if (bl7) {
                            int n7 = n4 = serializable2 == null ? Integer.MAX_VALUE : ((JCPickItem)serializable2).getDistance();
                            if (n5 < n4) {
                                serializable2 = jCPickItem;
                            }
                        } else if (bl8) {
                            arrayList.add(jCPickItem);
                        } else {
                            return jCPickItem;
                        }
                    }
                }
                if (bl3 && (serializable = this.chartArea.pickMarker(chartDataView, point, true)) != null) {
                    n5 = chartDataView == null ? this.getDataView(0).getPickTolerance() : chartDataView.getPickTolerance();
                    n4 = ((JCPickItem)serializable).getDistance();
                    if (n4 <= n5) {
                        if (bl7) {
                            int n8;
                            int n9 = n8 = serializable2 == null ? Integer.MAX_VALUE : ((JCPickItem)serializable2).getDistance();
                            if (n4 < n8) {
                                serializable2 = serializable;
                            }
                        } else if (bl8) {
                            arrayList.add(serializable);
                        } else {
                            return serializable;
                        }
                    }
                }
                if (bl7 && serializable2 != null) {
                    return serializable2;
                }
                if (bl5 && (serializable = this.chartArea.pickEnvelope(chartDataView, point)) != null) {
                    if (bl8) {
                        arrayList.add(serializable);
                    } else {
                        return serializable;
                    }
                }
                if (bl4 && (serializable = this.chartArea.pickThreshold(chartDataView, point)) != null) {
                    if (bl8) {
                        arrayList.add(serializable);
                    } else {
                        return serializable;
                    }
                }
                if (bl8 && arrayList.size() > 0) {
                    return new JCPickItem(arrayList, component);
                }
                if (jCDataIndex != null) {
                    jCPickItem.setItem(this.chartArea);
                    jCPickItem.setDistance(0);
                    return jCPickItem;
                }
            }
            if (jCDataIndex != null) {
                serializable2 = jCDataIndex;
                if (component instanceof JCLegend) {
                    serializable = (JCLegend)component;
                    Point point2 = new Point(point.x - ((Component)serializable).getLocation().x, point.y - ((Component)serializable).getLocation().y);
                    JCLegendItem jCLegendItem = ((JCLegend)serializable).pick(point2);
                    Object object = jCLegendItem == null ? null : jCLegendItem.itemInfo;
                    serializable2 = (bl || bl2) && object instanceof JCDataIndex || bl3 && object instanceof JCMarker || bl5 && object instanceof JCEnvelope || bl4 && object instanceof JCAbstractThreshold ? jCLegendItem : component;
                }
                jCPickItem.setItem(serializable2);
                jCPickItem.setDistance(jCDataIndex.getDistance());
                return jCPickItem;
            }
        }
        jCPickItem.setItem(this);
        jCPickItem.setDistance(0);
        return jCPickItem;
    }

    public JCPickItem pickItem(Point point, ChartDataView chartDataView, int n2, boolean bl) {
        int n3 = bl ? 2 : 1;
        return this.pickItem(point, chartDataView, n2, n3);
    }

    public JCDataIndex pick(Point point, ChartDataView chartDataView) {
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        return this.pickInternal(point, component, chartDataView);
    }

    protected JCDataIndex pickInternal(Point point, Component component, ChartDataView chartDataView) {
        JCDataIndex jCDataIndex;
        if (point == null || component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (component instanceof JCLegend) {
            jCDataIndex = this.pickLegend(point2, chartDataView);
        } else if (component instanceof JCChartArea) {
            jCDataIndex = this.chartArea.pick(point2, chartDataView, -1);
        } else {
            jCDataIndex = new JCDataIndex(-1, null, -1);
            jCDataIndex.obj = component;
        }
        return jCDataIndex;
    }

    public JCDataIndex pickSeries(Point point, ChartDataView chartDataView) {
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        return this.pickSeriesInternal(point, component, chartDataView);
    }

    protected JCDataIndex pickSeriesInternal(Point point, Component component, ChartDataView chartDataView) {
        if (point == null || component == null) {
            return null;
        }
        if (component instanceof JCChartArea) {
            Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
            return this.chartArea.pickSeries(point2, chartDataView, -1);
        }
        return this.pick(point, chartDataView);
    }

    protected JCDataIndex pickLegend(Point point, ChartDataView chartDataView) {
        Object object;
        JCDataIndex jCDataIndex;
        JCLegendItem jCLegendItem = this.legend.pick(point);
        JCDataIndex jCDataIndex2 = new JCDataIndex(-1, null, -1);
        jCDataIndex2.obj = this.legend;
        if (jCLegendItem == null) {
            return jCDataIndex2;
        }
        if (jCLegendItem.itemInfo instanceof JCDataIndex) {
            jCDataIndex = (JCDataIndex)jCLegendItem.itemInfo;
        } else if (jCLegendItem.itemInfo instanceof LegendEntry) {
            object = (LegendEntry)jCLegendItem.itemInfo;
            jCDataIndex = new JCDataIndex(object.getParent(), null, -1, -1);
        } else {
            return jCDataIndex2;
        }
        object = jCDataIndex.getDataView();
        if (chartDataView != null && object != chartDataView) {
            return jCDataIndex2;
        }
        jCDataIndex2.dataView = object;
        jCDataIndex2.series = jCDataIndex.getSeries();
        jCDataIndex2.seriesIndex = jCDataIndex.getSeriesIndex();
        jCDataIndex2.distance = 0;
        return jCDataIndex2;
    }

    public Point unpick(ChartDataView chartDataView, int n2, int n3) {
        if (chartDataView == null || n3 < 0) {
            return null;
        }
        if (n3 >= chartDataView.getSeries().size()) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(n3);
        int n4 = chartDataViewSeries.getFirstPoint();
        int n5 = chartDataViewSeries.getLastPoint();
        if (n2 < n4 || n2 > n5) {
            return null;
        }
        ChartDraw chartDraw = this.chartArea.getDrawable(chartDataView);
        if (chartDraw == null) {
            return null;
        }
        Point point = chartDraw.unpick(n2, n3);
        if (point != null) {
            Point point2 = this.chartArea.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            Rectangle rectangle = this.chartArea.getDrawingArea();
            point.x += rectangle.x;
            point.y += rectangle.y;
        }
        return point;
    }

    public Point unpick(int n2, ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        return this.unpick(chartDataViewSeries.getParent(), n2, chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries));
    }

    public void addChartListener(JCChartListener jCChartListener) {
        this.listeners = JCListenerList.add(this.listeners, jCChartListener);
    }

    public void removeChartListener(JCChartListener jCChartListener) {
        this.listeners = JCListenerList.remove(this.listeners, jCChartListener);
    }

    public int getListCount() {
        return JCListenerList.getListCount(this.listeners);
    }

    protected void sendEvent(JCAxis jCAxis) {
        JCChartEvent jCChartEvent = new JCChartEvent(this, jCAxis);
        Enumeration<Object> enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).changeChart(jCChartEvent);
        }
    }

    public void addPickListener(JCPickListener jCPickListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCPickListener);
    }

    public void removePickListener(JCPickListener jCPickListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCPickListener);
    }

    public void sendPickEvent(JCDataIndex jCDataIndex) {
        JCPickEvent jCPickEvent = new JCPickEvent(this, jCDataIndex);
        Enumeration<Object> enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCPickListener)enumeration.nextElement()).pick(jCPickEvent);
        }
    }

    public void addPickSeriesListener(JCPickSeriesListener jCPickSeriesListener) {
        this.pickSeriesListeners = JCListenerList.add(this.pickSeriesListeners, jCPickSeriesListener);
    }

    public void removePickSeriesListener(JCPickSeriesListener jCPickSeriesListener) {
        this.pickSeriesListeners = JCListenerList.remove(this.pickSeriesListeners, jCPickSeriesListener);
    }

    public void sendPickSeriesEvent(JCDataIndex jCDataIndex) {
        JCPickEvent jCPickEvent = new JCPickEvent(this, jCDataIndex);
        Enumeration<Object> enumeration = JCListenerList.elements(this.pickSeriesListeners);
        while (enumeration.hasMoreElements()) {
            ((JCPickSeriesListener)enumeration.nextElement()).pickSeries(jCPickEvent);
        }
    }

    public void sendPickItemEvent(JCPickItem jCPickItem) {
        JCPickItemEvent jCPickItemEvent = new JCPickItemEvent(this, jCPickItem);
        Enumeration<Object> enumeration = JCListenerList.elements(this.pickItemListeners);
        while (enumeration.hasMoreElements()) {
            ((JCPickItemListener)enumeration.nextElement()).pickItem(jCPickItemEvent);
        }
    }

    public void addPickItemListener(JCPickItemListener jCPickItemListener) {
        this.pickItemListeners = JCListenerList.add(this.pickItemListeners, jCPickItemListener);
    }

    public void removePickItemListener(JCPickItemListener jCPickItemListener) {
        this.pickItemListeners = JCListenerList.remove(this.pickItemListeners, jCPickItemListener);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.isFocusTraversable()) {
            this.processEvent(new FocusEvent(this, 1004));
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public void resetDefaults() {
        this.lineColorIndex = 0;
        this.fillColorIndex = 0;
        this.symbolColorIndex = 0;
        this.symbolShapeIndex = 1;
    }

    public void setLineColorIndex(int n2) {
        this.lineColorIndex = n2;
    }

    public void setFillColorIndex(int n2) {
        this.fillColorIndex = n2;
    }

    public void setSymbolColorIndex(int n2) {
        this.symbolColorIndex = n2;
    }

    public void setSymbolShapeIndex(int n2) {
        this.symbolShapeIndex = n2;
    }

    public int getLineColorIndex() {
        return this.lineColorIndex;
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public int getSymbolColorIndex() {
        return this.symbolColorIndex;
    }

    public int getSymbolShapeIndex() {
        return this.symbolShapeIndex;
    }

    @Override
    public synchronized void registerForTooltips() {
        if (this.registeredForToolTips) {
            return;
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.registeredForToolTips = true;
    }

    @Override
    public synchronized void unregisterForTooltips(Object object) {
        Object object2;
        if (!this.registeredForToolTips) {
            return;
        }
        if (object instanceof JCChartLabelManager && this.legend.isItemTextToolTipEnabled()) {
            return;
        }
        if (object instanceof JCLegend && this.chartLabelManager != null && (object2 = this.chartLabelManager.getChartLabels()) != null) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                JCChartLabel jCChartLabel = (JCChartLabel)iterator.next();
                if (jCChartLabel == null || !jCChartLabel.isDwellLabel()) continue;
                return;
            }
        }
        if (this.getToolTipText() == null) {
            object2 = ToolTipManager.sharedInstance();
            ((ToolTipManager)object2).unregisterComponent(this);
            this.registeredForToolTips = false;
        }
    }

    @Override
    public synchronized void setToolTipText(String string) {
        super.setToolTipText(string);
        if (string == null && this.registeredForToolTips) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        JCLegend jCLegend;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.toolTipComponent = this.getComponentAt(n2, n3);
        if (this.toolTipComponent instanceof JCChartArea) {
            if (this.chartLabelManager != null) {
                if (this.chartLabelManager.locateCurrentDwellLabel(n2, n3)) {
                    return "";
                }
                return super.getToolTipText(mouseEvent);
            }
        } else if (this.toolTipComponent instanceof JCLegend && (jCLegend = (JCLegend)this.toolTipComponent).isItemTextToolTipEnabled()) {
            Point point = this.toolTipComponent.getLocation();
            MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return jCLegend.getToolTipText(mouseEvent2);
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point;
        if (this.chartLabelManager != null && this.toolTipComponent instanceof JCChartArea && (point = this.chartLabelManager.getCurrentDwellLabelAttachPoint()) != null) {
            return point;
        }
        return super.getToolTipLocation(mouseEvent);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        if (!(this.toolTipComponent instanceof JCChartArea)) {
            return jToolTip;
        }
        if (this.chartLabelManager != null) {
            JCChartLabel jCChartLabel = this.chartLabelManager.getCurrentDwellLabel();
            Point point = this.chartLabelManager.getCurrentDwellLabelAttachPoint();
            if (point.x == -9999 || point.y == -9999) {
                return jToolTip;
            }
            JComponent jComponent = this.chartLabelManager.getCurrentDwellLabelComponent();
            if (jComponent != null) {
                jToolTip.add(jComponent);
                if (jCChartLabel.isConnected()) {
                    jToolTip.addAncestorListener(this);
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        graphics.setColor(this.getForeground());
                        jCChartLabel.drawConnector(graphics);
                        graphics.dispose();
                    }
                }
                jComponent.setLocation(0, 0);
                jToolTip.setPreferredSize(jComponent.getPreferredSize());
                return jToolTip;
            }
        }
        return jToolTip;
    }

    public JCChartLabelManager getChartLabelManager() {
        if (this.chartLabelManager == null) {
            try {
                String string = "com.klg.jclass.chart.JCDefaultChartLabelManager";
                this.chartLabelManager = (JCChartLabelManager)Class.forName(string).newInstance();
                this.chartLabelManager.setParentChart(this);
            }
            catch (Exception exception) {
                this.getErrorLog().logErrorMessage("creatingChartLabelManager", exception);
            }
        }
        return this.chartLabelManager;
    }

    public void setChartLabelManager(JCChartLabelManager jCChartLabelManager) {
        if (this.chartLabelManager != jCChartLabelManager) {
            this.chartLabelManager = jCChartLabelManager;
            this.chartLabelManager.setParentChart(this);
        }
    }

    public boolean hasChartLabelManager() {
        return this.chartLabelManager != null;
    }

    public String getCustomizerName() {
        return this.customizerName;
    }

    public void setCustomizerName(String string) {
        if (string == null) {
            return;
        }
        this.customizerName = string;
    }

    @Override
    public JCChartUI getUI() {
        return (JCChartUI)this.ui;
    }

    @Override
    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    @Override
    public void updateUI() {
        ComponentUI componentUI = UIManager.getUI(this);
        try {
            JCChartUI jCChartUI = (JCChartUI)componentUI;
        }
        catch (Exception exception) {
            componentUI = JCChartUI.createUI(this);
        }
        this.setUI(componentUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void registerUI() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put(uiClassID, "com.klg.jclass.chart.JCChartUI");
    }

    public Object getSource() {
        return this;
    }

    @Override
    public Component getComponentAt(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        int n4 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < n4; ++i2) {
            Component component = componentArray[i2];
            if (!this.componentContains(component, n2, n3)) continue;
            return component;
        }
        return this;
    }

    public Component getComponentAtIgnoreChartLabels(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        int n4 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < n4; ++i2) {
            Component component = componentArray[i2];
            if (this.getChartLabel(component) != null || component instanceof JCChartLabelLine || !this.componentContains(component, n2, n3)) continue;
            return component;
        }
        return this;
    }

    protected boolean componentContains(Component component, int n2, int n3) {
        if (component != null) {
            Point point = component.getLocation();
            if (component.isShowing() && component.contains(n2 - point.x, n3 - point.y)) {
                return true;
            }
        }
        return false;
    }

    public Image snapshot() {
        return this.snapshot(2);
    }

    public Image snapshot(int n2) {
        Image image;
        Dimension dimension = this.getSize();
        try {
            image = new BufferedImage(dimension.width, dimension.height, n2);
        }
        catch (Exception exception) {
            image = this.createImage(dimension.width, dimension.height);
        }
        this.snapshot(image);
        return image;
    }

    public void snapshot(Image image) {
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.paint(graphics);
            graphics.dispose();
        }
    }

    protected Image createLocalImage(int n2, int n3) {
        return this.createImage(n2, n3);
    }

    @Override
    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        if (this.queryGraphics != null) {
            this.disposeQueryGraphics();
            this.createQueryGraphics();
        }
        this.getChartArea().setGraphics(graphics);
        this.getLegend().setGraphics(graphics);
    }

    public void createQueryGraphics() {
        if (this.queryGraphics != null) {
            this.queryGraphics.dispose();
            this.queryGraphics = null;
        }
        this.queryGraphics = this.getGraphics();
    }

    public void disposeQueryGraphics() {
        if (this.queryGraphics != null) {
            this.queryGraphics.dispose();
            this.queryGraphics = null;
        }
    }

    public Graphics getQueryGraphics() {
        if (this.queryGraphics == null) {
            this.createQueryGraphics();
        }
        return this.queryGraphics;
    }

    @Override
    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    @Override
    public void serverPaint(Graphics graphics) {
        this.inServerPaint = true;
        this.chartArea.setChanged(true, 8);
        if (this.chartLabelManager != null) {
            this.chartLabelManager.markAllChartLabelsForRecalc();
        }
        ServerRenderer.paintComponent(graphics, this);
        this.inServerPaint = false;
    }

    @Override
    public void setUsingDoublePixels(boolean bl) {
        this.usingDoublePixels = bl;
    }

    @Override
    public boolean isUsingDoublePixels() {
        return this.usingDoublePixels;
    }

    @Override
    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    @Override
    public void setAntiAliasing(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("The antiAliasing value must be one of ANTI_ALIASING_DEFAULT,ANTI_ALIASING_ON, or ANTI_ALIASING_OFF");
        }
        if (this.antiAliasing == n2) {
            return;
        }
        this.antiAliasing = n2;
        this.setChanged(true, 1);
    }

    public void setChartLayout(int n2) {
        if (n2 == 0) {
            this.setLayout(new LegendAdjustLayout());
        } else if (n2 == 1) {
            this.setLayout(new PlotPriorityLayout());
        } else if (n2 == 2) {
            this.setLayout(new LegendComponentLayout());
        } else {
            throw new IllegalArgumentException("The chartLayout value must be either DEFAULT_LAYOUT, PLOT_PRIORITY_LAYOUT, orLEGEND_COMPONENT_LAYOUT.");
        }
        this.chartLayout = n2;
        this.setChanged(true, 37);
    }

    public int getChartLayout() {
        return this.chartLayout;
    }

    public boolean isIncludedInAlignmentCalcs() {
        return this.includedInAlignmentCalcs;
    }

    public void setIncludedInAlignmentCalcs(boolean bl) {
        this.includedInAlignmentCalcs = bl;
    }

    public int getAlignmentWidthGroup() {
        return this.alignmentWidthGroup;
    }

    public void setAlignmentWidthGroup(int n2) {
        this.alignmentWidthGroup = n2;
    }

    public int getAlignmentHeightGroup() {
        return this.alignmentHeightGroup;
    }

    public void setAlignmentHeightGroup(int n2) {
        this.alignmentHeightGroup = n2;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getFooterImageMapInfo() {
        return this.footerImageMapInfo;
    }

    public void setFooterImageMapInfo(ImageMapInfo imageMapInfo) {
        this.footerImageMapInfo = imageMapInfo;
    }

    public ImageMapInfo getHeaderImageMapInfo() {
        return this.headerImageMapInfo;
    }

    public void setHeaderImageMapInfo(ImageMapInfo imageMapInfo) {
        this.headerImageMapInfo = imageMapInfo;
    }

    @Override
    public void setLocale(Locale locale) {
        TrackChange trackChange;
        Object object;
        Iterator<JCAxis> iterator;
        List<JCAxis> list;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale != null && this.locale.equals(locale)) {
            return;
        }
        Locale locale2 = locale;
        try {
            this.locale = locale;
        }
        catch (MissingResourceException missingResourceException) {
            this.locale = Locale.getDefault();
        }
        if (this.legend != null) {
            this.legend.setLocale(locale);
        }
        if (this.chartArea != null) {
            this.chartArea.setLocale(locale);
            list = this.chartArea.getXAxes();
            if (list != null && list.size() > 0) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ((JCAxis)object).setLocale(locale);
                }
            }
            if ((iterator = this.chartArea.getYAxes()) != null && iterator.size() != 0) {
                object = iterator.iterator();
                while (object.hasNext()) {
                    trackChange = (JCAxis)object.next();
                    ((JCAxis)trackChange).setLocale(locale);
                }
            }
        }
        if (this.data != null) {
            list = this.data.iterator();
            while (list.hasNext()) {
                iterator = (ChartDataView)list.next();
                ((ChartDataView)((Object)iterator)).setLocale(locale);
            }
        }
        if ((list = this.getChartLabelManager()) != null && (iterator = list.getChartLabels()) != null) {
            object = iterator.iterator();
            while (object.hasNext()) {
                trackChange = (JCChartLabel)object.next();
                JComponent jComponent = ((JCChartLabel)trackChange).component;
                if (jComponent == null) continue;
                jComponent.setLocale(locale);
            }
        }
        this.firePropertyChange("locale", locale2, locale);
        if (this.isValid()) {
            this.invalidate();
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof LegendAdjustLayout) {
            this.legend.setEffectiveAnchor(0);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.registerUI();
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            this.getErrorLog().logErrorMessage("readObject", exception);
        }
    }

    public static void main(String[] stringArray) {
        JCExitFrame jCExitFrame = new JCExitFrame(JCChartBundle.string("com.klg.jclass.chart.Key5", Locale.getDefault()));
        JCChart jCChart = new JCChart();
        jCChart.setAllowUserChanges(true);
        jCChart.setTrigger(0, new EventTrigger(4, 6));
        jCExitFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jCExitFrame.getContentPane().add(jCChart);
        jCExitFrame.pack();
        jCExitFrame.setSize(500, 300);
        jCExitFrame.setVisible(true);
    }
}

